/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBVoiceMsg;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GetVoiceDataTask
extends ExThread {
    private final JSONObject mDataObj;
    private long mTimestamp = -1L;

    public GetVoiceDataTask(Context context, JSONObject dataObj, long returnTimeStamp) {
        super(context, "GetVoiceDataTask");
        this.mDataObj = dataObj;
        this.mTimestamp = returnTimeStamp;
    }

    @Override
    public void run() {
        if (this.mDataObj != null) {
            try {
                JSONArray recordList = this.mDataObj.getJSONArray("PersonalRecord");
                JSONArray voiceList = this.mDataObj.getJSONArray("VoiceMessage");
                this.parseArray(voiceList, 0);
                this.parseArray(recordList, 1);
                PreferencesUtil.setTimeStamp(this.mCtx, "record.listVoiceMessageAndPersonalReocrd.TimeStamp", this.mTimestamp);
            }
            catch (JSONException e) {
                Log.e(this.getClass().getSimpleName(), "doParseContent", e);
            }
            BroadcastUtil.sendVoiceRecordChangedEvent(this.mCtx);
        }
        this.cleanUp();
    }

    private void parseArray(JSONArray arr, int type) {
        int size = arr.length();
        for (int i = 0; i < size; ++i) {
            Message msg;
            String packetId;
            VoiceItem item = null;
            JSONObject props = new JSONObject();
            int msgType = 12;
            try {
                JSONObject obj = arr.getJSONObject(i);
                item = VoicemailManager.parse(this.mCtx, obj, type);
                msgType = item.getGroup() == 0 ? 12 : 13;
                props.put("vmId", item.getId());
                if (msgType == 12) {
                    props.put("vm", obj);
                } else {
                    props.put("record", obj);
                }
                props.put("message_type", msgType);
            }
            catch (JSONException e) {
                Log.e(VoiceItem.class.getSimpleName(), "parseArray", e);
            }
            if (item == null) continue;
            GetVoiceDataTask.configureVoiceItem(this.mCtx, item);
            VoiceItem oldItem = UCDBVoiceMsg.getVoiceItem(this.mCtx, item.getId(), type);
            if (oldItem == null) {
                if (!ApiVersion.isApi3Later()) {
                    packetId = null;
                    packetId = item.getType().equals("LINE_TYPE_8") ? ChatRoomManager.newInboundNumRecordMsg(this.mCtx, item.getDuration(), item.getNumber(), item.getSite(), item.getEndTime(), item.isRead(), item.isPlayed(), msgType, props, true) : ChatRoomManager.newInboundRecordMsg(this.mCtx, item.getDuration(), item.getNumber(), item.getName(), item.getDBId(), item.getDBId(), item.getEndTime(), item.isRead(), item.isPlayed(), msgType, props, true);
                    item.setPacketId(packetId);
                }
                UCDBVoiceMsg.addVoiceItem(this.mCtx, item);
                continue;
            }
            if (!ApiVersion.isApi3Later() && (packetId = oldItem.getPacketId()) != null && (msg = UCDBMessage.findMsgByPacketId(this.mCtx, packetId)) != null) {
                boolean doFlagChanged = false;
                if (!msg.isPlayed() && item.isPlayed()) {
                    doFlagChanged = true;
                }
                if (!msg.isRead() && item.isRead()) {
                    doFlagChanged = true;
                }
                UCDBMessage.updateChatRoomMsgReadPlayedStatusByPacketId(this.mCtx, packetId, item.isRead(), item.isPlayed());
                if (doFlagChanged) {
                    BroadcastUtil.sendMsgPlayedEvent(this.mCtx, packetId);
                }
            }
            UCDBVoiceMsg.updateVoiceItem(this.mCtx, String.valueOf(item.getId()), type, item.isRead(), item.isPlayed());
        }
        if (PreferencesUtil.isSyncOldChatEventDone(this.mCtx)) {
            BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
            BroadcastUtil.sendMsgChangedEvent(this.mCtx);
        }
    }

    public static void updateNameForDisp(Context ctx, VoiceItem item) {
        if ("EMPLOYEE".equals(item.getType())) {
            if (item.getDBId() != null) {
                LiteContact c = UCDBContact.getContactByEmpId(ctx, Long.parseLong(item.getDBId().trim()));
                if (c != null) {
                    item.setName(ContactManager.getContactFullName(c));
                } else {
                    item.setName(item.getNumber());
                }
            }
        } else if ("LOCATION".equals(item.getType())) {
            if (item.getSite() != null && item.getNumber() != null) {
                LiteContact c = UCDBContact.getContactByLodId(ctx, item.getSite(), item.getNumber());
                if (c != null) {
                    item.setName(ContactManager.getContactFullName(c));
                } else {
                    item.setName(item.getNumber());
                }
            }
        } else if ("TRUNK".equals(item.getType())) {
            item.setName(PhoneNoUtil.getPhoneNumDisp(ctx, item.getSite(), item.getNumber()));
        } else if ("LINE_TYPE_1".equals(item.getType())) {
            if (item.getDBId() != null) {
                LiteContact c = ContactManager.getContact(ctx, item.getDBId());
                if (c != null) {
                    item.setName(ContactManager.getContactFullName(c));
                } else {
                    item.setName(item.getNumber());
                }
            }
        } else if ("LINE_TYPE_2".equals(item.getType())) {
            if (item.getDBId() != null) {
                LiteContact c = ContactManager.getContact(ctx, item.getDBId());
                if (c != null) {
                    item.setName(ContactManager.getContactFullName(c));
                } else {
                    item.setName(item.getNumber());
                }
            }
        } else if ("LINE_TYPE_6".equals(item.getType())) {
            long contactId;
            LiteMyContact c;
            if (item.getDBId() != null && (c = UCDBExternalContact.getExternalContactById(ctx, contactId = JidUtil.trimExternalContactId(item.getDBId()))) != null) {
                item.setName(c.getName());
            }
        } else if ("LINE_TYPE_8".equals(item.getType())) {
            if (item.getName() == null) {
                item.setName(item.getNumber());
            } else {
                item.setName(PhoneNoUtil.getPhoneNumDisp(ctx, item.getSite(), item.getNumber()));
            }
        } else if ("LINE_TYPE_4".equals(item.getType())) {
            ChatRoomInfo chatRoom = ChatRoomManager.getChatRoom(ctx, item.getDBId());
            item.setName(ChatRoomUtil.getChatRoomTitle(ctx, chatRoom));
        } else if ("LINE_TYPE_5".equals(item.getType())) {
            ChatRoomInfo chatRoom = ChatRoomManager.getChatRoom(ctx, item.getDBId());
            LiteConferenceRoom room = MeetmeManager.getStaticMeetme(ctx, item.getDBId());
            String roomTitle = ChatRoomUtil.getConfRoomTitle(ctx, chatRoom, room, false, false);
            item.setName(roomTitle);
        }
    }

    public static void configureVoiceItem(Context ctx, VoiceItem item) {
        if ("EMPLOYEE".equals(item.getType())) {
            long dbid;
            LiteContact c;
            boolean hasEmpConfigured = false;
            if (item.getJid() != null) {
                if (!DeletedContactManager.existDeletedContact(ctx, item.getJid())) {
                    item.setType("LINE_TYPE_1");
                    item.setDBId(item.getJid());
                    hasEmpConfigured = true;
                    LiteContact liteContact = ContactManager.getContact(ctx, item.getJid());
                }
            } else if (item.getDBId() != null && (c = UCDBContact.getContactByEmpId(ctx, dbid = Long.parseLong(item.getDBId().trim()))) != null) {
                item.setType("LINE_TYPE_1");
                item.setDBId(c.getJid());
                hasEmpConfigured = true;
            }
            if (!hasEmpConfigured && item.getNumber() != null) {
                item.setType("LINE_TYPE_8");
                item.setDBId(item.getNumber() + "@phonenumber");
            }
        } else if ("LOCATION".equals(item.getType())) {
            LiteContact c;
            boolean hasLocationConfigured = false;
            if (item.getJid() != null) {
                item.setType("LINE_TYPE_2");
                item.setDBId(item.getJid());
                hasLocationConfigured = true;
            } else if (item.getSite() != null && item.getNumber() != null && (c = UCDBContact.getContactByLodId(ctx, item.getSite(), item.getNumber())) != null) {
                item.setType("LINE_TYPE_2");
                item.setDBId(c.getJid());
                hasLocationConfigured = true;
            }
            if (!hasLocationConfigured && item.getNumber() != null) {
                item.setType("LINE_TYPE_8");
                item.setDBId(item.getNumber() + "@phonenumber");
            }
        } else {
            item.setType("LINE_TYPE_8");
            item.setDBId(item.getNumber() + "@phonenumber");
            PhoneMatcherResult result = PhoneMatcher.match(ctx, item.getNumber(), false);
            if (result != null) {
                if (result.getMatchType() == 0 || result.getMatchType() == 4) {
                    item.setType("LINE_TYPE_1");
                    item.setDBId(result.getTargetJid());
                    item.setName(result.getTargetName());
                } else if (result.getMatchType() == 1) {
                    item.setType("LINE_TYPE_2");
                    item.setDBId(result.getTargetJid());
                    item.setName(result.getTargetName());
                } else if (result.getMatchType() == 5) {
                    item.setType("LINE_TYPE_6");
                    item.setDBId(result.getTargetJid());
                    item.setName(result.getTargetName());
                }
            }
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

