/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.db.UCDBVoiceMsg;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import java.util.List;

@MigratedFromMobileApp
public class MarkRemoteReadTask
extends ExThread {
    private String mChatId;

    public MarkRemoteReadTask(Context ctx, String chatId) {
        super(ctx, "MarkRemoteReadTask");
        this.mChatId = chatId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Context context = this.mCtx;
        synchronized (context) {
            Long[] ids;
            int i;
            List<Long[]> chatEventIdList = ChatRoomManager.findUnreadMsgIds(this.mCtx, this.mChatId);
            List<Message> chatVoicemaildMsgList = ChatRoomManager.findUnreadVociemailMsgIds(this.mCtx, this.mChatId);
            List<Message> chatPersonalRecordMsgList = ChatRoomManager.findUnreadPersonalRecordMsgIds(this.mCtx, this.mChatId);
            for (i = 0; chatEventIdList != null && i < chatEventIdList.size(); ++i) {
                ids = chatEventIdList.get(i);
                if (ids[1] == null || ids[1] == -1L || ids[1] == 0L) continue;
                UCDBRemoteMark.addRemoteMark(this.mCtx, 3, ids[1]);
                UCDBMessage.updateChatRoomMsgReadStatusByChatEventId(this.mCtx, ids[1]);
            }
            if (chatEventIdList != null && chatEventIdList.size() != 0) {
                BroadcastUtil.sendMsgReadStatusChangedEvent(this.mCtx, this.mChatId);
            }
            if (!ApiVersion.isApi3Later()) {
                String dirtyPersonalRecordingIdStr;
                String dirtyVoicemailIdStr = this.getUpdateIdList(chatVoicemaildMsgList, 0);
                if (dirtyVoicemailIdStr != null) {
                    WebAgent.getInstance().markVoicemailAsRead(dirtyVoicemailIdStr);
                }
                if ((dirtyPersonalRecordingIdStr = this.getUpdateIdList(chatPersonalRecordMsgList, 1)) != null) {
                    WebAgent.getInstance().markPersonalRecordAsRead(dirtyPersonalRecordingIdStr);
                }
            }
            if (ApiVersion.isApi1Later()) {
                String chatEventIdStr = this.getUpdateChatEventIdList(chatEventIdList);
                if (chatEventIdStr != null) {
                    WebAgent.getInstance().markChatEventAsRead(chatEventIdStr);
                }
            } else {
                for (i = 0; chatEventIdList != null && i < chatEventIdList.size(); ++i) {
                    ids = chatEventIdList.get(i);
                    if (ids[1] == null || ids[1] == -1L || ids[1] == 0L) continue;
                    WebAgent.getInstance().markChatEventAsRead(ids[1]);
                }
            }
        }
        TaskController.getInstance().removeTask(this);
    }

    private String getUpdateChatEventIdList(List<Long[]> chatEventIdList) {
        StringBuffer b = new StringBuffer();
        boolean doNeetUpdate = false;
        int index = 0;
        for (int i = 0; chatEventIdList != null && i < chatEventIdList.size(); ++i) {
            Long[] ids = chatEventIdList.get(i);
            if (ids[1] == null || ids[1] == -1L || ids[1] == 0L) continue;
            doNeetUpdate = true;
            if (index != 0) {
                b.append(",");
            }
            b.append(ids[1]);
            ++index;
        }
        if (doNeetUpdate) {
            return b.toString();
        }
        return null;
    }

    private String getUpdateIdList(List<Message> itemList, int type) {
        StringBuffer b = new StringBuffer();
        boolean doNeetUpdate = false;
        int index = 0;
        for (int i = 0; itemList != null && i < itemList.size(); ++i) {
            Message message = itemList.get(i);
            try {
                VoiceItem item = VoicemailManager.getVoiceItemByMessage(this.mCtx, message);
                if (item == null) continue;
                doNeetUpdate = true;
                if (index != 0) {
                    b.append(",");
                }
                b.append(item.getId());
                if (type == 1) {
                    UCDBRemoteMark.addRemoteMark(this.mCtx, 1, item.getId());
                } else if (type == 0) {
                    UCDBRemoteMark.addRemoteMark(this.mCtx, 2, item.getId());
                }
                UCDBVoiceMsg.updateVoiceMsgReadStatus(this.mCtx, item.getId());
                ++index;
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (doNeetUpdate) {
            return b.toString();
        }
        return null;
    }

    @Override
    public String toString() {
        return "MarkRemoteReadTask - " + super.toString();
    }
}

