/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.FetchEmpTaskController;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.HashSet;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MeetmeJoinTask
extends ExThread {
    private static final Logger logger = LoggerFactory.getLogger(MeetmeJoinTask.class);
    private JSONObject mDataObj;

    public MeetmeJoinTask(Context context, JSONObject dataObj) {
        super(context, "MeetmeJoinTask");
        this.mDataObj = dataObj;
    }

    @Override
    public void run() {
        this.doAction();
        this.cleanUp();
    }

    private void doAction() {
        try {
            String roomNo;
            logger.info("received meetMe join event: " + String.valueOf(this.mDataObj));
            long roomId = Long.parseLong(this.mDataObj.getString("meetMe"));
            String callerType = this.mDataObj.getString("callerType");
            String chatroomJid = this.mDataObj.has("chatRoomId") ? this.mDataObj.getString("chatRoomId") : null;
            String string = roomNo = this.mDataObj.has("roomNo") ? this.mDataObj.getString("roomNo") : "";
            if (chatroomJid == null || "".equals(chatroomJid.trim()) || callerType == null) {
                return;
            }
            boolean newAdd = ChatRoomManager.prepareChatRoom(this.mCtx, chatroomJid);
            if (newAdd) {
                WebAgent.getInstance().getOneRoomSync(chatroomJid);
            }
            this.processMeemeJoinData(roomId, callerType, chatroomJid);
            WebAgent.getInstance().queryMeetMeListUser(roomId);
            if (this.mDataObj.has("channel") && this.mDataObj.has("roomName")) {
                String sipUsername = PreferencesUtil.getSipUserName(this.mCtx);
                String channel = this.mDataObj.getString("channel");
                String roomName = this.mDataObj.getString("roomName");
                String sipCallId = null;
                if (this.mDataObj.has("sipCallId")) {
                    sipCallId = this.mDataObj.getString("sipCallId");
                }
                if (channel.startsWith("SIP/" + sipUsername + "-")) {
                    PhoneAgent.getInstance().onInviteThreeWayCalling(this.mCtx, String.valueOf(roomId), roomName, roomNo, chatroomJid, sipCallId);
                }
            }
        }
        catch (Throwable t) {
            Log.e(MeetmeJoinTask.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void processMeemeJoinData(long roomId, String callerType, String chatroomJid) throws JSONException {
        LiteConferenceUserStatus newUser;
        LiteConferenceRoom confRoom = UCDBConf.getConfRoomByChatRoomId(this.mCtx, String.valueOf(roomId));
        if (confRoom == null) {
            WebAgent.getInstance().getOneMeetMe(roomId);
        }
        if ((newUser = (LiteConferenceUserStatus)new Gson().fromJson(this.mDataObj.toString(), new TypeToken<LiteConferenceUserStatus>(this){}.getType())) == null) {
            Log.e(MeetmeJoinTask.class.getSimpleName(), "ERROR: new user is null");
            return;
        }
        MeetmeManager.addConfRoomUser(this.mCtx, roomId, newUser);
        if (!UCDBChatRoom.hasParticipants(this.mCtx, chatroomJid)) {
            return;
        }
        if (callerType.equals("EMPLOYEE")) {
            String callerJid = newUser.getCallerJid();
            if (TextUtils.isNotBlank((CharSequence)callerJid)) {
                LiteContact contact = ContactManager.getContact(this.mCtx, callerJid);
                if (contact == null) {
                    FetchEmpTaskController.getInstance(this.mCtx).addTaskNoScopeCheck(callerJid);
                } else {
                    FetchEmpTaskController.getInstance(this.mCtx).addTask(contact);
                }
                this.newMeetmeJoinMsg(chatroomJid, callerJid, newUser.getCallerIdNumber());
            } else {
                long callerDbId = Long.parseLong(newUser.getCallerDbId());
                LiteContact contact = ContactManager.getContact(this.mCtx, callerDbId);
                if (contact != null) {
                    FetchEmpTaskController.getInstance(this.mCtx).addTask(contact);
                    this.newMeetmeJoinMsg(chatroomJid, contact.getJid(), newUser.getCallerIdNumber());
                } else {
                    HashSet<Long> idSet = new HashSet<Long>();
                    idSet.add(callerDbId);
                    WebAgent.getInstance().queryEmployeeListByIds(idSet);
                }
            }
        } else if (callerType.equals("LOCATION")) {
            String callerJid = ContactManager.getJidByLocId(this.mCtx, newUser.getCallerIdNumberSite(), newUser.getCallerIdNumber());
            if (callerJid != null) {
                this.newMeetmeJoinMsg(chatroomJid, callerJid, newUser.getCallerIdNumber());
            }
        } else {
            PhoneMatcherResult result = PhoneMatcher.match(this.mCtx, newUser.getCallerIdNumber(), true);
            if (result != null) {
                this.newMeetmeJoinMsg(chatroomJid, result.getTargetJid(), newUser.getCallerIdNumber());
            } else {
                this.newMeetmeJoinMsg(chatroomJid, newUser.getCallerIdNumber() + "@phonenumber", newUser.getCallerIdNumber());
            }
        }
    }

    private void newMeetmeJoinMsg(String chatroomJid, String callerJid, String number) {
        String userJid = PreferencesUtil.getUserJid(this.mCtx);
        String packetId = ChatRoomManager.genNewPacketId();
        MsgBean bean = new MsgBean();
        bean.setChatEventId(-1L);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(chatroomJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(callerJid);
        bean.setToJid(userJid);
        bean.setContent(number);
        bean.setMsgType(callerJid.equals(userJid) ? 231 : 232);
        bean.setDuration(0L);
        bean.setRead(true);
        bean.setPlayed(true);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(false);
        ChatRoomManager.newChatMsg(this.mCtx, chatroomJid, bean, false);
        if (PreferencesUtil.isSyncOldChatEventDone(this.mCtx)) {
            BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
            BroadcastUtil.sendMsgChangedEvent(UCChatClient.context, chatroomJid);
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

