/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.TenantUtils;
import com.blisscloud.ezuc.WsEncryption;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Base64;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.SiteInfo;
import com.blisscloud.mobile.ezuc.listener.IProgressUpdateListener;
import com.blisscloud.mobile.ezuc.util.KeyStoreLoader;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCSSLSocketFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.HttpInetSocketAddress;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CommonUtil {
    private static final String ENCODING_UTF8 = "UTF-8";
    public static final int SOTIMEOUT = 10000;
    public static final int CONNTIMEOUT = 10000;
    private static Random randGen = new Random();
    private static final char[] numbersAndLetters = "0123456789abcdefghijklmnopqrstuvwxyz0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    public static String randomString(int length) {
        if (length < 1) {
            return null;
        }
        char[] randBuffer = new char[length];
        for (int i = 0; i < randBuffer.length; ++i) {
            randBuffer[i] = numbersAndLetters[randGen.nextInt(71)];
        }
        return new String(randBuffer);
    }

    public static String getTimeFormat(long l) {
        Object s = null;
        s = l < 10L ? "0" + l : Long.toString(l);
        return s;
    }

    public static String getDurationSeconds(long sec) {
        return CommonUtil.getDurationMilliSeconds(sec * 1000L);
    }

    public static String getDurationMilliSeconds(long duration) {
        if (duration <= 500L) {
            return "00:00";
        }
        if (duration < 1000L) {
            return "00:01";
        }
        long secondX = duration / 1000L + (long)(duration % 1000L > 500L ? 1 : 0);
        long hour = secondX / 3600L;
        long rest = secondX % 3600L;
        long minute = rest / 60L;
        long second = rest %= 60L;
        if (hour > 0L) {
            return CommonUtil.formatTwoDigit(hour) + ":" + CommonUtil.formatTwoDigit(minute) + ":" + CommonUtil.formatTwoDigit(second);
        }
        return CommonUtil.formatTwoDigit(minute) + ":" + CommonUtil.formatTwoDigit(second);
    }

    private static String formatTwoDigit(long t) {
        if (t == 0L) {
            return "00";
        }
        if (t < 10L) {
            return "0" + String.valueOf(t);
        }
        return String.valueOf(t);
    }

    public static SiteInfo[] getJsonDataArray(String data) {
        JSONArray dataArray = null;
        SiteInfo[] ret = null;
        if (TextUtils.isNotBlank((CharSequence)data)) {
            try {
                dataArray = new JSONArray(data);
                if (dataArray.length() > 0) {
                    ret = new SiteInfo[dataArray.length()];
                }
                for (int a = 0; a < dataArray.length(); ++a) {
                    ret[a] = new SiteInfo();
                    JSONObject dataObj = dataArray.getJSONObject(a);
                    ret[a].setId(dataObj.getLong("id"));
                    ret[a].setName(dataObj.getString("name"));
                }
            }
            catch (JSONException e) {
                Log.e(CommonUtil.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage());
            }
        }
        return ret;
    }

    public static String[] getJsonDataArray(String data, String key) {
        JSONArray dataArray = null;
        String[] ret = null;
        if (TextUtils.isNotBlank((CharSequence)data)) {
            try {
                dataArray = new JSONArray(data);
                if (dataArray.length() > 0) {
                    ret = CommonUtil.getJsonArray(dataArray, key);
                }
            }
            catch (JSONException e) {
                Log.e(CommonUtil.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage());
            }
        }
        return ret;
    }

    private static String[] getJsonArray(JSONArray dataArray, String key) {
        String[] ret = new String[dataArray.length()];
        try {
            for (int a = 0; a < dataArray.length(); ++a) {
                JSONObject dataObj = dataArray.getJSONObject(a);
                ret[a] = dataObj.get(key).toString();
            }
        }
        catch (JSONException e) {
            Log.e(CommonUtil.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage());
        }
        return ret;
    }

    public static HttpClient getHttpsClient(Context ctx, boolean handleRedirect, int conntimeout, int sotimeout) {
        return CommonUtil.getHttpsClient(ctx, CommonUtil.getHttpsPort(ctx), handleRedirect, conntimeout, sotimeout);
    }

    public static HttpClient getHttpsClient(Context ctx, boolean handleRedirect) {
        return CommonUtil.getHttpsClient(ctx, CommonUtil.getHttpsPort(ctx), handleRedirect, 10000, 10000);
    }

    public static int getHttpsPort(Context ctx) {
        int p = 0;
        p = PreferencesUtil.isInOffice(ctx) ? 8443 : PreferencesUtil.getExternalPort(ctx);
        return p;
    }

    public static String getHttpsIpPort(Context ctx) {
        String s = null;
        s = PreferencesUtil.isInOffice(ctx) ? PreferencesUtil.getHost(ctx) + ":8443" : PreferencesUtil.getExternalHost(ctx) + ":" + PreferencesUtil.getExternalPort(ctx);
        return s;
    }

    public static HttpClient getHttpsClient(Context ctx, int port, boolean handleRedirect, int conntimeout, int sotimeout) {
        KeyStore keyStore = KeyStoreLoader.getInstance(ctx).getKeyStore();
        if (keyStore == null) {
            return null;
        }
        BasicHttpParams httpParameters = new BasicHttpParams();
        httpParameters.setParameter("http.protocol.handle-redirects", (Object)handleRedirect);
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpParameters, (int)conntimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)httpParameters, (int)sotimeout);
        DefaultHttpClient mHttpClient = null;
        try {
            final UCSSLSocketFactory sff = new UCSSLSocketFactory(keyStore);
            sff.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            SchemeRegistry schemeRegistry = new SchemeRegistry();
            schemeRegistry.register(new Scheme("https", port, (SchemeSocketFactory)sff));
            mHttpClient = new DefaultHttpClient((ClientConnectionManager)new BasicClientConnectionManager(schemeRegistry){

                protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
                    return new DefaultClientConnectionOperator(schreg){

                        public void openConnection(OperatedClientConnection conn, HttpHost target, InetAddress local, HttpContext context, HttpParams params) throws IOException {
                            if (conn == null) {
                                throw new IllegalArgumentException("Connection may not be null");
                            }
                            if (target == null) {
                                throw new IllegalArgumentException("Target host may not be null");
                            }
                            if (params == null) {
                                throw new IllegalArgumentException("Parameters may not be null");
                            }
                            if (conn.isOpen()) {
                                throw new IllegalStateException("Connection must not be open");
                            }
                            Scheme schm = this.schemeRegistry.getScheme(target.getSchemeName());
                            SchemeSocketFactory sf = schm.getSchemeSocketFactory();
                            InetAddress[] addresses = this.resolveHostname(target.getHostName());
                            int port = schm.resolvePort(target.getPort());
                            for (int i = 0; i < addresses.length; ++i) {
                                HttpInetSocketAddress remoteAddress;
                                block11: {
                                    InetAddress address = addresses[i];
                                    boolean last = i == addresses.length - 1;
                                    Socket sock = sff.createSocket();
                                    conn.opening(sock, target);
                                    remoteAddress = new HttpInetSocketAddress(target, address, port);
                                    InetSocketAddress localAddress = null;
                                    if (local != null) {
                                        localAddress = new InetSocketAddress(local, 0);
                                    }
                                    Log.d(CommonUtil.class.getSimpleName(), "Connecting to " + String.valueOf(remoteAddress));
                                    try {
                                        Socket connsock = sf.connectSocket(sock, (InetSocketAddress)remoteAddress, localAddress, params);
                                        if (sock != connsock) {
                                            sock = connsock;
                                            conn.opening(sock, target);
                                        }
                                        this.prepareSocket(sock, context, params);
                                        conn.openCompleted(sf.isSecure(sock), params);
                                        return;
                                    }
                                    catch (ConnectException ex) {
                                        if (last) {
                                            throw new HttpHostConnectException(target, ex);
                                        }
                                    }
                                    catch (ConnectTimeoutException ex) {
                                        if (!last) break block11;
                                        throw ex;
                                    }
                                }
                                Log.d(CommonUtil.class.getSimpleName(), "Connect to " + String.valueOf(remoteAddress) + " timed out. Connection will be retried using another IP address");
                            }
                        }
                    };
                }
            }, (HttpParams)httpParameters);
        }
        catch (Exception e) {
            Log.e(CommonUtil.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage());
        }
        return mHttpClient;
    }

    public static String doHttpRequest(Context ctx, String no, String url, JSONObject jo, boolean handleRedirect) {
        return CommonUtil.doHttpRequest(ctx, no, url, jo, null, handleRedirect);
    }

    public static String doHttpRequest(Context ctx, String no, String url, JSONObject jo, HashMap<String, String> postParams, boolean handleRedirect) {
        HttpClient httpclient = CommonUtil.getHttpsClient(ctx, 8443, handleRedirect, 10000, 10000);
        String result = null;
        boolean fail = true;
        try {
            HttpResponse response;
            StatusLine statusLine;
            int code;
            HttpPost httpPost = new HttpPost(url);
            Locale locale = I18NUtil.getAppLocale();
            if (Locale.TAIWAN.equals(locale)) {
                httpPost.addHeader("Accept-Language", "zh-TW");
            } else if (Locale.CHINA.equals(locale) || Locale.CHINESE.equals(locale)) {
                httpPost.addHeader("Accept-Language", "zh-CN");
            } else {
                httpPost.addHeader("Accept-Language", "en-US");
            }
            ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
            nvps.add(new BasicNameValuePair("username", TenantUtils.USER_NAME));
            nvps.add(new BasicNameValuePair("password", TenantUtils.PASSWORD));
            if (no != null) {
                String enterpriseNo = no.toLowerCase(Locale.US);
                enterpriseNo = URLEncoder.encode(enterpriseNo, ENCODING_UTF8);
                nvps.add(new BasicNameValuePair("tenantNo", enterpriseNo));
                nvps.add(new BasicNameValuePair("enterpriseNo", enterpriseNo));
            }
            if (postParams != null) {
                Set<Map.Entry<String, String>> set = postParams.entrySet();
                for (Map.Entry<String, String> p : set) {
                    nvps.add(new BasicNameValuePair(p.getKey(), p.getValue()));
                }
            }
            if (jo != null) {
                jo.put("ts", String.valueOf(Calendar.getInstance().getTimeInMillis()));
                jo.put("rnd", String.valueOf(Math.random()));
                if (no != null) {
                    jo.put("tenantNo", no);
                }
                jo.put("dsusername", TenantUtils.DS_USER_NAME);
                jo.put("dspassword", TenantUtils.DS_PASSWORD);
                jo.put("checkSum", TenantUtils.getChecksum(jo.getString("rnd")));
                String timeStampx = CommonUtil.encryptString(jo.toString());
                nvps.add(new BasicNameValuePair("timeStampx", timeStampx));
            }
            if (nvps.size() > 0) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps));
            }
            if ((code = (statusLine = (response = httpclient.execute((HttpUriRequest)httpPost)).getStatusLine()).getStatusCode() / 100) == 3) {
                Header h = response.getFirstHeader("Location");
                if (h != null) {
                    result = h.getValue();
                    Log.i(CommonUtil.class.getSimpleName(), "result:" + result);
                    fail = false;
                }
            } else if (code == 2) {
                HttpEntity entity2 = response.getEntity();
                result = EntityUtils.toString((HttpEntity)entity2);
                Log.i(CommonUtil.class.getSimpleName(), "result:" + result);
                fail = false;
            }
        }
        catch (Throwable e) {
            Log.e(CommonUtil.class.getSimpleName(), "doHttpRequest error:" + e.getLocalizedMessage());
        }
        if (fail) {
            return null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doHttpRequest(Context ctx, String url, IProgressUpdateListener listener, boolean handleRedirect) {
        HttpClient httpclient = CommonUtil.getHttpsClient(ctx, 8443, handleRedirect, 10000, 10000);
        InputStream instream = null;
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        FileOutputStream fout = null;
        boolean fail = true;
        HttpPost httpPost = null;
        try {
            boolean created;
            httpPost = new HttpPost(url);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            int code = statusLine.getStatusCode() / 100;
            Log.i(CommonUtil.class.getSimpleName(), "StatusLine:" + String.valueOf(statusLine));
            if (code != 2) return fail;
            HttpEntity entity = response.getEntity();
            if (entity == null) return fail;
            instream = entity.getContent();
            long contentLength = response.getEntity().getContentLength();
            long currentLength = 0L;
            File f = new File("uctempvideo.mp4");
            if (f.exists()) {
                f.delete();
            }
            if (!(created = f.createNewFile())) return fail;
            fout = new FileOutputStream(f);
            bis = new BufferedInputStream(instream);
            bos = new BufferedOutputStream(fout);
            byte[] inByte = new byte[1024];
            int length = bis.read(inByte);
            while (length != -1) {
                ((BufferedOutputStream)bos).write(inByte, 0, length);
                listener.onProgessUpdate((currentLength += (long)length) * 100L / contentLength);
                length = bis.read(inByte);
            }
            fail = false;
            return fail;
        }
        catch (Throwable e) {
            Log.e(CommonUtil.class.getSimpleName(), "doHttpRequest", e);
            httpPost.abort();
            return fail;
        }
        finally {
            if (bis != null) {
                try {
                    try {
                        bis.close();
                        bis = null;
                    }
                    catch (IOException e) {
                        Log.e(CommonUtil.class.getSimpleName(), "doHttpRequest", e);
                        bis = null;
                    }
                }
                catch (Throwable throwable) {
                    bis = null;
                    throw throwable;
                }
            }
            if (bos != null) {
                try {
                    try {
                        bos.close();
                        bos = null;
                    }
                    catch (IOException e) {
                        Log.e(CommonUtil.class.getSimpleName(), "doHttpRequest", e);
                        bos = null;
                    }
                }
                catch (Throwable throwable) {
                    bos = null;
                    throw throwable;
                }
            }
            if (fout != null) {
                try {
                    try {
                        fout.close();
                        fout = null;
                    }
                    catch (IOException e) {
                        Log.e(CommonUtil.class.getSimpleName(), "doHttpRequest", e);
                        fout = null;
                    }
                }
                catch (Throwable throwable) {
                    fout = null;
                    throw throwable;
                }
            }
            if (instream != null) {
                try {
                    try {
                        instream.close();
                        instream = null;
                    }
                    catch (IOException e) {
                        Log.e(CommonUtil.class.getSimpleName(), "doHttpRequest", e);
                        instream = null;
                    }
                }
                catch (Throwable throwable) {
                    instream = null;
                    throw throwable;
                }
            }
        }
    }

    private static String encryptString(String str) {
        try {
            byte[] b = WsEncryption._encryptString(str.getBytes(ENCODING_UTF8));
            return Base64.encodeToString(b, 0);
        }
        catch (UnsupportedEncodingException e) {
            Log.e(CommonUtil.class.getSimpleName(), "encryptString:[" + e.getLocalizedMessage() + "]", e);
            return null;
        }
    }

    public static String getNumberHtmlTable(List<LiteTeleNumber> teleNumbers, boolean hyperlinkNumber) {
        StringBuilder htmlText = new StringBuilder("<html><table cellspacing=\"0\" cellpadding=\"0\">");
        for (LiteTeleNumber teleNumber : teleNumbers) {
            String number = teleNumber.getNumber();
            if (hyperlinkNumber) {
                htmlText.append("<tr><td><font color=\"blue\"><a style=\"text-decoration: none;\" href=\"" + teleNumber.getNumber() + "\">" + teleNumber.getNumber() + "</a></font></td></tr>");
                continue;
            }
            htmlText.append("<tr><td>" + number + "</td></tr>");
        }
        return htmlText.toString();
    }

    public static String strSetToString(Set<String> strSet) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        for (String str : strSet) {
            if (i != 0) {
                b.append(",");
            }
            b.append(str);
            ++i;
        }
        return b.toString();
    }

    public static String longSetToString(Set<Long> idSet) {
        StringBuffer b = new StringBuffer();
        int i = 0;
        for (Long id : idSet) {
            if (i != 0) {
                b.append(",");
            }
            b.append(String.valueOf(id));
            ++i;
        }
        return b.toString();
    }

    public static JSONArray getJSONArrayString(Collection<String> participantJIDs) {
        JSONArray obj = new JSONArray();
        if (participantJIDs != null) {
            for (String i : participantJIDs) {
                obj.put(i);
            }
        }
        return obj;
    }

    public static boolean isChina(Context ctx) {
        Locale locale = I18NUtil.getAppLocale();
        return "CN".equals(locale.getCountry()) || "HK".equals(locale.getCountry()) || "MO".equals(locale.getCountry());
    }
}

