/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.util.ProtectedConfigFile;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.Set;

class Editor {
    public static final File PREFERENCE_FILE_ENCRYPTED = new File(FileUtil.getAppRootDir(), "ucpref.properties");
    private Properties p = new Properties();

    Editor() {
    }

    public Editor putStringSet(String key, Set<String> value) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.close();
            this.p.setProperty(key, ProtectedConfigFile.base64Encode(baos.toByteArray()));
        }
        catch (Throwable t) {
            Log.i(PreferencesUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
        return this;
    }

    public Set<String> getStringSet(String key, Set<String> defValue) {
        if (this.p.containsKey(key)) {
            try {
                String s = this.p.getProperty(key);
                byte[] data = ProtectedConfigFile.base64Decode(s);
                ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
                Object o = ois.readObject();
                ois.close();
                return (Set)o;
            }
            catch (Throwable t) {
                Log.i(PreferencesUtil.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
                return defValue;
            }
        }
        return defValue;
    }

    public synchronized void load() {
        Log.i(Editor.class.getSimpleName(), "load preference file " + PREFERENCE_FILE_ENCRYPTED.getAbsolutePath());
        try {
            File OLD_PREFERENCE_FILE;
            if ((PREFERENCE_FILE_ENCRYPTED == null || !PREFERENCE_FILE_ENCRYPTED.exists()) && (OLD_PREFERENCE_FILE = new File(FileUtil.getAppRootDir(), "uc-chatclient.properties")) != null && OLD_PREFERENCE_FILE.exists()) {
                Properties p = new Properties();
                FileInputStream fis = new FileInputStream(OLD_PREFERENCE_FILE);
                p.load(fis);
                fis.close();
                Properties encP = new Properties();
                for (Object name : p.keySet()) {
                    Log.i(Editor.class.getSimpleName(), String.valueOf(name) + " enc " + p.getProperty((String)name));
                    String enc = ProtectedConfigFile.encrypt(p.getProperty((String)name));
                    encP.setProperty((String)name, enc);
                    String dec = ProtectedConfigFile.decrypt(enc);
                    Log.i(Editor.class.getSimpleName(), String.valueOf(name) + " dec " + dec);
                }
                if (!PREFERENCE_FILE_ENCRYPTED.getParentFile().exists()) {
                    PREFERENCE_FILE_ENCRYPTED.getParentFile().mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(PREFERENCE_FILE_ENCRYPTED);
                encP.store(fos, null);
                fos.close();
                OLD_PREFERENCE_FILE.delete();
            }
            FileInputStream fis = new FileInputStream(PREFERENCE_FILE_ENCRYPTED);
            this.p.load(fis);
            fis.close();
        }
        catch (FileNotFoundException e) {
            Log.w(Editor.class.getSimpleName(), "preference file " + PREFERENCE_FILE_ENCRYPTED.getAbsolutePath() + " is not found.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public synchronized boolean commit() {
        Log.d(Editor.class.getSimpleName(), "save preference file " + PREFERENCE_FILE_ENCRYPTED.getAbsolutePath());
        try {
            if (!PREFERENCE_FILE_ENCRYPTED.getParentFile().exists()) {
                PREFERENCE_FILE_ENCRYPTED.getParentFile().mkdirs();
            }
            FileOutputStream fos = new FileOutputStream(PREFERENCE_FILE_ENCRYPTED);
            this.p.store(fos, null);
            fos.close();
            return true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public synchronized boolean contains(String key) {
        return this.p.containsKey(key);
    }

    public synchronized Editor remove(String key) {
        if (this.p.containsKey(key)) {
            this.p.remove(key);
        }
        return this;
    }

    public synchronized boolean getBoolean(String key, boolean defaultValue) {
        return this.p.containsKey(key) ? Boolean.parseBoolean(ProtectedConfigFile.decrypt(this.p.getProperty(key))) : defaultValue;
    }

    public synchronized int getInt(String key, int defaultValue) {
        return this.p.containsKey(key) ? Integer.parseInt(ProtectedConfigFile.decrypt(this.p.getProperty(key))) : defaultValue;
    }

    public synchronized float getFloat(String key, float defaultValue) {
        return this.p.containsKey(key) ? Float.parseFloat(ProtectedConfigFile.decrypt(this.p.getProperty(key))) : defaultValue;
    }

    public synchronized long getLong(String key, long defaultValue) {
        return this.p.containsKey(key) ? Long.parseLong(ProtectedConfigFile.decrypt(this.p.getProperty(key))) : defaultValue;
    }

    public synchronized String getString(String key, String defaultValue) {
        return this.p.containsKey(key) ? ProtectedConfigFile.decrypt(this.p.getProperty(key)) : defaultValue;
    }

    public synchronized Editor putBoolean(String key, boolean value) {
        this.p.setProperty(key, ProtectedConfigFile.encrypt(String.valueOf(value)));
        return this;
    }

    public synchronized Editor putInt(String key, int value) {
        this.p.setProperty(key, ProtectedConfigFile.encrypt(String.valueOf(value)));
        return this;
    }

    public synchronized Editor putLong(String key, long value) {
        this.p.setProperty(key, ProtectedConfigFile.encrypt(String.valueOf(value)));
        return this;
    }

    public synchronized Editor putFloat(String key, float value) {
        this.p.setProperty(key, ProtectedConfigFile.encrypt(String.valueOf(value)));
        return this;
    }

    public synchronized Editor putString(String key, String value) {
        this.p.setProperty(key, ProtectedConfigFile.encrypt(value));
        return this;
    }
}

