/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import java.util.HashMap;
import org.json.JSONObject;

public class HttpRequestUtil
extends AsyncTask<Void, Void, Void> {
    private int mConnectionTimeout = 10000;
    private final Context mCtx;
    private final String mEnterpriseNo;
    private final JSONObject mJo;
    private final HashMap<String, String> mPostParam;
    private final String mURL;
    private final IRequestListener mListener;
    private String mResult;
    private Thread mRequestThread;
    private boolean mTerminated;
    private boolean mHandleRedirect = true;

    public HttpRequestUtil(Context ctx, String no, String url, JSONObject jo, HashMap<String, String> postParams, IRequestListener listener, boolean handleRedirect, int connectionTimeout) {
        this.mCtx = ctx;
        this.mEnterpriseNo = no;
        this.mJo = jo;
        this.mPostParam = postParams;
        this.mURL = url;
        this.mListener = listener;
        this.mTerminated = false;
        this.mHandleRedirect = handleRedirect;
        this.mConnectionTimeout = connectionTimeout;
    }

    @Override
    protected void onCancelled(Void result) {
        this.mTerminated = true;
        super.onCancelled(result);
    }

    protected Void doInBackground(Void ... arg0) {
        long startTime = System.currentTimeMillis();
        Request request = new Request();
        this.mRequestThread = new Thread((Runnable)request, "HttpRequestUtil");
        this.mRequestThread.start();
        long duration = 0L;
        try {
            do {
                Thread.sleep(300L);
            } while (!TextUtils.isNotBlank((CharSequence)this.mResult) && (duration = System.currentTimeMillis() - startTime) < (long)this.mConnectionTimeout && !this.mTerminated);
        }
        catch (InterruptedException e) {
            Log.e(HttpRequestUtil.class.getSimpleName(), "HttpRequestUtil", e);
        }
        if (this.mRequestThread.isAlive()) {
            Log.i(HttpRequestUtil.class.getSimpleName(), "HttpRequestUtil stop request thread");
            this.mRequestThread.interrupt();
            this.mRequestThread = null;
        }
        return null;
    }

    @Override
    protected void onPostExecute(Void result) {
        super.onPostExecute(result);
        if (this.mListener != null && !this.isCancelled()) {
            this.mListener.onRequestCompleted(this.mResult);
        }
    }

    public static interface IRequestListener {
        public void onRequestCompleted(String var1);
    }

    private class Request
    implements Runnable {
        private Request() {
        }

        @Override
        public void run() {
            HttpRequestUtil.this.mResult = CommonUtil.doHttpRequest(HttpRequestUtil.this.mCtx, HttpRequestUtil.this.mEnterpriseNo, HttpRequestUtil.this.mURL, HttpRequestUtil.this.mJo, HttpRequestUtil.this.mPostParam, HttpRequestUtil.this.mHandleRedirect);
        }
    }
}

