/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.sip;

import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.sip.SipCall;
import com.blisscloud.sip.SipPhoneService;
import com.blisscloud.sip.SipServiceHelper;
import com.blisscloud.sip.SipUtils;
import org.apache.commons.lang3.StringUtils;
import org.pjsip.pjsua2.Account;
import org.pjsip.pjsua2.CallInfo;
import org.pjsip.pjsua2.CallOpParam;
import org.pjsip.pjsua2.CallSetting;
import org.pjsip.pjsua2.OnIncomingCallParam;
import org.pjsip.pjsua2.OnRegStateParam;
import org.pjsip.pjsua2.SipHeader;
import org.pjsip.pjsua2.SipHeaderVector;
import org.pjsip.pjsua2.SipRxData;

class SipAccount
extends Account {
    long lastSystemTime = System.currentTimeMillis();
    private final SipServiceHelper sipServiceHelper;
    private final SipCall[] currentCall;
    private final String makeCallSuffix;

    public SipAccount(SipServiceHelper sipServiceHelper, String makeCallSuffix) {
        this.sipServiceHelper = sipServiceHelper;
        this.makeCallSuffix = makeCallSuffix;
        this.currentCall = new SipCall[PhoneAgent.LINE_COUNT];
    }

    public void answerCall(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "answerCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].answer();
            Log.w(SipAccount.class.getSimpleName(), "answerCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void hangupCall(int line) {
        SipCall call = this.currentCall[line];
        if (call != null) {
            Log.w(SipAccount.class.getSimpleName(), "hangupCall call:" + String.valueOf(this.currentCall[line]));
            try {
                CallInfo ci = call.getInfo();
                Log.i(SipAccount.class.getSimpleName(), "hangup & call state:" + ci.getState());
                if (ci.getState() != 6) {
                    call.hangup();
                }
            }
            catch (Exception e) {
                Log.w("Call already invalid: " + e.getMessage(), e);
            }
            Log.w(SipAccount.class.getSimpleName(), "hangupCall call:" + String.valueOf(call) + " done!");
        }
    }

    public void rejectCall(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "rejectCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].reject();
            Log.w(SipAccount.class.getSimpleName(), "rejectCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void bridgeCall(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "bridgeCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].bridgeCall();
            Log.w(SipAccount.class.getSimpleName(), "bridgeCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void sendDTMF(int line, String dtmf) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "sendDTMF call:" + String.valueOf(this.currentCall[line]) + ", dtmf:" + dtmf);
            this.currentCall[line].sendDTMF(dtmf);
            Log.w(SipAccount.class.getSimpleName(), "sendDTMF call:" + String.valueOf(this.currentCall[line]) + ", dtmf:" + dtmf + " done!");
        }
    }

    public void holdCall(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "holdCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].holdCall();
            Log.w(SipAccount.class.getSimpleName(), "holdCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void unHoldCall(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "unHoldCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].unHoldCall();
            Log.w(SipAccount.class.getSimpleName(), "unHoldCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void transferCall(int line, String phoneNumber) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "transferCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].transferCall(this.getSipNum(phoneNumber));
            Log.w(SipAccount.class.getSimpleName(), "transferCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void transferReplaceCall(int line, int destLine) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "transferCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].transferReplaceCall(this.currentCall[destLine]);
            Log.w(SipAccount.class.getSimpleName(), "transferCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void muteCall(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "muteCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].muteCall();
            Log.w(SipAccount.class.getSimpleName(), "muteCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void unMuteCall(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "unMuteCall call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].unMuteCall();
            Log.w(SipAccount.class.getSimpleName(), "unMuteCall call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void playRingTone(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "playRingTone call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].playRingTone();
            Log.w(SipAccount.class.getSimpleName(), "playRingTone call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void preForAutoAnswer(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "preForAutoAnswer call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].preForAutoAnswer();
            Log.w(SipAccount.class.getSimpleName(), "preForAutoAnswer call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void stopRingTone(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "stopRingTone call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].stopRingTone();
            Log.w(SipAccount.class.getSimpleName(), "stopRingTone call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void adjustVolumnGain(int line, Bundle data) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "adjustVolumnGain call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].adjustVolumnGain(data);
            Log.w(SipAccount.class.getSimpleName(), "adjustVolumnGain call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void startRecording(int line, PhoneLineInfo lineInfo) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "startRecording call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].startRecording(lineInfo);
            Log.w(SipAccount.class.getSimpleName(), "startRecording call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void stopRecording(int line) {
        if (this.currentCall[line] != null) {
            Log.w(SipAccount.class.getSimpleName(), "stopRecording call:" + String.valueOf(this.currentCall[line]));
            this.currentCall[line].stopRecording();
            Log.w(SipAccount.class.getSimpleName(), "stopRecording call:" + String.valueOf(this.currentCall[line]) + " done!");
        }
    }

    public void checkSipMsg(String sipMsg) {
        if (this.currentCall[0] != null && sipMsg.contains("Reason")) {
            this.currentCall[0].setReason(SipUtils.getHeaderData(sipMsg, "Reason"));
        }
        this.parsePjsuaLog(sipMsg);
    }

    public void parsePjsuaLog(String rawText) {
        if (rawText == null || rawText.isEmpty()) {
            return;
        }
        String[] lines = rawText.split("\\r?\\n");
        String sipMethod = null;
        String event = null;
        String callId = null;
        StringBuilder bodyBuilder = new StringBuilder();
        boolean inBody = false;
        boolean isNotify = false;
        for (String line : lines) {
            String trimmed = line.trim();
            if (sipMethod == null && trimmed.matches("^[A-Z]+\\s+sip:.*SIP/2.0$")) {
                sipMethod = trimmed.split("\\s+")[0];
                isNotify = "NOTIFY".equalsIgnoreCase(sipMethod);
                continue;
            }
            if (!inBody && trimmed.isEmpty()) {
                inBody = true;
                continue;
            }
            if (inBody) {
                bodyBuilder.append(line).append("\n");
                continue;
            }
            if (trimmed.toLowerCase().startsWith("event:")) {
                event = line.substring(line.indexOf(":") + 1).trim();
            }
            if (!trimmed.toLowerCase().startsWith("call-id:")) continue;
            callId = line.substring(line.indexOf(":") + 1).trim();
        }
        if (!isNotify) {
            return;
        }
        if (event == null) {
            return;
        }
        String body = bodyBuilder.toString().trim();
        int myLine = 0;
        Log.i(SipAccount.class.getSimpleName(), "callId:" + callId);
        for (int i = 0; i < this.currentCall.length; ++i) {
            if (this.currentCall[i] == null || this.currentCall[i].getCallIdString() == null) continue;
            Log.i(SipAccount.class.getSimpleName(), "currentCall[i].getCallIdString():" + this.currentCall[i].getCallIdString() + " " + this.currentCall[i].getMyLine());
            if (!this.currentCall[i].getCallIdString().equals(callId)) continue;
            myLine = this.currentCall[i].getMyLine();
        }
        Log.i(SipAccount.class.getSimpleName(), "\u6aa2\u6e2c\u5230 NOTIFY\uff0cEvent: " + event + " Body: " + body);
        switch (event.toLowerCase()) {
            case "talk": {
                try {
                    Log.i(SipAccount.class.getSimpleName(), "talk myLine:" + myLine);
                    BroadcastUtil.sendSipNotifyTalkEvent(this.sipServiceHelper.getAppContext(), myLine);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case "hold": {
                try {
                    Log.i(SipAccount.class.getSimpleName(), "hold myLine:" + myLine);
                    BroadcastUtil.sendSipNotifyHoldEvent(this.sipServiceHelper.getAppContext(), myLine);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            default: {
                System.out.println("Unhandle Event: " + event);
            }
        }
    }

    public void makeCall(int line, String number, String delayDtmf, String linkId, long empId, long contactId) {
        this.cleanCall(line);
        try {
            SipHeader sh;
            SipCall call = new SipCall(this.sipServiceHelper, this, -1);
            call.setMyLine(line);
            call.setCaller(this.getSipNum(number));
            CallOpParam prm = new CallOpParam();
            SipHeaderVector shv = new SipHeaderVector();
            if (StringUtils.isNotBlank((CharSequence)linkId)) {
                sh = new SipHeader();
                sh.setHName("linkId");
                sh.setHValue(linkId);
                shv.add(sh);
            }
            if (empId != -1L) {
                sh = new SipHeader();
                sh.setHName("ucEmpId");
                sh.setHValue(String.valueOf(empId));
                shv.add(sh);
            }
            if (contactId != -1L) {
                sh = new SipHeader();
                sh.setHName("ucContactId");
                sh.setHValue(String.valueOf(contactId));
                shv.add(sh);
            }
            if (StringUtils.isNotBlank((CharSequence)delayDtmf)) {
                SipHeader sh2 = new SipHeader();
                sh2.setHName("delayDtmf");
                sh2.setHValue(delayDtmf);
                shv.add(sh2);
            }
            if (shv.size() > 0) {
                prm.getTxOption().setHeaders(shv);
            }
            CallSetting opt = prm.getOpt();
            opt.setAudioCount(1L);
            opt.setVideoCount(0L);
            this.currentCall[line] = call;
            this.currentCall[line].makeCall(call.getCaller(), prm);
            this.currentCall[line].playDialRing();
            this.currentCall[line] = call;
        }
        catch (Throwable e) {
            this.cleanCall(line);
            Log.e(SipPhoneService.class.getSimpleName(), "make call fail", e);
        }
    }

    private String getSipNum(String number) {
        return "sip:" + number + this.makeCallSuffix;
    }

    public void cleanCall(int line) {
        if (this.currentCall == null) {
            return;
        }
        if (this.currentCall[line] != null) {
            this.currentCall[line].cleanSelf();
            this.currentCall[line] = null;
        }
        if (this.currentCall[0] != null || this.currentCall[1] == null) {
            // empty if block
        }
    }

    public void cleanAllCall() {
        this.cleanCall(0);
        this.cleanCall(1);
    }

    public boolean hasCurrentCall(int line) {
        return this.currentCall[line] != null;
    }

    @Override
    public void onRegState(OnRegStateParam prm) {
        try {
            long now = System.currentTimeMillis();
            Log.i(SipAccount.class.getSimpleName(), "onRegState id:" + this.getId() + ", status:" + prm.getStatus() + ", code:" + prm.getCode() + ", reason:" + prm.getReason() + ", expiration:" + prm.getExpiration() + ", last:" + (now - this.lastSystemTime) / 1000L);
            if (prm.getExpiration() == 0L) {
                BroadcastUtil.sendSipUnregStateEvent(this.sipServiceHelper.getAppContext(), prm.getReason());
            } else {
                BroadcastUtil.sendSipRegStateEvent(this.sipServiceHelper.getAppContext(), prm.getReason(), prm.getCode());
            }
            this.lastSystemTime = now;
        }
        catch (Throwable t) {
            Log.i(SipPhoneService.class.getSimpleName(), t.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onIncomingCall(OnIncomingCallParam prm) {
        try {
            SipCall call;
            int incomingCallId = prm.getCallId();
            int thisLine = -1;
            if (this.currentCall[0] == null) {
                thisLine = 0;
            } else if (this.currentCall[1] == null) {
                thisLine = 1;
            }
            if (thisLine == -1) {
                try {
                    SipCall rejectCall = new SipCall(this.sipServiceHelper, this, incomingCallId);
                    try {
                        CallOpParam param = new CallOpParam();
                        param.setStatusCode(486);
                        rejectCall.hangup(param);
                    }
                    catch (Exception e) {
                        Log.e(SipAccount.class.getSimpleName(), "Reject call failed: " + e.getMessage());
                    }
                    finally {
                        rejectCall.delete();
                    }
                }
                catch (Exception e) {
                    Log.e(SipAccount.class.getSimpleName(), "Reject call failed: " + e.getMessage());
                }
                return;
            }
            this.currentCall[thisLine] = call = new SipCall(this.sipServiceHelper, this, incomingCallId);
            SipRxData data = prm.getRdata();
            Log.i(SipAccount.class.getSimpleName(), "info:" + data.getInfo());
            Log.i(SipAccount.class.getSimpleName(), "WholeMsg: " + data.getWholeMsg());
            String sipMsg = data.getWholeMsg();
            String blinfo = SipUtils.getHeaderData(sipMsg, "BL_INFO");
            String blRuleInfo = SipUtils.getHeaderData(sipMsg, "BL_RULE_INFO");
            String blPattern = SipUtils.getHeaderData(sipMsg, "BL_PATTERN");
            call.setMyLine(thisLine);
            call.setCaller(SipUtils.getHeaderData(sipMsg, "From"));
            int result = this.sipServiceHelper.checkDeviceReadyOrNot();
            if (result != 0) {
                Log.e(SipAccount.class.getSimpleName(), "checkDeviceReadyOrNot:" + result);
            }
            CallInfo ci = call.getInfo();
            BroadcastUtil.sendSipIncomingEvent(this.sipServiceHelper.getAppContext(), this.currentCall[thisLine].getCaller(), call.getMyLine(), blinfo, blRuleInfo, blPattern, ci.getCallIdString());
        }
        catch (Throwable e) {
            Log.e(SipAccount.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
        }
    }
}

