/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.sip;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.main.MixVolume;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.SystemUtils;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import com.blisscloud.sip.SipAccount;
import com.blisscloud.sip.SipServiceHelper;
import java.io.File;
import org.pjsip.pjsua2.AudioMedia;
import org.pjsip.pjsua2.AudioMediaRecorder;
import org.pjsip.pjsua2.Call;
import org.pjsip.pjsua2.CallInfo;
import org.pjsip.pjsua2.CallMediaInfo;
import org.pjsip.pjsua2.CallMediaInfoVector;
import org.pjsip.pjsua2.CallOpParam;
import org.pjsip.pjsua2.Media;
import org.pjsip.pjsua2.OnCallMediaStateParam;
import org.pjsip.pjsua2.OnCallStateParam;
import org.pjsip.pjsua2.StreamStat;

class SipCall
extends Call {
    private int myLine = -1;
    private SipAccount account = null;
    private String caller = null;
    private AudioMedia audioMedia = null;
    private boolean isMute = false;
    private String reason = null;
    private boolean isHangupDone = false;
    private long recStartTime = 0L;
    private long recStopTime = 0L;
    private File recordingFile = null;
    private AudioMediaRecorder recorder = null;
    private PhoneLineInfo currentLineInfo = null;
    private final SipServiceHelper sipServiceHelper;
    private boolean media_establish = false;
    private int mAudioIdx = 0;
    private int mTimeoutTimes = 0;
    private long mRxBytes = 0L;
    private boolean isBridged = false;
    private UCTimerTask hangupCleanUpTimerTask = null;
    private CheckRTP checkRTPTask = null;
    private int timeoutSec = 30;
    private String callIdString = null;
    private boolean micMonitorRunning = false;

    public SipCall(SipServiceHelper sipServiceHelper, SipAccount acc, int call_id) {
        super(acc, call_id);
        this.account = acc;
        this.sipServiceHelper = sipServiceHelper;
        this.timeoutSec = PreferencesUtil.getAutoHangupTimeoutSec(sipServiceHelper.getAppContext());
    }

    public void startRecording(PhoneLineInfo lineInfo) {
        Log.i(SipCall.class.getSimpleName(), "startRecording ==>");
        try {
            if (this.recorder != null) {
                this.recorder.delete();
                this.recorder = null;
            }
            if (this.audioMedia == null) {
                return;
            }
            this.currentLineInfo = lineInfo;
            this.recStartTime = System.currentTimeMillis();
            this.recorder = new AudioMediaRecorder();
            File recordingRoot = MediaFileUtil.getRecordingRoot(this.sipServiceHelper.getAppContext());
            long timestamp = System.currentTimeMillis();
            String fileName1 = String.format("recording-%1$s-%2$s.wav", lineInfo.getNumber(), DateTimeUtil.getDateTimeStr(timestamp));
            this.recordingFile = new File(recordingRoot, fileName1);
            if (!this.recordingFile.exists()) {
                this.recordingFile.createNewFile();
            }
            Log.i(SipCall.class.getSimpleName(), "f.getAbsolutePath()=" + this.recordingFile.getAbsolutePath());
            this.recorder.createRecorder(this.recordingFile.getAbsolutePath());
            AudioMedia captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia();
            if (captureDeviceMedia != null) {
                captureDeviceMedia.startTransmit(this.recorder);
            }
            this.audioMedia.startTransmit(this.recorder);
            BroadcastUtil.sendSipRecordingEvent(this.sipServiceHelper.getAppContext(), this.myLine, true);
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
        }
    }

    public void suspendRecording() {
        try {
            if (this.recorder != null && this.audioMedia != null) {
                AudioMedia captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia();
                if (captureDeviceMedia != null) {
                    captureDeviceMedia.stopTransmit(this.recorder);
                }
                this.audioMedia.stopTransmit(this.recorder);
            }
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
        }
    }

    public void resumeRecording() {
        try {
            if (this.recorder != null && this.audioMedia != null) {
                AudioMedia captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia();
                if (captureDeviceMedia != null) {
                    captureDeviceMedia.startTransmit(this.recorder);
                }
                this.audioMedia.startTransmit(this.recorder);
            }
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
        }
    }

    public void stopRecording() {
        Log.i(SipCall.class.getSimpleName(), "stopRecording ==>");
        try {
            if (this.recorder == null) {
                this.cleanUpRecording();
                return;
            }
            if (this.audioMedia == null) {
                return;
            }
            this.recStopTime = System.currentTimeMillis();
            AudioMedia captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia();
            if (captureDeviceMedia != null) {
                captureDeviceMedia.stopTransmit(this.recorder);
            }
            this.audioMedia.stopTransmit(this.recorder);
            this.notifyRecordingReady();
            this.cleanUpRecording();
            BroadcastUtil.sendSipRecordingEvent(this.sipServiceHelper.getAppContext(), this.myLine, false);
            this.currentLineInfo = null;
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
        }
    }

    public void stopRecordingDisconnected() {
        Log.i(SipCall.class.getSimpleName(), "stopRecording ==>");
        try {
            if (this.recorder == null) {
                this.cleanUpRecording();
                return;
            }
            if (this.audioMedia == null) {
                return;
            }
            this.recStopTime = System.currentTimeMillis();
            this.notifyRecordingReady();
            this.cleanUpRecording();
            BroadcastUtil.sendSipRecordingEvent(this.sipServiceHelper.getAppContext(), this.myLine, false);
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
        }
    }

    private void cleanUpRecording() {
        if (this.recorder != null) {
            this.recorder.delete();
            this.recorder = null;
        }
        if (this.recordingFile != null) {
            this.recordingFile = null;
        }
    }

    synchronized void answer() {
        this.stopRingTone();
        CallOpParam prm = new CallOpParam();
        prm.setStatusCode(200);
        try {
            super.answer(prm);
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "answer fail", e);
        }
    }

    public void cleanSelf() {
        try {
            this.cancelHangupCallTask();
            this.cancelRtpTask();
            this.stopRingTone();
            this.delete();
        }
        catch (Throwable e) {
            Log.w(SipCall.class.getSimpleName(), "currentCall.delete0 fail", e);
        }
    }

    synchronized void hangup() {
        Log.w(SipCall.class.getSimpleName(), "hangup start -- ");
        if (this.hangupCleanUpTimerTask != null) {
            return;
        }
        try {
            this.cancelRtpTask();
            this.stopRingTone();
            CallOpParam callOpPrm = new CallOpParam();
            super.hangup(callOpPrm);
            this.cancelHangupCallTask();
            this.hangupCleanUpTimerTask = new HangupCleanUpTask();
            this.sipServiceHelper.runTask(this.hangupCleanUpTimerTask, 3000L, -1L);
        }
        catch (Exception e) {
            Log.e(SipCall.class.getSimpleName(), "hangup fail", e);
        }
        Log.w(SipCall.class.getSimpleName(), "hangup end -- ");
    }

    synchronized void bridgeCall() {
        this.isBridged = true;
    }

    synchronized void reject() {
        Log.w(SipCall.class.getSimpleName(), "reject start -- ");
        if (this.hangupCleanUpTimerTask != null) {
            return;
        }
        try {
            this.cancelRtpTask();
            this.stopRingTone();
            CallOpParam callOpPrm = new CallOpParam();
            callOpPrm.setStatusCode(603);
            super.hangup(callOpPrm);
            this.hangupCleanUpTimerTask = new HangupCleanUpTask();
            this.sipServiceHelper.runTask(this.hangupCleanUpTimerTask, 3000L, -1L);
        }
        catch (Exception e) {
            Log.e(SipCall.class.getSimpleName(), "reject fail", e);
        }
        Log.w(SipCall.class.getSimpleName(), "reject end -- ");
    }

    void holdCall() {
        CallOpParam prm = new CallOpParam(true);
        prm.setOptions(2L);
        try {
            super.setHold(prm);
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "holdCall fail", e);
        }
    }

    void unHoldCall() {
        CallOpParam prm = new CallOpParam(true);
        try {
            prm.getOpt().setFlag(1L);
            super.reinvite(prm);
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "unholdCall fail", e);
        }
    }

    @Override
    public void onCallState(OnCallStateParam prm) {
        try {
            CallInfo ci = this.getInfo();
            this.callIdString = ci.getCallIdString();
            Log.i(SipCall.class.getSimpleName(), ci.getId() + " onCallState:" + ci.getState() + " " + this.callIdString);
            if (ci.getState() == 6) {
                Log.w(SipCall.class.getSimpleName(), "NOTE: receive disconnected .........................");
                if (this.myLine != -1) {
                    this.sipServiceHelper.runTask(new DisconnectedCallTask(), 0L, -1L);
                }
                this.cancelRtpTask();
                this.sipServiceHelper.stopMicMonitorShared();
                this.micMonitorRunning = false;
            } else if (ci.getState() == 3) {
                Log.i(SipCall.class.getSimpleName(), "getRemOfferer?" + ci.getRemOfferer());
            } else if (ci.getState() == 1) {
                BroadcastUtil.sendSipOutgoingEvent(this.sipServiceHelper.getAppContext(), this.caller, this.myLine, ci.getCallIdString());
            } else if (ci.getState() != 4 && ci.getState() == 5) {
                if (PreferencesUtil.isAutoHangupEnabled(this.sipServiceHelper.getAppContext())) {
                    this.checkRTPTask = new CheckRTP();
                    this.sipServiceHelper.runTask(this.checkRTPTask, 1000L, 1000L);
                }
                this.stopRingTone();
                BroadcastUtil.sendSipIncallEvent(this.sipServiceHelper.getAppContext(), this.caller, this.myLine);
                if (!this.micMonitorRunning) {
                    this.micMonitorRunning = true;
                    this.sipServiceHelper.startMicMonitorShared();
                }
            }
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "onCallState", e);
            return;
        }
    }

    private void cancelRtpTask() {
        if (this.checkRTPTask != null) {
            this.checkRTPTask.cancel();
            this.checkRTPTask = null;
        }
    }

    private void cancelHangupCallTask() {
        if (this.hangupCleanUpTimerTask != null) {
            this.hangupCleanUpTimerTask.cancel();
            this.hangupCleanUpTimerTask = null;
        }
    }

    private void notifyRecordingReady() {
        if (this.recordingFile != null) {
            BroadcastUtil.sendSipRecordingReadyEvent(this.sipServiceHelper.getAppContext(), this.caller, this.myLine, this.reason, this.recStartTime, this.recStopTime, this.recordingFile, this.currentLineInfo);
        }
    }

    @Override
    public void onCallMediaState(OnCallMediaStateParam prm) {
        CallInfo ci;
        try {
            ci = this.getInfo();
            Log.d(SipCall.class.getSimpleName(), "onCallMediaState callState:" + ci.getState());
            Log.d(SipCall.class.getSimpleName(), "getRemOfferer:" + ci.getRemOfferer());
            if (ci.getState() == 3) {
                this.stopRingTone();
            }
        }
        catch (Throwable e) {
            return;
        }
        CallMediaInfoVector cmiv = ci.getMedia();
        for (int i = 0; i < cmiv.size(); ++i) {
            CallMediaInfo cmi = cmiv.get(i);
            Log.i(SipCall.class.getSimpleName(), "onCallMediaState status:" + cmi.getStatus() + " type:" + cmi.getType());
            if (cmi.getType() == 1 && (cmi.getStatus() == 1 || cmi.getStatus() == 3)) {
                this.mAudioIdx = i;
                Media m = this.getMedia(cmi.getIndex());
                this.audioMedia = AudioMedia.typecastFromMedia(m);
                if (SystemUtils.isWindows()) {
                    MixVolume.setVolume(PreferencesUtil.getFloat(UCChatClient.context, "APP_SETTING_VOLUME", Float.valueOf(1.0f)).floatValue());
                }
                try {
                    AudioMedia captureDeviceMedia;
                    if (!this.isMute && (captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia()) != null) {
                        captureDeviceMedia.startTransmit(this.audioMedia);
                    }
                    this.audioMedia.startTransmit(this.sipServiceHelper.getPlaybackDevMedia());
                }
                catch (Throwable e) {
                    continue;
                }
                try {
                    float txGain = PreferencesUtil.getTxGain(this.sipServiceHelper.getAppContext());
                    float rxGain = PreferencesUtil.getRxGain(this.sipServiceHelper.getAppContext());
                    Log.i(SipCall.class.getSimpleName(), "txGain:" + txGain + ", rxGain:" + rxGain);
                    this.audioMedia.adjustTxLevel(txGain);
                    this.audioMedia.adjustRxLevel(rxGain);
                }
                catch (Throwable e) {
                    Log.e(SipCall.class.getSimpleName(), "adjustTxLevel fail", e);
                }
                this.resumeRecording();
                this.media_establish = true;
                if (ci.getState() != 5) continue;
                BroadcastUtil.sendSipIncallEvent(this.sipServiceHelper.getAppContext(), this.caller, this.myLine);
                continue;
            }
            if (cmi.getType() != 1 || cmi.getStatus() != 2) continue;
            this.suspendRecording();
            try {
                AudioMedia captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia();
                if (captureDeviceMedia != null) {
                    captureDeviceMedia.stopTransmit(this.audioMedia);
                }
            }
            catch (Throwable e) {
                Log.e(SipCall.class.getSimpleName(), "muteCall", e);
            }
            BroadcastUtil.sendSipOnHoldEvent(this.sipServiceHelper.getAppContext(), this.caller, this.myLine);
        }
    }

    synchronized void playDialRing() {
        this.stopRingTone();
        this.sipServiceHelper.playDialRing();
    }

    synchronized void playBusyTone() {
        this.sipServiceHelper.playBusyTone();
    }

    synchronized void preForAutoAnswer() {
        if (this.isHangupDone) {
            return;
        }
        CallOpParam callOpPrm = new CallOpParam();
        callOpPrm.setStatusCode(180);
        try {
            super.answer(callOpPrm);
        }
        catch (Exception e) {
            Log.e(SipCall.class.getSimpleName(), "call.answer ring fail", e);
        }
    }

    synchronized void playRingTone() {
        if (this.isHangupDone) {
            return;
        }
        this.stopRingTone();
        this.sipServiceHelper.playIncomingRing();
    }

    synchronized void stopRingTone() {
        this.sipServiceHelper.stopIncomingRing();
        this.sipServiceHelper.stopDialRing();
    }

    void muteCall() {
        if (this.isMute) {
            return;
        }
        try {
            AudioMedia captureDeviceMedia;
            if (this.audioMedia != null && (captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia()) != null) {
                captureDeviceMedia.stopTransmit(this.audioMedia);
            }
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "muteCall", e);
        }
        this.isMute = true;
        BroadcastUtil.sendSipMuteEvent(this.sipServiceHelper.getAppContext(), this.myLine, this.isMute);
    }

    void unMuteCall() {
        if (!this.isMute) {
            return;
        }
        try {
            AudioMedia captureDeviceMedia;
            if (this.audioMedia != null && (captureDeviceMedia = this.sipServiceHelper.getCaptureDevMedia()) != null) {
                captureDeviceMedia.startTransmit(this.audioMedia);
            }
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "unMuteCall", e);
        }
        this.isMute = false;
        BroadcastUtil.sendSipMuteEvent(this.sipServiceHelper.getAppContext(), this.myLine, this.isMute);
    }

    void sendDTMF(String dtmf) {
        try {
            super.dialDtmf(dtmf);
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "sendDTMF", e);
        }
    }

    void transferReplaceCall(Call destLine) {
        try {
            super.xferReplaces(destLine, new CallOpParam());
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "transferCall", e);
        }
    }

    void transferCall(String phoneNumWithSipSuffix) {
        try {
            super.xfer(phoneNumWithSipSuffix, new CallOpParam());
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "transferCall", e);
        }
    }

    void adjustVolumnGain(Bundle data) {
        if (this.audioMedia == null) {
            return;
        }
        try {
            if ("PJSIP_AUDIO_PLAY_GAIN".equals(data.getString("KEY_VOLUMN_GAIN_TYPE"))) {
                float f = data.getFloat("KEY_VOLUMN_GAIN_VALUE", 1.0f);
                if (f > 0.0f) {
                    this.audioMedia.adjustTxLevel(f);
                }
            } else {
                float f = data.getFloat("KEY_VOLUMN_GAIN_VALUE", 1.0f);
                if (f > 0.0f) {
                    this.audioMedia.adjustRxLevel(f);
                }
            }
        }
        catch (Throwable e) {
            Log.e(SipCall.class.getSimpleName(), "adjustVolumnGain fail", e);
        }
    }

    public int getMyLine() {
        return this.myLine;
    }

    public void setMyLine(int myLine) {
        this.myLine = myLine;
    }

    public String getCaller() {
        return this.caller;
    }

    public void setCaller(String caller) {
        this.caller = caller;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public String toString() {
        return "SipCall [myLine=" + this.myLine + "]";
    }

    public String getCallIdString() {
        return this.callIdString;
    }

    public void setCallIdString(String callIdString) {
        this.callIdString = callIdString;
    }

    public class CheckRTP
    extends UCTimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SipCall sipCall = SipCall.this;
            synchronized (sipCall) {
                try {
                    SipCall.this.sipServiceHelper.registerCurrentThread();
                    CallInfo ci = SipCall.this.getInfo();
                    if (ci.getState() == 0) {
                        Log.e(SipCall.class.getSimpleName(), "call state is null... skip!");
                        return;
                    }
                    StreamStat stat = SipCall.this.getStreamStat(SipCall.this.mAudioIdx);
                    long rxBytes = stat.getRtcp().getRxStat().getBytes();
                    if (SipCall.this.mRxBytes == rxBytes && SipCall.this.isBridged) {
                        ++SipCall.this.mTimeoutTimes;
                        Log.i(SipCall.class.getSimpleName(), "timeout:" + SipCall.this.mTimeoutTimes);
                    } else {
                        SipCall.this.mTimeoutTimes = 0;
                        SipCall.this.mRxBytes = rxBytes;
                        Log.i(SipCall.class.getSimpleName(), "rxBytes:" + rxBytes + " isBridged:" + SipCall.this.isBridged);
                    }
                    if (SipCall.this.mTimeoutTimes >= SipCall.this.timeoutSec) {
                        SipCall.this.cancelRtpTask();
                        SipCall.this.hangup();
                    }
                }
                catch (Exception e) {
                    Log.e(SipCall.class.getSimpleName(), "CheckRTP fail", e);
                }
            }
        }
    }

    public class HangupCleanUpTask
    extends UCTimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            SipCall sipCall = SipCall.this;
            synchronized (sipCall) {
                if (SipCall.this.isHangupDone) {
                    Log.w(SipCall.class.getSimpleName(), "NOTE: already hangup again .........................OKKKKKK -- ");
                    return;
                }
                Log.w(SipCall.class.getSimpleName(), "NOTE: receive disconnected .........................DDDDDD -- ");
                SipCall.this.isHangupDone = true;
                SipCall.this.stopRingTone();
                SipCall.this.stopRecording();
                BroadcastUtil.sendSipIdleEvent(SipCall.this.sipServiceHelper.getAppContext(), SipCall.this.caller, SipCall.this.reason, SipCall.this.myLine);
                SipCall.this.hangupCleanUpTimerTask = null;
                SipCall.this.sipServiceHelper.registerCurrentThread();
                SipCall.this.account.cleanCall(SipCall.this.myLine);
            }
        }
    }

    public class DisconnectedCallTask
    extends UCTimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun() {
            SipCall sipCall = SipCall.this;
            synchronized (sipCall) {
                SipCall.this.isHangupDone = true;
                SipCall.this.cancelHangupCallTask();
                Log.i(SipCall.class.getSimpleName(), "onCallState in PJSIP_INV_STATE_DISCONNECTED line:" + SipCall.this.myLine);
                SipCall.this.stopRingTone();
                SipCall.this.stopRecordingDisconnected();
                if (SipCall.this.media_establish) {
                    SipCall.this.playBusyTone();
                }
                BroadcastUtil.sendSipIdleEvent(SipCall.this.sipServiceHelper.getAppContext(), SipCall.this.caller, SipCall.this.reason, SipCall.this.myLine);
                SipCall.this.sipServiceHelper.registerCurrentThread();
                SipCall.this.account.cleanCall(SipCall.this.myLine);
            }
        }
    }
}

