/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.sip;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.media.Archive;
import com.blisscloud.ezuc.client.media.AudioClipPlayer;
import com.blisscloud.ezuc.client.util.SystemUtils;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.Message;
import com.blisscloud.ezuc.client.util.simulate.Service;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import com.blisscloud.sip.Messenger;
import com.blisscloud.sip.SipAccount;
import com.blisscloud.sip.SipCodec;
import com.blisscloud.sip.SipEndPoint;
import com.blisscloud.sip.SipServiceHelper;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Timer;
import java.util.TimerTask;
import org.pjsip.pjsua2.AccountConfig;
import org.pjsip.pjsua2.AccountMediaConfig;
import org.pjsip.pjsua2.AccountRegConfig;
import org.pjsip.pjsua2.AudDevManager;
import org.pjsip.pjsua2.AudioDevInfo;
import org.pjsip.pjsua2.AudioDevInfoVector2;
import org.pjsip.pjsua2.AudioMedia;
import org.pjsip.pjsua2.AudioMediaRecorder;
import org.pjsip.pjsua2.AuthCredInfo;
import org.pjsip.pjsua2.AuthCredInfoVector;
import org.pjsip.pjsua2.EpConfig;
import org.pjsip.pjsua2.LogConfig;
import org.pjsip.pjsua2.LogEntry;
import org.pjsip.pjsua2.LogWriter;
import org.pjsip.pjsua2.MediaConfig;
import org.pjsip.pjsua2.TlsConfig;
import org.pjsip.pjsua2.TransportConfig;

public class SipPhoneService
extends Service
implements SipServiceHelper {
    private static final String THREAD_NAME = "SipPhoneService";
    private static final String CLIP_RINGOUT = "media/phone/ringout.wav";
    private static final String CLIP_BUSYTONE = "media/phone/busytone.wav";
    private static AudioClipPlayer clip_ringin;
    private static AudioClipPlayer clip_ringout;
    private static AudioClipPlayer clip_busyTone;
    private SipEndPoint ep = null;
    private SipAccount account = null;
    private String username = null;
    private String passwd = null;
    private String realm = null;
    private int port = 0;
    private MyLogWriter logWriter;
    private final int LOG_LEVEL = 6;
    private BroadcastReceiver mReceiver;
    private Timer sipPhoneServiceTimer = new Timer("SipPhoneServiceTimer");
    public static final int MSG_START_SIP = 1;
    public static final int MSG_STOP_SIP = 2;
    public static final int MSG_FORCE_STOP_SIP = 3;
    public static final int MSG_PLAY_RING_TONE = 7;
    public static final int MSG_STOP_RINGTONE = 8;
    public static final int MSG_SEND_DTMF = 9;
    public static final int MSG_MAKE_CALL = 10;
    public static final int MSG_CALL_ANSWER = 11;
    public static final int MSG_CALL_HANGUP = 12;
    public static final int MSG_CALL_HOLD = 13;
    public static final int MSG_CALL_UNHOLD = 14;
    public static final int MSG_CALL_MUTE = 15;
    public static final int MSG_CALL_UNMUTE = 16;
    public static final int MSG_CALL_TRANSFER = 17;
    public static final int MSG_CALL_REJECT = 18;
    public static final int MSG_CALL_TRANSFER_REPLACE = 19;
    public static final int MSG_ADJUST_VOLUMN_GAIN = 20;
    public static final int MSG_CALL_BRIDGED = 21;
    public static final int MSG_RECORDING_START = 28;
    public static final int MSG_RECORDING_STOP = 29;
    public static final int MSG_MANUAL_REGIST = 30;
    public static final int MSG_PRE_AUTOANSWER = 50;
    final SipPhoneHandler mHandler = new SipPhoneHandler();
    final Messenger mMessenger = new Messenger(this.mHandler);
    private AudioMediaRecorder micRecorder;
    private File micFile = new File(System.getProperty("java.io.tmpdir"), "mic_monitor.wav");
    private volatile boolean stopMicMonitor = false;
    private int activeCallCount = 0;

    public static void reloadRingTone() {
        try {
            boolean isRunning = false;
            if (clip_ringin != null) {
                isRunning = clip_ringin.isRunning();
                clip_ringin.stop();
                clip_ringin = null;
            }
            int ringSetting = PreferencesUtil.getInt(UCChatClient.context, "RING_SETTING", 0);
            float ringSettingVolume = PreferencesUtil.getFloat(UCChatClient.context, "RING_SETTING_VOLUME", Float.valueOf(0.5f)).floatValue();
            String ringinSource = "media/phone/" + MediaFileUtil.getWavFileNameForRing(ringSetting);
            clip_ringin = new AudioClipPlayer(Archive.getAudioInputStream(SipPhoneService.class.getClassLoader().getResource(ringinSource)), null);
            clip_ringin.adjustVolume(ringSettingVolume);
            if (isRunning) {
                clip_ringin.loop();
            }
            if (clip_ringout != null) {
                clip_ringout.stop();
                clip_ringout = null;
            }
            clip_ringout = new AudioClipPlayer(Archive.getAudioInputStream(SipPhoneService.class.getClassLoader().getResource(CLIP_RINGOUT)), null);
            clip_ringout.adjustVolume(0.8f);
            if (clip_busyTone != null) {
                clip_busyTone.stop();
                clip_busyTone = null;
            }
            clip_busyTone = new AudioClipPlayer(Archive.getAudioInputStream(SipPhoneService.class.getClassLoader().getResource(CLIP_BUSYTONE)), null);
            clip_busyTone.adjustVolume(0.8f);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onCreate() {
        Log.d(SipPhoneService.class.getSimpleName(), "onCreate() ..........................");
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        Log.d(SipPhoneService.class.getSimpleName(), "onDestroy() ........................");
        this.deinit(true);
        if (this.mReceiver != null) {
            this.unregisterReceiver(this.mReceiver);
        }
        if (clip_ringin != null) {
            clip_ringin.stop();
        }
        if (clip_ringout != null) {
            clip_ringout.stop();
        }
        if (clip_busyTone != null) {
            clip_busyTone.stop();
        }
    }

    void startEngine(Bundle data) {
        Log.i(SipPhoneService.class.getSimpleName(), "startEngine:" + Thread.currentThread().getName());
        if (this.ep != null) {
            Log.w(SipPhoneService.class.getSimpleName(), "startEngine return");
            return;
        }
        this.username = data.getString("username");
        this.passwd = data.getString("passwd");
        this.realm = data.getString("realm");
        this.port = data.getInt("port");
        boolean remoteMobileSrtpUsed = data.getBoolean("remoteMobileSrtpUsed", false);
        Log.i(SipPhoneService.class.getSimpleName(), "remoteMobileSrtpUsed:" + remoteMobileSrtpUsed);
        try {
            this.ep = new SipEndPoint(this);
            this.ep.libCreate();
            this.registerCurrentThread();
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.libCreate fail", e);
            return;
        }
        AccountConfig accCfg = this.loadAccountConfig(remoteMobileSrtpUsed);
        TransportConfig sipTpConfig = new TransportConfig();
        sipTpConfig.setQosType(3);
        sipTpConfig.setPort(60600L);
        EpConfig epConfig = new EpConfig();
        LogConfig log_cfg = epConfig.getLogConfig();
        this.logWriter = new MyLogWriter();
        log_cfg.setLevel(6L);
        log_cfg.setConsoleLevel(6L);
        log_cfg.setWriter(this.logWriter);
        log_cfg.setDecor(log_cfg.getDecor() & 0xFFFFFFFFFFFFFE7FL);
        TlsConfig tlsConfig = new TlsConfig();
        tlsConfig.setMethod(33);
        sipTpConfig.setTlsConfig(tlsConfig);
        MediaConfig med_cfg = epConfig.getMedConfig();
        med_cfg.setNoVad(true);
        med_cfg.setEcOptions(12419L);
        med_cfg.setEcTailLen(30L);
        epConfig.setMedConfig(med_cfg);
        try {
            this.ep.libInit(epConfig);
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.libInit fail", e);
            return;
        }
        try {
            this.ep.transportCreate(3, sipTpConfig);
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.transportCreate fail", e);
        }
        String makeCallSuffix = "@" + this.realm + ":" + this.port + ";transport=tls";
        this.account = new SipAccount(this, makeCallSuffix);
        try {
            this.account.create(accCfg);
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "MyAccount0 create fail", e);
            return;
        }
        this.setCodecs();
        try {
            this.ep.audDevManager().setOutputRoute(2, true);
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "setOutputRoute fail", e);
        }
        try {
            this.ep.libStart();
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.libStart fail", e);
            return;
        }
        Log.i(SipPhoneService.class.getSimpleName(), "startEngine:" + Thread.currentThread().getName() + " end .....................................");
    }

    private AccountConfig loadAccountConfig(boolean remoteMobileSrtpUsed) {
        AccountConfig accCfg = new AccountConfig();
        accCfg.setIdUri("sip:" + this.username + "@" + this.realm + ":" + this.port + ";transport=tls");
        AuthCredInfoVector creds = accCfg.getSipConfig().getAuthCreds();
        creds.add(new AuthCredInfo("Digest", "*", this.username, 0, this.passwd));
        AccountMediaConfig mediaConfig = accCfg.getMediaConfig();
        if (remoteMobileSrtpUsed) {
            mediaConfig.setSrtpUse(2);
        } else {
            mediaConfig.setSrtpUse(0);
        }
        accCfg.setMediaConfig(mediaConfig);
        AccountRegConfig accRegCfg = accCfg.getRegConfig();
        if (accRegCfg == null) {
            accRegCfg = new AccountRegConfig();
        }
        accRegCfg.setRetryIntervalSec(0L);
        accRegCfg.setFirstRetryIntervalSec(0L);
        accRegCfg.setTimeoutSec(900L);
        accRegCfg.setDelayBeforeRefreshSec(800L);
        accRegCfg.setRegistrarUri("sip:" + this.realm + ":" + this.port + ";transport=tls");
        accRegCfg.setProxyUse(0L);
        accCfg.setRegConfig(accRegCfg);
        accCfg.getNatConfig().setIceEnabled(false);
        accCfg.getNatConfig().setMediaStunUse(1);
        accCfg.getNatConfig().setSipStunUse(1);
        return accCfg;
    }

    private void setCodecs() {
        try {
            this.ep.codecSetPriority("opus/48000/2", (short)SipCodec.getPriorityFromMax(0));
            this.ep.codecSetPriority("iLBC/8000", (short)SipCodec.getPriorityFromMax(1));
            this.ep.codecSetPriority("G722/16000", (short)SipCodec.getPriorityFromMax(2));
            this.ep.codecSetPriority("PCMU/8000", (short)SipCodec.getPriorityFromMax(3));
            this.ep.codecSetPriority("PCMA/8000", (short)SipCodec.getPriorityFromMax(4));
            this.ep.codecSetPriority("G729/8000/1", (short)SipCodec.getPriorityFromMax(5));
            this.ep.codecSetPriority("speex/8000", (short)0);
            this.ep.codecSetPriority("speex/16000", (short)0);
            this.ep.codecSetPriority("speex/32000", (short)0);
            this.ep.codecSetPriority("GSM/8000", (short)0);
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.codecSetPriority fail", e);
        }
    }

    void deinit(boolean forceStop) {
        Log.i(SipPhoneService.class.getSimpleName(), "deinit start, end point is " + String.valueOf(this.ep));
        if (this.ep == null) {
            Log.i(SipPhoneService.class.getSimpleName(), "deinit skip!");
            return;
        }
        if (this.account != null) {
            this.account.cleanAllCall();
        }
        try {
            if (forceStop) {
                this.ep.libDestroy(3L);
            } else {
                this.ep.libDestroy();
            }
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.delete fail", e);
        }
        this.cleanAccount();
        try {
            this.ep.delete();
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.delete fail", e);
        }
        this.ep = null;
        Log.i(SipPhoneService.class.getSimpleName(), "deinit done!");
    }

    void cleanAccount() {
        if (this.account != null) {
            try {
                this.account.delete();
            }
            catch (Throwable e) {
                Log.w(SipPhoneService.class.getSimpleName(), "account delete fail", e);
            }
            this.account = null;
        }
    }

    @Override
    public int checkDeviceReadyOrNot() {
        try {
            AudDevManager mgr = this.ep.audDevManager();
            mgr.refreshDevs();
            int outputCount = 0;
            int inputCount = 0;
            AudioDevInfoVector2 deviceList = mgr.enumDev2();
            for (int i = 0; i < deviceList.size(); ++i) {
                AudioDevInfo deviceInfo = deviceList.get(i);
                Log.i(SipPhoneService.class.getSimpleName(), "==>" + deviceInfo.getName() + " " + deviceInfo.getOutputCount() + " " + deviceInfo.getInputCount());
                if (deviceInfo.getOutputCount() > 0L) {
                    outputCount = (int)((long)outputCount + deviceInfo.getOutputCount());
                }
                if (deviceInfo.getInputCount() <= 0L) continue;
                inputCount = (int)((long)inputCount + deviceInfo.getInputCount());
            }
            if (outputCount == 0 && inputCount == 0) {
                return -3;
            }
            if (outputCount != 0 && inputCount == 0) {
                return -2;
            }
            if (outputCount == 0 && inputCount != 0) {
                return -1;
            }
            return 0;
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "checkDeviceReadyOrNot", e);
            return 0;
        }
    }

    @Override
    public Handler getHandler() {
        return this.mHandler;
    }

    @Override
    public void registerCurrentThread() {
        try {
            if (this.ep != null) {
                Log.i(SipPhoneService.class.getSimpleName(), "Thread:" + Thread.currentThread().getName());
                this.ep.libRegisterThread(Thread.currentThread().getName());
            }
        }
        catch (Throwable e) {
            Log.e(SipPhoneService.class.getSimpleName(), "ep.libDestroy fail fail", e);
        }
    }

    @Override
    public Context getAppContext() {
        return this.getApplicationContext();
    }

    @Override
    public AudioMedia getCaptureDevMedia() {
        if (this.ep != null) {
            try {
                return this.ep.audDevManager().getCaptureDevMedia();
            }
            catch (Throwable e) {
                Log.e(SipPhoneService.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
            }
        }
        return null;
    }

    @Override
    public AudioMedia getPlaybackDevMedia() {
        if (this.ep != null) {
            try {
                return this.ep.audDevManager().getPlaybackDevMedia();
            }
            catch (Throwable e) {
                Log.e(SipPhoneService.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
            }
        }
        return null;
    }

    @Override
    public void playIncomingRing() {
        if (clip_ringin != null) {
            clip_ringin.loop();
        }
    }

    @Override
    public void stopIncomingRing() {
        if (clip_ringin != null) {
            clip_ringin.stop();
        }
    }

    @Override
    public void playDialRing() {
        if (clip_ringout != null) {
            clip_ringout.loop();
        }
    }

    @Override
    public void stopDialRing() {
        if (clip_ringout != null) {
            clip_ringout.stop();
        }
    }

    @Override
    public void playBusyTone() {
        if (clip_busyTone != null) {
            clip_busyTone.replay();
        }
    }

    @Override
    public void runHandler(Runnable runnable, long time) {
        this.mHandler.postDelayed(runnable, time);
    }

    @Override
    public void runTask(UCTimerTask task, long delay, long period) {
        if (task != null) {
            if (period > 0L) {
                this.sipPhoneServiceTimer.schedule((TimerTask)task, delay, period);
            } else {
                this.sipPhoneServiceTimer.schedule((TimerTask)task, delay);
            }
        }
    }

    @Override
    public synchronized void startMicMonitorShared() {
        if (this.activeCallCount == 0) {
            try {
                AudioMedia captureDeviceMedia = this.getCaptureDevMedia();
                if (captureDeviceMedia == null) {
                    Log.e(SipPhoneService.class.getSimpleName(), "Capture device is null, mic monitor skipped");
                    return;
                }
                this.stopMicMonitor = false;
                this.micRecorder = new AudioMediaRecorder();
                this.micRecorder.createRecorder(this.micFile.getAbsolutePath());
                captureDeviceMedia.startTransmit(this.micRecorder);
                new Thread(() -> {
                    while (!this.stopMicMonitor) {
                        try {
                            int level = this.readMicLevelFromFile(this.micFile);
                            BroadcastUtil.sendMicLevel(UCChatClient.context, level);
                            Thread.sleep(500L);
                        }
                        catch (Exception e) {
                            break;
                        }
                    }
                }, "MicMonitorThread-Shared").start();
            }
            catch (Exception e) {
                Log.e(SipPhoneService.class.getSimpleName(), "==>" + e.getLocalizedMessage(), e);
            }
        }
        ++this.activeCallCount;
    }

    @Override
    public synchronized void stopMicMonitorShared() {
        if (this.activeCallCount > 0) {
            --this.activeCallCount;
        }
        if (this.activeCallCount == 0) {
            try {
                this.stopMicMonitor = true;
                AudioMedia captureDeviceMedia = this.getCaptureDevMedia();
                if (captureDeviceMedia != null && this.micRecorder != null) {
                    captureDeviceMedia.stopTransmit(this.micRecorder);
                }
                if (this.micRecorder != null) {
                    this.micRecorder.delete();
                    this.micRecorder = null;
                }
                Log.i(SipPhoneService.class.getSimpleName(), "Shared mic monitor stopped");
            }
            catch (Exception e) {
                Log.e(SipPhoneService.class.getSimpleName(), "Stop shared mic monitor fail", e);
            }
        }
    }

    private int readMicLevelFromFile(File wavFile) throws IOException {
        if (!wavFile.exists()) {
            return 0;
        }
        try (RandomAccessFile raf = new RandomAccessFile(wavFile, "r");){
            int bytesRead;
            if (raf.length() <= 44L) {
                int n = 0;
                return n;
            }
            int sampleRate = 16000;
            int bytesPerSample = 2;
            int channels = 1;
            int bytesPerSecond = sampleRate * bytesPerSample * channels;
            int readDurationMs = 200;
            int tailBytes = bytesPerSecond * readDurationMs / 1000;
            long startPos = raf.length() - (long)tailBytes;
            if (startPos < 44L) {
                startPos = 44L;
            }
            raf.seek(startPos);
            int peak = 0;
            byte[] buffer = new byte[1024];
            while ((bytesRead = raf.read(buffer)) != -1) {
                for (int i = 0; i < bytesRead; i += 2) {
                    short sample = (short)(buffer[i] & 0xFF | buffer[i + 1] << 8);
                    int absVal = Math.abs(sample);
                    if (absVal <= peak) continue;
                    peak = absVal;
                }
            }
            int n = (int)((double)peak / 32767.0 * 100.0);
            return n;
        }
    }

    static {
        try {
            File jarFile = new File(UCChatClient.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (jarFile.getName().endsWith(".jar")) {
                File pjsipLibDir = new File(jarFile.getParentFile(), "lib-pjsip");
                if (SystemUtils.isWindows()) {
                    System.load(new File(pjsipLibDir, "libwinpthread-1.dll").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libgcc_s_seh-1.dll").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libstdc++-6.dll").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libcrypto-3-x64.dll").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libssl-3-x64.dll").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libssp-0.dll").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libopus-0.dll").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "pjsua2.dll").getAbsolutePath());
                } else if (SystemUtils.isMac()) {
                    System.load(new File(pjsipLibDir, "libcrypto.3.dylib").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libssl.3.dylib").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libopus.0.dylib").getAbsolutePath());
                    System.load(new File(pjsipLibDir, "libpjsua2.jnilib").getAbsolutePath());
                }
            } else {
                System.loadLibrary("libwinpthread-1");
                System.loadLibrary("libgcc_s_seh-1");
                System.loadLibrary("libstdc++-6");
                System.loadLibrary("libcrypto-3-x64");
                System.loadLibrary("libssl-3-x64");
                System.loadLibrary("libssp-0");
                System.loadLibrary("libopus-0");
                System.loadLibrary("pjsua2");
            }
            Log.i(SipPhoneService.class.getSimpleName(), "sip Library loaded");
        }
        catch (Throwable t) {
            Log.e(SipPhoneService.class.getSimpleName(), "sip Library loaded fail", t);
        }
        SipPhoneService.reloadRingTone();
    }

    class SipPhoneHandler
    extends Handler {
        public SipPhoneHandler() {
            super(SipPhoneService.THREAD_NAME);
        }

        @Override
        public void handleMessage(Message msg) {
            try {
                this.handleMessageLocal(msg);
            }
            catch (Throwable ex) {
                Log.e(SipPhoneService.class.getSimpleName(), ex.getLocalizedMessage(), ex);
            }
        }

        private void handleMessageLocal(Message msg) {
            Log.i(SipPhoneService.class.getSimpleName(), "handleMessage:" + msg.what);
            Bundle data = msg.getData();
            int line = data.getInt("KEY_SIP_LINE", 0);
            switch (msg.what) {
                case 1: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_START_SIP start engine -- " + Thread.currentThread().getName());
                    SipPhoneService.this.deinit(true);
                    SipPhoneService.this.startEngine(data);
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_START_SIP start engine complete -- " + Thread.currentThread().getName());
                    break;
                }
                case 2: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_STOP_SIP stop engine -- " + Thread.currentThread().getName());
                    SipPhoneService.this.deinit(false);
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_STOP_SIP stop engine complete-- " + Thread.currentThread().getName());
                    break;
                }
                case 3: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_STOP_SIP stop engine -- " + Thread.currentThread().getName());
                    SipPhoneService.this.deinit(true);
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_STOP_SIP stop engine complete-- " + Thread.currentThread().getName());
                    break;
                }
                case 11: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_ANSWER call:" + line + ", account:" + String.valueOf(SipPhoneService.this.account));
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.answerCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_ANSWER ");
                    break;
                }
                case 12: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_HANGUP call:" + line + ", account:" + String.valueOf(SipPhoneService.this.account));
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.hangupCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_HANGUP ");
                    break;
                }
                case 18: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_REJECT call:" + line + ", account:" + String.valueOf(SipPhoneService.this.account));
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.rejectCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_REJECT ");
                    break;
                }
                case 21: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_BRIDGED call:" + line + ", account:" + String.valueOf(SipPhoneService.this.account));
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.bridgeCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_BRIDGED ");
                    break;
                }
                case 10: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_MAKE_CALL");
                    if (SipPhoneService.this.account != null) {
                        int result = SipPhoneService.this.checkDeviceReadyOrNot();
                        if (result != 0) {
                            BroadcastUtil.sendSipCallFailedEvent(SipPhoneService.this.getAppContext(), line, result);
                            return;
                        }
                        String phoneNumber = data.getString("phoneNum");
                        long empId = data.getLong("empId", -1L);
                        long contactId = data.getLong("contactId", -1L);
                        String linkId = data.getString("KEY_SIP_LINKID");
                        String mainPhoneNum = phoneNumber;
                        String subExten = null;
                        int index = phoneNumber.indexOf(",");
                        if (index != -1) {
                            mainPhoneNum = phoneNumber.substring(0, index);
                            subExten = phoneNumber.substring(index);
                        }
                        SipPhoneService.this.account.makeCall(line, mainPhoneNum, subExten, linkId, empId, contactId);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end MSG_MAKE_CALL");
                    break;
                }
                case 9: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_SEND_DTMF");
                    if (SipPhoneService.this.account != null) {
                        String dtmf = data.getString("KEY_SIP_DTMF");
                        SipPhoneService.this.account.sendDTMF(line, dtmf);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end MSG_SEND_DTMF");
                    break;
                }
                case 13: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_HOLD");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.holdCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_HOLD");
                    break;
                }
                case 14: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_UNHOLD");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.unHoldCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_UNHOLD");
                    break;
                }
                case 17: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_TRANSFER");
                    if (SipPhoneService.this.account != null) {
                        String phoneNumber = data.getString("phoneNum");
                        SipPhoneService.this.account.transferCall(line, phoneNumber);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_TRANSFER");
                    break;
                }
                case 19: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_TRANSFER_REPLACE");
                    if (SipPhoneService.this.account != null) {
                        int destLineId = data.getInt("KEY_SIP_DEST_LINE");
                        SipPhoneService.this.account.transferReplaceCall(line, destLineId);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_TRANSFER_REPLACE");
                    break;
                }
                case 15: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_MUTE");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.muteCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_MUTE");
                    break;
                }
                case 16: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_CALL_UNMUTE");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.unMuteCall(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_CALL_UNMUTE");
                    break;
                }
                case 7: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_PLAY_RING_TONE");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.playRingTone(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_PLAY_RING_TONE");
                    break;
                }
                case 50: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_PRE_AUTOANSWER");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.preForAutoAnswer(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_PRE_AUTOANSWER");
                    break;
                }
                case 8: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_STOP_RINGTONE");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.stopRingTone(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end receive MSG_STOP_RINGTONE");
                    break;
                }
                case 20: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_ADJUST_VOLUMN_GAIN");
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.adjustVolumnGain(line, data);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end MSG_ADJUST_VOLUMN_GAIN");
                    break;
                }
                case 28: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_RECORDING_START call:" + line + ", account:" + String.valueOf(SipPhoneService.this.account));
                    if (SipPhoneService.this.account != null) {
                        PhoneLineInfo lineInfo = (PhoneLineInfo)data.getSerializable("KEY_SIP_LINE_INFO");
                        SipPhoneService.this.account.startRecording(line, lineInfo);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end MSG_RECORDING_START");
                    break;
                }
                case 29: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_RECORDING_STOP call:" + line + ", account:" + String.valueOf(SipPhoneService.this.account));
                    if (SipPhoneService.this.account != null) {
                        SipPhoneService.this.account.stopRecording(line);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end MSG_RECORDING_STOP");
                    break;
                }
                case 30: {
                    Log.w(SipPhoneService.class.getSimpleName(), "receive MSG_MANUAL_REGIST");
                    try {
                        if (SipPhoneService.this.account != null) {
                            SipPhoneService.this.account.setRegistration(true);
                        }
                    }
                    catch (Throwable e) {
                        Log.e(SipPhoneService.class.getSimpleName(), "setRegistration fail", e);
                    }
                    Log.w(SipPhoneService.class.getSimpleName(), "end MSG_MANUAL_REGIST");
                    break;
                }
                default: {
                    super.handleMessage(msg);
                }
            }
        }
    }

    class MyLogWriter
    extends LogWriter {
        MyLogWriter() {
        }

        @Override
        public void write(LogEntry entry) {
            String msg = entry.getMsg();
            Log.i(SipPhoneService.class.getSimpleName(), msg);
            if (SipPhoneService.this.account != null) {
                SipPhoneService.this.account.checkSipMsg(msg);
            }
        }
    }
}

