/*
 * Decompiled with CFR 0.152.
 */
package org.java_websocket.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ByteChannel;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.java_websocket.SocketChannelIOHelper;
import org.java_websocket.WebSocket;
import org.java_websocket.WebSocketAdapter;
import org.java_websocket.WebSocketFactory;
import org.java_websocket.WebSocketImpl;
import org.java_websocket.WrappedByteChannel;
import org.java_websocket.drafts.Draft;
import org.java_websocket.handshake.ClientHandshake;
import org.java_websocket.handshake.Handshakedata;
import org.java_websocket.server.DefaultWebSocketServerFactory;

public abstract class WebSocketServer
extends WebSocketAdapter
implements Runnable {
    public static int DECODERS = Runtime.getRuntime().availableProcessors();
    private final Collection<WebSocket> connections;
    private final InetSocketAddress address;
    private ServerSocketChannel server;
    private Selector selector;
    private List<Draft> drafts;
    private Thread selectorthread;
    private volatile AtomicBoolean isclosed = new AtomicBoolean(false);
    private List<WebSocketWorker> decoders;
    private List<WebSocketImpl> iqueue;
    private BlockingQueue<ByteBuffer> buffers;
    private int queueinvokes = 0;
    private AtomicInteger queuesize = new AtomicInteger(0);
    private WebSocketServerFactory wsf = new DefaultWebSocketServerFactory();

    public WebSocketServer() throws UnknownHostException {
        this(new InetSocketAddress(80), DECODERS, null);
    }

    public WebSocketServer(InetSocketAddress address) {
        this(address, DECODERS, null);
    }

    public WebSocketServer(InetSocketAddress address, int decoders) {
        this(address, decoders, null);
    }

    public WebSocketServer(InetSocketAddress address, List<Draft> drafts) {
        this(address, DECODERS, drafts);
    }

    public WebSocketServer(InetSocketAddress address, int decodercount, List<Draft> drafts) {
        this(address, decodercount, drafts, new HashSet<WebSocket>());
    }

    public WebSocketServer(InetSocketAddress address, int decodercount, List<Draft> drafts, Collection<WebSocket> connectionscontainer) {
        if (address == null || decodercount < 1 || connectionscontainer == null) {
            throw new IllegalArgumentException("address and connectionscontainer must not be null and you need at least 1 decoder");
        }
        this.drafts = drafts == null ? Collections.emptyList() : drafts;
        this.address = address;
        this.connections = connectionscontainer;
        this.iqueue = new LinkedList<WebSocketImpl>();
        this.decoders = new ArrayList<WebSocketWorker>(decodercount);
        this.buffers = new LinkedBlockingQueue<ByteBuffer>();
        for (int i = 0; i < decodercount; ++i) {
            WebSocketWorker ex = new WebSocketWorker();
            this.decoders.add(ex);
            ex.start();
        }
    }

    public void start() {
        if (this.selectorthread != null) {
            throw new IllegalStateException(this.getClass().getName() + " can only be started once.");
        }
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(int timeout) throws IOException, InterruptedException {
        if (!this.isclosed.compareAndSet(false, true)) {
            return;
        }
        Object object = this.connections;
        synchronized (object) {
            for (WebSocket ws : this.connections) {
                ws.close(1001);
            }
        }
        object = this;
        synchronized (object) {
            if (this.selectorthread != null) {
                if (Thread.currentThread() != this.selectorthread) {
                    // empty if block
                }
                if (this.selectorthread != Thread.currentThread()) {
                    this.selectorthread.interrupt();
                    this.selectorthread.join();
                }
            }
            if (this.decoders != null) {
                for (WebSocketWorker w : this.decoders) {
                    w.interrupt();
                }
            }
            if (this.server != null) {
                this.server.close();
            }
        }
    }

    public void stop() throws IOException, InterruptedException {
        this.stop(0);
    }

    public Collection<WebSocket> connections() {
        return this.connections;
    }

    public InetSocketAddress getAddress() {
        return this.address;
    }

    public int getPort() {
        int port = this.getAddress().getPort();
        if (port == 0 && this.server != null) {
            port = this.server.socket().getLocalPort();
        }
        return port;
    }

    public List<Draft> getDraft() {
        return Collections.unmodifiableList(this.drafts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        WebSocketServer webSocketServer = this;
        synchronized (webSocketServer) {
            if (this.selectorthread != null) {
                throw new IllegalStateException(this.getClass().getName() + " can only be started once.");
            }
            this.selectorthread = Thread.currentThread();
            if (this.isclosed.get()) {
                return;
            }
        }
        this.selectorthread.setName("WebsocketSelector" + this.selectorthread.getId());
        try {
            this.server = ServerSocketChannel.open();
            this.server.configureBlocking(false);
            ServerSocket socket = this.server.socket();
            socket.setReceiveBufferSize(WebSocketImpl.RCVBUF);
            socket.bind(this.address);
            this.selector = Selector.open();
            this.server.register(this.selector, this.server.validOps());
        }
        catch (IOException ex) {
            this.handleFatal(null, ex);
            return;
        }
        block16: while (true) {
            WebSocketImpl conn;
            block30: {
                try {
                    while (!this.selectorthread.isInterrupted()) {
                        SelectionKey key = null;
                        conn = null;
                        try {
                            this.selector.select();
                            Set<SelectionKey> keys = this.selector.selectedKeys();
                            Iterator<SelectionKey> i = keys.iterator();
                            while (i.hasNext()) {
                                block29: {
                                    key = i.next();
                                    if (!key.isValid()) continue;
                                    if (key.isAcceptable()) {
                                        if (!this.onConnect(key)) {
                                            key.cancel();
                                            continue;
                                        }
                                        SocketChannel channel = this.server.accept();
                                        channel.configureBlocking(false);
                                        WebSocket w = this.wsf.createWebSocket((WebSocketAdapter)this, (List)this.drafts, channel.socket());
                                        ((WebSocketImpl)w).key = channel.register(this.selector, 1, w);
                                        ((WebSocketImpl)w).channel = this.wsf.wrapChannel(channel, ((WebSocketImpl)w).key);
                                        i.remove();
                                        this.allocateBuffers(w);
                                        continue;
                                    }
                                    if (key.isReadable()) {
                                        conn = (WebSocketImpl)key.attachment();
                                        ByteBuffer buf = this.takeBuffer();
                                        try {
                                            if (SocketChannelIOHelper.read(buf, conn, conn.channel)) {
                                                conn.inQueue.put(buf);
                                                this.queue(conn);
                                                i.remove();
                                                if (conn.channel instanceof WrappedByteChannel && ((WrappedByteChannel)conn.channel).isNeedRead()) {
                                                    this.iqueue.add(conn);
                                                }
                                                break block29;
                                            }
                                            this.pushBuffer(buf);
                                        }
                                        catch (IOException e) {
                                            this.pushBuffer(buf);
                                            throw e;
                                        }
                                        catch (RuntimeException e) {
                                            this.pushBuffer(buf);
                                            throw e;
                                        }
                                    }
                                }
                                if (!key.isWritable() || !SocketChannelIOHelper.batch(conn = (WebSocketImpl)key.attachment(), conn.channel) || !key.isValid()) continue;
                                key.interestOps(1);
                            }
                            break block30;
                        }
                        catch (CancelledKeyException keys) {
                        }
                        catch (IOException ex) {
                            if (key != null) {
                                key.cancel();
                            }
                            this.handleIOException(key, conn, ex);
                        }
                    }
                    return;
                    {
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
                catch (RuntimeException e) {
                    this.handleFatal(null, e);
                }
                return;
            }
            while (true) {
                if (this.iqueue.isEmpty()) continue block16;
                conn = this.iqueue.remove(0);
                WrappedByteChannel c = (WrappedByteChannel)conn.channel;
                ByteBuffer buf = this.takeBuffer();
                try {
                    if (SocketChannelIOHelper.readMore(buf, conn, c)) {
                        this.iqueue.add(conn);
                    }
                    conn.inQueue.put(buf);
                    this.queue(conn);
                    continue;
                }
                finally {
                    this.pushBuffer(buf);
                    continue;
                }
                break;
            }
            break;
        }
    }

    protected void allocateBuffers(WebSocket c) throws InterruptedException {
        if (this.queuesize.get() >= 2 * this.decoders.size() + 1) {
            return;
        }
        this.queuesize.incrementAndGet();
        this.buffers.put(this.createBuffer());
    }

    protected void releaseBuffers(WebSocket c) throws InterruptedException {
    }

    public ByteBuffer createBuffer() {
        return ByteBuffer.allocate(WebSocketImpl.RCVBUF);
    }

    private void queue(WebSocketImpl ws) throws InterruptedException {
        if (ws.workerThread == null) {
            ws.workerThread = this.decoders.get(this.queueinvokes % this.decoders.size());
            ++this.queueinvokes;
        }
        ws.workerThread.put(ws);
    }

    private ByteBuffer takeBuffer() throws InterruptedException {
        return this.buffers.take();
    }

    private void pushBuffer(ByteBuffer buf) throws InterruptedException {
        if (this.buffers.size() > this.queuesize.intValue()) {
            return;
        }
        this.buffers.put(buf);
    }

    private void handleIOException(SelectionKey key, WebSocket conn, IOException ex) {
        SelectableChannel channel;
        this.onWebsocketError(conn, ex);
        if (conn != null) {
            conn.closeConnection(1006, ex.getMessage());
        } else if (key != null && (channel = key.channel()) != null && channel.isOpen()) {
            try {
                channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (WebSocketImpl.DEBUG) {
                System.out.println("Connection closed because of" + String.valueOf(ex));
            }
        }
    }

    private void handleFatal(WebSocket conn, Exception e) {
        this.onError(conn, e);
        try {
            this.stop();
        }
        catch (IOException e1) {
            this.onError(null, e1);
        }
        catch (InterruptedException e1) {
            Thread.currentThread().interrupt();
            this.onError(null, e1);
        }
    }

    protected String getFlashSecurityPolicy() {
        return "<cross-domain-policy><allow-access-from domain=\"*\" to-ports=\"" + this.getPort() + "\" /></cross-domain-policy>";
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, String message) {
        this.onMessage(conn, message);
    }

    @Override
    public final void onWebsocketMessage(WebSocket conn, ByteBuffer blob) {
        this.onMessage(conn, blob);
    }

    @Override
    public final void onWebsocketOpen(WebSocket conn, Handshakedata handshake) {
        if (this.addConnection(conn)) {
            this.onOpen(conn, (ClientHandshake)handshake);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void onWebsocketClose(WebSocket conn, int code, String reason, boolean remote) {
        this.selector.wakeup();
        try {
            if (this.removeConnection(conn)) {
                this.onClose(conn, code, reason, remote);
            }
        }
        finally {
            try {
                this.releaseBuffers(conn);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeConnection(WebSocket ws) {
        Collection<WebSocket> collection = this.connections;
        synchronized (collection) {
            return this.connections.remove(ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addConnection(WebSocket ws) {
        Collection<WebSocket> collection = this.connections;
        synchronized (collection) {
            return this.connections.add(ws);
        }
    }

    @Override
    public final void onWebsocketError(WebSocket conn, Exception ex) {
        this.onError(conn, ex);
    }

    @Override
    public final void onWriteDemand(WebSocket w) {
        WebSocketImpl conn = (WebSocketImpl)w;
        try {
            conn.key.interestOps(5);
        }
        catch (CancelledKeyException e) {
            conn.outQueue.clear();
        }
        this.selector.wakeup();
    }

    @Override
    public void onWebsocketCloseInitiated(WebSocket conn, int code, String reason) {
        this.onCloseInitiated(conn, code, reason);
    }

    @Override
    public void onWebsocketClosing(WebSocket conn, int code, String reason, boolean remote) {
        this.onClosing(conn, code, reason, remote);
    }

    public void onCloseInitiated(WebSocket conn, int code, String reason) {
    }

    public void onClosing(WebSocket conn, int code, String reason, boolean remote) {
    }

    public final void setWebSocketFactory(WebSocketServerFactory wsf) {
        this.wsf = wsf;
    }

    public final WebSocketFactory getWebSocketFactory() {
        return this.wsf;
    }

    protected boolean onConnect(SelectionKey key) {
        return true;
    }

    private Socket getSocket(WebSocket conn) {
        WebSocketImpl impl = (WebSocketImpl)conn;
        return ((SocketChannel)impl.key.channel()).socket();
    }

    @Override
    public InetSocketAddress getLocalSocketAddress(WebSocket conn) {
        return (InetSocketAddress)this.getSocket(conn).getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress(WebSocket conn) {
        return (InetSocketAddress)this.getSocket(conn).getRemoteSocketAddress();
    }

    public abstract void onOpen(WebSocket var1, ClientHandshake var2);

    public abstract void onClose(WebSocket var1, int var2, String var3, boolean var4);

    public abstract void onMessage(WebSocket var1, String var2);

    public abstract void onError(WebSocket var1, Exception var2);

    public void onMessage(WebSocket conn, ByteBuffer message) {
    }

    public static interface WebSocketServerFactory
    extends WebSocketFactory {
        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter var1, Draft var2, Socket var3);

        @Override
        public WebSocketImpl createWebSocket(WebSocketAdapter var1, List<Draft> var2, Socket var3);

        public ByteChannel wrapChannel(SocketChannel var1, SelectionKey var2) throws IOException;
    }

    public class WebSocketWorker
    extends Thread {
        private BlockingQueue<WebSocketImpl> iqueue = new LinkedBlockingQueue<WebSocketImpl>();

        public WebSocketWorker() {
            this.setName("WebSocketWorker-" + this.getId());
            this.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    Thread.getDefaultUncaughtExceptionHandler().uncaughtException(t, e);
                }
            });
        }

        public void put(WebSocketImpl ws) throws InterruptedException {
            this.iqueue.put(ws);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            ws = null;
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    buf = null;
                    ws = this.iqueue.take();
                    buf = (ByteBuffer)ws.inQueue.poll();
                    if (!WebSocketWorker.$assertionsDisabled && buf == null) {
                        throw new AssertionError();
                    }
                    try {
                        ws.decode(buf);
                    }
                    finally {
                        WebSocketServer.this.pushBuffer(buf);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException buf) {
            }
            catch (RuntimeException e) {
                WebSocketServer.this.handleFatal(ws, e);
            }
            ** GOTO lbl-1000
        }
    }
}

