/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.api.transcode;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.api.transcode.AudioFrameWithPacket;
import org.jcodec.api.transcode.Options;
import org.jcodec.api.transcode.PacketSink;
import org.jcodec.api.transcode.Sink;
import org.jcodec.api.transcode.VideoFrameWithPacket;
import org.jcodec.codecs.h264.H264Encoder;
import org.jcodec.codecs.png.PNGEncoder;
import org.jcodec.codecs.prores.ProresEncoder;
import org.jcodec.codecs.raw.RAWVideoEncoder;
import org.jcodec.codecs.vpx.IVFMuxer;
import org.jcodec.codecs.vpx.VP8Encoder;
import org.jcodec.codecs.wav.WavMuxer;
import org.jcodec.codecs.y4m.Y4MMuxer;
import org.jcodec.common.AudioCodecMeta;
import org.jcodec.common.AudioEncoder;
import org.jcodec.common.AudioFormat;
import org.jcodec.common.Codec;
import org.jcodec.common.Format;
import org.jcodec.common.Muxer;
import org.jcodec.common.MuxerTrack;
import org.jcodec.common.VideoCodecMeta;
import org.jcodec.common.VideoEncoder;
import org.jcodec.common.io.IOUtils;
import org.jcodec.common.io.NIOUtils;
import org.jcodec.common.io.SeekableByteChannel;
import org.jcodec.common.logging.Logger;
import org.jcodec.common.model.AudioBuffer;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.Picture;
import org.jcodec.common.model.Size;
import org.jcodec.containers.imgseq.ImageSequenceMuxer;
import org.jcodec.containers.mkv.muxer.MKVMuxer;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.containers.raw.RawMuxer;

public class SinkImpl
implements Sink,
PacketSink {
    private String destName;
    private SeekableByteChannel destStream;
    private Muxer muxer;
    private MuxerTrack videoOutputTrack;
    private MuxerTrack audioOutputTrack;
    private boolean framesOutput;
    private Codec outputVideoCodec;
    private Codec outputAudioCodec;
    private Format outputFormat;
    private ThreadLocal<ByteBuffer> bufferStore = new ThreadLocal();
    private AudioEncoder audioEncoder;
    private VideoEncoder videoEncoder;
    private String profile;
    private boolean interlaced;

    @Override
    public void outputVideoPacket(Packet packet, VideoCodecMeta codecMeta) throws IOException {
        if (!this.outputFormat.isVideo()) {
            return;
        }
        if (this.videoOutputTrack == null) {
            this.videoOutputTrack = this.muxer.addVideoTrack(this.outputVideoCodec, codecMeta);
        }
        this.videoOutputTrack.addFrame(packet);
        this.framesOutput = true;
    }

    @Override
    public void outputAudioPacket(Packet audioPkt, AudioCodecMeta audioCodecMeta) throws IOException {
        if (!this.outputFormat.isAudio()) {
            return;
        }
        if (this.audioOutputTrack == null) {
            this.audioOutputTrack = this.muxer.addAudioTrack(this.outputAudioCodec, audioCodecMeta);
        }
        this.audioOutputTrack.addFrame(audioPkt);
        this.framesOutput = true;
    }

    public void initMuxer() throws IOException {
        if (this.destStream == null && this.outputFormat != Format.IMG) {
            this.destStream = NIOUtils.writableFileChannel(this.destName);
        }
        switch (this.outputFormat) {
            case MKV: {
                this.muxer = new MKVMuxer(this.destStream);
                break;
            }
            case MOV: {
                this.muxer = MP4Muxer.createMP4MuxerToChannel(this.destStream);
                break;
            }
            case IVF: {
                this.muxer = new IVFMuxer(this.destStream);
                break;
            }
            case IMG: {
                this.muxer = new ImageSequenceMuxer(this.destName);
                break;
            }
            case WAV: {
                this.muxer = new WavMuxer(this.destStream);
                break;
            }
            case Y4M: {
                this.muxer = new Y4MMuxer(this.destStream);
                break;
            }
            case RAW: {
                this.muxer = new RawMuxer(this.destStream);
                break;
            }
            default: {
                throw new RuntimeException("The output format " + String.valueOf((Object)this.outputFormat) + " is not supported.");
            }
        }
    }

    @Override
    public void finish() throws IOException {
        if (this.framesOutput) {
            this.muxer.finish();
        } else {
            Logger.warn("No frames output.");
        }
        if (this.destStream != null) {
            IOUtils.closeQuietly(this.destStream);
        }
    }

    public SinkImpl(String destName, Format outputFormat, Codec outputVideoCodec, Codec outputAudioCodec) {
        if (destName == null && outputFormat == Format.IMG) {
            throw new IllegalArgumentException("A destination file should be specified for the image muxer.");
        }
        this.destName = destName;
        this.outputFormat = outputFormat;
        this.outputVideoCodec = outputVideoCodec;
        this.outputAudioCodec = outputAudioCodec;
        this.outputFormat = outputFormat;
    }

    public static SinkImpl createWithStream(SeekableByteChannel destStream, Format outputFormat, Codec outputVideoCodec, Codec outputAudioCodec) {
        SinkImpl result = new SinkImpl(null, outputFormat, outputVideoCodec, outputAudioCodec);
        result.destStream = destStream;
        return result;
    }

    @Override
    public void init() throws IOException {
        this.initMuxer();
        if (this.outputFormat.isVideo() && this.outputVideoCodec != null) {
            switch (this.outputVideoCodec) {
                case PRORES: {
                    this.videoEncoder = new ProresEncoder(this.profile, this.interlaced);
                    break;
                }
                case H264: {
                    this.videoEncoder = H264Encoder.createH264Encoder();
                    break;
                }
                case VP8: {
                    this.videoEncoder = VP8Encoder.createVP8Encoder(10);
                    break;
                }
                case PNG: {
                    this.videoEncoder = new PNGEncoder();
                    break;
                }
                case RAW: {
                    this.videoEncoder = new RAWVideoEncoder();
                    break;
                }
                default: {
                    throw new RuntimeException("Could not find encoder for the codec: " + String.valueOf((Object)this.outputVideoCodec));
                }
            }
        }
    }

    protected VideoEncoder.EncodedFrame encodeVideo(Picture frame, ByteBuffer _out) {
        if (!this.outputFormat.isVideo()) {
            return null;
        }
        return this.videoEncoder.encodeFrame(frame, _out);
    }

    private AudioEncoder createAudioEncoder(Codec codec, AudioFormat format) {
        if (codec != Codec.PCM) {
            throw new RuntimeException("Only PCM audio encoding (RAW audio) is supported.");
        }
        return new RawAudioEncoder();
    }

    protected ByteBuffer encodeAudio(AudioBuffer audioBuffer) {
        if (this.audioEncoder == null) {
            AudioFormat format = audioBuffer.getFormat();
            this.audioEncoder = this.createAudioEncoder(this.outputAudioCodec, format);
        }
        return this.audioEncoder.encode(audioBuffer.getData(), null);
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public void setInterlaced(Boolean interlaced) {
        this.interlaced = interlaced;
    }

    @Override
    public void outputVideoFrame(VideoFrameWithPacket videoFrame) throws IOException {
        if (!this.outputFormat.isVideo() || this.outputVideoCodec == null) {
            return;
        }
        ByteBuffer buffer = this.bufferStore.get();
        int bufferSize = this.videoEncoder.estimateBufferSize(videoFrame.getFrame().getPicture());
        if (buffer == null || bufferSize < buffer.capacity()) {
            buffer = ByteBuffer.allocate(bufferSize);
            this.bufferStore.set(buffer);
        }
        buffer.clear();
        Picture frame = videoFrame.getFrame().getPicture();
        VideoEncoder.EncodedFrame enc = this.encodeVideo(frame, buffer);
        Packet outputVideoPacket = Packet.createPacketWithData(videoFrame.getPacket(), NIOUtils.clone(enc.getData()));
        outputVideoPacket.setFrameType(enc.isKeyFrame() ? Packet.FrameType.KEY : Packet.FrameType.INTER);
        this.outputVideoPacket(outputVideoPacket, VideoCodecMeta.createSimpleVideoCodecMeta(new Size(frame.getWidth(), frame.getHeight()), frame.getColor()));
    }

    @Override
    public void outputAudioFrame(AudioFrameWithPacket audioFrame) throws IOException {
        if (!this.outputFormat.isAudio() || this.outputAudioCodec == null) {
            return;
        }
        this.outputAudioPacket(Packet.createPacketWithData(audioFrame.getPacket(), this.encodeAudio(audioFrame.getAudio())), AudioCodecMeta.fromAudioFormat(audioFrame.getAudio().getFormat()));
    }

    @Override
    public ColorSpace getInputColor() {
        if (this.videoEncoder == null) {
            throw new IllegalStateException("Video encoder has not been initialized, init() must be called before using this class.");
        }
        ColorSpace[] colorSpaces = this.videoEncoder.getSupportedColorSpaces();
        return colorSpaces == null ? null : colorSpaces[0];
    }

    @Override
    public void setOption(Options option, Object value) {
        if (option == Options.PROFILE) {
            this.profile = (String)value;
        } else if (option == Options.INTERLACED) {
            this.interlaced = (Boolean)value;
        }
    }

    @Override
    public boolean isVideo() {
        return this.outputFormat.isVideo();
    }

    @Override
    public boolean isAudio() {
        return this.outputFormat.isAudio();
    }

    private static class RawAudioEncoder
    implements AudioEncoder {
        private RawAudioEncoder() {
        }

        @Override
        public ByteBuffer encode(ByteBuffer audioPkt, ByteBuffer buf) {
            return audioPkt;
        }
    }
}

