/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.protocol.vfw;

import com.sun.media.BasicPlugIn;
import com.sun.media.CircularBuffer;
import com.sun.media.ExtBuffer;
import com.sun.media.NBA;
import com.sun.media.protocol.BasicSourceStream;
import com.sun.media.protocol.vfw.CapDriverCaps;
import com.sun.media.protocol.vfw.CapStatus;
import com.sun.media.protocol.vfw.CaptureParms;
import com.sun.media.protocol.vfw.VFWCapture;
import com.sun.media.protocol.vfw.VFWDeviceQuery;
import com.sun.media.ui.VideoFormatChooser;
import com.sun.media.vfw.BitMapInfo;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Control;
import javax.media.Format;
import javax.media.MediaLocator;
import javax.media.Owned;
import javax.media.SystemTimeBase;
import javax.media.control.FormatControl;
import javax.media.control.MonitorControl;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.BufferTransferHandler;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PushBufferStream;

public class VFWSourceStream
extends BasicSourceStream
implements PushBufferStream,
Runnable,
ActionListener,
FormatControl,
Owned {
    private MediaLocator locator = null;
    private int capHandle = 0;
    Integer cbHandleLock = new Integer(0);
    private int cbHandle = 0;
    private VideoFormat capFormat = null;
    private float capFrameRate = 0.0f;
    private int capPreviewRate = 33;
    private int capWidth = -1;
    private int capHeight = -1;
    private byte[] data = null;
    private int maxDataSize = 1;
    BufferTransferHandler transferHandler = null;
    private int length = 0;
    private int nativeParentWindow = 0;
    private static String STRING_CF = "Custom Format...";
    private static String STRING_SD = "Video Source...";
    private Integer lockInit = new Integer(1);
    private Integer vfwReqLock = new Integer(2);
    private int vfwRequest = -1;
    private static final int REQ_START = 1;
    private static final int REQ_STOP = 2;
    private static final int REQ_FORMATDIALOG = 3;
    private static final int REQ_SOURCEDIALOG = 4;
    private static final int REQ_DISCONNECT = 5;
    private static final int REQ_UPDATECAPTURESETUP = 6;
    private static final int REQ_MONITOR = 7;
    private boolean started = false;
    private boolean connected = false;
    private boolean connectedOK = false;
    private Frame capFrame = null;
    public static int MAX_CARDS = 10;
    public static boolean DEBUG = false;
    private int cardNo = 0;
    private static boolean[] inUse = new boolean[MAX_CARDS];
    private static Integer VFWLock = new Integer(0);
    Integer readLock = new Integer(1);
    Integer waitForStop = new Integer(2);
    boolean doneReading = false;
    boolean waitingToStop = false;
    long lastTimeStamp = 0L;
    long startTimeStamp = 0L;
    long[] resultTimeStamp = new long[1];
    SystemTimeBase systemTimeBase = new SystemTimeBase();
    private Panel controlPanel = null;
    private Control[] controls = null;
    private static final String DEFAULT_PORT = "default";
    private boolean hasDlgVideoFormat = false;
    private boolean hasDlgVideoSource = false;
    private boolean hasOverlay = false;
    private boolean monitorEnabled = false;
    private float defaultFrameRate = 15.0f;
    private float requestedFrameRate = 15.0f;
    private PushThread pt = null;
    private TransferDataThread tdt = null;
    private VideoFormat defaultFormat = null;
    private VideoFormat requestedFormat = null;
    private VideoFormat fullFormat = null;
    private CaptureDeviceInfo cdi = null;
    CircularBuffer bufferQ = new CircularBuffer(8);
    private float[] FRAME_RATES = new float[]{1.0f, 2.0f, 5.0f, 7.5f, 10.0f, 12.5f, 15.0f, 20.0f, 24.0f, 25.0f, 30.0f};
    Choice formatChoice = null;
    Choice frameRateChoice = null;
    Panel controlComponent = null;
    Button formatDialog = null;
    Button sourceDialog = null;
    VideoFormatChooser formatChooser = null;
    private Checkbox cbMonitorEnable = null;
    private Panel monitorComponent = null;
    private TextField textPreviewRate = null;
    static /* synthetic */ Class array$B;

    public VFWSourceStream(MediaLocator ml) {
        super(new ContentDescriptor("raw"), -1L);
        this.locator = ml;
        this.cardNo = VFWSourceStream.getCardNo(ml);
    }

    CaptureDeviceInfo getCaptureDeviceInfo() {
        if (this.cdi == null) {
            String url = "vfw://" + this.cardNo;
            Vector cdiList = CaptureDeviceManager.getDeviceList(new VideoFormat(null));
            if (cdiList != null && cdiList.size() > 0) {
                int i2 = 0;
                while (i2 < cdiList.size()) {
                    CaptureDeviceInfo tempCDI = (CaptureDeviceInfo)cdiList.elementAt(i2);
                    if (tempCDI.getLocator().toString().equalsIgnoreCase(url)) {
                        this.cdi = tempCDI;
                        break;
                    }
                    ++i2;
                }
            }
            if (this.cdi == null) {
                this.cdi = VFWSourceStream.autoDetect(this.cardNo);
            }
        }
        return this.cdi;
    }

    public static CaptureDeviceInfo autoDetect(int cardNo) {
        VFWDeviceQuery cdi;
        block3: {
            cdi = null;
            try {
                cdi = new VFWDeviceQuery(cardNo);
                if (cdi != null && cdi.getFormats() != null && cdi.getFormats().length > 0 && CaptureDeviceManager.addDevice(cdi)) {
                    CaptureDeviceManager.commit();
                }
            }
            catch (Throwable t) {
                if (!(t instanceof ThreadDeath)) break block3;
                throw (ThreadDeath)t;
            }
        }
        return cdi;
    }

    static int getCardNo(MediaLocator locator) {
        int cardNo = 0;
        String remainder = locator.getRemainder();
        if (remainder != null && remainder.length() > 0) {
            while (remainder.length() > 1 && remainder.charAt(0) == '/') {
                remainder = remainder.substring(1);
            }
            try {
                Integer integer = Integer.valueOf(remainder);
                if (integer != null) {
                    cardNo = integer;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cardNo;
    }

    public Object getDataType() {
        return Format.byteArray;
    }

    public void setTransferHandler(BufferTransferHandler th) {
        this.transferHandler = th;
    }

    public void connect(Format format) throws IOException {
        Integer n2 = VFWLock;
        synchronized (n2) {
            if (this.connected) {
                return;
            }
            if (inUse[this.cardNo]) {
                throw new IOException("Capture device in use");
            }
            VFWSourceStream.inUse[this.cardNo] = true;
            this.connected = false;
            if (format != null) {
                this.requestedFormat = (VideoFormat)format;
            }
            Thread initThread = new Thread((Runnable)this, "VFW Request Thread");
            initThread.start();
            if (!this.connected) {
                try {
                    while (!this.connected) {
                        Thread.currentThread();
                        Thread.sleep(50L);
                        Thread.currentThread();
                        Thread.yield();
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            if (!this.connectedOK) {
                VFWSourceStream.inUse[this.cardNo] = false;
                this.connected = false;
                throw new IOException("Could not connect to capture device");
            }
            this.updateComponents();
        }
    }

    private boolean doConnect() {
        this.nativeParentWindow = VFWCapture.createWindow("Cap Parent");
        this.capHandle = VFWCapture.capCreateCaptureWindow("Test", this.nativeParentWindow, 0, 0, 320, 240, VFWCapture.getNextID());
        if (this.capHandle == 0) {
            VFWCapture.destroyWindow(this.nativeParentWindow);
            return false;
        }
        this.cbHandle = VFWCapture.createFrameCallback(this.capHandle);
        if (this.cbHandle == 0 || !VFWCapture.capDriverConnect(this.capHandle, this.cardNo)) {
            if (this.cbHandle != 0) {
                VFWCapture.destroyFrameCallback(this.capHandle, this.cbHandle);
            }
            VFWCapture.destroyWindow(this.capHandle);
            VFWCapture.destroyWindow(this.nativeParentWindow);
            return false;
        }
        CapDriverCaps cdc = new CapDriverCaps();
        VFWCapture.capDriverGetCaps(this.capHandle, cdc);
        CaptureParms cp = new CaptureParms();
        VFWCapture.capCaptureGetSetup(this.capHandle, cp);
        cp.fYield = true;
        cp.fCaptureAudio = false;
        cp.fAbortLeftMouse = false;
        cp.fAbortRightMouse = false;
        cp.fMakeUserHitOKToCapture = false;
        if (cdc.fHasDlgVideoFormat) {
            this.hasDlgVideoFormat = true;
        }
        if (this.requestedFormat == null) {
            Dimension size = new Dimension(320, 240);
            this.requestedFormat = new RGBFormat(size, size.width * size.height * 3, Format.byteArray, this.requestedFrameRate, 24, 3, 2, 1, 3, size.width * 3, 1, -1);
        }
        if (cp.dwRequestMicroSecPerFrame == 0) {
            cp.dwRequestMicroSecPerFrame = 66667;
        }
        this.defaultFrameRate = 1000000.0f / (float)cp.dwRequestMicroSecPerFrame;
        if (this.requestedFormat.getFrameRate() > 0.0f && this.requestedFormat.getFrameRate() < 61.0f) {
            this.requestedFrameRate = this.requestedFormat.getFrameRate();
        }
        cp.dwRequestMicroSecPerFrame = (int)(1000000.0f / this.requestedFrameRate);
        cp.wNumVideoRequested = 15;
        VFWCapture.capCaptureSetSetup(this.capHandle, cp);
        VFWCapture.capCaptureGetSetup(this.capHandle, cp);
        this.capFrameRate = cp.dwRequestMicroSecPerFrame != 0 ? 1000000.0f / (float)cp.dwRequestMicroSecPerFrame : this.requestedFrameRate;
        if (cdc.fHasDlgVideoSource) {
            this.hasDlgVideoSource = true;
        }
        if (cdc.fHasOverlay) {
            VFWCapture.capOverlay(this.capHandle, this.monitorEnabled);
            this.hasOverlay = true;
        } else {
            VFWCapture.capPreview(this.capHandle, this.monitorEnabled);
            VFWCapture.capPreviewRate(this.capHandle, 33);
            this.hasOverlay = false;
        }
        VFWCapture.capSetWindowPos(this.capHandle, 0, 0, 320, 240);
        BitMapInfo bmi = new BitMapInfo();
        VFWCapture.capGetVideoFormat(this.capHandle, bmi);
        this.defaultFormat = bmi.createVideoFormat(Format.byteArray, this.capFrameRate);
        bmi = new BitMapInfo(this.requestedFormat);
        VFWCapture.capSetVideoFormat(this.capHandle, bmi);
        VFWCapture.capGetVideoFormat(this.capHandle, bmi);
        this.capFormat = bmi.createVideoFormat(Format.byteArray);
        VideoFormat frOnly = new VideoFormat(null, null, -1, null, this.capFrameRate);
        this.fullFormat = (VideoFormat)this.capFormat.intersects(frOnly);
        this.maxDataSize = bmi.biSizeImage;
        this.data = new byte[this.maxDataSize];
        return true;
    }

    void updateCaptureSetup() {
        CaptureParms cp = new CaptureParms();
        VFWCapture.capCaptureGetSetup(this.capHandle, cp);
        if (this.requestedFrameRate < 1.0f) {
            this.requestedFrameRate = 1.0f;
        }
        cp.dwRequestMicroSecPerFrame = (int)(1000000.0f / this.requestedFrameRate);
        VFWCapture.capCaptureSetSetup(this.capHandle, cp);
        VFWCapture.capCaptureGetSetup(this.capHandle, cp);
        if (cp.dwRequestMicroSecPerFrame != 0) {
            this.capFrameRate = 1000000.0f / (float)cp.dwRequestMicroSecPerFrame;
        }
        this.updateFormatChooser();
    }

    void updateFormatChooser() {
        if (this.formatChooser != null) {
            this.formatChooser.setCurrentFormat(this.capFormat);
            this.formatChooser.setFrameRate(this.capFrameRate);
        }
    }

    void requestUpdateCaptureSetup() {
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 6;
            this.vfwReqLock.notifyAll();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void disconnect() {
        if (this.started) {
            try {
                this.stop();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.connected = false;
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 5;
            this.vfwReqLock.notifyAll();
        }
        while (this.pt != null) {
            try {
                this.wait(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        VFWSourceStream.inUse[this.cardNo] = false;
        CircularBuffer circularBuffer = this.bufferQ;
        synchronized (circularBuffer) {
            this.bufferQ.notifyAll();
        }
        Integer n3 = this.readLock;
        synchronized (n3) {
            this.readLock.notifyAll();
            return;
        }
    }

    private void doDisconnect() {
        VFWCapture.capCaptureAbort(this.capHandle);
        VFWCapture.stopFrameCallback(this.capHandle, this.cbHandle);
        Integer n2 = this.cbHandleLock;
        synchronized (n2) {
            this.cbHandle = 0;
        }
        if (this.hasOverlay) {
            VFWCapture.capOverlay(this.capHandle, false);
        } else {
            VFWCapture.capPreview(this.capHandle, false);
        }
        VFWCapture.capDriverDisconnect(this.capHandle);
        VFWSourceStream vFWSourceStream = this;
        synchronized (vFWSourceStream) {
            VFWCapture.destroyWindow(this.capHandle);
            VFWCapture.destroyWindow(this.nativeParentWindow);
            this.notifyAll();
        }
    }

    void start() throws IOException {
        this.started = true;
        this.updateComponents();
        VFWSourceStream vFWSourceStream = this;
        synchronized (vFWSourceStream) {
            if (!this.connected) {
                this.started = false;
                return;
            }
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                this.bufferQ.reset();
            }
            if (this.pt == null) {
                this.pt = new PushThread(this);
                this.pt.start();
            }
            PushThread pushThread = this.pt;
            synchronized (pushThread) {
                this.pt.buffer = null;
                this.pt.data = null;
                this.pt.dataBytes = 0L;
            }
            if (this.tdt == null) {
                this.tdt = new TransferDataThread(this);
                this.tdt.start();
            }
            Integer n2 = this.vfwReqLock;
            synchronized (n2) {
                this.vfwRequest = 1;
                this.vfwReqLock.notifyAll();
            }
        }
    }

    private void handleFormatChange() {
        float chooserFrameRate;
        VideoFormat newFormat = null;
        VideoFormat frOnly = null;
        if (this.requestedFormat != null) {
            BitMapInfo bmi = new BitMapInfo(this.requestedFormat);
            VFWCapture.capSetVideoFormat(this.capHandle, bmi);
            VFWCapture.capGetVideoFormat(this.capHandle, bmi);
            this.capFormat = bmi.createVideoFormat(Format.byteArray);
            if (this.requestedFormat.getFrameRate() > 0.0f && this.requestedFormat.getFrameRate() < 61.0f) {
                this.requestedFrameRate = this.requestedFormat.getFrameRate();
            }
            this.requestedFormat = null;
            this.maxDataSize = bmi.biSizeImage;
            this.data = new byte[this.maxDataSize];
            this.capWidth = bmi.biWidth;
            this.capHeight = bmi.biHeight;
        }
        if (this.formatChooser != null && (double)Math.abs((chooserFrameRate = this.formatChooser.getFrameRate()) - this.capFrameRate) > 0.45) {
            this.requestedFrameRate = chooserFrameRate;
        }
        if (this.requestedFrameRate != -1.0f) {
            this.updateCaptureSetup();
            this.requestedFrameRate = -1.0f;
        }
        frOnly = new VideoFormat(null, null, -1, null, this.capFrameRate);
        newFormat = (VideoFormat)this.capFormat.intersects(frOnly);
        if (this.fullFormat == null || !newFormat.equals(this.fullFormat)) {
            this.fullFormat = newFormat;
        }
        this.updateFormatChooser();
    }

    private void doStartCapture() {
        this.handleFormatChange();
        CapStatus cs = new CapStatus();
        VFWCapture.capGetStatus(this.capHandle, cs);
        if (cs.fCapturingNow) {
            return;
        }
        VFWCapture.startFrameCallback(this.capHandle, this.cbHandle);
        VFWCapture.capCaptureSequenceNoFile(this.capHandle);
        this.startTimeStamp = this.systemTimeBase.getNanoseconds();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void stop() throws IOException {
        this.started = false;
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 2;
            this.waitingToStop = true;
            this.vfwReqLock.notifyAll();
        }
        Integer n3 = this.waitForStop;
        synchronized (n3) {
            while (this.waitingToStop) {
                try {
                    this.waitForStop.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.updateComponents();
    }

    public void finalize() {
        if (this.connected) {
            this.disconnect();
        }
    }

    boolean getStarted() {
        return this.started;
    }

    boolean getConnected() {
        return this.connected;
    }

    int getCapHandle() {
        return this.capHandle;
    }

    int getCBHandle() {
        return this.cbHandle;
    }

    byte[] getData() {
        return this.data;
    }

    void pushData(int length) {
        this.length = length;
        if (this.transferHandler != null) {
            this.transferHandler.transferData(this);
        }
    }

    Object checkDataAllocation(Buffer buffer) {
        Object data;
        if (buffer instanceof ExtBuffer && ((ExtBuffer)buffer).isNativePreferred()) {
            data = ((ExtBuffer)buffer).getNativeData();
            if (data == null || ((NBA)data).getSize() < this.maxDataSize) {
                data = new NBA(array$B == null ? (array$B = VFWSourceStream.class$("[B")) : array$B, this.maxDataSize);
            }
            ((ExtBuffer)buffer).setNativeData((NBA)data);
        } else {
            data = buffer.getData();
            if (data == null || !(data instanceof byte[]) || ((byte[])data).length < this.maxDataSize) {
                data = new byte[this.maxDataSize];
                buffer.setData(data);
            }
        }
        return data;
    }

    public void read(Buffer buffer) {
        Integer n2 = this.readLock;
        synchronized (n2) {
            CircularBuffer circularBuffer = this.bufferQ;
            synchronized (circularBuffer) {
                if (this.bufferQ.canRead()) {
                    Buffer captureBuffer = this.bufferQ.read();
                    buffer.copy(captureBuffer, true);
                    buffer.setOffset(0);
                    buffer.setFormat(this.fullFormat);
                    buffer.setFlags(32912);
                    this.bufferQ.readReport();
                } else {
                    buffer.setDiscard(true);
                }
            }
            this.doneReading = true;
            this.readLock.notifyAll();
        }
    }

    public Object[] getControls() {
        if (this.controls == null) {
            this.controls = new Control[2];
            this.controls[0] = this;
            this.controls[1] = new MC();
        }
        return this.controls;
    }

    public Format getFormat() {
        if (this.fullFormat == null) {
            this.fullFormat = (VideoFormat)this.getSupportedFormats()[0];
        }
        return this.fullFormat;
    }

    public Format[] getSupportedFormats() {
        if (this.cdi == null) {
            this.cdi = this.getCaptureDeviceInfo();
        }
        if (this.cdi == null) {
            return new Format[0];
        }
        return this.cdi.getFormats();
    }

    public Format setFormat(Format in) {
        if (!(in instanceof VideoFormat)) {
            return null;
        }
        Format matched = BasicPlugIn.matches(in, this.getSupportedFormats());
        if (matched != null) {
            this.requestedFormat = (VideoFormat)in;
        }
        if (this.connected && !this.started) {
            this.handleFormatChange();
            return this.fullFormat;
        }
        return matched;
    }

    public void setEnabled(boolean value) {
    }

    public boolean isEnabled() {
        return true;
    }

    private void updateComponents() {
        if (this.formatChoice != null) {
            this.formatChoice.setEnabled(!this.started);
        }
        if (this.formatChooser != null) {
            this.formatChooser.setEnabled(this.connected && !this.started);
        }
        if (this.formatDialog != null) {
            this.formatDialog.setEnabled(this.connected && !this.started);
        }
        if (this.sourceDialog != null) {
            this.sourceDialog.setEnabled(this.connected && !this.started);
        }
        if (this.frameRateChoice != null) {
            this.frameRateChoice.setEnabled(!this.started);
        }
        if (this.cbMonitorEnable != null) {
            this.cbMonitorEnable.setEnabled(!this.started);
        }
    }

    public Component getControlComponent() {
        if (this.controlComponent == null) {
            this.controlComponent = new Panel(new BorderLayout());
            this.controlComponent.setName("Capture Control");
            Format[] formats = this.getSupportedFormats();
            this.formatChooser = new VideoFormatChooser(formats, (VideoFormat)this.getFormat(), this.FRAME_RATES);
            this.controlComponent.add("North", this.formatChooser);
            this.formatDialog = new Button(STRING_CF);
            this.sourceDialog = new Button(STRING_SD);
            this.sourceDialog.addActionListener(this);
            Panel southPanel = new Panel();
            southPanel.add(this.formatDialog);
            southPanel.add(this.sourceDialog);
            this.controlComponent.add("South", southPanel);
            this.updateComponents();
            this.updateFormatChooser();
            this.formatDialog.addActionListener(this);
        }
        return this.controlComponent;
    }

    public Object getOwner() {
        return this;
    }

    public synchronized void actionPerformed(ActionEvent ae) {
        String source = ae.getActionCommand();
        if (source.equals(STRING_CF)) {
            Integer n2 = this.vfwReqLock;
            synchronized (n2) {
                this.vfwRequest = 3;
                this.vfwReqLock.notifyAll();
            }
        }
        if (source.equals(STRING_SD)) {
            Integer n3 = this.vfwReqLock;
            synchronized (n3) {
                this.vfwRequest = 4;
                this.vfwReqLock.notifyAll();
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block37: {
            wmQuit = false;
            peekResult = 1;
            if (!this.doConnect()) break block37;
            var3_3 = this.lockInit;
            synchronized (var3_3) {
                this.connected = true;
                this.connectedOK = true;
                this.lockInit.notifyAll();
                ** GOTO lbl121
            }
        }
        var3_4 = this.lockInit;
        synchronized (var3_4) {
            this.connected = true;
            this.connectedOK = false;
            this.lockInit.notifyAll();
            return;
        }
        {
            try {
                Thread.currentThread();
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            peekResult = VFWCapture.peekWindowLoop(this.nativeParentWindow);
            if (peekResult == 0) {
                wmQuit = true;
            }
            do {
                if (this.vfwRequest < 0) continue block24;
                cpVFWRequest = this.vfwRequest;
                this.vfwRequest = -1;
                switch (cpVFWRequest) {
                    case 2: {
                        if (VFWSourceStream.DEBUG) {
                            System.err.println("capture - Stopping");
                        }
                        VFWCapture.stopFrameCallback(this.capHandle, this.cbHandle);
                        VFWCapture.capCaptureStop(this.capHandle);
                        i = 0;
                        cs = new CapStatus();
                        while (i < 100) {
                            VFWCapture.capGetStatus(this.capHandle, cs);
                            if (!cs.fCapturingNow) {
                                if (!VFWSourceStream.DEBUG) break;
                                System.err.println("capture - Stopped");
                                break;
                            }
                            try {
                                Thread.currentThread();
                                Thread.sleep(50L);
                            }
                            catch (InterruptedException ie) {
                                // empty catch block
                            }
                            ++i;
                        }
                        this.waitingToStop = false;
                        var6_12 = this.waitForStop;
                        synchronized (var6_12) {
                            this.waitForStop.notifyAll();
                            break;
                        }
                    }
                    case 1: {
                        if (VFWSourceStream.DEBUG) {
                            System.err.println("capture - Starting");
                        }
                        this.doStartCapture();
                        if (!VFWSourceStream.DEBUG) break;
                        System.err.println("capture - Started");
                        break;
                    }
                    case 5: {
                        if (!VFWSourceStream.DEBUG) break;
                        System.err.println("capture - Disconnecting");
                        break;
                    }
                    case 3: {
                        if (!this.monitorEnabled) {
                            VFWCapture.showWindow(this.nativeParentWindow, 1, -1, -1);
                        }
                        VFWCapture.capDlgVideoFormat(this.capHandle);
                        this.setMonitorEnabled(this.monitorEnabled);
                        bmi = new BitMapInfo();
                        VFWCapture.capGetVideoFormat(this.capHandle, bmi);
                        newFormat = bmi.createVideoFormat(Format.byteArray, this.requestedFrameRate);
                        if (!newFormat.equals(this.capFormat)) {
                            this.requestedFormat = newFormat;
                            this.maxDataSize = this.requestedFormat.getMaxDataLength();
                            this.data = new byte[this.maxDataSize];
                        }
                        this.updateFormatChooser();
                        break;
                    }
                    case 4: {
                        if (!this.monitorEnabled) {
                            VFWCapture.showWindow(this.nativeParentWindow, 1, -1, -1);
                        }
                        VFWCapture.capDlgVideoSource(this.capHandle);
                        this.setMonitorEnabled(this.monitorEnabled);
                        break;
                    }
                    case 6: {
                        this.updateCaptureSetup();
                        break;
                    }
                    case 7: {
                        if (this.hasOverlay) {
                            VFWCapture.capOverlay(this.capHandle, this.monitorEnabled);
                            break;
                        }
                        VFWCapture.capPreview(this.capHandle, this.monitorEnabled);
                        VFWCapture.capPreviewRate(this.capHandle, this.capPreviewRate);
                    }
                }
lbl121:
                // 12 sources

            } while (this.connected);
        }
        this.doDisconnect();
        if (VFWSourceStream.DEBUG) {
            System.err.println("capture - Disconnected");
        }
        while (!wmQuit) {
            try {
                Thread.currentThread();
                Thread.yield();
                Thread.currentThread();
                Thread.sleep(50L);
            }
            catch (InterruptedException var3_7) {
                // empty catch block
            }
            peekResult = VFWCapture.peekWindowLoop(this.nativeParentWindow);
            if (peekResult != 0) continue;
            wmQuit = true;
        }
        this.pt = null;
    }

    Component getMonitorControlComponent() {
        if (this.monitorComponent == null) {
            this.monitorComponent = new Panel();
            this.monitorComponent.setLayout(new BorderLayout());
            this.cbMonitorEnable = new Checkbox("Video Monitor");
            this.cbMonitorEnable.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent ie) {
                    VFWSourceStream.this.setMonitorEnabled(VFWSourceStream.this.cbMonitorEnable.getState());
                }
            });
            Panel panelPreviewRate = new Panel(new BorderLayout());
            panelPreviewRate.add("East", new Label("frames/sec"));
            this.textPreviewRate = new TextField("30");
            this.textPreviewRate.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ae) {
                    try {
                        float previewRate = Float.valueOf(VFWSourceStream.this.textPreviewRate.getText()).floatValue();
                        if (previewRate < 0.1f) {
                            previewRate = 0.1f;
                        } else if (previewRate > 30.0f) {
                            previewRate = 30.0f;
                        }
                        VFWSourceStream.this.setMonitorPreviewRate(previewRate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            panelPreviewRate.add("Center", this.textPreviewRate);
            this.monitorComponent.add("West", this.cbMonitorEnable);
            this.monitorComponent.add("Center", panelPreviewRate);
        }
        return this.monitorComponent;
    }

    boolean setMonitorEnabled(boolean value) {
        if (value) {
            if (this.nativeParentWindow != 0) {
                VFWCapture.showWindow(this.nativeParentWindow, 2, this.capWidth, this.capHeight);
            }
            this.monitorEnabled = true;
        } else {
            if (this.nativeParentWindow != 0) {
                VFWCapture.showWindow(this.nativeParentWindow, 0, -1, -1);
            }
            this.monitorEnabled = false;
        }
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 7;
            this.vfwReqLock.notifyAll();
        }
        return value;
    }

    float setMonitorPreviewRate(float rate) {
        int millis;
        if (rate > 30.0f) {
            rate = 30.0f;
        } else if ((double)rate < 0.1) {
            rate = 0.1f;
        }
        this.capPreviewRate = millis = (int)(1000.0f / rate);
        Integer n2 = this.vfwReqLock;
        synchronized (n2) {
            this.vfwRequest = 7;
            this.vfwReqLock.notifyAll();
        }
        return rate;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        int i2 = 0;
        while (i2 < MAX_CARDS) {
            VFWSourceStream.inUse[i2] = false;
            ++i2;
        }
    }

    class TransferDataThread
    extends Thread {
        VFWSourceStream stream;

        public TransferDataThread(VFWSourceStream stream) {
            super("VFW TransferDataThread");
            this.stream = stream;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            while (VFWSourceStream.this.getConnected()) {
                CircularBuffer circularBuffer = VFWSourceStream.this.bufferQ;
                // MONITORENTER : circularBuffer
                while (!VFWSourceStream.this.bufferQ.canRead() && VFWSourceStream.this.getConnected()) {
                    try {
                        VFWSourceStream.this.bufferQ.wait(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : circularBuffer
                Integer n2 = this.stream.readLock;
                // MONITORENTER : n2
                this.stream.doneReading = false;
                // MONITOREXIT : n2
                if (VFWSourceStream.this.bufferQ.canRead() && VFWSourceStream.this.getConnected() && VFWSourceStream.this.getStarted()) {
                    VFWSourceStream.this.pushData(1);
                }
                Integer n3 = this.stream.readLock;
                // MONITORENTER : n3
                if (!VFWSourceStream.this.doneReading) {
                    try {
                        this.stream.readLock.wait(1000L);
                    }
                    catch (InterruptedException ie2) {
                        // empty catch block
                    }
                }
                // MONITOREXIT : n3
            }
        }
    }

    class PushThread
    extends Thread {
        VFWSourceStream stream;
        public Object data = null;
        public long dataBytes = 0L;
        public Buffer buffer = null;

        public PushThread(VFWSourceStream stream) {
            super("VFW VideoPollThread");
            this.stream = stream;
        }

        public void run() {
            int handle = VFWSourceStream.this.getCapHandle();
            int cbHandle = VFWSourceStream.this.getCBHandle();
            int time = 0;
            while (VFWSourceStream.this.getConnected()) {
                try {
                    Thread.sleep(10L);
                    Thread.yield();
                    time += 10;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                PushThread pushThread = this;
                synchronized (pushThread) {
                    if (VFWSourceStream.this.getStarted()) {
                        Object object;
                        if (this.buffer == null) {
                            object = VFWSourceStream.this.bufferQ;
                            synchronized (object) {
                                if (!VFWSourceStream.this.bufferQ.canWrite()) {
                                    VFWSourceStream.this.bufferQ.read();
                                    VFWSourceStream.this.bufferQ.readReport();
                                }
                                this.buffer = VFWSourceStream.this.bufferQ.getEmptyBuffer();
                            }
                            this.data = VFWSourceStream.this.checkDataAllocation(this.buffer);
                            this.dataBytes = this.data instanceof NBA ? ((NBA)this.data).getNativeData() : 0L;
                        }
                        object = VFWSourceStream.this.cbHandleLock;
                        synchronized (object) {
                            int result;
                            cbHandle = VFWSourceStream.this.getCBHandle();
                            if (cbHandle != 0 && (result = VFWCapture.getAvailableData(handle, cbHandle, this.data, this.dataBytes, VFWSourceStream.this.maxDataSize, VFWSourceStream.this.resultTimeStamp)) > 0) {
                                VFWSourceStream.this.lastTimeStamp = VFWSourceStream.this.startTimeStamp + VFWSourceStream.this.resultTimeStamp[0] * 1000000L;
                                CircularBuffer circularBuffer = VFWSourceStream.this.bufferQ;
                                synchronized (circularBuffer) {
                                    this.buffer.setOffset(0);
                                    this.buffer.setTimeStamp(VFWSourceStream.this.lastTimeStamp);
                                    this.buffer.setLength(result);
                                    VFWSourceStream.this.bufferQ.writeReport();
                                    VFWSourceStream.this.bufferQ.notifyAll();
                                    this.buffer = null;
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    class MC
    implements MonitorControl,
    Owned {
        public Component getControlComponent() {
            return VFWSourceStream.this.getMonitorControlComponent();
        }

        public float setPreviewFrameRate(float value) {
            return VFWSourceStream.this.setMonitorPreviewRate(value);
        }

        public boolean setEnabled(boolean value) {
            return VFWSourceStream.this.setMonitorEnabled(value);
        }

        public Object getOwner() {
            return VFWSourceStream.this;
        }
    }
}

