/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client;

import com.blisscloud.ezuc.client.ApplicationInstanceListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationInstanceManager {
    private static Logger log = LoggerFactory.getLogger(ApplicationInstanceManager.class);
    public static final int SINGLE_INSTANCE_NETWORK_SOCKET = 43210;
    private static ApplicationInstanceListener subListener;

    public static boolean registerInstance() {
        boolean returnValueOnError = true;
        try {
            final ServerSocket socket = new ServerSocket(43210, 10, InetAddress.getLocalHost());
            log.debug("Listening for application instances on socket 43210");
            Thread instanceListenerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    boolean socketClosed = false;
                    while (!socketClosed) {
                        if (socket.isClosed()) {
                            socketClosed = true;
                            continue;
                        }
                        try {
                            Socket client = socket.accept();
                            BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                            String message = in.readLine();
                            if ("$$EZUCInstance$$\n".trim().equals(message.trim())) {
                                log.debug("Shared key matched - new application instance found");
                                ApplicationInstanceManager.fireNewInstance();
                            }
                            in.close();
                            client.close();
                        }
                        catch (IOException e) {
                            socketClosed = true;
                        }
                    }
                }
            });
            instanceListenerThread.setName("UC-InstanceListener");
            instanceListenerThread.start();
        }
        catch (UnknownHostException e) {
            log.error(e.getMessage(), (Throwable)e);
            return returnValueOnError;
        }
        catch (IOException e) {
            log.debug("Port is already taken.  Notifying first instance.");
            try {
                Socket clientSocket = new Socket(InetAddress.getLocalHost(), 43210);
                OutputStream out = clientSocket.getOutputStream();
                out.write("$$EZUCInstance$$\n".getBytes());
                out.close();
                clientSocket.close();
                log.debug("Successfully notified first instance.");
                return false;
            }
            catch (UnknownHostException e1) {
                log.error(e.getMessage(), (Throwable)e);
                return returnValueOnError;
            }
            catch (IOException e1) {
                log.error("Error connecting to local port for single instance notification");
                log.error(e1.getMessage(), (Throwable)e1);
                return returnValueOnError;
            }
        }
        return true;
    }

    public static void setApplicationInstanceListener(ApplicationInstanceListener listener) {
        subListener = listener;
    }

    private static void fireNewInstance() {
        if (subListener != null) {
            subListener.newInstanceCreated();
        }
    }
}

