/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client;

import com.blisscloud.ezuc.client.ApplicationInstanceListener;
import com.blisscloud.ezuc.client.ApplicationInstanceManager;
import com.blisscloud.ezuc.client.ClosePolicyPanel;
import com.blisscloud.ezuc.client.UCBaseActivity;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.UIController;
import com.blisscloud.ezuc.client.component.GlassPanel;
import com.blisscloud.ezuc.client.component.GlassPanelCallback;
import com.blisscloud.ezuc.client.component.LoadingDataPanel;
import com.blisscloud.ezuc.client.component.ProgressCircleUI;
import com.blisscloud.ezuc.client.component.ToastPanel;
import com.blisscloud.ezuc.client.http.DesktopHttpServer;
import com.blisscloud.ezuc.client.login.LoginPanel;
import com.blisscloud.ezuc.client.login.LoginWindow;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.main.MixVolume;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.SystemUtils;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatMsgQueueController;
import com.blisscloud.mobile.ezuc.agent.ConnectionAgent;
import com.blisscloud.mobile.ezuc.agent.NetworkService;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.VerifyEnterpriseNoTask;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Properties;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.commons.lang3.StringUtils;
import org.ini4j.Ini;

public class UCChatClient
extends JFrame {
    private static final double FRAME_RATIO = 0.9;
    public static final boolean TESTING_ENABLED = true;
    private static volatile UCChatClient instance;
    public static Activity context;
    private LoginWindow loginWindow = new LoginWindow();
    private UIController uic;
    private MainPanel mainPanel;
    private LoadingDataPanel loadingDataPanel;
    private GlassPanel glassPanel;
    private ToastPanel toastPanel;
    private ComponentAdapter posAdapter;
    private boolean isLoginMode = false;
    private DesktopHttpServer mDesktopHttpServer;
    private JMenuItem exitItem = null;
    private JMenuItem logoutItem = null;
    private TrayIcon trayIcon;
    private JProgressBar progressBar = null;
    private JPanel progressPanel = null;
    private JLabel importLable = null;
    private int mProgress = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UCChatClient getInstance() {
        if (instance == null) {
            Activity activity = context;
            synchronized (activity) {
                if (instance == null) {
                    instance = new UCChatClient();
                    instance.startHttpServerAsync();
                }
            }
        }
        return instance;
    }

    private UCChatClient() {
        try {
            this.uic = new UIController();
            this.mainPanel = new MainPanel();
            this.loadingDataPanel = new LoadingDataPanel();
            this.glassPanel = new GlassPanel();
            this.toastPanel = new ToastPanel();
            this.toastPanel.setVisible(false);
            this.posAdapter = new ComponentAdapter(this){

                @Override
                public void componentResized(ComponentEvent e) {
                    Component c = (Component)e.getSource();
                    Rectangle rect = c.getBounds();
                    PreferencesUtil.setWindowBounds(context, rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight());
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    Component c = (Component)e.getSource();
                    Rectangle rect = c.getBounds();
                    PreferencesUtil.setWindowBounds(context, rect.getX() + "," + rect.getY() + "," + rect.getWidth() + "," + rect.getHeight());
                }
            };
            Platform.startup((Runnable)new Runnable(this){

                @Override
                public void run() {
                    Log.i(UCChatClient.class.getSimpleName(), "JAVAFX Platform start up ...");
                }
            });
            this.initGUI();
            this.initSystemTray();
            if (SystemUtils.isWindows()) {
                MixVolume.setVolume(PreferencesUtil.getFloat(context, "APP_SETTING_VOLUME", Float.valueOf(1.0f)).floatValue());
            }
        }
        catch (Throwable t) {
            Log.i(UCChatClient.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getAppName());
            this.setIconImages(UIConstants.APP_ICONS);
            this.setDefaultCloseOperation(0);
            this.setGlassPane(this.glassPanel);
            this.getLayeredPane().add((Component)this.toastPanel, JLayeredPane.POPUP_LAYER);
            this.getLayeredPane().setOpaque(false);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    PreferencesUtil.ClosePolicy closePolicy = PreferencesUtil.getClosePolicy();
                    if (closePolicy == null) {
                        SwingUtilities.invokeLater(new Runnable(this){

                            @Override
                            public void run() {
                                ClosePolicyPanel cpp = new ClosePolicyPanel();
                                UCChatClient.getInstance().showGlassPanel(cpp, true);
                            }
                        });
                    } else {
                        switch (closePolicy) {
                            case minimize: {
                                UCChatClient.this.setVisible(false);
                                break;
                            }
                            case close: {
                                WebAgent.getInstance().logout(2002, false);
                            }
                        }
                    }
                }
            });
            this.addWindowFocusListener(new WindowAdapter(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    if (UCChatClient.this.mainPanel != null) {
                        UCChatClient.this.mainPanel.setGainFocus(true, e.getOppositeWindow());
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (UCChatClient.this.mainPanel != null) {
                        UCChatClient.this.mainPanel.setGainFocus(false, e.getOppositeWindow());
                    }
                }
            });
            this.addWindowStateListener(new WindowAdapter(this){

                @Override
                public void windowStateChanged(WindowEvent evt) {
                    int oldState = evt.getOldState();
                    int newState = evt.getNewState();
                    if ((oldState & 1) == 0 && (newState & 1) != 0) {
                        Log.d(UCChatClient.class.getSimpleName(), "Frame was iconized");
                    } else if ((oldState & 1) != 0 && (newState & 1) == 0) {
                        Log.d(UCChatClient.class.getSimpleName(), "Frame was deiconized");
                    }
                    if ((oldState & 6) == 0 && (newState & 6) != 0) {
                        Log.d(UCChatClient.class.getSimpleName(), "Frame was maximized");
                        PreferencesUtil.setMaxWindows(context, true);
                    } else if ((oldState & 6) != 0 && (newState & 6) == 0) {
                        Log.d(UCChatClient.class.getSimpleName(), "Frame was not maximized");
                        PreferencesUtil.setMaxWindows(context, false);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initSystemTray() {
        if (!SystemTray.isSupported()) {
            Log.w(UCChatClient.class.getSimpleName(), "SystemTray is not supported");
            return;
        }
        final JDialog jDialog = new JDialog();
        jDialog.setUndecorated(true);
        jDialog.setSize(1, 1);
        this.exitItem = new JMenuItem(I18NUtil.getString("common_btn_close"));
        this.exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UCChatClient.this.exit();
            }
        });
        this.logoutItem = new JMenuItem(I18NUtil.getString("login_btn_logout_exit"));
        this.logoutItem.addActionListener(new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PhoneAgent.getInstance().isCallIdle()) {
                    ToastUtil.showLong(I18NUtil.getString("call_incall_exit_not_allowed"));
                } else {
                    WebAgent.getInstance().logout(2002, true);
                }
            }
        });
        SystemTray tray = SystemTray.getSystemTray();
        String appName = I18NUtil.getAppName();
        this.trayIcon = new TrayIcon(UIConstants.ICON_LOGO32.getImage(), appName);
        this.trayIcon.setImageAutoSize(true);
        this.trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UCChatClient.this.handleMoveToFront();
            }
        });
        this.trayIcon.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 1) {
                    UCChatClient.this.handleMoveToFront();
                } else if (e.getButton() == 3 && e.isPopupTrigger()) {
                    JPopupMenu jPopupMenu = new JPopupMenu(){

                        @Override
                        public void firePopupMenuWillBecomeInvisible() {
                            jDialog.setVisible(false);
                        }
                    };
                    jPopupMenu.setSize(100, 30);
                    jPopupMenu.removeAll();
                    if (WebAgent.isLogin) {
                        jPopupMenu.add(UCChatClient.this.logoutItem);
                        jPopupMenu.addSeparator();
                    }
                    jPopupMenu.add(UCChatClient.this.exitItem);
                    jDialog.setLocation(e.getX() + 5, e.getY() - 5 - jPopupMenu.getHeight());
                    jDialog.setVisible(true);
                    jPopupMenu.show(jDialog, 0, 0);
                }
            }
        });
        try {
            tray.add(this.trayIcon);
        }
        catch (AWTException e) {
            Log.e(UCChatClient.class.getSimpleName(), "TrayIcon could not be added.");
        }
    }

    public void handleMoveToFront() {
        if (this.isLoginMode) {
            int currentState = this.loginWindow.getExtendedState();
            if (currentState != 0) {
                this.loginWindow.setExtendedState(0);
            }
            this.loginWindow.setVisible(true);
            this.loginWindow.setAlwaysOnTop(true);
            this.loginWindow.toFront();
            this.loginWindow.repaint();
            this.loginWindow.requestFocus();
            this.loginWindow.setAlwaysOnTop(false);
        } else {
            UCChatClient inst = UCChatClient.getInstance();
            inst.setVisible(true);
            int currentState = inst.getExtendedState();
            if (currentState != 0) {
                inst.setExtendedState(0);
            }
            inst.setAlwaysOnTop(true);
            inst.toFront();
            inst.repaint();
            inst.requestFocus();
            inst.setAlwaysOnTop(false);
        }
    }

    public void startHttpServerAsync() {
        Thread t = new Thread("DesktopHttpServerInitial"){

            @Override
            public void run() {
                try {
                    UCChatClient.this.mDesktopHttpServer = new DesktopHttpServer();
                }
                catch (IOException e) {
                    Log.e(UCChatClient.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        };
        t.start();
    }

    public boolean startHttpServerSync() {
        try {
            this.mDesktopHttpServer = new DesktopHttpServer();
            return true;
        }
        catch (IOException e) {
            Log.e(UCChatClient.class.getSimpleName(), e.getLocalizedMessage(), e);
            return false;
        }
    }

    public void stopHttpServer() {
        if (this.mDesktopHttpServer != null) {
            this.mDesktopHttpServer.stopServer();
        }
    }

    public boolean isHttpServerReady() {
        return this.mDesktopHttpServer != null;
    }

    @Override
    public void setContentPane(Container contentPane) {
        Container oldContentPane;
        this.isLoginMode = false;
        this.loginWindow.dispose();
        this.loginWindow.onStop();
        if (!this.isVisible()) {
            this.setVisible(true);
        }
        if ((oldContentPane = super.getContentPane()) != null && oldContentPane instanceof UCBaseActivity) {
            ((UCBaseActivity)oldContentPane).onStop();
        }
        super.setContentPane(contentPane);
        if (contentPane != null && contentPane instanceof UCBaseActivity) {
            ((UCBaseActivity)contentPane).onResume();
        }
    }

    public void showLoginPanel(LoginPanel.Mode mode) {
        this.isLoginMode = true;
        this.dispose();
        if (!this.loginWindow.isVisible()) {
            this.loginWindow.setLocationRelativeTo(this);
            this.loginWindow.setVisible(true);
            this.loginWindow.showLoginPanel(mode);
            this.loginWindow.onResume();
        }
    }

    public void showMainPanel(int mode) {
        Rectangle virtualBounds = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        if (mode == 0) {
            Rectangle loginBounds = this.loginWindow.getBounds();
            for (int j = 0; j < gs.length; ++j) {
                GraphicsDevice gd = gs[j];
                GraphicsConfiguration[] gc = gd.getConfigurations();
                for (int i = 0; i < gc.length; ++i) {
                    if (!gc[i].getBounds().contains(loginBounds)) continue;
                    virtualBounds = virtualBounds == null ? new Rectangle(gc[i].getBounds()) : virtualBounds.union(gc[i].getBounds());
                }
            }
        } else {
            for (int j = 0; j < gs.length; ++j) {
                GraphicsDevice gd = gs[j];
                GraphicsConfiguration[] gc = gd.getConfigurations();
                for (int i = 0; i < gc.length; ++i) {
                    virtualBounds = virtualBounds == null ? new Rectangle(gc[i].getBounds()) : virtualBounds.union(gc[i].getBounds());
                }
            }
        }
        Rectangle virtualBounds2 = new Rectangle();
        virtualBounds2.setFrame(virtualBounds.getX() - 8.0, virtualBounds.getY() - 8.0, virtualBounds.getWidth() + 16.0, virtualBounds.getHeight() + 16.0);
        String boundStr = PreferencesUtil.getWindowBounds(context);
        boolean isMaxWindows = PreferencesUtil.isMaxWindows(context);
        Rectangle bounds = null;
        if (boundStr != null) {
            String[] bAry = boundStr.split(",");
            Rectangle rect = new Rectangle();
            rect.setFrame(Double.parseDouble(bAry[0]), Double.parseDouble(bAry[1]), Double.parseDouble(bAry[2]), Double.parseDouble(bAry[3]));
            if (virtualBounds2.contains(rect)) {
                bounds = rect;
            }
        }
        PreferencesUtil.setMaxWindows(context, false);
        if (bounds == null) {
            Rectangle smallBounds = new Rectangle();
            smallBounds.setSize((int)((double)virtualBounds.width * 0.9), (int)((double)virtualBounds.height * 0.9));
            smallBounds.setLocation((int)(virtualBounds.getX() + (double)virtualBounds.width * 0.09999999999999998 / 2.0), (int)(virtualBounds.getY() + (double)virtualBounds.height * 0.09999999999999998 / 2.0));
            this.setResizable(true);
            this.setMinimumSize(new Dimension(1120, 650));
            this.setBounds(smallBounds);
        } else {
            this.setResizable(true);
            this.setMinimumSize(new Dimension(1120, 650));
            if (isMaxWindows) {
                Rectangle smallBounds = new Rectangle();
                smallBounds.setSize((int)((double)bounds.width * 0.9), (int)((double)bounds.height * 0.9));
                smallBounds.setLocation((int)(bounds.getX() + (double)bounds.width * 0.09999999999999998 / 2.0), (int)(bounds.getY() + (double)bounds.height * 0.09999999999999998 / 2.0));
                this.setBounds(smallBounds);
                PreferencesUtil.setWindowBounds(context, smallBounds.getX() + "," + smallBounds.getY() + "," + smallBounds.getWidth() + "," + smallBounds.getHeight());
            } else {
                this.setBounds(bounds);
            }
        }
        this.setContentPane(this.mainPanel);
        this.mainPanel.calculateCount();
        this.revalidate();
        this.repaint();
        this.addComponentListener(this.posAdapter);
    }

    public void showLoadingDataPanel(int mode) {
        this.setContentPane(this.loadingDataPanel);
        Rectangle virtualBounds = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        if (mode == 0) {
            Rectangle loginBounds = this.loginWindow.getBounds();
            for (int j = 0; j < gs.length; ++j) {
                GraphicsDevice gd = gs[j];
                GraphicsConfiguration[] gc = gd.getConfigurations();
                for (int i = 0; i < gc.length; ++i) {
                    Rectangle deviceBounds = gc[i].getBounds();
                    boolean isContained = deviceBounds.contains(loginBounds);
                    if (!isContained) continue;
                    virtualBounds = virtualBounds == null ? new Rectangle(gc[i].getBounds()) : virtualBounds.union(gc[i].getBounds());
                }
            }
        } else {
            for (int j = 0; j < gs.length; ++j) {
                GraphicsDevice gd = gs[j];
                GraphicsConfiguration[] gc = gd.getConfigurations();
                for (int i = 0; i < gc.length; ++i) {
                    virtualBounds = virtualBounds == null ? new Rectangle(gc[i].getBounds()) : virtualBounds.union(gc[i].getBounds());
                }
            }
        }
        Rectangle virtualBounds2 = new Rectangle();
        virtualBounds2.setFrame(virtualBounds.getX() - 8.0, virtualBounds.getY() - 8.0, virtualBounds.getWidth() + 16.0, virtualBounds.getHeight() + 16.0);
        String boundStr = PreferencesUtil.getWindowBounds(context);
        boolean isMaxWindows = PreferencesUtil.isMaxWindows(context);
        Rectangle bounds = null;
        if (boundStr != null) {
            String[] bAry = boundStr.split(",");
            Rectangle rect = new Rectangle();
            rect.setFrame(Double.parseDouble(bAry[0]), Double.parseDouble(bAry[1]), Double.parseDouble(bAry[2]), Double.parseDouble(bAry[3]));
            if (virtualBounds2.contains(rect)) {
                bounds = rect;
            }
        }
        PreferencesUtil.setMaxWindows(context, false);
        if (bounds == null) {
            Rectangle smallBounds = new Rectangle();
            smallBounds.setSize((int)((double)virtualBounds.width * 0.9), (int)((double)virtualBounds.height * 0.9));
            smallBounds.setLocation((int)(virtualBounds.getX() + (double)virtualBounds.width * 0.09999999999999998 / 2.0), (int)(virtualBounds.getY() + (double)virtualBounds.height * 0.09999999999999998 / 2.0));
            this.setResizable(false);
            this.setMinimumSize(new Dimension(800, 550));
            this.setBounds(smallBounds);
        } else {
            this.setResizable(false);
            this.setMinimumSize(new Dimension(800, 550));
            if (isMaxWindows) {
                Rectangle smallBounds = new Rectangle();
                smallBounds.setSize((int)((double)bounds.width * 0.9), (int)((double)bounds.height * 0.9));
                smallBounds.setLocation((int)(bounds.getX() + (double)bounds.width * 0.09999999999999998 / 2.0), (int)(bounds.getY() + (double)bounds.height * 0.09999999999999998 / 2.0));
                this.setBounds(smallBounds);
                PreferencesUtil.setWindowBounds(context, smallBounds.getX() + "," + smallBounds.getY() + "," + smallBounds.getWidth() + "," + smallBounds.getHeight());
            } else {
                this.setBounds(bounds);
            }
        }
        this.revalidate();
        this.repaint();
    }

    public boolean isLoginMode() {
        return this.isLoginMode;
    }

    public void setLoadingDataText(String text) {
        this.loadingDataPanel.setLoadingText(text);
    }

    public void showGlassPanel(JComponent comp, boolean cancellable) {
        this.glassPanel.showComponent(comp, cancellable);
    }

    public void showGlassPanel(JComponent comp, boolean cancellable, GlassPanelCallback callback) {
        this.glassPanel.showComponent(comp, cancellable, callback);
    }

    public void showGlassPanel(JComponent comp, boolean cancellable, boolean blockMouse, Color background, GlassPanelCallback callback) {
        this.glassPanel.showComponent(comp, cancellable, blockMouse, background, callback);
    }

    public void hideGlassPanel() {
        this.glassPanel.setVisible(false);
    }

    public void showDataImportForOption() {
        JPanel x = new JPanel();
        x.setOpaque(false);
        this.showGlassPanel(x, false, false, null, new GlassPanelCallback(this){

            @Override
            public void onHide() {
            }
        });
    }

    public void showDataImportProgress() {
        this.hideGlassPanel();
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel();
            this.progressPanel.setOpaque(false);
            this.progressPanel.setLayout(new BoxLayout(this.progressPanel, 1));
            this.progressBar = new JProgressBar(){

                @Override
                public void updateUI() {
                    super.updateUI();
                    this.setUI(new ProgressCircleUI());
                    this.setBorder(BorderFactory.createEmptyBorder(25, 25, 25, 25));
                }
            };
            this.progressBar.setOpaque(false);
            this.progressBar.setStringPainted(true);
            this.progressBar.setFont(UIConstants.FONT_24_BOLD);
            this.progressPanel.add(this.progressBar);
            this.importLable = new JLabel();
            this.importLable.setText(I18NUtil.getString("init_data_notice"));
            this.importLable.setFont(UIConstants.FONT_24_BOLD);
            this.importLable.setForeground(Color.WHITE);
            this.importLable.setAlignmentX(0.5f);
            this.progressPanel.add(this.importLable);
        }
        this.mProgress = 0;
        this.updateImportProgress();
        this.showGlassPanel(this.progressPanel, false, false, null, new GlassPanelCallback(this){

            @Override
            public void onHide() {
            }
        });
    }

    public void updateImportProgress() {
        if (this.progressBar != null) {
            int progressTemp = 0;
            long currentEventTime = PreferencesUtil.getSyncDataCurrentTime(context);
            long daysCount = PreferencesUtil.getSyncDaysCount(context);
            if (daysCount != 0L) {
                double percent = (double)(currentEventTime - (System.currentTimeMillis() - daysCount * 86400000L)) * 1.0 / 8.64E7 / (double)daysCount;
                String pStr = String.format("%.0f", percent * 100.0);
                progressTemp = Integer.parseInt(pStr);
                if (progressTemp >= 100) {
                    progressTemp = 99;
                } else if (progressTemp < 0) {
                    progressTemp = 0;
                }
            } else {
                progressTemp = 0;
            }
            if (progressTemp > this.mProgress) {
                this.mProgress = progressTemp;
            }
            this.progressBar.setValue(this.mProgress);
            Log.i(UCChatClient.class.getSimpleName(), "updateImportProgress:" + this.mProgress);
        }
    }

    public void updateImportProgress(int progress) {
        this.mProgress = progress;
        if (this.progressBar != null) {
            this.progressBar.setValue(this.mProgress);
            Log.i(UCChatClient.class.getSimpleName(), "updateImportProgress:" + this.mProgress);
        }
    }

    public void hideDataImportProgress() {
        this.hideGlassPanel();
    }

    public void showToastPanel(String message, int duration) {
        if (this.getContentPane() == this.mainPanel) {
            this.toastPanel.showMessage(message, duration);
            JLayeredPane p = this.getLayeredPane();
            p.invalidate();
            p.repaint();
        }
    }

    public void hideToastPanel() {
        if (this.getContentPane() == this.mainPanel) {
            this.toastPanel.setVisible(false);
            JLayeredPane p = this.getLayeredPane();
            p.invalidate();
            p.repaint();
        }
    }

    public void showErrorToastPanel(String message, int duration) {
        if (this.getContentPane() == this.mainPanel) {
            this.toastPanel.showErrorMessage(message, duration);
            JLayeredPane p = this.getLayeredPane();
            p.invalidate();
            p.repaint();
        }
    }

    public MainPanel getMainPanel() {
        return this.mainPanel;
    }

    public void exit() {
        UCDBHelper.closeDatabase(context);
        UserDatabase.closeDatabase(context);
        System.exit(0);
    }

    public boolean isReadyForChat() {
        return this.getContentPane() == this.mainPanel && !this.mainPanel.isInitialing();
    }

    public static void main(String[] args) {
        String javaVersion = System.getProperty("java.version");
        String javaLibPath = System.getProperty("java.library.path");
        if (SystemUtils.isWindows()) {
            File file = new File("C:\\Windows\\krb5.ini");
            if (file.exists()) {
                System.setProperty("java.security.krb5.conf", file.getAbsolutePath());
            } else {
                System.err.println("krb5.ini not found!");
            }
        }
        Log.i(UCChatClient.class.getSimpleName(), "You are using JAVA " + javaVersion);
        Log.i(UCChatClient.class.getSimpleName(), "java.library.path: " + javaLibPath);
        Log.i(UCChatClient.class.getSimpleName(), "Max Memory is " + Runtime.getRuntime().maxMemory());
        if (javaVersion.compareTo("1.7") < 0) {
            Log.i(UCChatClient.class.getSimpleName(), "UC Chat Client Cancelled, unsupported JAVA version!");
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    int result = JOptionPane.showConfirmDialog(null, I18NUtil.getString("setting_notice_java_version_check"), I18NUtil.getString("common_title_error"), 2, 0);
                    if (result == 0) {
                        Desktop desktop;
                        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
                        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                            try {
                                desktop.browse(new URI("http://www.java.com/"));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    System.exit(0);
                }
            });
            return;
        }
        PreferencesUtil.load();
        if (!PreferencesUtil.isMultipleApplicationInstance()) {
            if (!ApplicationInstanceManager.registerInstance()) {
                Log.w(UCChatClient.class.getSimpleName(), "Another instance of this application is already running.  Exiting.");
                System.exit(0);
            }
            ApplicationInstanceManager.setApplicationInstanceListener(new ApplicationInstanceListener(){

                @Override
                public void newInstanceCreated() {
                    Log.w(UCChatClient.class.getSimpleName(), "New instance detected...just bring the first desktop instance to front");
                    EventQueue.invokeLater(new Runnable(this){

                        @Override
                        public void run() {
                            UCChatClient inst = UCChatClient.getInstance();
                            inst.setVisible(true);
                            int currentState = inst.getExtendedState();
                            inst.setExtendedState(1);
                            inst.setExtendedState(currentState == 1 ? 0 : currentState);
                            inst.toFront();
                            inst.repaint();
                        }
                    });
                }
            });
        }
        String releaseTime = "";
        String releaseVersion = "";
        int releaseVersionCode = -1;
        Properties versionProp = new Properties();
        try {
            versionProp.load(UCChatClient.class.getResourceAsStream("/version.info"));
            releaseTime = versionProp.getProperty("release.time");
            releaseVersion = versionProp.getProperty("release.version");
            releaseVersionCode = Integer.parseInt(versionProp.getProperty("release.version.code"));
        }
        catch (Exception e) {
            Log.e(UCChatClient.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
        Log.i(UCChatClient.class.getSimpleName(), "EZDesktop Started");
        Log.i(UCChatClient.class.getSimpleName(), "    Release Time: " + releaseTime);
        Log.i(UCChatClient.class.getSimpleName(), "    Release Version: " + releaseVersion);
        Log.i(UCChatClient.class.getSimpleName(), "    Release Version Code: " + releaseVersionCode);
        Log.i(UCChatClient.class.getSimpleName(), "    App Directory: " + FileUtil.getAppRootDir().getAbsolutePath());
        Log.i(UCChatClient.class.getSimpleName(), "JVM file.encoding: " + System.getProperty("file.encoding"));
        Log.i(UCChatClient.class.getSimpleName(), "    os.arch: " + System.getProperty("os.arch"));
        Log.i(UCChatClient.class.getSimpleName(), "    os.name: " + System.getProperty("os.name"));
        int ucDBVersion = PreferencesUtil.getUCDatabaseVersion();
        Log.i(UCChatClient.class.getSimpleName(), "current UC database version:" + ucDBVersion + ", application UC database version:167");
        if (ucDBVersion == -1) {
            dbHelper = UCDBHelper.getDB(context);
            dbHelper.onCreate(dbHelper.getWritableDatabase());
            PreferencesUtil.setUCDatabaseVersion(167);
        } else if (ucDBVersion < 167) {
            dbHelper = UCDBHelper.getDB(context);
            dbHelper.onUpgrade(dbHelper.getWritableDatabase(), ucDBVersion, 167);
            PreferencesUtil.setUCDatabaseVersion(167);
        }
        int userDBVersion = PreferencesUtil.getUserDatabaseVersion();
        Log.i(UCChatClient.class.getSimpleName(), "current User database version:" + userDBVersion + ", application User database version:2");
        if (userDBVersion < 2) {
            UserDatabase.getDB(context).onUpgrade(null, userDBVersion, 2);
            PreferencesUtil.setUserDatabaseVersion(2);
        }
        if (SystemUtils.isMac()) {
            UCChatClient.readyToRunStep1();
        } else if (SystemUtils.isWindows()) {
            File iniFile = new File("C:\\Windows\\ezuc.ini");
            if (!iniFile.exists()) {
                UCChatClient.readyToRunStep1();
                return;
            }
            if (!UCChatClient.checkIni(iniFile)) {
                UCChatClient.readyToRunStep1();
            }
        } else {
            System.exit(0);
        }
    }

    private static boolean checkIni(File iniFile) {
        try {
            String username;
            String currentLoginId;
            Ini ini = new Ini(iniFile);
            String iniSpn = ini.get((Object)"kerberos", (Object)"spn");
            String iniOid = ini.get((Object)"kerberos", (Object)"oid");
            if (StringUtils.isNotBlank((CharSequence)iniSpn)) {
                PreferencesUtil.setGSSSPN(context, iniSpn);
            }
            if (StringUtils.isNotBlank((CharSequence)iniOid)) {
                PreferencesUtil.setGSSOID(context, iniOid);
            }
            if (StringUtils.isBlank((CharSequence)(currentLoginId = PreferencesUtil.getLoginID(context))) && StringUtils.isNotBlank((CharSequence)(username = System.getProperty("user.name")))) {
                PreferencesUtil.setLoginInfo(context, username);
            }
            final String iniEnterpriseNo = ini.get((Object)"server", (Object)"enterpriseNo");
            String currentNo = PreferencesUtil.getEnterpriseNo(context);
            if (StringUtils.isBlank((CharSequence)currentNo) && StringUtils.isNotBlank((CharSequence)iniEnterpriseNo)) {
                VerifyEnterpriseNoTask mQueryTask = new VerifyEnterpriseNoTask(context, iniEnterpriseNo, new ICheckCompleteListener(){

                    @Override
                    public void onCheckCompleted(Object data, int result) {
                        if (0 == result) {
                            PreferencesUtil.setEnterpriseNoNotReady(context, iniEnterpriseNo);
                        }
                        UCChatClient.readyToRunStep1();
                    }
                });
                mQueryTask.execute(new Void[0]);
                return true;
            }
            return false;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    private static void readyToRunStep1() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean hasEnterpriseSet;
                try {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                    UIManager.put("Button.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("CheckBox.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("ComboBox.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("Label.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("List.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("Menu.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("MenuBar.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("MenuItem.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("OptionPane.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("RadioButton.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("TextArea.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("TextField.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("TitledBorder.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("ToggleButton.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("ToolBar.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("Tree.font", UIConstants.FONT_12_PLAIN);
                    UIManager.put("PopupMenu.consumeEventOnClose", Boolean.FALSE);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ToolTipManager.sharedInstance().setInitialDelay(200);
                Platform.setImplicitExit((boolean)false);
                PreferencesUtil.saveDeviceInformation(context, 3);
                String loginId = PreferencesUtil.getLoginID(context);
                boolean hasLoginId = TextUtils.isNotBlank((CharSequence)loginId);
                boolean hasPassword = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getLoginPWD(context));
                boolean hasSysToken = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getLoginToken(context));
                boolean remainLogin = PreferencesUtil.isRemainLoggedIn(context);
                boolean hasEnterpriseNo = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getEnterpriseNo(context));
                boolean hasEnterpriseIp = TextUtils.isNotBlank((CharSequence)PreferencesUtil.getEnterpriseIp(context));
                boolean bl = hasEnterpriseSet = hasEnterpriseNo || hasEnterpriseIp;
                if (hasEnterpriseSet && remainLogin && hasLoginId && (hasPassword || hasSysToken)) {
                    UCChatClient.readyToRun(true);
                    return;
                }
                if (!remainLogin && hasLoginId && hasPassword) {
                    UCChatClient.readyToRun(false);
                    return;
                }
                if (!remainLogin && hasLoginId && hasSysToken) {
                    PreferencesUtil.setRemainLoggedIn(context);
                    remainLogin = true;
                    UCChatClient.readyToRun(true);
                    return;
                }
                UCChatClient.readyToRun(false);
            }
        });
    }

    private static void readyToRun(boolean reconnect) {
        UCChatClient inst = UCChatClient.getInstance();
        PhoneAgent.getInstance();
        WebAgent.getInstance();
        ConnectionAgent.getInstance();
        NetworkService.getInstance();
        ChatMsgQueueController.getInstance(context);
        ChatRoomManager.markSendinMsgAsError(context);
        if (reconnect) {
            Log.i(UCChatClient.class.getSimpleName(), "***** \u986f\u793aLoadingDataPanel");
            inst.showLoadingDataPanel(1);
            if (PreferencesUtil.isSyncOldChatEventDone(context)) {
                inst.setLoadingDataText(I18NUtil.getString("login_notice_data_loading"));
            }
            inst.mainPanel.initDataProcess(1);
            inst.setVisible(true);
        } else {
            inst.showLoginPanel(LoginPanel.Mode.WAIT);
        }
    }

    public TrayIcon getTrayIcon() {
        return this.trayIcon;
    }

    static {
        context = new Activity();
    }
}

