/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.bulletin;

import com.blisscloud.ezuc.bean.web.LiteBulletinHeader;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bulletin.BulletinArea;
import com.blisscloud.ezuc.client.bulletin.BulletinPanel;
import com.blisscloud.ezuc.client.chat.IView;
import com.blisscloud.ezuc.client.contacthistory.ContactHistoryPanel;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BulletinDetailPanel
extends JPanel
implements IView {
    private static final long serialVersionUID = 4931109261766268942L;
    private Long mBulletinId = null;
    private JLabel lblTypeName;
    private BulletinArea bulletinArea;
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;

    public BulletinDetailPanel(Long bulletinId) {
        this.mBulletinId = bulletinId;
        this.initGUI();
        this.initReceiver();
        this.updateBulletinDetail();
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if ("ezuc.intent.action.event.BULLETIN_STATUS_CHANGED".equals(action)) {
                        long bulletinId = intent.getLongExtra("bulletinId", -1L);
                        if (BulletinDetailPanel.this.mBulletinId == bulletinId && BulletinDetailPanel.this.bulletinArea != null) {
                            BulletinDetailPanel.this.bulletinArea.updateStatus();
                        }
                    } else if ("ezuc.intent.action.event.BULLETIN_SUBJECT_PHOTO_READY".equals(action)) {
                        long bulletinId = intent.getLongExtra("bulletinId", -1L);
                        if (BulletinDetailPanel.this.mBulletinId == bulletinId && BulletinDetailPanel.this.bulletinArea != null) {
                            BulletinDetailPanel.this.bulletinArea.updatePhoto();
                        }
                    } else if ("ezuc.intent.action.event.BULLETIN_DETAIL_READY".equals(action)) {
                        long bulletinId = intent.getLongExtra("bulletinId", -1L);
                        if (BulletinDetailPanel.this.mBulletinId == bulletinId && BulletinDetailPanel.this.bulletinArea != null) {
                            BulletinDetailPanel.this.bulletinArea.updateDetails();
                        }
                    } else if ("ezuc.intent.action.event.PERSONAL_INFO_CHANGED".equals(action) && BulletinDetailPanel.this.bulletinArea != null) {
                        BulletinDetailPanel.this.bulletinArea.updatePhoto();
                        BulletinDetailPanel.this.bulletinArea.updateDetails();
                    }
                }
                catch (Throwable t) {
                    Log.e(ContactHistoryPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.BULLETIN_STATUS_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.BULLETIN_SUBJECT_PHOTO_READY");
        this.filter.addAction("ezuc.intent.action.event.BULLETIN_DETAIL_READY");
        this.filter.addAction("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    @Override
    public String getViewId() {
        return BulletinPanel.convertBulletinToViewId(this.mBulletinId);
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(520, 480));
            this.setMinimumSize(new Dimension(520, 480));
            this.lblTypeName = new JLabel();
            this.add((Component)this.lblTypeName, "North");
            this.lblTypeName.setBorder(UIConstants.BORDER_HEADER);
            this.lblTypeName.setHorizontalAlignment(0);
            this.lblTypeName.setFont(UIConstants.FONT_16_BOLD);
            this.bulletinArea = new BulletinArea(this.mBulletinId);
            this.add((Component)((Object)this.bulletinArea), "Center");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateBulletinDetail() {
        LiteBulletinHeader header = UCDBBulletin.getBulletinHeader(UCChatClient.context, this.mBulletinId);
        if (header == null) {
            return;
        }
        this.lblTypeName.setText(header.getTypeName());
    }

    @Override
    public void onShow(Intent intent) {
    }

    @Override
    public void onHide() {
    }

    @Override
    public void onClose() {
    }

    public void loadBulletin(Long bulletinId) {
        this.mBulletinId = bulletinId;
        this.updateBulletinDetail();
        if (this.bulletinArea != null) {
            this.bulletinArea.reloadContent(bulletinId);
        }
    }
}

