/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.bulletin;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;

public class LoadSubjectPhotoPanel
extends JPanel
implements ImageObserver {
    private static final int BORDER_THICK = 16;
    private static final Image IMAGE_WAITING = UIConstants.ICON_LOADING24.getImage();
    private JLabel lblMessage;
    private BufferedImage mImage;
    private DownloadFileTask mDownloadTask;

    public LoadSubjectPhotoPanel() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setOpaque(false);
            this.setPreferredSize(new Dimension(200, 100));
            this.setMaximumSize(new Dimension(200, 100));
            this.setBackground(new Color(255, 128, 128));
            SpringLayout thisLayout = new SpringLayout();
            this.setLayout(thisLayout);
            this.lblMessage = new JLabel();
            thisLayout.putConstraint("West", (Component)this.lblMessage, 20, "West", (Component)this);
            thisLayout.putConstraint("East", (Component)this.lblMessage, -20, "East", (Component)this);
            thisLayout.putConstraint("South", (Component)this.lblMessage, -20, "South", (Component)this);
            this.add(this.lblMessage);
            this.lblMessage.setHorizontalAlignment(0);
            this.lblMessage.setForeground(Color.WHITE);
            this.lblMessage.setFont(UIConstants.FONT_14_PLAIN);
            this.lblMessage.setText(I18NUtil.getString("common_title_loading"));
            JLabel lblClose = new JLabel();
            lblClose.setIcon(UIConstants.ICON_CLOSE);
            lblClose.setCursor(UIConstants.CURSOR_HAND);
            lblClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    LoadSubjectPhotoPanel.this.setVisible(false);
                }
            });
            thisLayout.putConstraint("North", (Component)lblClose, 6, "North", (Component)this);
            thisLayout.putConstraint("East", (Component)lblClose, -6, "East", (Component)this);
            this.add(lblClose);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelDownloadIfNotCompleted() {
        if (this.mDownloadTask != null && this.mDownloadTask.isAlive()) {
            this.mDownloadTask.cancel();
        }
    }

    private Dimension countImageDisplaySize(BufferedImage image) {
        int compWidth = this.getWidth() - 16;
        int compHeight = this.getHeight() - 16;
        int imgWidth = image.getWidth();
        int imgHeight = image.getHeight();
        float r = Math.min((float)compWidth / (float)imgWidth, (float)compHeight / (float)imgHeight);
        float dispRatio = Math.min(1.0f, r);
        int imgDispWidth = (int)((float)imgWidth * dispRatio);
        int imgDispHeight = (int)((float)imgHeight * dispRatio);
        return new Dimension(imgDispWidth, imgDispHeight);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mImage != null) {
            int width = this.getWidth();
            int height = this.getHeight();
            Dimension dispSize = this.countImageDisplaySize(this.mImage);
            int imgDispWidth = dispSize.width;
            int imgDispHeight = dispSize.height;
            int bgX = (width - imgDispWidth - 16) / 2;
            int bgY = (height - imgDispHeight - 16) / 2;
            g.setColor(Color.WHITE);
            g.fillRect(bgX, bgY, imgDispWidth + 16 - 1, imgDispHeight + 16 - 1);
            g.setColor(Color.DARK_GRAY);
            g.drawRect(bgX, bgY, imgDispWidth + 16 - 1, imgDispHeight + 16 - 1);
            int imgX = (width - imgDispWidth) / 2;
            int imgY = (height - imgDispHeight) / 2;
            BufferedImage bi = GraphicUtil.createScaledCenterImage(this.mImage, imgDispWidth, imgDispHeight);
            g.drawImage(bi, imgX, imgY, imgDispWidth, imgDispHeight, this);
        }
    }

    public void showImage(File cacheFile, String imageName) {
        try {
            File imageFile = new File(FileUtil.getTempDir(), imageName);
            Files.copy(cacheFile.toPath(), imageFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.mImage = FileUtil.readFileHandleExif(imageFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadSubjectPhotoPanel.this.lblMessage.setVisible(false);
                LoadSubjectPhotoPanel.this.setPreferredSize(new Dimension(LoadSubjectPhotoPanel.this.mImage.getWidth() + 16, LoadSubjectPhotoPanel.this.mImage.getHeight() + 16));
                LoadSubjectPhotoPanel.this.setMaximumSize(new Dimension(LoadSubjectPhotoPanel.this.mImage.getWidth() + 16, LoadSubjectPhotoPanel.this.mImage.getHeight() + 16));
                LoadSubjectPhotoPanel.this.revalidate();
                LoadSubjectPhotoPanel.this.repaint();
                if (LoadSubjectPhotoPanel.this.getParent() != null) {
                    LoadSubjectPhotoPanel.this.getParent().revalidate();
                    LoadSubjectPhotoPanel.this.getParent().repaint();
                }
            }
        });
    }
}

