/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.io.File;
import javafx.application.Platform;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AudioPlayerRequest {
    private String mPlayPacketId;
    private Element mPlanAudioIconElem;
    private String mPlanAudioIconElemId;
    private Element mPlanAudioDurationElem;
    private long mPlayAudioTime = 0L;
    private int mAudioImageCount = 0;
    private UCTimerTask mPlayTimerTask;
    private MediaPlayer mMediaPlayer;
    private int mAudioPlayType;
    private Message mMessage;
    private Document mDocument;

    public AudioPlayerRequest(int audioPlayType, Message message, File audioFile, ElementAttrMap targetMap, Document document) {
        try {
            String packetId = targetMap.get("packetId");
            String audioInfoIconId = targetMap.get("audioInfoIconId");
            String audioInfoDurationId = targetMap.get("audioInfoDurationId");
            this.mDocument = document;
            this.mAudioPlayType = audioPlayType;
            this.mMessage = message;
            this.mPlayPacketId = packetId;
            this.mPlanAudioIconElem = this.mDocument.getElementById(audioInfoIconId);
            if (this.mPlanAudioIconElem != null) {
                this.mPlanAudioIconElemId = this.mPlanAudioIconElem.getAttribute("id");
            }
            this.mPlanAudioDurationElem = this.mDocument.getElementById(audioInfoDurationId);
            this.mPlayAudioTime = System.currentTimeMillis();
            Media hit = new Media(audioFile.toURI().toString());
            this.mMediaPlayer = new MediaPlayer(hit);
            this.mMediaPlayer.setOnPlaying(new Runnable(){

                @Override
                public void run() {
                    Log.i(AudioPlayerRequest.class.getSimpleName(), AudioPlayerRequest.this.mPlayPacketId + " onPlaying");
                    AudioPlayerRequest.this.mPlayAudioTime = System.currentTimeMillis();
                }
            });
            this.mMediaPlayer.setOnError(new Runnable(){

                @Override
                public void run() {
                    Log.i(AudioPlayerRequest.class.getSimpleName(), AudioPlayerRequest.this.mPlayPacketId + " onError");
                    AudioPlayerRequest.this.onFinishOut();
                }
            });
            this.mMediaPlayer.setOnStopped(new Runnable(){

                @Override
                public void run() {
                    Log.i(AudioPlayerRequest.class.getSimpleName(), AudioPlayerRequest.this.mPlayPacketId + " onStopped");
                    AudioPlayerRequest.this.onFinishOut();
                }
            });
            this.mMediaPlayer.setOnEndOfMedia(new Runnable(){

                @Override
                public void run() {
                    Log.i(AudioPlayerRequest.class.getSimpleName(), AudioPlayerRequest.this.mPlayPacketId + " onEndOfMedia");
                    AudioPlayerRequest.this.onFinishOut();
                }
            });
            this.mPlayTimerTask = new UCTimerTask(){

                @Override
                public void doRun() {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            try {
                                AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", "");
                                if (AudioPlayerRequest.this.mAudioPlayType == 0) {
                                    if (AudioPlayerRequest.this.mAudioImageCount % 3 == 0) {
                                        AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.audio1IconURI);
                                    } else if (AudioPlayerRequest.this.mAudioImageCount % 3 == 1) {
                                        AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.audio2IconURI);
                                    } else {
                                        AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.audio3IconURI);
                                    }
                                } else if (AudioPlayerRequest.this.mAudioPlayType == 1) {
                                    if (AudioPlayerRequest.this.mAudioImageCount % 3 == 0) {
                                        AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.audioSelf1IconURI);
                                    } else if (AudioPlayerRequest.this.mAudioImageCount % 3 == 1) {
                                        AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.audioSelf2IconURI);
                                    } else {
                                        AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.audioSelf3IconURI);
                                    }
                                } else if (AudioPlayerRequest.this.mAudioImageCount % 5 == 0) {
                                    AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.voiceMail1IconURI);
                                } else if (AudioPlayerRequest.this.mAudioImageCount % 5 == 1) {
                                    AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.voiceMail2IconURI);
                                } else if (AudioPlayerRequest.this.mAudioImageCount % 5 == 2) {
                                    AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.voiceMail3IconURI);
                                } else if (AudioPlayerRequest.this.mAudioImageCount % 5 == 3) {
                                    AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.voiceMail4IconURI);
                                } else if (AudioPlayerRequest.this.mAudioImageCount % 5 == 4) {
                                    AudioPlayerRequest.this.mPlanAudioIconElem.setAttribute("src", MessageResource.voiceMail5IconURI);
                                }
                                DomUtil.cleanTextNodes(AudioPlayerRequest.this.mPlanAudioDurationElem);
                                AudioPlayerRequest.this.mPlanAudioDurationElem.appendChild(AudioPlayerRequest.this.mDocument.createTextNode(CommonUtil.getDurationMilliSeconds(Math.min(System.currentTimeMillis() - AudioPlayerRequest.this.mPlayAudioTime, AudioPlayerRequest.this.mMessage.getDuration()))));
                                ++AudioPlayerRequest.this.mAudioImageCount;
                            }
                            catch (UCThreadException e) {
                                Log.e(AudioPlayerRequest.class.getSimpleName(), e.getLocalizedMessage(), e);
                            }
                        }
                    });
                }
            };
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }

    private void onFinishOut() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    AudioPlayerRequest.this.onFinish();
                }
                catch (Throwable e) {
                    Log.e(AudioPlayerRequest.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }

    private void onFinish() throws UCThreadException {
        this.cleanup();
        if (this.mPlayTimerTask != null) {
            this.mPlayTimerTask.cancel();
            this.mPlayTimerTask = null;
        }
        int msgType = this.mMessage.getMsgType();
        int type = 0;
        if (msgType == 12 || msgType == 1005) {
            type = 2;
        } else if (msgType == 1 || msgType == 6) {
            type = this.mPlanAudioIconElemId != null && this.mPlanAudioIconElemId.startsWith("myMess") ? 1 : 0;
        }
        if (this.mMessage != null && type != -1) {
            if (this.mPlanAudioIconElem != null) {
                if (type == 0) {
                    this.mPlanAudioIconElem.setAttribute("src", "");
                    this.mPlanAudioIconElem.setAttribute("src", MessageResource.audio3IconURI);
                } else if (type == 1) {
                    this.mPlanAudioIconElem.setAttribute("src", "");
                    this.mPlanAudioIconElem.setAttribute("src", MessageResource.audioSelf3IconURI);
                } else if (type == 2) {
                    this.mPlanAudioIconElem.setAttribute("src", "");
                    this.mPlanAudioIconElem.setAttribute("src", MessageResource.voiceMailIconURI);
                }
            }
            if (this.mPlanAudioDurationElem != null) {
                if (type == 0) {
                    DomUtil.cleanTextNodes(this.mPlanAudioDurationElem);
                    this.mPlanAudioDurationElem.appendChild(this.mDocument.createTextNode(CommonUtil.getDurationMilliSeconds(this.mMessage.getDuration())));
                } else if (type == 1) {
                    DomUtil.cleanTextNodes(this.mPlanAudioDurationElem);
                    this.mPlanAudioDurationElem.appendChild(this.mDocument.createTextNode(CommonUtil.getDurationMilliSeconds(this.mMessage.getDuration())));
                } else if (type == 2) {
                    DomUtil.cleanTextNodes(this.mPlanAudioDurationElem);
                    this.mPlanAudioDurationElem.appendChild(this.mDocument.createTextNode(CommonUtil.getDurationMilliSeconds(MsgUtil.getMsgDuration(this.mMessage))));
                }
            }
        }
    }

    public synchronized void close() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer = null;
        }
    }

    public synchronized void cleanup() {
        if (this.mMediaPlayer != null) {
            this.mMediaPlayer.dispose();
            this.mMediaPlayer = null;
        }
    }

    public synchronized boolean isCurrentPlaying(String packetId) {
        return this.mPlayPacketId.equalsIgnoreCase(packetId) && this.mMediaPlayer != null && this.mMediaPlayer.getStatus() == MediaPlayer.Status.PLAYING;
    }

    public Message getMessage() {
        return this.mMessage;
    }

    public void play() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AudioPlayerRequest.this.mMediaPlayer != null) {
                        AudioPlayerRequest.this.mMediaPlayer.play();
                    }
                }
                catch (Throwable t) {
                    Log.e(AudioPlayerRequest.class.getSimpleName(), t.getMessage(), t);
                }
            }
        }, "MessageAreaPlayMedia");
        t.start();
    }

    public UCTimerTask getPlayTimerTask() {
        return this.mPlayTimerTask;
    }
}

