/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.MessageDropperField;
import com.blisscloud.ezuc.client.chat.SelectFileHandler;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.mobile.ezuc.util.FileSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class MessageDropper
extends DropTargetAdapter {
    MessageDropperField dropperText;
    FileSelectionCallback fileCallback;

    public MessageDropper(MessageDropperField txtMessage, FileSelectionCallback fileCallback) {
        this.dropperText = txtMessage;
        this.fileCallback = fileCallback;
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        try {
            if (PreferencesUtil.isSyncDataNow(UCChatClient.context)) {
                e.dropComplete(false);
                return;
            }
            e.acceptDrop(3);
            Transferable trans = e.getTransferable();
            if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List files = (List)trans.getTransferData(DataFlavor.javaFileListFlavor);
                final ArrayList<File> targetFileList = new ArrayList<File>();
                for (File file : files) {
                    long fileLimit = PreferencesUtil.getFileUploadUpperLimit(UCChatClient.context);
                    long fileSize = file.length();
                    if (fileLimit != -1L && fileSize > fileLimit) {
                        if (this.dropperText.getTextField() != null) {
                            JOptionPane.showMessageDialog(this.dropperText.getTextField(), String.format(I18NUtil.getString("chat_validation_doc_maxsize"), FileUtil.convertFileSizeDisplay(fileLimit)), I18NUtil.getString("common_title_error"), 0);
                        }
                        return;
                    }
                    targetFileList.add(file);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectFileHandler.handleSelectedFileList(targetFileList, MessageDropper.this.fileCallback);
                    }
                });
            } else if (e.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                String text = (String)trans.getTransferData(DataFlavor.stringFlavor);
                if (this.dropperText.getTextField() != null) {
                    this.dropperText.getTextField().replaceSelection(text);
                }
            } else if (e.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                final Image image = (Image)trans.getTransferData(DataFlavor.imageFlavor);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SelectFileHandler.handleSelectedFileList(image, MessageDropper.this.fileCallback);
                    }
                });
            }
            e.dropComplete(true);
        }
        catch (Exception e1) {
            e.dropComplete(false);
            e1.printStackTrace();
        }
    }
}

