/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bulletin.BulletinDetailPanel;
import com.blisscloud.ezuc.client.bulletin.BulletinPanel;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.IView;
import com.blisscloud.ezuc.client.chat.ViewListener;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ConferenceChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.FaxDocRoom;
import com.blisscloud.ezuc.client.chat.roomimpl.MultiUserChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.PhoneHistoryRoom;
import com.blisscloud.ezuc.client.chat.roomimpl.WechatChatroom;
import com.blisscloud.ezuc.client.contact.MyContactEditor;
import com.blisscloud.ezuc.client.phone.PhoneIncomePanel;
import com.blisscloud.ezuc.client.phone.PhonePanel;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.AppConstUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ViewContainer
extends JPanel {
    private static final long serialVersionUID = 4210237413267681471L;
    private static final int ONE_MINUTE = 60000;
    private static Image bgImage;
    public static final String PAGE_BACKGROUND = "BackgroundPanel";
    private static final String PAGE_PHONE_0 = "PhonePanel0";
    private static final String PAGE_PHONE_1 = "PhonePanel1";
    private static final String PAGE_PHONE_INCOME = "PhoneIncomePanel";
    private static final String PAGE_MY_CONTACT_EDITOR = "MyContactEditor";
    private Map<String, IChatroom> mChatroomMap = new HashMap<String, IChatroom>();
    private CardLayout thisLayout = new CardLayout();
    private String currentPage = "BackgroundPanel";
    private BackgroundPanel mPanelBg;
    private PhonePanel mPanelPhone0;
    private PhonePanel mPanelPhone1;
    private PhoneIncomePanel mPanelIncomePhone;
    private MyContactEditor mMyContactEditor;
    private Timer timer = new Timer("ViewContainerTimer");
    private BulletinDetailPanel bulletinView = null;

    private static Image getViewContainerBackground() {
        if (bgImage == null) {
            String bgName = AppConstUtil.getBackgroundImgName();
            bgImage = new ImageIcon(ViewContainer.class.getClassLoader().getResource("images/" + bgName)).getImage();
        }
        return bgImage;
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ViewContainer());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public ViewContainer() {
        this.initGUI();
        this.timer.schedule((TimerTask)new UCTimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void doRun() {
                if (ViewContainer.this.mChatroomMap == null) {
                    return;
                }
                ViewContainer viewContainer = ViewContainer.this;
                synchronized (viewContainer) {
                    ArrayList<IChatroom> rooms = new ArrayList<IChatroom>(ViewContainer.this.mChatroomMap.values());
                    for (IChatroom room : rooms) {
                        if (JidUtil.isFakeExternalCallJid(room.getChatroomID()) || JidUtil.isFakeFaxDocJid(room.getChatroomID()) || System.currentTimeMillis() - room.getTimestamp() <= 60000L) continue;
                        IView activeComp = ViewContainer.this.getActiveComponent();
                        if (activeComp == room) {
                            room.setTimestamp(System.currentTimeMillis());
                            continue;
                        }
                        ViewContainer.this.closeChatRoomInternal(room.getChatroomID());
                    }
                }
                Runtime.getRuntime().gc();
            }
        }, 30000L, 30000L);
    }

    private void cleanTheOldestOne() {
        ArrayList<IChatroom> rooms = new ArrayList<IChatroom>(this.mChatroomMap.values());
        Collections.sort(rooms, new Comparator<IChatroom>(this){

            @Override
            public int compare(IChatroom o1, IChatroom o2) {
                if (o1.getTimestamp() - o2.getTimestamp() > 0L) {
                    return 1;
                }
                if (o1.getTimestamp() - o2.getTimestamp() < 0L) {
                    return -1;
                }
                return 0;
            }
        });
        for (int i = 0; i < rooms.size(); ++i) {
            System.out.println("=>" + rooms.get(i).getChatroomID() + " " + rooms.get(i).getTimestamp());
        }
        for (IChatroom room : rooms) {
            if (JidUtil.isFakeExternalCallJid(room.getChatroomID()) || JidUtil.isFakeFaxDocJid(room.getChatroomID())) continue;
            this.closeChatRoomInternal(room.getChatroomID());
            Runtime.getRuntime().gc();
            return;
        }
    }

    private void initGUI() {
        try {
            this.setLayout(this.thisLayout);
            this.mPanelBg = new BackgroundPanel();
            this.add((Component)this.mPanelBg, PAGE_BACKGROUND);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addViewListener(ViewListener l) {
        this.listenerList.add(ViewListener.class, l);
    }

    public void removeViewListener(ViewListener l) {
        this.listenerList.remove(ViewListener.class, l);
    }

    protected void fireViewShown(String viewId, Intent viewIntent) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ViewListener.class) continue;
            ((ViewListener)listeners[i + 1]).viewShown(viewId, viewIntent);
        }
    }

    protected void fireViewHide(String viewId) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ViewListener.class) continue;
            ((ViewListener)listeners[i + 1]).viewHide(viewId);
        }
    }

    protected void fireViewClose(String viewId) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ViewListener.class) continue;
            ((ViewListener)listeners[i + 1]).viewClosed(viewId);
        }
    }

    public IView getActiveComponent() {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            if (!(comp instanceof IView)) continue;
            IView view = (IView)((Object)comp);
            if (this.currentPage == null || !this.currentPage.equals(view.getViewId())) continue;
            return view;
        }
        return null;
    }

    public MyContactEditor getMyContactEditor() {
        return this.mMyContactEditor;
    }

    public IChatroom getChatroom(String roomJID) {
        return this.mChatroomMap.get(roomJID);
    }

    public synchronized Collection<IChatroom> getChatroom(ChatroomType type) {
        HashSet<IChatroom> matched = new HashSet<IChatroom>();
        Collection<IChatroom> rooms = this.mChatroomMap.values();
        for (IChatroom room : rooms) {
            if (room.getChatroomType() != type) continue;
            matched.add(room);
        }
        return matched;
    }

    public Collection<IChatroom> getAllChatroom() {
        return this.mChatroomMap.values();
    }

    public boolean isChatroomOpened(String roomJID) {
        return this.mChatroomMap.containsKey(roomJID);
    }

    public boolean isChatroomVisible(String roomJID) {
        return this.currentPage.equals(roomJID);
    }

    public boolean isBackgroundPageVisible() {
        return this.currentPage.equals(PAGE_BACKGROUND);
    }

    public boolean isIncomingViewVisible() {
        return this.currentPage.equals(PAGE_PHONE_INCOME);
    }

    private void setCurrentPage(String newPage, String p) {
        Log.i(ViewContainer.class.getSimpleName(), p + " currentPage is " + newPage);
        this.currentPage = newPage;
    }

    private synchronized void switchView(IView view, String viewPageName, Intent viewIntent) {
        IView activeComp = this.getActiveComponent();
        if (activeComp == view) {
            if (activeComp instanceof IView) {
                if (viewIntent != null && viewIntent.getBooleanExtra("NO_RELOAD_IF_OPEN", false)) {
                    return;
                }
                view.onShow(viewIntent);
            }
        } else {
            if (activeComp instanceof IView) {
                IView activeView = activeComp;
                activeView.onHide();
                this.fireViewHide(activeView.getViewId());
            }
            this.thisLayout.show(this, viewPageName);
            this.setCurrentPage(viewPageName, "switch");
            view.onShow(viewIntent);
            this.fireViewShown(view.getViewId(), viewIntent);
        }
    }

    private synchronized void showBackgroundPage(String p) {
        IView activeComp = this.getActiveComponent();
        if (activeComp != null && activeComp instanceof IView) {
            IView activeView = activeComp;
            activeView.onHide();
            this.fireViewHide(activeView.getViewId());
        }
        this.thisLayout.show(this, PAGE_BACKGROUND);
        this.setCurrentPage(PAGE_BACKGROUND, p);
        this.fireViewShown(PAGE_BACKGROUND, null);
    }

    public synchronized void showPhonePanel(String chatJid) {
        PhoneLineInfo lineInfo1;
        CallLine line1;
        CallLine line0 = PhoneAgent.getInstance().getCallLine(0);
        if (line0 != null && line0.getLineInfo() != null) {
            PhoneLineInfo lineInfo0 = line0.getLineInfo();
            String jid = null;
            jid = lineInfo0.getType() == 8 || lineInfo0.getType() == 10 ? lineInfo0.getNumber() : lineInfo0.getJid();
            if (jid != null && jid.equals(chatJid)) {
                this.showPhonePanel(0);
            }
        }
        if ((line1 = PhoneAgent.getInstance().getCallLine(1)) != null && line1.getLineInfo() != null && (lineInfo1 = line1.getLineInfo()) != null && lineInfo1.getJid() != null && lineInfo1.getJid().equals(chatJid)) {
            String jid = null;
            jid = lineInfo1.getType() == 8 || lineInfo1.getType() == 10 ? lineInfo1.getNumber() : lineInfo1.getJid();
            if (jid != null && jid.equals(chatJid)) {
                this.showPhonePanel(1);
            }
        }
    }

    public synchronized void showPhonePanel(int phoneLineIndex) {
        if (phoneLineIndex == 0) {
            if (this.mPanelPhone0 == null) {
                this.mPanelPhone0 = new PhonePanel(0);
                this.add((Component)this.mPanelPhone0, PAGE_PHONE_0);
            }
            this.switchView(this.mPanelPhone0, PAGE_PHONE_0, null);
        } else if (phoneLineIndex == 1) {
            if (this.mPanelPhone1 == null) {
                this.mPanelPhone1 = new PhonePanel(1);
                this.add((Component)this.mPanelPhone1, PAGE_PHONE_1);
            }
            this.switchView(this.mPanelPhone1, PAGE_PHONE_1, null);
        }
    }

    public synchronized void showPhoneIncomePanel(CallLine callLine) {
        if (this.mPanelIncomePhone == null) {
            this.mPanelIncomePhone = new PhoneIncomePanel();
            this.add((Component)this.mPanelIncomePhone, PAGE_PHONE_INCOME);
        }
        this.mPanelIncomePhone.setCurrentPhoneIndex(callLine.getLineId());
        this.switchView(this.mPanelIncomePhone, PAGE_PHONE_INCOME, null);
    }

    public synchronized void showMyContactEditor(Intent intent) {
        if (this.mMyContactEditor == null) {
            this.mMyContactEditor = new MyContactEditor();
            this.add((Component)this.mMyContactEditor, PAGE_MY_CONTACT_EDITOR);
        }
        this.switchView(this.mMyContactEditor, PAGE_MY_CONTACT_EDITOR, intent);
        long contactId = intent.getLongExtra("contactid", -1L);
        this.mMyContactEditor.setMyContactId(contactId);
    }

    public synchronized void showBulletin(Long bulletinId) {
        if (this.bulletinView == null) {
            this.bulletinView = new BulletinDetailPanel(bulletinId);
        } else {
            this.bulletinView.loadBulletin(bulletinId);
        }
        this.add((Component)this.bulletinView, this.bulletinView.getViewId());
        this.switchView(this.bulletinView, this.bulletinView.getViewId(), null);
    }

    public synchronized void closeBulletin(Long bulletinId) {
        String viewId = BulletinPanel.convertBulletinToViewId(bulletinId);
        boolean showBackGround = false;
        IView activeComp = this.getActiveComponent();
        if (activeComp == this.bulletinView) {
            showBackGround = true;
        }
        this.removeBulletinView(viewId);
        if (showBackGround) {
            this.showBackgroundPage("closeBulletin");
        }
    }

    public synchronized void showChatroom(String roomJID) {
        this.showChatroom(roomJID, new Intent());
    }

    public synchronized void showChatroom(String roomJID, Intent intent) {
        if (roomJID == null) {
            roomJID = "__EXTERNAL_TRUNK_CALL_GROUP__";
        }
        boolean cleanOne = false;
        Object room = null;
        if (this.mChatroomMap.containsKey(roomJID)) {
            room = this.mChatroomMap.get(roomJID);
            if (intent != null) {
                intent.putExtra("ROOM_INIT", false);
            }
        } else {
            if (this.mChatroomMap.size() > 8) {
                cleanOne = true;
            }
            if (intent != null) {
                intent.putExtra("ROOM_INIT", true);
            }
            room = JidUtil.isFakeExternalCallJid(roomJID) ? new PhoneHistoryRoom(roomJID) : (JidUtil.isFakeFaxDocJid(roomJID) ? new FaxDocRoom(roomJID) : (JidUtil.isCustomerJid(roomJID) ? new WechatChatroom(roomJID, this) : (JidUtil.isEmployeeJid(roomJID) || JidUtil.isBcAnnouncerJid(roomJID) ? new Chatroom(roomJID, this) : (JidUtil.isAPIUserJid(roomJID) ? new Chatroom(roomJID, this) : (JidUtil.isChatJid(roomJID) ? new MultiUserChatroom(roomJID, this) : (JidUtil.isConfJid(roomJID) ? new ConferenceChatroom(roomJID, this) : new Chatroom(roomJID, this)))))));
            this.mChatroomMap.put(roomJID, (IChatroom)room);
            this.add((Component)room, roomJID);
        }
        room.setTimestamp(System.currentTimeMillis());
        this.switchView((IView)room, roomJID, intent);
        if (cleanOne) {
            this.cleanTheOldestOne();
        }
    }

    private synchronized void removeBulletinView(String viewId) {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            IView view;
            if (!(comp instanceof IView) || !(view = (IView)((Object)comp)).getViewId().equals(viewId)) continue;
            view.onClose();
            this.fireViewClose(view.getViewId());
            this.remove(comp);
        }
    }

    public synchronized void hidePhonePanel(int phoneLineIndex, PhoneLineInfo lastLineInfo) {
        CallLine line0;
        if (phoneLineIndex == 0) {
            CallLine line1 = PhoneAgent.getInstance().getCallLine(1);
            if (line1.getState() != CallState.IDLE) {
                this.showPhonePanel(1);
                return;
            }
        } else if (phoneLineIndex == 1 && (line0 = PhoneAgent.getInstance().getCallLine(0)).getState() != CallState.IDLE) {
            this.showPhonePanel(0);
            return;
        }
        if (PAGE_PHONE_0.equals(this.currentPage) || PAGE_PHONE_1.equals(this.currentPage)) {
            if (lastLineInfo == null) {
                this.showBackgroundPage("hidePhonePanel");
            } else if (lastLineInfo.getJid() == null) {
                this.showChatroom("__EXTERNAL_TRUNK_CALL_GROUP__");
            } else {
                String jid = null;
                jid = lastLineInfo.getType() == 8 || lastLineInfo.getType() == 10 ? lastLineInfo.getNumber() : lastLineInfo.getJid();
                this.showChatroom(jid);
            }
        }
    }

    public synchronized void hidePhoneIncomePanel() {
        this.showBackgroundPage("hidePhoneIncomePanel1");
    }

    public synchronized void hidePhoneIncomePanel(PhoneLineInfo lastLineInfo) {
        if (lastLineInfo == null || lastLineInfo.getJid() == null) {
            this.showBackgroundPage("hidePhoneIncomePanel2");
        }
    }

    public synchronized void hideMyContactEditor() {
        this.showBackgroundPage("hideMyContactEditor");
    }

    public synchronized void closeChatroom(String roomJID) {
        IChatroom chatroom = this.mChatroomMap.get(roomJID);
        if (chatroom == null) {
            return;
        }
        boolean showBackGround = false;
        IView activeComp = this.getActiveComponent();
        if (activeComp == null || activeComp == chatroom) {
            showBackGround = true;
        }
        this.closeChatRoomInternal(roomJID);
        if (showBackGround) {
            this.showBackgroundPage("closeChatroom");
        }
    }

    private synchronized void closeChatRoomInternal(String roomJID) {
        Log.i(ViewContainer.class.getSimpleName(), "closeChatRoomInternal " + roomJID);
        IChatroom chatroom = this.mChatroomMap.get(roomJID);
        if (chatroom != null) {
            chatroom.onClose();
            this.fireViewClose(chatroom.getViewId());
            this.mChatroomMap.remove(roomJID);
            this.remove((Component)((Object)chatroom));
            chatroom = null;
            System.gc();
        }
    }

    public synchronized void release() {
        Component[] comps;
        for (Component comp : comps = this.getComponents()) {
            if (comp == this.mPanelBg) continue;
            if (comp instanceof IView) {
                ((IView)((Object)comp)).onClose();
            }
            this.remove(comp);
        }
        this.currentPage = PAGE_BACKGROUND;
        this.mPanelPhone0 = null;
        this.mPanelPhone1 = null;
        this.mPanelIncomePhone = null;
        this.mMyContactEditor = null;
        this.showBackgroundPage("closeChatroom");
        this.mChatroomMap.clear();
    }

    @Override
    public Dimension getMinimumSize() {
        Image bg = ViewContainer.getViewContainerBackground();
        return new Dimension(bg.getWidth(null), bg.getHeight(null));
    }

    class BackgroundPanel
    extends JPanel {
        private static final long serialVersionUID = -1540538569856097318L;

        BackgroundPanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            Image bg = ViewContainer.getViewContainerBackground();
            int w = this.getWidth();
            int h = this.getHeight();
            int imgW = bg.getWidth(this);
            int imgH = bg.getHeight(this);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setPaint(UIConstants.BACKGROUND_CHATROOM);
            g2d.fillRect(0, 0, w, h);
            g2d.drawImage(bg, (w - imgW) / 2, (h - imgH) / 2, this);
        }
    }
}

