/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.DeleteService;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import java.util.HashSet;
import javax.swing.JOptionPane;

public class DeleteFile {
    public static void handle(DeleteService deleteService, String packetId) {
        int result = JOptionPane.showConfirmDialog(deleteService.getParentPanel(), I18NUtil.getString("common_notice_delete_confirm"), I18NUtil.getString("common_title_warning"), 2, 2);
        if (result == 0) {
            Message message = deleteService.getMessageByPacketId(packetId);
            DeleteFile.doDelete(message, true, true);
            BroadcastUtil.sendMsgDeletedEvent(UCChatClient.context, packetId);
        }
    }

    public static void doDelete(Message message, boolean isDeleteRemoteItem, boolean isDeleteChatEvent) {
        try {
            int msgType = message.getMsgType();
            if (msgType == 12 || msgType == 1005 || msgType == 13 || msgType == 1006) {
                VoiceItem item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, message);
                if (item == null) {
                    Log.i(MessageArea.class.getSimpleName(), "VoiceItem null:" + message.getContent());
                    ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                    return;
                }
                VoicemailManager.delete(UCChatClient.context, item, isDeleteRemoteItem, isDeleteChatEvent);
            } else {
                ChatRoomManager.clearSpecificChatMsg((Context)UCChatClient.context, message.getPacketId());
                HashSet<Long> eventSet = new HashSet<Long>();
                if (message.getChatEventId() != -1L && message.getChatEventId() != 0L) {
                    eventSet.add(message.getChatEventId());
                }
                if (message.getSyncEventId() != -1L && message.getSyncEventId() != 0L) {
                    eventSet.add(message.getSyncEventId());
                }
                if (eventSet.size() > 0) {
                    for (Long id : eventSet) {
                        UCDBRemoteMark.addRemoteMark((Context)UCChatClient.context, 8, id);
                    }
                    WebAgent.getInstance().deleteChatEvent(eventSet);
                }
            }
        }
        catch (Exception e) {
            Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }
}

