/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import org.json.JSONObject;

public class DialOutbound {
    public static void handleRedialMine(ActionService actionService, ElementAttrMap targetMap) {
        String packetId = targetMap.get("packetId");
        Message message = actionService.getMessageByPacketId(packetId);
        boolean version_2_0 = false;
        JSONObject propObj = null;
        if (message.getProps() != null) {
            try {
                String version;
                propObj = new JSONObject(message.getProps());
                if (propObj.has("version") && (version = propObj.getString("version")).equalsIgnoreCase("2.0")) {
                    version_2_0 = true;
                }
            }
            catch (Exception e) {
                Log.e(DialOutbound.class.getSimpleName(), e.getMessage(), e);
            }
        }
        if (version_2_0) {
            DialOutbound.dialMineNew(message, propObj);
        } else {
            DialOutbound.dialMineOld(message);
        }
    }

    private static void dialMineNew(Message message, JSONObject propObj) {
        String toJid = message.getToJid();
        if (propObj.has("dstExt") && propObj.has("dstSiteId")) {
            try {
                String number = propObj.getString("dstExt");
                Long siteId = propObj.getLong("dstSiteId");
                DialOutbound.doDialOutboundAgain(toJid, siteId, number);
            }
            catch (Exception e) {
                Log.e(DialOutbound.class.getSimpleName(), e.getMessage(), e);
            }
        } else {
            DialOutbound.dialMineOld(message);
        }
    }

    private static void dialMineOld(Message message) {
        String toJid = message.getToJid();
        String origContent = message.getContent();
        if (!TextUtils.isBlank((CharSequence)origContent) && origContent.indexOf("_@@_") != -1) {
            String[] comps = origContent.split("_@@_");
            boolean numberDial = false;
            String number = null;
            String siteIdStr = null;
            Long siteId = null;
            if (comps.length >= 3) {
                siteIdStr = comps[1];
                if (TextUtils.isNotBlank((CharSequence)siteIdStr) && TextUtils.isDigitsOnly(siteIdStr)) {
                    siteId = Long.parseLong(siteIdStr);
                }
                number = comps[2];
                numberDial = true;
            }
            if (numberDial) {
                if (siteId == null) {
                    DialOutbound.doDialOutboundAgain(toJid, null, number);
                } else {
                    DialOutbound.doDialOutboundAgain(toJid, siteId, number);
                }
            }
        }
    }

    public static void handleRedialOthers(ActionService actionService, ElementAttrMap targetMap) {
        String packetId = targetMap.get("packetId");
        Message message = actionService.getMessageByPacketId(packetId);
        boolean version_2_0 = false;
        JSONObject propObj = null;
        if (message.getProps() != null) {
            try {
                String version;
                propObj = new JSONObject(message.getProps());
                if (propObj.has("version") && (version = propObj.getString("version")).equalsIgnoreCase("2.0")) {
                    version_2_0 = true;
                }
            }
            catch (Exception e) {
                Log.e(DialOutbound.class.getSimpleName(), e.getMessage(), e);
            }
        }
        if (version_2_0) {
            DialOutbound.dialOthersNew(message, propObj);
        } else {
            DialOutbound.dialOthersOld(message);
        }
    }

    private static void dialOthersNew(Message message, JSONObject propObj) {
        String fromJid = message.getFromJid();
        if (propObj.has("srcExt") && propObj.has("srcSiteId")) {
            try {
                String number = propObj.getString("srcExt");
                Long siteId = propObj.getLong("srcSiteId");
                DialOutbound.doDialOutboundAgain(fromJid, siteId, number);
            }
            catch (Exception e) {
                Log.e(DialOutbound.class.getSimpleName(), e.getMessage(), e);
            }
        } else {
            DialOutbound.dialOthersOld(message);
        }
    }

    private static void dialOthersOld(Message message) {
        String fromJid = message.getFromJid();
        String origContent = message.getContent();
        if (!TextUtils.isBlank((CharSequence)origContent) && origContent.indexOf("_@@_") != -1) {
            String[] comps = origContent.split("_@@_");
            boolean numberDial = false;
            String number = null;
            String siteIdStr = null;
            Long siteId = null;
            if (comps.length >= 3) {
                siteIdStr = comps[1];
                if (TextUtils.isNotBlank((CharSequence)siteIdStr) && TextUtils.isDigitsOnly(siteIdStr)) {
                    siteId = Long.parseLong(siteIdStr);
                }
                number = comps[2];
                numberDial = true;
            }
            if (numberDial) {
                if (siteId == null) {
                    DialOutbound.doDialOutboundAgain(fromJid, null, number);
                } else {
                    DialOutbound.doDialOutboundAgain(fromJid, siteId, number);
                }
            }
        }
    }

    private static void doDialOutboundAgain(String callJid, Long siteId, String phonenum) {
        Activity ctx = UCChatClient.context;
        if (JidUtil.isMyContactJid(callJid)) {
            DialoutManager.dialMyContactNumberWithPrefix(ctx, phonenum, callJid);
        } else if (JidUtil.isLocationJid(callJid)) {
            LiteContact contact = ContactManager.getContact((Context)ctx, callJid);
            if (contact != null && JidUtil.isLocationJid(contact.getJid())) {
                DialoutManager.dialLocation(ctx, contact);
            }
        } else if (JidUtil.isEmployeeJid(callJid)) {
            boolean result = DialoutManager.dialEmpExt(ctx, phonenum, siteId, callJid);
            if (!result) {
                DialoutManager.dialEmpNumberWithPrefix(ctx, phonenum, callJid);
            }
        } else {
            DialoutManager.dialOtherContactNumberWithPrefix(ctx, phonenum);
        }
    }
}

