/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.util.PlayAudioUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import java.io.File;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class DownloadAudio {
    public static void handle(final ActionService actionService, final ElementAttrMap targetMap) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    String packetId = targetMap.get("packetId");
                    String fileInfoStorageId = targetMap.get("fileInfoStorageId");
                    Log.i(MessageArea.class.getSimpleName(), "Click Audio icon---------" + packetId);
                    Message audioMsg = actionService.getMessageByPacketId(packetId);
                    int audioPlayType = 0;
                    if (fileInfoStorageId != null && fileInfoStorageId.startsWith("myMess")) {
                        audioPlayType = 1;
                    }
                    if (actionService.isMsgPlayCurrent(packetId)) {
                        actionService.stopAudioFile();
                        return;
                    }
                    if (!audioMsg.isPlayed()) {
                        ChatRoomManager.markMsgAsPlayed(UCChatClient.context, audioMsg);
                        Element elem_audioUnplay = actionService.getElementById("otherAudioUnplayIcon_" + packetId);
                        if (elem_audioUnplay != null) {
                            elem_audioUnplay.getParentNode().removeChild(elem_audioUnplay);
                        }
                    }
                    String audioData = audioMsg.getContent();
                    String audioType = String.valueOf(audioMsg.getMsgType());
                    if (audioData == null || audioType == null) {
                        Log.e(MessageArea.class.getSimpleName(), "audio data is null or audio type is null !");
                    } else {
                        try {
                            File audioFile = PlayAudioUtils.getAudioFile(audioData, Integer.parseInt(audioType));
                            actionService.playAudioFile(targetMap, audioMsg, audioFile, audioPlayType);
                        }
                        catch (Exception e) {
                            Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ToastUtil.showErrorLong("cannot open audio:" + e.getLocalizedMessage());
                                }
                            });
                        }
                    }
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
    }
}

