/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyVoicemailDownloadOpenTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import javafx.application.Platform;
import javax.swing.SwingUtilities;
import org.w3c.dom.Element;

public class DownloadVoicemail
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(final ActionService actionService, final ElementAttrMap targetMap) {
        ActionService actionService2 = actionService;
        synchronized (actionService2) {
            final String packetId = targetMap.get("packetId");
            final String fileInfoStorageId = targetMap.get("fileInfoStorageId");
            Log.i(DownloadVoicemail.class.getSimpleName(), "Click Audio icon---------" + packetId);
            if (actionService.hasDownloadTask(packetId)) {
                return;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        VoiceItem item;
                        Message message = actionService.getMessageByPacketId(packetId);
                        int audioPlayType = 2;
                        if (actionService.isMsgPlayCurrent(packetId)) {
                            actionService.stopAudioFile();
                            return;
                        }
                        actionService.stopAudioFile();
                        if (!message.isPlayed()) {
                            ChatRoomManager.markMsgAsPlayed(UCChatClient.context, message);
                            Element elem_audioUnplay = actionService.getElementById("otherVoicemailUnplayIcon_" + packetId);
                            if (elem_audioUnplay != null) {
                                elem_audioUnplay.getParentNode().removeChild(elem_audioUnplay);
                            }
                        }
                        if ((item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, message)) == null) {
                            Log.i(MessageArea.class.getSimpleName(), "VoiceItem null:" + message.getContent());
                            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                            return;
                        }
                        if (item.getGroup() != 0) {
                            return;
                        }
                        if (actionService.hasDownloadUrl(item.getUrl())) {
                            return;
                        }
                        File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
                        if (cacheFile == null) {
                            return;
                        }
                        if (cacheFile.exists()) {
                            try {
                                actionService.playAudioFile(targetMap, message, cacheFile, audioPlayType);
                            }
                            catch (Exception e) {
                                Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ToastUtil.showErrorLong("cannot open audio:" + e.getLocalizedMessage());
                                    }
                                });
                            }
                        } else {
                            DownloadVoicemail.downloadAndOpenVoiceRecording(actionService, item, message, fileInfoStorageId, cacheFile, targetMap);
                        }
                    }
                    catch (UCThreadException e) {
                        Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            });
        }
    }

    private static void downloadAndOpenVoiceRecording(final ActionService actionService, VoiceItem item, final Message message, final String fileInfoStorageId, File cacheFile, final ElementAttrMap targetMap) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FileProgressBarRenderer.render(actionService, message.getPacketId(), fileInfoStorageId, ActionBase.isLeft(targetMap));
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
        String fileDownloadURL = item.getUrl();
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new MyVoicemailDownloadOpenTaskCallBack(actionService, message, cacheFile, targetMap));
        actionService.registerDownloadMap(message.getPacketId(), task);
        actionService.registerDownloadUrlMap(message.getPacketId(), item.getUrl());
        task.start();
    }
}

