/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class MyVoicemailDownloadForwardTaskCallBack
implements DownloadFileTaskCallBack {
    String mPackId;
    File mFile;
    List<String> mSelectedJids;
    ActionService mActionService;
    VoiceItem item;

    public MyVoicemailDownloadForwardTaskCallBack(ActionService actionService, String packetId, File toFile, VoiceItem item, List<String> selectedJids) {
        this.mActionService = actionService;
        this.mPackId = packetId;
        this.mFile = toFile;
        this.mSelectedJids = selectedJids;
        this.item = item;
    }

    @Override
    public void onFileLengthGot(int size) {
    }

    @Override
    public void onProgressUpdated(int progress) {
        this.mActionService.updateFileDownloadProgress(this.mPackId, progress);
    }

    @Override
    public void onDownloadFileStarted() {
    }

    @Override
    public void onDownloadFileCompleted() {
        this.mActionService.updateFileDownloadCompleted(this.mPackId);
        ArrayList<ChatReceiver> receiverList = new ArrayList<ChatReceiver>();
        for (String receiverJid : this.mSelectedJids) {
            receiverList.add(new ChatReceiver(receiverJid));
        }
        ChatActionUtil.uploadFile(receiverList, this.mFile, false, null, this.mActionService.getParentPanel());
        this.unlock();
    }

    @Override
    public void onDownloadFileCancelled() {
        this.mActionService.updateFileDownloadCancelled(this.mPackId);
        this.unlock();
    }

    @Override
    public void onDownloadFileFailed() {
        this.mActionService.updateFileDownloadFailed(this.mPackId);
        this.unlock();
        ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
    }

    private void unlock() {
        this.mActionService.unregisterDownloadMap(this.mPackId);
        this.mActionService.unregisterDownloadUrlMap(this.mPackId);
    }

    @Override
    public void onDownloadFileNotFound() {
        ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
    }
}

