/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomUtil {
    static Map<String, String> fileIconMap = new HashMap<String, String>();

    public static File selectFileFromChooser(Window window, String fileName) throws UCThreadException {
        int filepathIndex2;
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        FileChooser fc = new FileChooser();
        UCUploadFileChooser.setInitialSaveDir(fc);
        int filepathIndex1 = fileName.lastIndexOf("\\");
        if (filepathIndex1 != -1) {
            fileName = fileName.substring(filepathIndex1 + 1);
        }
        if ((filepathIndex2 = fileName.lastIndexOf("/")) != -1) {
            fileName = fileName.substring(filepathIndex2 + 1);
        }
        if (fileName.contains(".")) {
            int index = fileName.lastIndexOf(".");
            String name = fileName.substring(0, index);
            String ext = fileName.substring(index + 1);
            fc.setInitialFileName(name);
            fc.getExtensionFilters().clear();
            fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter(ext.toUpperCase(), new String[]{"*." + ext.toLowerCase()}));
        } else {
            fc.setInitialFileName(fileName);
            fc.getExtensionFilters().clear();
            fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        }
        File saveAsFile = fc.showSaveDialog(window);
        if (saveAsFile != null) {
            PreferencesUtil.setChatLastSaveDir(UCChatClient.context, saveAsFile.getParentFile().getAbsolutePath());
        }
        return saveAsFile;
    }

    public static String getDocumentIconURI(String fileName) {
        String ext = FileUtil.getFileExtension(fileName);
        if (fileIconMap.containsKey(ext)) {
            return fileIconMap.get(ext);
        }
        URL uri = UIConstants.getDocumentIconURI(fileName);
        if (uri != null) {
            String uriStr = uri.toString();
            fileIconMap.put(ext, uriStr);
            return uriStr;
        }
        uri = UIConstants.getDefaultDocURI();
        return uri.toString();
    }

    public static String getMessageStatusIcon(MessageStatus msgStatus) {
        if (msgStatus == null) {
            return "";
        }
        switch (msgStatus) {
            case NONE: {
                return MessageResource.messageStatusIconURI_none;
            }
            case UPLOADING: {
                return MessageResource.messageStatusIconURI_none;
            }
            case SENDING: {
                return MessageResource.messageStatusIconURI_sending;
            }
            case PROCESSED: {
                return MessageResource.messageStatusIconURI_none;
            }
            case NOT_PROCESSED: {
                return MessageResource.messageStatusIconURI_notProcessed;
            }
            case DELIVERED: {
                return MessageResource.messageStatusIconURI_none;
            }
            case DISPLAYED: {
                return MessageResource.messageStatusIconURI_none;
            }
            case DOWNLOADING: {
                return "";
            }
        }
        return "";
    }

    public static MessageStatus convertMsgStatus(String status) {
        MessageStatus msgStatus = MessageStatus.NONE;
        if (status.equals("UPLOAD_FAILED") || status.equals("REJECTED") || status.equals("E")) {
            msgStatus = MessageStatus.NOT_PROCESSED;
        } else if (status.equals("UPLOADING")) {
            msgStatus = MessageStatus.UPLOADING;
        } else if (status.equals("UPLOAD_SUCCEED") || status.equals("N")) {
            msgStatus = MessageStatus.SENDING;
        } else if (status.equals("PROCESSED") || status.equals("S")) {
            msgStatus = MessageStatus.PROCESSED;
        } else if (status.equals("D")) {
            msgStatus = MessageStatus.DELIVERED;
        } else if (status.equals("V")) {
            msgStatus = MessageStatus.DISPLAYED;
        }
        return msgStatus;
    }

    public static void cleanTextNodes(Element element) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList != null) {
            for (int i = nodeList.getLength() - 1; i >= 0; --i) {
                Node node = nodeList.item(i);
                element.removeChild(node);
            }
        }
    }
}

