/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.MyRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyVideoRenderer
extends MyRendererBase {
    public static void render(DomService domService, Node videoNode, Message msg, String myJid, String myName, boolean isMultiRoom, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String imageBase64Content = msg.getContent();
        long videoDuration = msg.getDuration();
        String packetId = msg.getPacketId();
        String status = msg.getStatus();
        String extraInfo = msg.getExtraMsgInfo();
        MessageStatus msgStatus = DomUtil.convertMsgStatus(status);
        Element videoElement = (Element)videoNode;
        MyVideoRenderer.fillMyCommonData(domService, videoElement, myJid, myName, msg, msgStatus, isMultiRoom);
        String fileInfoStorageId = "myMessageInfo_" + packetId;
        if (StringUtils.isNotBlank((CharSequence)extraInfo)) {
            Element elem_myImageWithMsgText = domService.getElementById("myExtraText");
            elem_myImageWithMsgText.setAttribute("id", "myExtraText_" + packetId);
            elem_myImageWithMsgText.setAttribute("packetId", packetId);
            elem_myImageWithMsgText.setAttribute("command", "selectAll");
            domService.addEventListener(elem_myImageWithMsgText, "dblclick");
            ChatTextWriter writer = new ChatTextWriter(domService, elem_myImageWithMsgText, packetId, searchKey, targetPacketId);
            MsgTextConverter.convertAndAppendText(extraInfo, writer);
        }
        Element elem_videoInfo = domService.getElementById("myMessageInfo");
        elem_videoInfo.setAttribute("id", fileInfoStorageId);
        elem_videoInfo.setAttribute("packetId", packetId);
        elem_videoInfo.setAttribute("messageId", String.valueOf(msg.getId()));
        Element elem_videoIcon = domService.getElementById("myMessageIcon");
        elem_videoIcon.setAttribute("id", "myMessageIcon_" + packetId);
        elem_videoIcon.setAttribute("packetId", packetId);
        if (TextUtils.isNotBlank((CharSequence)imageBase64Content)) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
            if (bi != null) {
                int imageWidth = bi.getWidth();
                int imageHeight = bi.getHeight();
                bi = GraphicUtil.convertVideoThumbnailImage(bi, 300, 50);
                imageWidth = bi.getWidth();
                imageHeight = bi.getHeight();
                elem_videoIcon.setAttribute("width", String.valueOf(imageWidth));
                elem_videoIcon.setAttribute("height", String.valueOf(imageHeight));
                elem_videoIcon.setAttribute("src", "data:image/png;base64," + GraphicUtil.convertImageToBase64String(bi));
            } else {
                elem_videoIcon.setAttribute("width", String.valueOf(120));
                elem_videoIcon.setAttribute("height", String.valueOf(90));
                elem_videoIcon.setAttribute("src", MessageResource.fileMissingIconURI);
            }
        } else {
            elem_videoIcon.setAttribute("width", String.valueOf(120));
            elem_videoIcon.setAttribute("height", String.valueOf(90));
            elem_videoIcon.setAttribute("src", MessageResource.fileMissingIconURI);
        }
        elem_videoIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        elem_videoIcon.setAttribute("isFromMe", "true");
        elem_videoIcon.setAttribute("command", "downloadVideo");
        elem_videoIcon.setAttribute("isFromMe", "true");
        domService.addEventListener(elem_videoIcon, "click");
        Element elem_videoDuration = domService.getElementById("myVideoDuration");
        elem_videoDuration.setAttribute("id", "myVideoDuration_" + packetId);
        elem_videoDuration.appendChild(domService.createTextNode(CommonUtil.getDurationMilliSeconds(videoDuration)));
        if (msgStatus == MessageStatus.UPLOADING) {
            MyVideoRenderer.appendFileUploadProgressBar(domService, packetId, fileInfoStorageId);
        }
    }
}

