/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.dom.OtherRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import javafx.application.Platform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class OtherPunchcardRenderer
extends OtherRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String otherJid, String otherName, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String packetId = msg.getPacketId();
        String address = msg.getContent();
        String title = msg.getTitle();
        Element textElement = (Element)textNode;
        OtherPunchcardRenderer.fillOtherCommonData(domService, textElement, otherJid, otherName, msg);
        if (TextUtils.isEmpty((CharSequence)address)) {
            address = I18NUtil.getString("chat_punchcard_no_address_hint");
        }
        Element elem_otherPunchCardAddrText = domService.getElementById("otherPunchCardAddress");
        elem_otherPunchCardAddrText.setAttribute("id", "otherPunchCardAddress_" + packetId);
        elem_otherPunchCardAddrText.setAttribute("packetId", packetId);
        elem_otherPunchCardAddrText.setAttribute("style", "cursor:pointer;");
        elem_otherPunchCardAddrText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_otherPunchCardAddrText, "click");
        ChatTextWriter writer1 = new ChatTextWriter(domService, elem_otherPunchCardAddrText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(address, writer1);
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = I18NUtil.getString("chat_msg_type_punch_card_title");
        }
        Element elem_otherPunchCardLabelText = domService.getElementById("otherPunchCardLabel");
        elem_otherPunchCardLabelText.setAttribute("id", "otherPunchCardLabel_" + packetId);
        elem_otherPunchCardLabelText.setAttribute("packetId", packetId);
        elem_otherPunchCardLabelText.setAttribute("style", "cursor:pointer;");
        elem_otherPunchCardLabelText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_otherPunchCardLabelText, "click");
        ChatTextWriter writer2 = new ChatTextWriter(domService, elem_otherPunchCardLabelText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(title, writer2);
        Element elem_otherPunchCardTimeText = domService.getElementById("otherPunchCardTime");
        elem_otherPunchCardTimeText.setAttribute("id", "otherPunchCardTime_" + packetId);
        elem_otherPunchCardTimeText.setAttribute("packetId", packetId);
        elem_otherPunchCardTimeText.setAttribute("style", "cursor:pointer;");
        elem_otherPunchCardTimeText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_otherPunchCardTimeText, "click");
        Text prefixText = domService.createTextNode(DateTimeUtil.getTimeStr(msg.getServerTime(), 2));
        elem_otherPunchCardTimeText.appendChild(prefixText);
    }
}

