/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.popup;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.popup.EmoticonPopupMenu;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class EmoticonButton
extends JButton {
    private String emoticonKey;
    private String mIconPath;
    private EmoticonPopupMenu.BtnClickListener mStickerClickListener;

    public EmoticonButton(String key, String iconPath, EmoticonPopupMenu.BtnClickListener stickerClickListener) {
        this.emoticonKey = key;
        this.mStickerClickListener = stickerClickListener;
        this.setFont(UIConstants.FONT_12_PLAIN);
        this.mIconPath = iconPath;
        ImageIcon emoticonIcon = GraphicUtil.getScaledIcon(this.mIconPath, 32, 32);
        emoticonIcon.setDescription(this.emoticonKey);
        this.setIcon(emoticonIcon);
        this.setPreferredSize(new Dimension(40, 40));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmoticonButton.this.mStickerClickListener.onEmoticonClick(EmoticonButton.this.emoticonKey, EmoticonButton.this.mIconPath);
            }
        });
    }
}

