/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.ChatRoomItem;
import com.blisscloud.ezuc.client.chat.ChatRoomMember;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.MessageDropperField;
import com.blisscloud.ezuc.client.chat.MessageInput;
import com.blisscloud.ezuc.client.chat.action.DialOutbound;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.chat.roomimpl.MsgPhoneFormatter;
import com.blisscloud.ezuc.client.component.ThinLineBorder;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.emoticons.EmoticonUtils;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.HistoryTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.LastMsg;
import com.blisscloud.ezuc.client.util.MessageContentUtil;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageHeader;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.task.MarkRemoteReadTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.FileSelectionCallback;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public abstract class BaseChatroom
extends JPanel
implements IChatroom,
MessageArea.MessageAreaCallback,
MessageDropperField {
    private static final int MSG_COUNT_FOR_JUMP = 15;
    private static final long serialVersionUID = 4805805704582911646L;
    private int LOAD_OLD_HISTORY_SIZE = 30;
    private int MSG_SIZE_LIMIT = 500;
    private static final int COUNT_TO_SHORT = 5;
    private static final int LAST_MSG_HEIGHT = 35;
    private static final int ICON_SIZE = 40;
    private static final int ICON_SHIFT_X = 18;
    private static final int ICON_SHIFT_Y = 8;
    protected ConcurrentHashMap<String, Long> lazyContentMap = new ConcurrentHashMap();
    protected MessageArea mMessageArea;
    protected String myJid;
    protected String myDisplayName;
    protected JPanel mPanrent = null;
    protected String mRoomJid = null;
    protected String mRoomDisplayName = null;
    protected MessageInput txtMessage;
    protected FileSelectionCallback fileSelectionCallback;
    protected Object msgLock = new String("msgLock");
    private long mTimestamp = System.currentTimeMillis();
    private boolean lastMsgShown;
    private long bottomNextDateTag = -1L;
    private String startPacketId;
    private String endPacketId;
    private long startMsgTimestamp = -1L;
    private long endMsgTimestamp = -1L;
    private long lastMsgTimestamp = -1L;
    private Message mLastMsg;
    protected FavoriteAction favoriteAction = new FavoriteAction(true);
    protected NotificationAction notificationAction = new NotificationAction(true);
    private JPanel mFloatingPanel;
    private JPanel mFloatingMsgPanel;
    private JTextPane mLastMsgPane;
    private JPanel mSearchControlPanel;
    private JLabel mSearchKeyLabel;
    private JLabel mSearchIndexLabel;
    private JLabel mSearchUpBtn;
    private JLabel mSearchDownBtn;
    protected boolean mForContentSearch;
    protected String mContentSearchKey;
    protected List<String> mSearchPacketIdList;
    protected int mSearchIndex = -1;
    protected String mLastPacketId;
    private boolean mInit = false;

    public BaseChatroom(String roomJid, JPanel parent) {
        this.mRoomJid = roomJid;
        this.mPanrent = parent;
        Message msg = ChatRoomManager.findLastMsg(UCChatClient.context, this.mRoomJid, -1L);
        if (msg != null) {
            this.lastMsgTimestamp = msg.getServerTime();
        }
        this.updateMyProfile();
        this.fileSelectionCallback = new FileSelectionCallback(){

            @Override
            public void onSendFile(File file, boolean original) {
                String extraInfo = null;
                if (BaseChatroom.this.txtMessage != null && TextUtils.isNotBlank((CharSequence)(extraInfo = BaseChatroom.this.txtMessage.getMessageTextWithIconKey()))) {
                    BaseChatroom.this.txtMessage.setText("");
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    database.deletePendingMessage(BaseChatroom.this.mRoomJid);
                }
                ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                chatReceiverList.add(new ChatReceiver(BaseChatroom.this.mRoomJid));
                ChatActionUtil.uploadFile(chatReceiverList, file, original, extraInfo, BaseChatroom.this);
            }

            @Override
            public String getRoomName() {
                return BaseChatroom.this.mRoomDisplayName;
            }
        };
    }

    protected void updateMyProfile() {
        Activity ctx = UCChatClient.context;
        this.myJid = PreferencesUtil.getUserJid(ctx);
        this.myDisplayName = ContactManager.getContactShortName((Context)ctx, ContactManager.getContact((Context)ctx, this.myJid));
    }

    @Override
    public String getChatroomID() {
        return this.mRoomJid;
    }

    protected String getDispTitle(List<ChatRoomItem> contacts) {
        StringBuffer b = new StringBuffer();
        String comma = I18NUtil.getString("comma");
        boolean first = true;
        for (int i = 0; contacts != null && i < contacts.size(); ++i) {
            if (i >= 5) {
                b.append(String.format(I18NUtil.getString("chat_label_many_participants"), "", contacts.size()));
                break;
            }
            ChatRoomItem m = contacts.get(i);
            if (!(m instanceof ChatRoomMember)) continue;
            if (!first) {
                b.append(comma);
            }
            ChatRoomMember crm = (ChatRoomMember)m;
            b.append(crm.getTitle());
            first = false;
        }
        return b.toString();
    }

    protected String getContactDispTitle(List<LiteContact> participants) {
        StringBuffer b = new StringBuffer();
        String comma = I18NUtil.getString("comma");
        boolean first = true;
        for (int i = 0; participants != null && i < participants.size(); ++i) {
            if (i >= 5) {
                b.append(String.format(I18NUtil.getString("chat_label_many_participants"), "", participants.size()));
                break;
            }
            LiteContact c = participants.get(i);
            if (!first) {
                b.append(comma);
            }
            b.append(ContactManager.getContactShortName((Context)UCChatClient.context, c));
            first = false;
        }
        return b.toString();
    }

    public List<HashMap<String, Object>> getChatHistory(String chatId, List<MessageHeader> chatMsgList, boolean isAfter) {
        ArrayList<HashMap<String, Object>> valueList = new ArrayList<HashMap<String, Object>>();
        if (chatMsgList == null || chatMsgList.size() == 0) {
            return valueList;
        }
        Log.d(BaseChatroom.class.getSimpleName(), "chatMsgList count: " + chatMsgList.size());
        Activity ctx = UCChatClient.context;
        LiteConferenceRoom meetingRoom = MeetmeManager.getMeetme((Context)ctx, chatId);
        HashMap<String, LiteContact> contactCache = new HashMap<String, LiteContact>();
        for (int i = 0; i < chatMsgList.size(); ++i) {
            Message msg;
            MessageHeader msgHeader = chatMsgList.get(i);
            if (msgHeader.getIsLazy() == 1) {
                this.lazyContentMap.put(msgHeader.getPacketId(), msgHeader.getId());
            }
            if ((msg = ChatRoomManager.getMsg(ctx, msgHeader.getId())).getProps() != null && msg.getProps().contains("refPacketId")) {
                try {
                    String refPacketId;
                    Message refMsg;
                    JSONObject propObj = new JSONObject(msg.getProps());
                    if (propObj.has("refPacketId") && (refMsg = UCDBMessage.findMsgByPacketId(UCChatClient.context, refPacketId = propObj.getString("refPacketId"))) != null && !refMsg.isRecalled() && refMsg.isLazyContent()) {
                        this.lazyContentMap.put(refMsg.getPacketId(), refMsg.getId());
                        ChatRoomManager.checkLazy(ctx, refMsg);
                    }
                }
                catch (Exception e) {
                    Log.e(DialOutbound.class.getSimpleName(), e.getMessage(), e);
                }
            }
            String status = msg.getStatus();
            String fromJid = msg.getFromJid();
            String toJid = msg.getToJid();
            Object content = msg.getContent();
            long msgId = msg.getId();
            String packetId = msg.getPacketId();
            long serverTime = msg.getServerTime();
            boolean isRead = msg.isRead();
            boolean isPlayed = msg.isPlayed();
            int readCount = msg.getReadCount();
            String readerList = msg.getReaderList();
            String title = msg.getTitle();
            HashMap<String, Message> map = new HashMap<String, Message>();
            int msgType = msg.getMsgType();
            if (MsgUtil.isSystemMsg(msgType)) {
                content = MessageContentUtil.convertMessage(ctx, msg, contactCache, meetingRoom != null);
                content = "  " + (String)content + "  ";
            } else if (msgType == 225) {
                content = MsgPhoneFormatter.convertInboundMissCallContent(ctx, msg.getContent());
            } else if (msgType == 223) {
                content = MsgPhoneFormatter.convertInboundTalkingContent(ctx, msg.getContent());
            } else if (msgType == 221) {
                content = MsgPhoneFormatter.convertOutboundTalkingContent(ctx, msg.getContent());
            } else if (msgType == 222) {
                content = MsgPhoneFormatter.convertOutboundMissCallContent(ctx, msg.getContent());
            }
            String dispName = MsgUtil.getFromName(ctx, fromJid, contactCache);
            Message dispMessage = new Message();
            dispMessage.setStatus(status);
            dispMessage.setFromJid(fromJid);
            dispMessage.setToJid(toJid);
            dispMessage.setContent((String)content);
            dispMessage.setContentType(msg.getContentType());
            dispMessage.setId(msgId);
            dispMessage.setPacketId(packetId);
            dispMessage.setFromName(dispName);
            dispMessage.setServerTime(serverTime);
            dispMessage.setFileName(msg.getFileName());
            dispMessage.setFileDownloadURL(msg.getFileDownloadURL());
            dispMessage.setMsgType(msg.getMsgType());
            dispMessage.setRead(isRead);
            dispMessage.setPlayed(isPlayed);
            dispMessage.setDuration(msg.getDuration());
            dispMessage.setNoticeContent(msg.getNoticeContent());
            dispMessage.setNoticeThumbnail(msg.getNoticeThumbnail());
            dispMessage.setChatEventId(msg.getChatEventId());
            dispMessage.setSyncEventId(msg.getSyncEventId());
            dispMessage.setReadCount(readCount);
            dispMessage.setReaderList(readerList);
            dispMessage.setFileSize(msg.getFileSize());
            dispMessage.setMimeType(msg.getMimeType());
            dispMessage.setExtraMsgInfo(msg.getExtraMsgInfo());
            dispMessage.setFileLocalPath(msg.getFileLocalPath());
            dispMessage.setProps(msg.getProps());
            dispMessage.setTitle(title);
            map.put("txtContent", dispMessage);
            valueList.add(0, map);
        }
        return this.handleTime(valueList, isAfter);
    }

    private List<HashMap<String, Object>> handleTime(List<HashMap<String, Object>> valueNoTimeList, boolean isAfter) {
        long currentNextDateTag = -1L;
        ArrayList<HashMap<String, Object>> finalTimeList = new ArrayList<HashMap<String, Object>>();
        for (int i = 0; valueNoTimeList != null && i < valueNoTimeList.size(); ++i) {
            HashMap<String, Object> itemMap = valueNoTimeList.get(i);
            Message msg = (Message)itemMap.get("txtContent");
            long msgTime = msg.getServerTime();
            if (isAfter ? msgTime >= this.bottomNextDateTag : msgTime >= currentNextDateTag) {
                HashMap<String, Object> newTimeMap = new HashMap<String, Object>();
                Message timeMsg = new Message();
                timeMsg.setStatus("R");
                timeMsg.setMsgType(200);
                timeMsg.setFromJid(PreferencesUtil.getUserJid(UCChatClient.context));
                timeMsg.setToJid(PreferencesUtil.getUserJid(UCChatClient.context));
                timeMsg.setContent(DateTimeUtil.getTimeStr(msgTime));
                timeMsg.setId(-1L);
                timeMsg.setPacketId("");
                timeMsg.setFromName("");
                newTimeMap.put("txtContent", timeMsg);
                newTimeMap.put("timeKey", DateTimeUtil.getTimeKey(msgTime));
                finalTimeList.add(newTimeMap);
                Calendar cal = Calendar.getInstance();
                cal.setTimeInMillis(msgTime);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(5, 1);
                currentNextDateTag = cal.getTimeInMillis();
                if (this.bottomNextDateTag < cal.getTimeInMillis()) {
                    this.bottomNextDateTag = cal.getTimeInMillis();
                }
            }
            finalTimeList.add(itemMap);
        }
        return finalTimeList;
    }

    protected void addSystemMessage(HashMap<String, Object> msgValue, boolean appendToBottom, boolean scrollToBottom) {
        this.mMessageArea.addSystemMessage(msgValue, appendToBottom, scrollToBottom);
    }

    public abstract void onReferenceSelected(String var1);

    public abstract void onReferenceRemoved(String var1);

    @Override
    public void checkAllDate() {
        this.mMessageArea.checkAllDate();
    }

    @Override
    public void checkAllPhoneData() {
        this.mMessageArea.checkAllPhoneData();
    }

    private void handleSearchControlMsgDelete(String packetId) {
        int pos;
        if (this.mSearchPacketIdList != null && (pos = this.mSearchPacketIdList.indexOf(packetId)) != -1) {
            this.mSearchPacketIdList.remove(packetId);
            if (this.mSearchPacketIdList.size() == 0) {
                this.onCloseSearchPanelNoLoad();
            } else {
                if (this.mSearchIndex >= pos && this.mSearchIndex != 0) {
                    --this.mSearchIndex;
                }
                this.handleSearchUpDown(false);
            }
        }
    }

    @Override
    public void recallMessage(String packetId) {
        this.onReferenceRemoved(packetId);
        this.mMessageArea.recallMessage(packetId);
        if (this.mLastMsg != null && this.mLastMsg.getPacketId().equals(packetId)) {
            this.fetchLastNewIncomingMsg();
        }
        this.handleSearchControlMsgDelete(packetId);
    }

    @Override
    public void deleteMessage(String packetId) {
        this.onReferenceRemoved(packetId);
        this.mMessageArea.deleteMessage(packetId);
        this.handleSearchControlMsgDelete(packetId);
    }

    @Override
    public void readedByMessage(String packetId) {
        this.mMessageArea.readedByMessage(packetId);
    }

    @Override
    public void playMessage(String packetId) {
        this.mMessageArea.playMessage(packetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateFileUploadProgress(Intent intent) {
        Object object = this.msgLock;
        synchronized (object) {
            String packetId = intent.getStringExtra("chatPacketId");
            int percent = intent.getIntExtra("percent", 0);
            this.mMessageArea.updateFileUploadProgress(packetId, percent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageContent(Intent intent) {
        Object object = this.msgLock;
        synchronized (object) {
            boolean oldIsAtBottom = this.mMessageArea.isScrollBarAtBottom();
            String packetId = intent.getStringExtra("chatPacketId");
            this.lazyContentMap.remove(packetId);
            this.mMessageArea.updateMessageContent(packetId);
            if (oldIsAtBottom && this.lastMsgShown) {
                this.mMessageArea.scrollToBottom(100);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMessageStatus(Intent intent) {
        Object object = this.msgLock;
        synchronized (object) {
            String packetId = intent.getStringExtra("chatPacketId");
            String msgStatus = intent.getStringExtra("chatMsgStatus");
            if (msgStatus != null) {
                if (msgStatus.equals("UPLOAD_SUCCEED")) {
                    this.mMessageArea.updateFileUploadSucceed(packetId);
                } else if (msgStatus.equals("UPLOAD_FAILED")) {
                    String fileName = intent.getStringExtra("chatFileName");
                    String errorMsg = intent.getStringExtra("errorMsg");
                    this.mMessageArea.updateFileUploadFailed(packetId, fileName);
                } else if (msgStatus.equals("E")) {
                    this.mMessageArea.updateMyMessage(packetId);
                } else if (msgStatus.equals("PROCESSED")) {
                    this.mMessageArea.updateMyMessage(packetId);
                } else if (msgStatus.equals("D")) {
                    this.mMessageArea.updateMyMessage(packetId);
                } else if (msgStatus.equals("V")) {
                    this.mMessageArea.updateMyMessage(packetId);
                } else if (msgStatus.equals("REJECTED")) {
                    this.mMessageArea.updateMyMessage(packetId);
                }
            }
        }
    }

    protected void loadLast() {
        Thread t = new Thread("ChatroomLoadNewMessage"){

            @Override
            public void run() {
                BaseChatroom.this.loadMessageLastFew(BaseChatroom.this.LOAD_OLD_HISTORY_SIZE);
            }
        };
        t.start();
    }

    protected JPanel getSearchControlPanel() {
        this.mSearchControlPanel = new JPanel();
        this.mSearchControlPanel.setLayout(new GridBagLayout());
        this.mSearchControlPanel.setVisible(false);
        this.mSearchControlPanel.setOpaque(false);
        JPanel searchContentPanel = new JPanel();
        this.mSearchControlPanel.add((Component)searchContentPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        FlowLayout panelLayout = new FlowLayout();
        panelLayout.setHgap(2);
        panelLayout.setVgap(0);
        searchContentPanel.setLayout(panelLayout);
        searchContentPanel.setOpaque(false);
        EmptyBorder paddingBorder = new EmptyBorder(1, 1, 1, 1);
        CompoundBorder compoundBorder = new CompoundBorder(new ThinLineBorder(Color.LIGHT_GRAY, 0.5f, 15), paddingBorder);
        searchContentPanel.setBorder(compoundBorder);
        this.mSearchKeyLabel = new JLabel();
        EmptyBorder paddingBorder2 = new EmptyBorder(0, 0, 0, 20);
        this.mSearchKeyLabel.setBorder(paddingBorder2);
        searchContentPanel.add(this.mSearchKeyLabel);
        this.mSearchIndexLabel = new JLabel();
        EmptyBorder paddingBorder3 = new EmptyBorder(0, 0, 0, 2);
        this.mSearchIndexLabel.setBorder(paddingBorder3);
        searchContentPanel.add(this.mSearchIndexLabel);
        this.mSearchUpBtn = new JLabel(UIConstants.ICON_ARROW_UP_2);
        this.mSearchUpBtn.setEnabled(false);
        searchContentPanel.add(this.mSearchUpBtn);
        this.mSearchUpBtn.setCursor(UIConstants.CURSOR_HAND);
        this.mSearchUpBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (!BaseChatroom.this.mSearchUpBtn.isEnabled()) {
                    return;
                }
                if (evt.getButton() == 1) {
                    BaseChatroom.this.handleNextSearch(false, 1);
                }
            }
        });
        this.mSearchDownBtn = new JLabel(UIConstants.ICON_ARROW_DOWN_2);
        this.mSearchDownBtn.setEnabled(false);
        searchContentPanel.add(this.mSearchDownBtn);
        this.mSearchDownBtn.setCursor(UIConstants.CURSOR_HAND);
        this.mSearchDownBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (!BaseChatroom.this.mSearchDownBtn.isEnabled()) {
                    return;
                }
                if (evt.getButton() == 1) {
                    BaseChatroom.this.handleNextSearch(false, 2);
                }
            }
        });
        final JLabel lblClose = new JLabel();
        lblClose.setCursor(UIConstants.CURSOR_HAND);
        lblClose.setIcon(UIConstants.icon_clear);
        lblClose.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        lblClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    BaseChatroom.this.onCloseSearchPanel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                lblClose.setIcon(UIConstants.icon_clearclick);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblClose.setIcon(UIConstants.icon_clear);
            }
        });
        this.mSearchControlPanel.add((Component)lblClose, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        return this.mSearchControlPanel;
    }

    private void onCloseSearchPanel() {
        this.mSearchControlPanel.setVisible(false);
        this.mSearchKeyLabel.setText("");
        this.mSearchIndexLabel.setText("");
        final String oldSearchPacketId = this.mLastPacketId;
        this.cleanUpSearch();
        Thread t = new Thread("ChatroomJumpToPacketId2"){

            @Override
            public void run() {
                BaseChatroom.this.loadMessagePacketId(oldSearchPacketId, 100);
            }
        };
        t.start();
    }

    private void onCloseSearchPanelNoLoad() {
        this.mSearchControlPanel.setVisible(false);
        this.mSearchKeyLabel.setText("");
        this.mSearchIndexLabel.setText("");
        this.cleanUpSearch();
    }

    private void handleNextSearch(boolean roomInit, int option) {
        if (option == 0) {
            this.mSearchIndex = this.mSearchPacketIdList.size() - 1;
        } else if (option == 1) {
            --this.mSearchIndex;
        } else if (option == 2) {
            ++this.mSearchIndex;
        } else {
            return;
        }
        if (this.mSearchIndex < 0) {
            this.mSearchIndex = this.mSearchPacketIdList.size() - 0;
        }
        if (this.mSearchIndex >= this.mSearchPacketIdList.size()) {
            this.mSearchIndex = this.mSearchPacketIdList.size() - 1;
        }
        this.handleSearchUpDown(roomInit);
    }

    private void handleSearchUpDown(final boolean roomInit) {
        this.mSearchControlPanel.setVisible(true);
        this.mSearchKeyLabel.setText(StringUtils.abbreviate((String)this.mContentSearchKey, (int)20));
        this.mSearchIndexLabel.setText(this.mSearchIndex + 1 + "/" + this.mSearchPacketIdList.size());
        if (this.mSearchIndex == 0) {
            this.mSearchUpBtn.setEnabled(false);
        } else {
            this.mSearchUpBtn.setEnabled(true);
        }
        if (this.mSearchIndex >= this.mSearchPacketIdList.size() - 1) {
            this.mSearchDownBtn.setEnabled(false);
        } else {
            this.mSearchDownBtn.setEnabled(true);
        }
        this.mLastPacketId = this.mSearchPacketIdList.get(this.mSearchIndex);
        Thread t = new Thread("ChatroomJumpToPacketId1"){

            @Override
            public void run() {
                BaseChatroom.this.loadMessagePacketId(BaseChatroom.this.mLastPacketId, roomInit ? 500 : 100);
            }
        };
        t.start();
    }

    protected JLayeredPane getMessageLayerPanel() {
        this.mFloatingPanel = new JPanel();
        this.mFloatingPanel.setLayout(new BorderLayout());
        this.mFloatingPanel.setBounds(0, 0, 40, 40);
        this.mFloatingPanel.setOpaque(false);
        this.mFloatingPanel.setVisible(false);
        JLabel arrowLabel = new JLabel(UIConstants.ICON_ARROW_DOWN_CIRCLE_BG);
        this.mFloatingPanel.add((Component)arrowLabel, "Center");
        arrowLabel.setCursor(UIConstants.CURSOR_HAND);
        arrowLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    BaseChatroom.this.loadLast();
                }
            }
        });
        this.mFloatingMsgPanel = new JPanel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics2D g2d = (Graphics2D)g.create();
                g2d.setComposite(AlphaComposite.getInstance(3, 0.75f));
                g2d.setColor(this.getBackground());
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.dispose();
            }
        };
        this.mFloatingMsgPanel.setLayout(new BorderLayout());
        this.mFloatingMsgPanel.setBounds(0, 0, 0, 0);
        this.mFloatingMsgPanel.setOpaque(false);
        this.mFloatingMsgPanel.setBackground(new Color(230, 230, 230));
        this.mFloatingMsgPanel.setVisible(false);
        this.mFloatingMsgPanel.setCursor(UIConstants.CURSOR_HAND);
        this.mFloatingMsgPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    BaseChatroom.this.loadLast();
                }
            }
        });
        this.mLastMsgPane = new JTextPane();
        this.mLastMsgPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.mLastMsgPane.setFont(UIConstants.FONT_14_PLAIN);
        this.mLastMsgPane.setForeground(Color.BLACK);
        this.mLastMsgPane.setOpaque(false);
        this.mLastMsgPane.setEnabled(true);
        this.mLastMsgPane.setEditable(false);
        this.mLastMsgPane.setCaret(new MyCaret());
        this.mLastMsgPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    BaseChatroom.this.loadLast();
                }
            }
        });
        this.mFloatingMsgPanel.add((Component)this.mLastMsgPane, "Center");
        final JLayeredPane layeredPane = new JLayeredPane();
        layeredPane.add((Component)((Object)this.mMessageArea), JLayeredPane.DEFAULT_LAYER);
        layeredPane.add((Component)this.mFloatingPanel, JLayeredPane.PALETTE_LAYER);
        layeredPane.add((Component)this.mFloatingMsgPanel, JLayeredPane.PALETTE_LAYER);
        layeredPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension size = layeredPane.getSize();
                BaseChatroom.this.mMessageArea.setBounds(0, 0, size.width, size.height);
                BaseChatroom.this.mFloatingPanel.setBounds(size.width - 40 - 18, size.height - 40 - 8, 40, 40);
                BaseChatroom.this.mFloatingMsgPanel.setBounds(0, size.height - 35, size.width, 35);
            }
        });
        return layeredPane;
    }

    protected void addMyMessage(Message msg, boolean appendToBottom, boolean scrollToBottom) {
        if (this.mMessageArea == null) {
            return;
        }
        int msgType = msg.getMsgType();
        Message.ContentType contentType = msg.getContentType();
        switch (contentType) {
            case TEXT: {
                if (msgType == 1 || msgType == 6) {
                    this.mMessageArea.addMyAudio(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom);
                    break;
                }
                if (msgType == 13 || msgType == 1006) {
                    this.mMessageArea.addMyPersonalRecord(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom);
                    break;
                }
                if (msgType == 0 || msgType == 221 || msgType == 222) {
                    this.mMessageArea.addMyMessage(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType == 8) {
                    this.mMessageArea.addMyLocation(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType != 9) break;
                this.mMessageArea.addMyPunchCard(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                break;
            }
            case FILE: {
                if (msgType == 5) {
                    this.mMessageArea.addMyImage(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType == 4) {
                    this.mMessageArea.addMyVideo(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType == 11) {
                    this.mMessageArea.addMyDocument(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType != 2) break;
                String fileExt = msg.getFileExtension();
                if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                    this.mMessageArea.addMyImage(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                    this.mMessageArea.addMyVideo(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (!UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) && !UCUploadFileChooser.AUDIO_TYPES.contains(fileExt)) break;
                this.mMessageArea.addMyDocument(this.myJid, this.myDisplayName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
            }
        }
    }

    protected void addOtherPartyMessage(Message msg, String otherJid, String otherDispName, boolean appendToBottom, boolean scrollToBottom) {
        if (this.mMessageArea == null) {
            return;
        }
        int msgType = msg.getMsgType();
        Message.ContentType contentType = msg.getContentType();
        switch (contentType) {
            case TEXT: {
                if (msgType == 1 || msgType == 6) {
                    this.mMessageArea.addOtherAudio(otherJid, otherDispName, msg, appendToBottom, scrollToBottom);
                    break;
                }
                if (msgType == 12 || msgType == 1005) {
                    this.mMessageArea.addOtherVoiceMail(otherJid, otherDispName, msg, appendToBottom, scrollToBottom);
                    break;
                }
                if (msgType == 13 || msgType == 1006) {
                    this.mMessageArea.addOtherPersonalRecord(otherJid, otherDispName, msg, appendToBottom, scrollToBottom);
                    break;
                }
                if (msgType == 0 || msgType == 223 || msgType == 225) {
                    this.mMessageArea.addOtherMessage(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType == 8) {
                    this.mMessageArea.addOtherLocation(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType != 9) break;
                this.mMessageArea.addOtherPunchCard(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                break;
            }
            case FILE: {
                if (msgType == 5) {
                    this.mMessageArea.addOtherImage(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType == 4) {
                    this.mMessageArea.addOtherVideo(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType == 11) {
                    this.mMessageArea.addOtherDocument(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (msgType != 2) break;
                String fileExt = msg.getFileExtension();
                if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                    this.mMessageArea.addOtherImage(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                    this.mMessageArea.addOtherVideo(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
                    break;
                }
                if (!UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) && !UCUploadFileChooser.AUDIO_TYPES.contains(fileExt)) break;
                this.mMessageArea.addOtherDocument(otherJid, otherDispName, msg, appendToBottom, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
            }
        }
    }

    protected void addRoomReceivedMessage(Message msg, boolean appendToBottom, boolean scrollToBottom, HashMap<String, LiteContact> contactCache) {
        Message.ContentType contentType = msg.getContentType();
        switch (contentType) {
            case TEXT: {
                String text = msg.getContent();
                String participantJID = msg.getFromJid();
                if (participantJID == null || participantJID.equals("")) break;
                if (participantJID.equals(this.myJid)) {
                    this.addMyMessage(msg, appendToBottom, scrollToBottom);
                    break;
                }
                String participantDisplayName = MsgUtil.getFromName(UCChatClient.context, participantJID, contactCache);
                this.addOtherPartyMessage(msg, participantJID, participantDisplayName, appendToBottom, scrollToBottom);
                break;
            }
            case FILE: {
                String participantJID = msg.getFromJid();
                if (participantJID.equals(this.myJid)) {
                    this.addMyMessage(msg, appendToBottom, scrollToBottom);
                    break;
                }
                String participantDisplayName = MsgUtil.getFromName(UCChatClient.context, participantJID, contactCache);
                this.addOtherPartyMessage(msg, participantJID, participantDisplayName, appendToBottom, scrollToBottom);
                break;
            }
        }
    }

    @Override
    public abstract ChatroomType getChatroomType();

    @Override
    public String getViewId() {
        return this.mRoomJid;
    }

    @Override
    public void onShow(Intent intent) {
        Log.d(BaseChatroom.class.getSimpleName(), "chatroom onShow: " + this.mRoomJid);
        final String oldSearchPacketId = this.mLastPacketId;
        boolean forContentSearch = false;
        if (intent != null) {
            forContentSearch = intent.getBooleanExtra("forContentSearch", false);
        }
        boolean roomInit = intent.getBooleanExtra("ROOM_INIT", false);
        String contentSearchKey = intent.getStringExtra("contentSearchKey");
        this.handleSearchKey(forContentSearch, contentSearchKey);
        for (String packetId : this.lazyContentMap.keySet()) {
            Long msgId = this.lazyContentMap.get(packetId);
            ChatRoomManager.getMsg(UCChatClient.context, msgId);
        }
        if (this.txtMessage != null) {
            this.txtMessage.requestFocus();
        }
        if (this.mForContentSearch) {
            this.handleNextSearch(roomInit, 0);
        } else {
            this.mSearchControlPanel.setVisible(false);
            this.mSearchKeyLabel.setText("");
            this.mSearchIndexLabel.setText("");
            if (StringUtils.isNotBlank((CharSequence)oldSearchPacketId)) {
                t = new Thread("ChatroomJumpToPacketId2"){

                    @Override
                    public void run() {
                        BaseChatroom.this.loadMessagePacketId(oldSearchPacketId, 100);
                    }
                };
                t.start();
            } else if (!this.mInit) {
                this.mInit = true;
                t = new Thread("ChatroomLoadMessageInit"){

                    @Override
                    public void run() {
                        BaseChatroom.this.loadMessageInit(BaseChatroom.this.LOAD_OLD_HISTORY_SIZE);
                    }
                };
                t.start();
            } else {
                this.loadNewMessage(false);
            }
        }
        this.onPhoneStatusChanged();
    }

    protected void handleSearchKey(boolean contentSearchEnabled, String contentSearchKey) {
        if (!contentSearchEnabled) {
            this.cleanUpSearch();
            return;
        }
        if (StringUtils.isBlank((CharSequence)contentSearchKey)) {
            this.cleanUpSearch();
            return;
        }
        List<String> searchPacketIdList = UCDBMessage.findContent(UCChatClient.context, this.mRoomJid, contentSearchKey);
        if (searchPacketIdList == null || searchPacketIdList.size() == 0) {
            this.cleanUpSearch();
            return;
        }
        this.mForContentSearch = true;
        this.mContentSearchKey = contentSearchKey;
        this.mSearchPacketIdList = searchPacketIdList;
    }

    private void cleanUpSearch() {
        this.mForContentSearch = false;
        this.mContentSearchKey = null;
        this.mSearchPacketIdList = null;
        this.mSearchIndex = -1;
        this.mLastPacketId = null;
    }

    @Override
    public void onHide() {
        if (this.mMessageArea != null) {
            this.mMessageArea.onHide();
        }
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    protected void updateMessageIdRange(Message msg) {
        long msgId = msg.getId();
        if (msgId == -1L) {
            return;
        }
        long msgTimestamp = msg.getServerTime();
        String msgPacketId = msg.getPacketId();
        if (this.startMsgTimestamp == -1L) {
            this.startMsgTimestamp = msgTimestamp;
            this.startPacketId = msgPacketId;
        } else if (msgTimestamp < this.startMsgTimestamp) {
            this.startMsgTimestamp = msgTimestamp;
            this.startPacketId = msgPacketId;
        }
        if (this.endMsgTimestamp == -1L) {
            this.endMsgTimestamp = msgTimestamp;
            this.endPacketId = msgPacketId;
        } else if (msgTimestamp > this.endMsgTimestamp) {
            this.endMsgTimestamp = msgTimestamp;
            this.endPacketId = msgPacketId;
        }
        if (this.lastMsgTimestamp == -1L) {
            this.lastMsgTimestamp = msgTimestamp;
        } else if (msgTimestamp > this.lastMsgTimestamp) {
            this.lastMsgTimestamp = msgTimestamp;
        }
    }

    private void cleanUpTimestamp() {
        this.lastMsgShown = false;
        this.bottomNextDateTag = -1L;
        this.startMsgTimestamp = -1L;
        this.startPacketId = null;
        this.endMsgTimestamp = -1L;
        this.endPacketId = null;
    }

    @Override
    public void loadNewMessage(boolean selfSendOut) {
        Log.d(BaseChatroom.class.getSimpleName(), "loadNewMessage...selfSendOut:" + selfSendOut + ", lastMsgShown:" + this.lastMsgShown);
        if (selfSendOut) {
            Thread t = new Thread("ChatroomLoadNewMessage1"){

                @Override
                public void run() {
                    BaseChatroom.this.loadMessageLastFew(BaseChatroom.this.LOAD_OLD_HISTORY_SIZE);
                    BaseChatroom.this.checkFloatingPanelDisp();
                }
            };
            t.start();
        } else if (this.lastMsgShown && this.mMessageArea.isScrollBarAtBottom()) {
            Thread t = new Thread("ChatroomLoadNewMessage2"){

                @Override
                public void run() {
                    BaseChatroom.this.loadMessageAfter(null, true);
                    BaseChatroom.this.checkFloatingPanelDisp();
                }
            };
            t.start();
        } else {
            this.fetchLastNewIncomingMsg();
        }
    }

    private void fetchLastNewIncomingMsg() {
        Thread t = new Thread("ChatroomLoadNewMessage3"){

            @Override
            public void run() {
                BaseChatroom.this.mLastMsg = ChatRoomManager.findLastMsg(UCChatClient.context, BaseChatroom.this.mRoomJid, BaseChatroom.this.lastMsgTimestamp);
                BaseChatroom.this.checkFloatingPanelDisp();
            }
        };
        t.start();
    }

    private void remarkAllUnreadMsg() {
        Activity ctx = UCChatClient.context;
        MarkRemoteReadTask t = new MarkRemoteReadTask(ctx, this.mRoomJid);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMessageInit(int size) {
        Log.d(BaseChatroom.class.getSimpleName(), "loadMessage size:" + size);
        Object object = this.msgLock;
        synchronized (object) {
            this.remarkAllUnreadMsg();
            List<MessageHeader> chatMsgList = ChatRoomManager.getChatMsgsInit(UCChatClient.context, this.mRoomJid, size);
            List<HashMap<String, Object>> chatHistory = this.getChatHistory(this.mRoomJid, chatMsgList, false);
            if (chatHistory.size() > 0) {
                this.appendMessage(chatHistory, true);
            }
            this.lastMsgShown = true;
            this.mLastMsg = null;
            this.mMessageArea.scrollToBottom(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMessageLastFew(int size) {
        Log.d(BaseChatroom.class.getSimpleName(), "loadMessageLastFew size:" + size);
        Object object = this.msgLock;
        synchronized (object) {
            this.remarkAllUnreadMsg();
            this.cleanUpTimestamp();
            this.mMessageArea.resetDataForJump();
            List<MessageHeader> chatMsgList = ChatRoomManager.getChatMsgsInit(UCChatClient.context, this.mRoomJid, size);
            List<HashMap<String, Object>> chatHistory = this.getChatHistory(this.mRoomJid, chatMsgList, false);
            if (chatHistory.size() > 0) {
                this.appendMessage(chatHistory, false);
            }
            this.lastMsgShown = true;
            this.mLastMsg = null;
            this.mMessageArea.scrollToBottom(100);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMessageAfter(Integer limit, boolean scrollToBottom) {
        Log.i(BaseChatroom.class.getSimpleName(), "loadMessageAfter size:" + limit + ", scrollToBottom:" + scrollToBottom);
        Object object = this.msgLock;
        synchronized (object) {
            this.remarkAllUnreadMsg();
            if (this.mMessageArea.getMessageSize() > this.MSG_SIZE_LIMIT) {
                List<MessageHeader> prevChatMsgList;
                List<HashMap<String, Object>> prevChatHistoryList;
                Log.i(BaseChatroom.class.getSimpleName(), "loadMessageAfter mMessageArea.getMessageSize():" + this.mMessageArea.getMessageSize());
                String oldEndPacketId = this.endPacketId;
                this.cleanUpTimestamp();
                this.mMessageArea.resetDataForJump();
                MessageHeader target = UCDBMessage.findMsgHeaderByPacketId(UCChatClient.context, oldEndPacketId);
                ArrayList<MessageHeader> chatMsgList = new ArrayList<MessageHeader>();
                chatMsgList.add(target);
                List<HashMap<String, Object>> chatHistory1 = this.getChatHistory(this.mRoomJid, chatMsgList, true);
                if (chatHistory1.size() > 0) {
                    this.appendMessage(chatHistory1, false);
                }
                if ((prevChatHistoryList = this.getChatHistory(this.mRoomJid, prevChatMsgList = ChatRoomManager.getChatMsgsBefore(UCChatClient.context, this.mRoomJid, this.startMsgTimestamp, 15), false)).size() > 0) {
                    this.appendOldMessage(prevChatHistoryList, false);
                }
                this.mMessageArea.scrollToBottom(100);
            } else {
                List<MessageHeader> chatMsgList = ChatRoomManager.getChatMsgsAfter(UCChatClient.context, this.mRoomJid, this.endMsgTimestamp, limit);
                Log.i(BaseChatroom.class.getSimpleName(), "chatMsgList size:" + chatMsgList.size());
                List<HashMap<String, Object>> chatHistory = this.getChatHistory(this.mRoomJid, chatMsgList, true);
                if (chatHistory.size() > 0) {
                    this.appendMessage(chatHistory, scrollToBottom);
                }
                if (limit == null || chatMsgList.size() != limit.intValue()) {
                    this.lastMsgShown = true;
                    this.mLastMsg = null;
                } else {
                    this.lastMsgShown = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMessageBefore(int size) {
        Log.i(BaseChatroom.class.getSimpleName(), "loadMessageBefore size:" + size);
        Object object = this.msgLock;
        synchronized (object) {
            if (this.mMessageArea.getMessageSize() > this.MSG_SIZE_LIMIT) {
                List<MessageHeader> prevChatMsgList;
                List<HashMap<String, Object>> prevChatHistoryList;
                List<MessageHeader> suffixChatMsgList;
                List<HashMap<String, Object>> suffixChatHistoryList;
                Log.i(BaseChatroom.class.getSimpleName(), "loadMessageBefore mMessageArea.getMessageSize():" + this.mMessageArea.getMessageSize());
                String oldStartPacketId = this.startPacketId;
                String targetPacketId = this.startPacketId;
                this.cleanUpTimestamp();
                this.mMessageArea.resetDataForJump();
                MessageHeader target = UCDBMessage.findMsgHeaderByPacketId(UCChatClient.context, oldStartPacketId);
                ArrayList<MessageHeader> chatMsgList = new ArrayList<MessageHeader>();
                chatMsgList.add(target);
                List<HashMap<String, Object>> chatHistory1 = this.getChatHistory(this.mRoomJid, chatMsgList, true);
                if (chatHistory1.size() > 0) {
                    this.appendMessage(chatHistory1, false);
                }
                if ((suffixChatHistoryList = this.getChatHistory(this.mRoomJid, suffixChatMsgList = ChatRoomManager.getChatMsgsAfter(UCChatClient.context, this.mRoomJid, this.endMsgTimestamp, 15), true)).size() > 0) {
                    this.appendMessage(suffixChatHistoryList, false);
                }
                if ((prevChatHistoryList = this.getChatHistory(this.mRoomJid, prevChatMsgList = ChatRoomManager.getChatMsgsBefore(UCChatClient.context, this.mRoomJid, this.startMsgTimestamp, size), false)).size() > 0) {
                    this.appendOldMessage(prevChatHistoryList, false);
                }
                this.mMessageArea.doScrollToPacketIdWithShift(targetPacketId, -50, 100);
            } else {
                String targetPacketId = this.startPacketId;
                List<MessageHeader> chatMsgList = ChatRoomManager.getChatMsgsBefore(UCChatClient.context, this.mRoomJid, this.startMsgTimestamp, size);
                List<HashMap<String, Object>> chatHistory = this.getChatHistory(this.mRoomJid, chatMsgList, false);
                if (chatHistory.size() > 0) {
                    this.appendOldMessage(chatHistory, false);
                }
                this.mMessageArea.doScrollToPacketIdWithShift(targetPacketId, -50, 100);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadMessagePacketId(String packetId, int interval) {
        Object object = this.msgLock;
        synchronized (object) {
            List<MessageHeader> suffixChatMsgList2;
            List<MessageHeader> prevChatMsgList;
            List<HashMap<String, Object>> chatHistory2;
            this.cleanUpTimestamp();
            this.mMessageArea.resetDataForJump();
            MessageHeader target = UCDBMessage.findMsgHeaderByPacketId(UCChatClient.context, packetId);
            if (target == null || target.getIsRecalled() == 1) {
                return;
            }
            ArrayList<MessageHeader> chatMsgList = new ArrayList<MessageHeader>();
            chatMsgList.add(target);
            List<HashMap<String, Object>> chatHistory1 = this.getChatHistory(this.mRoomJid, chatMsgList, true);
            if (chatHistory1.size() > 0) {
                this.appendMessage(chatHistory1, false);
            }
            if ((chatHistory2 = this.getChatHistory(this.mRoomJid, prevChatMsgList = ChatRoomManager.getChatMsgsBefore(UCChatClient.context, this.mRoomJid, this.startMsgTimestamp, 15), false)).size() > 0) {
                this.appendOldMessage(chatHistory2, false);
            }
            boolean lastHit = false;
            List<MessageHeader> suffixChatMsgList = ChatRoomManager.getChatMsgsAfter(UCChatClient.context, this.mRoomJid, this.endMsgTimestamp, 15);
            List<HashMap<String, Object>> chatHistory3 = this.getChatHistory(this.mRoomJid, suffixChatMsgList, true);
            if (chatHistory3.size() > 0) {
                this.appendMessage(chatHistory3, false);
            }
            if (suffixChatMsgList.size() < 15) {
                lastHit = true;
            }
            this.lastMsgShown = lastHit ? true : (suffixChatMsgList2 = ChatRoomManager.getChatMsgsAfter(UCChatClient.context, this.mRoomJid, this.endMsgTimestamp, 1)) == null || suffixChatMsgList2.size() == 0;
            this.mMessageArea.doScrollToPacketId(packetId, interval);
        }
    }

    protected void appendMessage(List<HashMap<String, Object>> msgValues, boolean scrollToBottom) {
        HashMap<String, LiteContact> contactCache = new HashMap<String, LiteContact>();
        String userJID = PreferencesUtil.getUserJid(UCChatClient.context);
        int size = msgValues.size();
        for (int i = 0; i < size; ++i) {
            HashMap<String, Object> msgValue = msgValues.get(i);
            Message msg = (Message)msgValue.get("txtContent");
            String senderJID = msg.getFromJid();
            int msgType = msg.getMsgType();
            if (MsgUtil.isSystemMsg(msgType)) {
                this.addSystemMessage(msgValue, true, scrollToBottom);
            } else if (msgType == 99) {
                this.mMessageArea.addNoticeMessage(msg, true, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
            } else {
                ChatroomType roomType = this.getChatroomType();
                if (roomType == ChatroomType.CONFERENCE || roomType == ChatroomType.MULTI) {
                    this.addRoomReceivedMessage(msg, true, scrollToBottom, contactCache);
                } else if (senderJID.equals(userJID)) {
                    this.addMyMessage(msg, true, scrollToBottom);
                } else {
                    this.addOtherPartyMessage(msg, this.mRoomJid, this.mRoomDisplayName, true, scrollToBottom);
                }
            }
            this.updateMessageIdRange(msg);
        }
    }

    protected void appendOldMessage(List<HashMap<String, Object>> msgValues, boolean scrollToBottom) {
        HashMap<String, LiteContact> contactCache = new HashMap<String, LiteContact>();
        String userJID = PreferencesUtil.getUserJid(UCChatClient.context);
        int size = msgValues.size();
        for (int i = size - 1; i >= 0; --i) {
            HashMap<String, Object> msgValue = msgValues.get(i);
            Message msg = (Message)msgValue.get("txtContent");
            String senderJID = msg.getFromJid();
            int msgType = msg.getMsgType();
            if (MsgUtil.isSystemMsg(msgType)) {
                this.addSystemMessage(msgValue, false, scrollToBottom);
            } else if (msgType == 99) {
                this.mMessageArea.addNoticeMessage(msg, false, scrollToBottom, this.mContentSearchKey, this.mLastPacketId);
            } else {
                ChatroomType roomType = this.getChatroomType();
                if (roomType == ChatroomType.CONFERENCE || roomType == ChatroomType.MULTI) {
                    this.addRoomReceivedMessage(msg, false, scrollToBottom, contactCache);
                } else if (senderJID.equals(userJID)) {
                    this.addMyMessage(msg, false, scrollToBottom);
                } else {
                    this.addOtherPartyMessage(msg, this.mRoomJid, this.mRoomDisplayName, false, scrollToBottom);
                }
            }
            this.updateMessageIdRange(msg);
        }
    }

    @Override
    public void onScrollTop() {
        Log.d(BaseChatroom.class.getSimpleName(), "onScrollTop...");
        Thread t = new Thread("ChatroomOnScrollBottomTop"){

            @Override
            public void run() {
                BaseChatroom.this.loadMessageBefore(BaseChatroom.this.LOAD_OLD_HISTORY_SIZE);
                BaseChatroom.this.checkFloatingPanelDisp();
            }
        };
        t.start();
    }

    @Override
    public void onScrollBottom() {
        Log.d(BaseChatroom.class.getSimpleName(), "onScrollBottom...");
        Thread t = new Thread("ChatroomOnScrollBottom"){

            @Override
            public void run() {
                BaseChatroom.this.loadMessageAfter(BaseChatroom.this.LOAD_OLD_HISTORY_SIZE, false);
                BaseChatroom.this.checkFloatingPanelDisp();
            }
        };
        t.start();
    }

    @Override
    public void onScrollNotBottom() {
        Log.d(BaseChatroom.class.getSimpleName(), "onScrollNotBottom...");
        this.checkFloatingPanelDisp();
    }

    private void checkFloatingPanelDisp() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BaseChatroom.this.checkFloatingPanelDispSwing();
            }
        });
    }

    private void checkFloatingPanelDispSwing() {
        if (!(this.mMessageArea == null || this.mMessageArea.isScrollBarAtBottom() && this.lastMsgShown)) {
            Log.d(BaseChatroom.class.getSimpleName(), "isScrollBarAtBottom:" + this.mMessageArea.isScrollBarAtBottom() + ", lastMsgShown:" + this.lastMsgShown);
            if (this.mLastMsg != null && this.mMessageArea != null && !this.mMessageArea.isMsgLoaded(this.mLastMsg.getPacketId())) {
                if (this.mFloatingPanel != null) {
                    this.mFloatingPanel.setVisible(false);
                }
                if (this.mFloatingMsgPanel != null) {
                    this.setLastMsg(this.mLastMsgPane, this.mLastMsg);
                    this.mFloatingMsgPanel.setVisible(true);
                    this.mFloatingMsgPanel.repaint();
                    this.mFloatingMsgPanel.invalidate();
                }
            } else {
                if (this.mFloatingPanel != null) {
                    this.mFloatingPanel.setVisible(true);
                    this.mFloatingPanel.repaint();
                    this.mFloatingPanel.invalidate();
                }
                if (this.mFloatingMsgPanel != null) {
                    this.mLastMsgPane.setText("");
                    this.mFloatingMsgPanel.setVisible(false);
                }
            }
        } else {
            if (this.mFloatingPanel != null) {
                this.mFloatingPanel.setVisible(false);
            }
            if (this.mFloatingMsgPanel != null) {
                this.mLastMsgPane.setText("");
                this.mFloatingMsgPanel.setVisible(false);
            }
        }
    }

    private void setLastMsg(JTextPane xlblLastMsg, Message msg) {
        HashMap<String, LiteContact> contactsMap = new HashMap<String, LiteContact>();
        ChatroomType roomType = this.getChatroomType();
        boolean isConfRoom = false;
        boolean isConfChatRoom = false;
        if (roomType == ChatroomType.CONFERENCE) {
            isConfRoom = true;
            isConfChatRoom = true;
        }
        if (roomType == ChatroomType.MULTI) {
            isConfChatRoom = true;
        }
        boolean isFuzzy = false;
        if (JidUtil.isFakeExternalCallJid(this.mRoomJid) && PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context)) {
            isFuzzy = true;
        }
        LastMsg lastMsgResult = MsgUtil.getLastMsgUtil(UCChatClient.context, msg, contactsMap, isConfRoom, isFuzzy);
        String content = lastMsgResult.getDispContentShort();
        String ownerName = null;
        if (lastMsgResult.isShowMsgSenderName() && isConfChatRoom) {
            ownerName = ContactManager.getContactShortName((Context)UCChatClient.context, contactsMap, msg.getFromJid());
        }
        this.setLastMessage(xlblLastMsg, ownerName, content);
    }

    public void setLastMessage(JTextPane xlblLastMsg, String ownerName, String lastMsg) {
        try {
            StyledDocument doc = (StyledDocument)xlblLastMsg.getDocument();
            Style style = doc.addStyle("StyleName", null);
            StyleConstants.setForeground(style, new Color(173, 0, 0));
            xlblLastMsg.setText("");
            if (lastMsg.startsWith("[PHONE_TALKING]") || lastMsg.startsWith("[PHONE_CANCEL]") || lastMsg.startsWith("[PHONE_CANCEL_IN]") || lastMsg.startsWith("[PHONE_CANCEL_OUT]")) {
                String[] terms = lastMsg.split(" ");
                String phoneKey = terms[0];
                String phoneIconPath = ChatRoomManager.getPhoneIconPath(phoneKey);
                ImageIcon phoneIcon = GraphicUtil.getScaledIcon(phoneIconPath, 16, 16);
                String remainText = lastMsg.substring(phoneKey.length());
                try {
                    xlblLastMsg.insertIcon(phoneIcon);
                    xlblLastMsg.getDocument().insertString(xlblLastMsg.getCaretPosition(), remainText, null);
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            } else if (EmoticonUtils.isStickerContent(lastMsg)) {
                String content = "[" + I18NUtil.getString("chat_msg_type_sticker") + "]";
                if (!TextUtils.isBlank((CharSequence)ownerName)) {
                    content = ownerName + ": " + content;
                }
                xlblLastMsg.getDocument().insertString(xlblLastMsg.getCaretPosition(), content, null);
            } else {
                Object content = lastMsg;
                if (!TextUtils.isBlank((CharSequence)ownerName)) {
                    content = ownerName + ": " + (String)content;
                }
                String msgContent = ((String)content).replace("\n", " ");
                HistoryTextWriter writer = new HistoryTextWriter(xlblLastMsg, 12, -1);
                try {
                    MsgTextConverter.convertAndAppendText(msgContent, writer);
                }
                catch (UCThreadException uCThreadException) {}
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dumpToPacketId(final String packetId) {
        Thread t = new Thread("ChatroomJumpToPacketId"){

            @Override
            public void run() {
                BaseChatroom.this.loadMessagePacketId(packetId, 100);
            }
        };
        t.start();
    }

    @Override
    public void resendMsg(Message message) {
        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
        chatReceiverList.add(new ChatReceiver(this.mRoomJid));
        ChatActionUtil.resendMessage(chatReceiverList, message, this);
    }

    @Override
    public void attachFromName(String name) {
        if (this.txtMessage.isEnabled()) {
            try {
                Document doc = this.txtMessage.getDocument();
                doc.insertString(doc.getLength(), "@" + name + " ", null);
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public Message getMessageByPacketId(String packetId) {
        return UCDBMessage.findMsgByPacketId(UCChatClient.context, packetId);
    }

    @Override
    public void onQuoteSelected(String packageId) {
        this.onReferenceSelected(packageId);
    }

    @Override
    public boolean isChatModeEnabled() {
        return this.txtMessage.isEnabled();
    }

    @Override
    public void onDelete(String packetId) {
        this.onReferenceRemoved(packetId);
    }

    @Override
    public void onRecall(String packetId) {
        this.onReferenceRemoved(packetId);
    }

    @Override
    public void updateFavoriteAction(boolean favorite) {
        if (this.favoriteAction == null) {
            return;
        }
        if (favorite) {
            if (this.favoriteAction.showText) {
                this.favoriteAction.putValue("Name", I18NUtil.getString("abook_fun_remove_from_my_favorites"));
            } else {
                this.favoriteAction.putValue("ShortDescription", I18NUtil.getString("abook_fun_remove_from_my_favorites"));
            }
        } else if (this.favoriteAction.showText) {
            this.favoriteAction.putValue("Name", I18NUtil.getString("abook_fun_add_to_my_favorites"));
        } else {
            this.favoriteAction.putValue("ShortDescription", I18NUtil.getString("abook_fun_add_to_my_favorites"));
        }
    }

    @Override
    public void updateNotificationAction(boolean enabled) {
        if (this.notificationAction == null) {
            return;
        }
        if (enabled) {
            if (this.notificationAction.showText) {
                this.notificationAction.putValue("Name", I18NUtil.getString("chat_fun_title_remind_disable"));
            } else {
                this.notificationAction.putValue("ShortDescription", I18NUtil.getString("chat_fun_title_remind_disable"));
            }
        } else if (this.notificationAction.showText) {
            this.notificationAction.putValue("Name", I18NUtil.getString("chat_fun_title_remind_enable"));
        } else {
            this.notificationAction.putValue("ShortDescription", I18NUtil.getString("chat_fun_title_remind_enable"));
        }
    }

    @Override
    public void updateActionMap() {
        if (this.txtMessage != null) {
            this.txtMessage.updateActionMap();
        }
    }

    @Override
    public MessageInput getTextField() {
        return this.txtMessage;
    }

    class FavoriteAction
    extends AbstractAction {
        boolean showText;

        public FavoriteAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("abook_fun_add_to_my_favorites"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("abook_fun_add_to_my_favorites"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean favorite = ChatRoomManager.switchMyFavorite(BaseChatroom.this.mRoomJid);
            BaseChatroom.this.updateFavoriteAction(favorite);
        }
    }

    class NotificationAction
    extends AbstractAction {
        boolean showText;

        public NotificationAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("chat_fun_title_remind_enable"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("chat_fun_title_remind_enable"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isEnabled;
            if (!WebAgent.isLogin) {
                return;
            }
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            boolean bl = isEnabled = !database.isDisableNotification(BaseChatroom.this.mRoomJid);
            if (isEnabled) {
                WebAgent.getInstance().disableChatRoomNotice(BaseChatroom.this.mRoomJid);
                BaseChatroom.this.updateNotificationAction(false);
            } else {
                WebAgent.getInstance().enableChatRoomNotice(BaseChatroom.this.mRoomJid, false);
                BaseChatroom.this.updateNotificationAction(true);
            }
        }
    }

    class MyCaret
    extends DefaultCaret {
        MyCaret() {
        }

        @Override
        protected void adjustVisibility(Rectangle nloc) {
        }
    }
}

