/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.bean.SelectContactResult;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.MessageInput;
import com.blisscloud.ezuc.client.chat.popup.EmoticonPopupMenu;
import com.blisscloud.ezuc.client.chat.popup.MediaContentInputListener;
import com.blisscloud.ezuc.client.chat.popup.StickerPopupMenu;
import com.blisscloud.ezuc.client.chat.roomimpl.BaseChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ListenerCleaner;
import com.blisscloud.ezuc.client.chat.roomimpl.ReferenceOut;
import com.blisscloud.ezuc.client.component.EmailLabel;
import com.blisscloud.ezuc.client.component.GradientPanel;
import com.blisscloud.ezuc.client.component.ImageLabel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.screen.CaptureUtil;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;

public class Chatroom
extends BaseChatroom
implements IChatroom {
    private static final long serialVersionUID = 3897320021725946031L;
    private ChatMode chatMode = null;
    private JPanel panelHeader;
    private PersonalPhoto lblPhoto;
    private ImageLabel btnConfig;
    private JScrollPane spMessage;
    private JPanel jToolBar1;
    private JPanel jPanel100;
    private JPanel spMessageOut;
    private ReferenceOut referenceMsgOut;
    private JLabel lblPadding;
    private JSeparator jSeparator0;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private ImageLabel btnSendFile;
    private ImageLabel btnScreenCapture;
    private ImageLabel btnSendSticker;
    private ImageLabel btnSendEmoticon;
    private ImageLabel btnCall;
    private ImageLabel btnHangup;
    private ImageLabel btnMuteSelf;
    private ImageLabel btnShowCallPage;
    private JPanel jPanelCall1;
    private JPanel mMenuPanel;
    private ImageLabel btnCall2;
    private ImageLabel btnHangup2;
    private ImageLabel btnMuteSelf2;
    private EmailLabel lblEmail;
    private JLabel lblDisplayName;
    private JPopupMenu popupMenuConfig;
    private JSplitPane jSplitPane1 = null;
    private InviteMemberAction inviteMemberAction = new InviteMemberAction(true);
    private int mChatType;
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private JPanel sendBtnPanel = null;
    private boolean showMuteMsg = false;
    private JButton sendButton = null;
    private String mQuotePackageId;

    public Chatroom(String roomJid, JPanel parent) {
        super(roomJid, parent);
        this.mMessageArea = new MessageArea(roomJid, false, this);
        this.initGUI();
        this.initConfigPopup();
        this.initReceiver();
        Log.i(Chatroom.class.getSimpleName(), "create chatroom jid: " + this.mRoomJid);
        ChatRoomManager.checkAndGenerateChatRoomData(UCChatClient.context, this.mRoomJid, null, false, false);
        ChatRoomInfo info = ChatRoomManager.getChatRoom(UCChatClient.context, this.mRoomJid);
        if (info == null) {
            throw new IllegalArgumentException("invalid chatroom jid " + this.mRoomJid);
        }
        this.mChatType = info.getType();
        this.updateChatMode();
        this.updateChatRoomStatus("ONSTART ...");
        this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(this.mRoomJid));
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        boolean isEnabled = !database.isDisableNotification(this.mRoomJid);
        this.updateNotificationAction(isEnabled);
    }

    @Override
    public ChatroomType getChatroomType() {
        return ChatroomType.SINGLE;
    }

    @Override
    public void execute(String command) {
    }

    public ChatMode getChatMode() {
        return this.chatMode;
    }

    public void setChatMode(ChatMode mode) {
        if (this.chatMode == mode) {
            return;
        }
        this.chatMode = mode;
        switch (this.chatMode) {
            case NORMAL: {
                this.btnConfig.setEnabled(true);
                this.btnSendFile.setEnabled(true);
                this.btnScreenCapture.setEnabled(true);
                this.btnSendSticker.setEnabled(true);
                this.btnSendEmoticon.setEnabled(true);
                if (!this.txtMessage.isEnabled()) {
                    this.txtMessage.setText("");
                }
                this.txtMessage.setEnabled(true);
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                if (!this.jPanel100.isVisible()) {
                    this.btnCall.setEnabled(true);
                    this.btnCall.setVisible(true);
                    this.jPanelCall1.setVisible(true);
                    this.btnConfig.setVisible(true);
                    this.jToolBar1.setVisible(true);
                    this.spMessage.setVisible(true);
                    this.jPanel100.setVisible(true);
                    this.sendBtnPanel.setVisible(true);
                    if (this.panelHeader.getHeight() >= 0) {
                        int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                        int loc = this.mPanrent.getHeight() - this.panelHeader.getHeight() - panelHeight;
                        if (loc > 200 && panelHeight > 200) {
                            this.jSplitPane1.setDividerLocation(loc);
                        } else {
                            this.jSplitPane1.setDividerLocation(0.7);
                        }
                    }
                }
                this.onPhoneStatusChanged();
                break;
            }
            case DELETED: {
                this.btnConfig.setEnabled(false);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnConfig.setVisible(false);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
                break;
            }
            case ONLY_PHONE: {
                this.btnConfig.setEnabled(true);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(true);
                this.btnCall2.setVisible(true);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnConfig.setVisible(true);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
                this.onPhoneStatusChanged();
                break;
            }
            case DISABLED: {
                this.btnConfig.setEnabled(false);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnConfig.setVisible(false);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
            }
        }
    }

    private void updateChatMode() {
        if (this.mChatType == 3) {
            this.setChatMode(ChatMode.ONLY_PHONE);
        } else if (this.mChatType == 4) {
            this.setChatMode(ChatMode.ONLY_PHONE);
        } else if (this.mChatType == 5) {
            this.setChatMode(ChatMode.ONLY_PHONE);
        } else if (this.mChatType == 7) {
            this.setChatMode(ChatMode.DISABLED);
        } else if (this.mChatType == 0) {
            if (JidUtil.isBcAnnouncerJid(this.mRoomJid)) {
                this.setChatMode(ChatMode.DISABLED);
            } else if (JidUtil.isAPIUserJid(this.mRoomJid)) {
                this.setChatMode(ChatMode.DISABLED);
            } else if (JidUtil.isEmployeeJid(this.mRoomJid)) {
                LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, this.mRoomJid);
                if (contact == null) {
                    this.setChatMode(ChatMode.DELETED);
                } else {
                    boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
                    if (hasChatPermission) {
                        this.setChatMode(ChatMode.NORMAL);
                    } else {
                        this.setChatMode(ChatMode.ONLY_PHONE);
                    }
                }
            }
        } else {
            this.setChatMode(ChatMode.DISABLED);
        }
    }

    private void updateChatRoomStatus(String location) {
        Activity ctx = UCChatClient.context;
        if (this.mChatType == 3) {
            this.lblPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
            this.lblDisplayName.setText("");
            this.lblEmail.setVisible(false);
            if (this.mRoomJid != null) {
                if (this.mRoomJid.indexOf("_@@_") != -1) {
                    String[] titles = this.mRoomJid.split("_@@_");
                    this.mRoomDisplayName = PhoneNoUtil.getPhoneNumDisp(ctx, titles[0], titles[1]);
                } else {
                    this.mRoomDisplayName = this.mRoomJid;
                }
            }
            this.lblDisplayName.setText(this.mRoomDisplayName);
        } else if (this.mChatType == 4) {
            if (JidUtil.isLocationJid(this.mRoomJid)) {
                this.lblPhoto.setImage(UIConstants.ICON_PHONE_PUBLIC_PHONE64.getImage());
            } else {
                this.lblPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
            }
            this.lblDisplayName.setText("");
            this.lblEmail.setVisible(false);
            LiteContact contact = ContactManager.getContact((Context)ctx, this.mRoomJid);
            ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(ctx, this.mRoomJid);
            this.mRoomDisplayName = ChatRoomUtil.getLocationRoomTitle(ctx, roomInfo, contact, this.mRoomJid);
            this.lblDisplayName.setText(this.mRoomDisplayName);
        } else if (this.mChatType == 7) {
            this.lblDisplayName.setText("");
            this.lblEmail.setVisible(false);
            MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(ctx, this.mRoomJid);
            Image image = MessageChannelManager.getMessageChannelImage(channel, 64, false, true);
            this.lblPhoto.setImage(image);
            ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(ctx, this.mRoomJid);
            this.mRoomDisplayName = ChatRoomUtil.getMessageChannelRoomTitle(ctx, roomInfo, channel, this.mRoomJid);
            this.lblDisplayName.setText(this.mRoomDisplayName);
        } else if (this.mChatType == 5) {
            this.lblDisplayName.setText("");
            this.lblEmail.setVisible(false);
            LiteMyContact contact = ContactManager.getExternalContact((Context)ctx, this.mRoomJid);
            Image image = ContactManager.getExternalContactImage(contact, 64, false, true);
            this.lblPhoto.setImage(image);
            ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(ctx, this.mRoomJid);
            this.mRoomDisplayName = ChatRoomUtil.getMyContactRoomTitle(ctx, roomInfo, contact);
            this.lblDisplayName.setText(this.mRoomDisplayName);
        } else if (this.mChatType == 0) {
            if (JidUtil.isBcAnnouncerJid(this.mRoomJid)) {
                this.mRoomDisplayName = I18NUtil.getAppName();
                this.lblPhoto.setImage(UIConstants.ICON_LOGO64.getImage());
                this.lblDisplayName.setText(this.mRoomDisplayName);
                this.lblEmail.setEmail(null);
                this.lblEmail.setVisible(false);
            } else {
                ChatRoomManager.checkAndGenerateChatRoomData(ctx, this.mRoomJid, null, false, false);
                ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(ctx, this.mRoomJid);
                LiteContact contact = ContactManager.getContact((Context)ctx, this.mRoomJid);
                this.mRoomDisplayName = ChatRoomUtil.getEmpRoomTitle(ctx, roomInfo, contact, this.mRoomJid);
                Image image = ContactManager.getContactImage(contact, 64, false, true);
                this.lblPhoto.setImage(image);
                this.lblDisplayName.setText(this.mRoomDisplayName);
                this.lblEmail.setEmail(contact == null ? null : contact.getEmail());
                this.lblEmail.setVisible(contact == null ? false : TextUtils.isNotBlank((CharSequence)contact.getEmail()));
            }
        } else if (this.mChatType == 1 || this.mChatType == 2) {
            // empty if block
        }
    }

    @Override
    public void updateMyChatRoomAction(boolean isMyChatRoom) {
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(640, 480));
            this.setMinimumSize(new Dimension(520, 300));
            this.panelHeader = new GradientPanel(1, UIConstants.COLOR_HEADER_BACKGROUND_FROM, UIConstants.COLOR_HEADER_BACKGROUND_TO);
            this.add((Component)this.panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.panelHeader.setLayout(jPanel1Layout);
            this.panelHeader.setBorder(UIConstants.BORDER_HEADER);
            this.lblPhoto = new PersonalPhoto();
            this.panelHeader.add((Component)this.lblPhoto, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPhoto.setPreferredSize(new Dimension(64, 64));
            this.lblPhoto.setMinimumSize(new Dimension(64, 64));
            this.lblPhoto.setMaximumSize(new Dimension(64, 64));
            this.lblDisplayName = new JLabel();
            this.panelHeader.add((Component)this.lblDisplayName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(4, 12, 0, 0), 0, 0));
            this.lblDisplayName.setText("<Display Name>");
            this.lblDisplayName.setFont(UIConstants.FONT_14_BOLD);
            this.lblEmail = new EmailLabel();
            this.panelHeader.add((Component)this.lblEmail, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 16, 0, new Insets(0, 10, 0, 0), 0, 0));
            this.lblEmail.setFont(UIConstants.FONT_14_PLAIN);
            this.lblEmail.setEmail("albert.chiou@blisscloud.com");
            this.lblEmail.setIcon(UIConstants.ICON_MAIL32);
            this.mMenuPanel = new JPanel();
            this.mMenuPanel.setOpaque(false);
            FlowLayout panelEndcallLayout = new FlowLayout();
            panelEndcallLayout.setAlignment(0);
            panelEndcallLayout.setVgap(0);
            panelEndcallLayout.setHgap(5);
            this.mMenuPanel.setLayout(panelEndcallLayout);
            this.panelHeader.add((Component)this.mMenuPanel, new GridBagConstraints(2, 0, 1, 3, 0.0, 0.0, 12, 3, new Insets(5, 5, 0, 0), 0, 0));
            this.btnCall2 = new ImageLabel((Icon)UIConstants.ICON_VOICE_CALL_SMALL, I18NUtil.getString("abook_popup_btn_talk"));
            this.mMenuPanel.add(this.btnCall2);
            this.btnCall2.setPreferredSize(new Dimension(this.btnCall2.calculatePreferWidth(), 32));
            this.btnCall2.setHorizontalAlignment(0);
            this.btnCall2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnCall2.setCursor(UIConstants.CURSOR_HAND);
            this.btnCall2.setArc(12);
            this.btnCall2.setVisible(false);
            this.btnCall2.setEnabled(false);
            this.btnCall2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnCall2.isEnabled()) {
                        Log.i(Chatroom.class.getSimpleName(), "room start dial:" + Chatroom.this.mRoomJid);
                        ChatRoomManager.startDialOut(Chatroom.this.btnCall2, Chatroom.this.mRoomJid);
                    }
                }
            });
            this.btnHangup2 = new ImageLabel((Icon)UIConstants.ICON_VOICE_END_SMALL, I18NUtil.getString("call_btn_hangup"));
            this.mMenuPanel.add(this.btnHangup2);
            this.btnHangup2.setPreferredSize(new Dimension(this.btnHangup2.calculatePreferWidth(), 32));
            this.btnHangup2.setHorizontalAlignment(0);
            this.btnHangup2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnHangup2.setCursor(UIConstants.CURSOR_HAND);
            this.btnHangup2.setArc(12);
            this.btnHangup2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnHangup2.isEnabled()) {
                        PhoneAgent.getInstance().hangupMeetme(Chatroom.this.mRoomJid);
                    }
                }
            });
            this.btnMuteSelf2 = new ImageLabel((Icon)UIConstants.ICON_CHAT_MIC_SMALL, I18NUtil.getString("call_btn_click_mute"));
            this.mMenuPanel.add(this.btnMuteSelf2);
            this.btnMuteSelf2.setPreferredSize(new Dimension(this.btnMuteSelf2.calculatePreferWidth(), 32));
            this.btnMuteSelf2.setHorizontalAlignment(0);
            this.btnMuteSelf2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnMuteSelf2.setCursor(UIConstants.CURSOR_HAND);
            this.btnMuteSelf2.setArc(12);
            this.btnMuteSelf2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    Chatroom.this.onClickMuteButton();
                }
            });
            this.btnConfig = new ImageLabel(UIConstants.ICON_MENU);
            this.mMenuPanel.add(this.btnConfig);
            this.btnConfig.setToolTipText(I18NUtil.getString("common_btn_config"));
            this.btnConfig.setPreferredSize(new Dimension(32, 32));
            this.btnConfig.setMinimumSize(new Dimension(32, 32));
            this.btnConfig.setMaximumSize(new Dimension(32, 32));
            this.btnConfig.setHorizontalAlignment(0);
            this.btnConfig.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnConfig.setCursor(UIConstants.CURSOR_HAND);
            this.btnConfig.setArc(12);
            this.popupMenuConfig = new JPopupMenu();
            this.setComponentPopupMenu(this.btnConfig, this.popupMenuConfig);
            this.panelHeader.add((Component)this.getSearchControlPanel(), new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1 = new JSplitPane(0);
            this.add((Component)this.jSplitPane1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
            this.jSplitPane1.add((Component)this.getMessageLayerPanel(), "top");
            this.jPanel100 = new JPanel();
            BorderLayout jPanel100Layout = new BorderLayout();
            this.jPanel100.setLayout(jPanel100Layout);
            this.jSplitPane1.add((Component)this.jPanel100, "bottom");
            this.spMessageOut = new JPanel();
            this.spMessageOut.setLayout(new BorderLayout());
            this.jPanel100.add((Component)this.spMessageOut, "Center");
            this.jToolBar1 = new JPanel();
            this.jPanel100.add((Component)this.jToolBar1, "North");
            GridBagLayout jToolBar1Layout = new GridBagLayout();
            this.jToolBar1.setLayout(jToolBar1Layout);
            this.jToolBar1.setBorder(UIConstants.BORDER_MESSAGE_TOOLBAR);
            int x = 0;
            boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
            boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
            this.btnSendFile = new ImageLabel((Icon)UIConstants.ICON_FILE, I18NUtil.getString("chat_btn_send_file"));
            this.jToolBar1.add((Component)this.btnSendFile, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnSendFile.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendFile.setBorder(BORDER_BTN_MESSAGE);
            this.btnSendFile.setNormalBorderColor(null);
            this.btnSendFile.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendFile.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnSendFile.isEnabled()) {
                        Chatroom.this.btnSendFileMouseClicked(evt);
                    }
                }
            });
            this.btnSendFile.setVisible(hasFilePermission);
            this.jSeparator0 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator0, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator0.setPreferredSize(new Dimension(2, 20));
            this.jSeparator0.setOrientation(1);
            this.jSeparator0.setVisible(hasFilePermission);
            this.btnScreenCapture = new ImageLabel((Icon)UIConstants.ICON_SCREEN_CAPTURE, I18NUtil.getString("chat_btn_screen_capture"));
            this.jToolBar1.add((Component)this.btnScreenCapture, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnScreenCapture.setFont(UIConstants.FONT_14_PLAIN);
            this.btnScreenCapture.setBorder(BORDER_BTN_MESSAGE);
            this.btnScreenCapture.setNormalBorderColor(null);
            this.btnScreenCapture.setCursor(UIConstants.CURSOR_HAND);
            this.btnScreenCapture.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnScreenCapture.isEnabled()) {
                        Chatroom.this.btnScreenCaptureMouseClicked(evt);
                    }
                }
            });
            this.btnScreenCapture.setVisible(hasPhotoPermission);
            this.jSeparator1 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator1, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator1.setPreferredSize(new Dimension(2, 20));
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setVisible(hasPhotoPermission);
            this.btnSendSticker = new ImageLabel((Icon)UIConstants.ICON_STICKER, I18NUtil.getString("chat_msg_type_sticker"));
            this.jToolBar1.add((Component)this.btnSendSticker, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnSendSticker.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendSticker.setBorder(BORDER_BTN_MESSAGE);
            this.btnSendSticker.setNormalBorderColor(null);
            this.btnSendSticker.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendSticker.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnSendSticker.isEnabled()) {
                        Chatroom.this.btnSendStickerMouseClicked(evt);
                    }
                }
            });
            this.jSeparator2 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator2, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator2.setPreferredSize(new Dimension(2, 20));
            this.jSeparator2.setOrientation(1);
            this.btnSendEmoticon = new ImageLabel((Icon)UIConstants.ICON_EMOTICON, I18NUtil.getString("chat_msg_type_emoticon"));
            this.jToolBar1.add((Component)this.btnSendEmoticon, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnSendEmoticon.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendEmoticon.setBorder(BORDER_BTN_MESSAGE);
            this.btnSendEmoticon.setNormalBorderColor(null);
            this.btnSendEmoticon.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendEmoticon.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnSendEmoticon.isEnabled()) {
                        Chatroom.this.btnSendEmoticonMouseClicked(evt);
                    }
                }
            });
            this.lblPadding = new JLabel();
            this.jToolBar1.add((Component)this.lblPadding, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCall = new ImageLabel((Icon)UIConstants.ICON_VOICE_CHAT, I18NUtil.getString("abook_popup_btn_talk"));
            this.jToolBar1.add((Component)this.btnCall, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCall.setFont(UIConstants.FONT_14_PLAIN);
            this.btnCall.setBorder(BORDER_BTN_MESSAGE);
            this.btnCall.setNormalBorderColor(null);
            this.btnCall.setCursor(UIConstants.CURSOR_HAND);
            this.btnCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnCall.isEnabled()) {
                        Log.i(Chatroom.class.getSimpleName(), "room start dial:" + Chatroom.this.mRoomJid);
                        ChatRoomManager.startDialOut(Chatroom.this.btnCall, Chatroom.this.mRoomJid);
                    }
                }
            });
            this.jPanelCall1 = new JPanel();
            FlowLayout panelEndcallLayout2 = new FlowLayout();
            panelEndcallLayout2.setAlignment(0);
            panelEndcallLayout2.setVgap(0);
            this.jPanelCall1.setLayout(panelEndcallLayout2);
            this.jToolBar1.add((Component)this.jPanelCall1, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnHangup = new ImageLabel(UIConstants.ICON_VOICE_END);
            this.jPanelCall1.add(this.btnHangup);
            this.btnHangup.setToolTipText(I18NUtil.getString("call_btn_hangup"));
            this.btnHangup.setFont(UIConstants.FONT_14_PLAIN);
            this.btnHangup.setBorder(BORDER_BTN_MESSAGE);
            this.btnHangup.setNormalBorderColor(null);
            this.btnHangup.setCursor(UIConstants.CURSOR_HAND);
            this.btnHangup.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnHangup.isEnabled()) {
                        PhoneAgent.getInstance().hangupMeetme(Chatroom.this.mRoomJid);
                    }
                }
            });
            this.jSeparator3 = new JSeparator();
            this.jPanelCall1.add(this.jSeparator3);
            this.jSeparator3.setPreferredSize(new Dimension(2, 20));
            this.jSeparator3.setOrientation(1);
            this.btnMuteSelf = new ImageLabel(UIConstants.ICON_CHAT_MIC);
            this.jPanelCall1.add(this.btnMuteSelf);
            this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
            this.btnMuteSelf.setFont(UIConstants.FONT_14_PLAIN);
            this.btnMuteSelf.setBorder(BORDER_BTN_MESSAGE);
            this.btnMuteSelf.setNormalBorderColor(null);
            this.btnMuteSelf.setCursor(UIConstants.CURSOR_HAND);
            this.btnMuteSelf.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    Chatroom.this.onClickMuteButton();
                }
            });
            this.jSeparator4 = new JSeparator();
            this.jPanelCall1.add(this.jSeparator4);
            this.jSeparator4.setPreferredSize(new Dimension(2, 20));
            this.jSeparator4.setOrientation(1);
            this.btnShowCallPage = new ImageLabel(UIConstants.ICON_SHOW_CALL_PAGE);
            this.jPanelCall1.add(this.btnShowCallPage);
            this.btnShowCallPage.setToolTipText(I18NUtil.getString("chatroom_btn_switch_to_call_view"));
            this.btnShowCallPage.setFont(UIConstants.FONT_14_PLAIN);
            this.btnShowCallPage.setBorder(BORDER_BTN_MESSAGE);
            this.btnShowCallPage.setNormalBorderColor(null);
            this.btnShowCallPage.setCursor(UIConstants.CURSOR_HAND);
            this.btnShowCallPage.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (Chatroom.this.btnShowCallPage.isEnabled()) {
                        UCChatClient.getInstance().getMainPanel().getViewContainer().showPhonePanel(Chatroom.this.mRoomJid);
                    }
                }
            });
            this.spMessage = new UCScrollPane();
            this.spMessageOut.add((Component)this.spMessage, "Center");
            this.spMessage.setPreferredSize(new Dimension(300, 130));
            this.txtMessage = new MessageInput(new MessageInput.MessageInputCallback(){

                @Override
                public void onSendMessage(String text) {
                    if (TextUtils.isNotBlank((CharSequence)text)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(Chatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(Chatroom.this.mQuotePackageId, chatReceiverList, text)) {
                            Chatroom.this.txtMessage.setText("");
                            Chatroom.this.onReferenceRemoved(Chatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(Chatroom.this.mRoomJid);
                        }
                        Chatroom.this.txtMessage.requestFocus();
                    }
                }

                @Override
                public List<LiteContact> pickContact() {
                    return null;
                }

                @Override
                public void focusLost() {
                    Chatroom.this.saveDraft();
                }
            }, this.fileSelectionCallback, this);
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String pendingMsg = database.getPendingMessage(this.getChatroomID());
            this.txtMessage.setPendingText(pendingMsg);
            this.spMessage.setViewportView(this.txtMessage);
            this.sendBtnPanel = new JPanel();
            this.sendBtnPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 15));
            this.sendBtnPanel.setLayout(new BorderLayout());
            this.sendBtnPanel.setBackground(Color.WHITE);
            this.spMessageOut.add((Component)this.sendBtnPanel, "East");
            this.sendButton = new JButton();
            this.sendBtnPanel.add((Component)this.sendButton, "South");
            this.sendButton.setText(I18NUtil.getString("chat_btn_send") + " (S)");
            this.sendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String docText = Chatroom.this.txtMessage.getMessageTextWithIconKey();
                    if (TextUtils.isNotBlank((CharSequence)docText)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(Chatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(Chatroom.this.mQuotePackageId, chatReceiverList, docText)) {
                            Chatroom.this.txtMessage.setText("");
                            Chatroom.this.onReferenceRemoved(Chatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(Chatroom.this.mRoomJid);
                        }
                        Chatroom.this.txtMessage.requestFocus();
                    }
                }
            });
            this.panelHeader.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (Chatroom.this.panelHeader.getHeight() >= 0) {
                        int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                        int loc = Chatroom.this.mPanrent.getHeight() - Chatroom.this.panelHeader.getHeight() - panelHeight;
                        if (loc > 200 && panelHeight > 200) {
                            Chatroom.this.jSplitPane1.setDividerLocation(loc);
                        } else {
                            Chatroom.this.jSplitPane1.setDividerLocation(0.7);
                        }
                    }
                }
            });
            this.jPanel100.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension d = Chatroom.this.jPanel100.getSize();
                    if (d.getHeight() >= 0.0) {
                        PreferencesUtil.setChatInputAreaHeight(UCChatClient.context, (int)d.getHeight());
                    }
                    if (Chatroom.this.mMessageArea != null) {
                        Chatroom.this.mMessageArea.refreshScrollBar();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClickMuteButton() {
        try {
            Log.i(Chatroom.class.getSimpleName(), "PhoneActivity onClickMuteButton");
            int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
            if (lineIndex != -1) {
                if (PhoneAgent.getInstance().toggleMute(lineIndex)) {
                    this.showMuteMsg = true;
                } else {
                    CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
                    boolean isMuted = callLine.isMute();
                    if (isMuted) {
                        ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_muted"), 10);
                        this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                        this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
                    } else {
                        ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_unmuted"), 10);
                        this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                        this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.e(Chatroom.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    @Override
    public void onReferenceSelected(String packetId) {
        if (StringUtils.isBlank((CharSequence)packetId)) {
            return;
        }
        this.onReferenceRemoved(null);
        this.mQuotePackageId = packetId;
        this.referenceMsgOut = new ReferenceOut(new ReferenceOut.ReferenceClose(){

            @Override
            public void onReferenceCancel() {
                Chatroom.this.onReferenceRemoved(null);
            }

            @Override
            public void onMouseClicked() {
                Chatroom.this.mMessageArea.scrollToPacketId(Chatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Chatroom.this.mMessageArea.scrollToPacketId(Chatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.setCursor(new Cursor(12));
        Message quoteMsg = UCDBMessage.findMsgByPacketId(UCChatClient.context, this.mQuotePackageId);
        this.referenceMsgOut.setMsg(quoteMsg, false);
        this.spMessageOut.add((Component)this.referenceMsgOut, "North");
        this.jPanel100.validate();
    }

    @Override
    public void onReferenceRemoved(String packetId) {
        if (StringUtils.isNotBlank((CharSequence)packetId) && (StringUtils.isBlank((CharSequence)this.mQuotePackageId) || !this.mQuotePackageId.equalsIgnoreCase(packetId))) {
            return;
        }
        if (this.referenceMsgOut != null) {
            this.spMessageOut.remove(this.referenceMsgOut);
            this.referenceMsgOut = null;
            this.mQuotePackageId = null;
            this.jPanel100.validate();
        }
    }

    private void initConfigPopup() {
        this.popupMenuConfig.add(this.inviteMemberAction);
        this.popupMenuConfig.addSeparator();
        this.popupMenuConfig.add(this.favoriteAction);
        this.popupMenuConfig.add(this.notificationAction);
    }

    private void cleanConfigPopup() {
        this.popupMenuConfig.removeAll();
        ListenerCleaner.cleanPropertyChangeListener(this.inviteMemberAction);
        ListenerCleaner.cleanPropertyChangeListener(this.favoriteAction);
        ListenerCleaner.cleanPropertyChangeListener(this.notificationAction);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if ("ezuc.intent.action.event.GROUP_LIST_CHANGED".equals(action)) {
                        Chatroom.this.group_listChanged();
                    } else if ("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED".equals(action)) {
                        String jid = intent.getStringExtra("jid");
                        String myJid = PreferencesUtil.getUserJid(context);
                        if (jid.equals(Chatroom.this.mRoomJid) || jid.equals(myJid)) {
                            Chatroom.this.web_participantPhotoChanged();
                        }
                    } else if ("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED".equals(action)) {
                        long contactId = intent.getLongExtra("id", -1L);
                        if ((contactId + "@externalcontact").equals(Chatroom.this.mRoomJid)) {
                            Chatroom.this.web_externalPhotoChanged();
                        }
                    } else if ("ezuc.intent.action.event.MESSAGE_CHANNEL_PHOTO_CHANGED".equals(action)) {
                        long channelId = intent.getLongExtra("id", -1L);
                        MessageChannel channel = UCDBMessageChannel.getMessageChannelById(UCChatClient.context, channelId);
                        if (channel != null && channel.getJid().equals(Chatroom.this.mRoomJid)) {
                            Chatroom.this.web_channelPhotoChanged();
                        }
                    } else if ("ezuc.intent.action.event.CONTACT_LIST_CHANGED".equals(action)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Chatroom.this.updateChatMode();
                                Chatroom.this.updateChatRoomStatus("CONTACT_LIST_CHANGED ...");
                            }
                        });
                    } else if ("ezuc.intent.action.event.MESSAGE_CHANNEL_LIST_CHANGED".equals(action)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Chatroom.this.updateChatMode();
                                Chatroom.this.updateChatRoomStatus("MESSAGE_CHANNEL_LIST_CHANGED ...");
                            }
                        });
                    } else if ("ezuc.intent.action.event.PHONE_MUTE_CHANGED".equals(action)) {
                        Bundle bundle = intent.getExtras();
                        if (bundle == null) {
                            return;
                        }
                        int line = bundle.getInt("line");
                        int lineIndex = PhoneAgent.getInstance().isInCall(Chatroom.this.mRoomJid);
                        if (lineIndex != -1) {
                            if (lineIndex != line) {
                                return;
                            }
                            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
                            if (callLine.isMute()) {
                                if (Chatroom.this.showMuteMsg) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_muted"), 10);
                                }
                                Chatroom.this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                                Chatroom.this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
                                Chatroom.this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MUTE_SMALL);
                                Chatroom.this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_unmute"));
                                Chatroom.this.btnMuteSelf2.setPreferredSize(new Dimension(Chatroom.this.btnMuteSelf2.calculatePreferWidth(), 32));
                            } else {
                                if (Chatroom.this.showMuteMsg) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_unmuted"), 10);
                                }
                                Chatroom.this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                                Chatroom.this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
                                Chatroom.this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MIC_SMALL);
                                Chatroom.this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_mute"));
                                Chatroom.this.btnMuteSelf2.setPreferredSize(new Dimension(Chatroom.this.btnMuteSelf2.calculatePreferWidth(), 32));
                            }
                        }
                        Chatroom.this.showMuteMsg = false;
                    } else if ("ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER".equals(action)) {
                        Chatroom.this.onPhoneStatusChanged();
                    } else if ("ezuc.intent.action.event.PHONE_CALL_BRIDGED".equals(action)) {
                        Chatroom.this.onPhoneStatusChanged();
                    } else if ("ezuc.intent.action.event.PERSONAL_INFO_CHANGED".equals(action)) {
                        Chatroom.this.updateChatMode();
                        boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
                        boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
                        Chatroom.this.btnSendFile.setVisible(hasFilePermission);
                        Chatroom.this.jSeparator0.setVisible(hasFilePermission);
                        Chatroom.this.btnScreenCapture.setVisible(hasPhotoPermission);
                        Chatroom.this.jSeparator1.setVisible(hasPhotoPermission);
                    }
                }
                catch (Throwable t) {
                    Log.e(Chatroom.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.GROUP_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.MESSAGE_CHANNEL_PHOTO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CONTACT_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.MESSAGE_CHANNEL_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_MUTE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_CALL_BRIDGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER");
        this.filter.addAction("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void btnSendFileMouseClicked(MouseEvent evt) {
        FileUtil.sendFile(this.fileSelectionCallback);
    }

    private void btnScreenCaptureMouseClicked(MouseEvent evt) {
        CaptureUtil.captureImage(this, this.fileSelectionCallback);
    }

    private void btnSendStickerMouseClicked(MouseEvent evt) {
        final StickerPopupMenu menu = StickerPopupMenu.getInstance();
        menu.setMediaContentInputListener(new MediaContentInputListener(){

            @Override
            public void onStickerClick(String stickerKey) {
                ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                chatReceiverList.add(new ChatReceiver(Chatroom.this.mRoomJid));
                ChatActionUtil.sendMessage(Chatroom.this.mQuotePackageId, chatReceiverList, stickerKey);
                Chatroom.this.onReferenceRemoved(Chatroom.this.mQuotePackageId);
                menu.setVisible(false);
                Chatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
            }

            @Override
            public void onIdiomClick(String text) {
            }

            @Override
            public void onSymbolClick(String text) {
            }
        });
        menu.show(this.btnSendSticker, 0, -menu.getPreferredSize().height);
    }

    private void btnSendEmoticonMouseClicked(MouseEvent evt) {
        final EmoticonPopupMenu menu = EmoticonPopupMenu.getInstance();
        menu.setMediaContentInputListener(new MediaContentInputListener(){

            @Override
            public void onStickerClick(String stickerKey) {
            }

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
                ImageIcon eIcon = GraphicUtil.getScaledIcon(iconPath, 16, 16);
                eIcon.setDescription(emoticonKey);
                Chatroom.this.txtMessage.insertIcon(eIcon);
                menu.setVisible(false);
                Chatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onIdiomClick(String text) {
                try {
                    Chatroom.this.txtMessage.replaceSelection("");
                    Chatroom.this.txtMessage.getDocument().insertString(Chatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                Chatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onSymbolClick(String text) {
                try {
                    Chatroom.this.txtMessage.replaceSelection("");
                    Chatroom.this.txtMessage.getDocument().insertString(Chatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                Chatroom.this.txtMessage.requestFocus();
            }
        });
        menu.show(this.btnSendEmoticon, 0, -menu.getPreferredSize().height);
    }

    private void setComponentPopupMenu(final Component parent, final JPopupMenu menu) {
        parent.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                if (parent.isEnabled()) {
                    menu.show(parent, 0, parent.getHeight());
                }
            }
        });
    }

    @Override
    public void onClose() {
        this.saveDraft();
        if (this.mMessageArea != null) {
            this.mMessageArea.onClose();
        }
        if (this.receiver != null) {
            UCChatClient.context.unregisterReceiver(this.receiver);
        }
        ListenerCleaner.cleanMouseListner(this.btnSendFile);
        ListenerCleaner.cleanMouseListner(this.btnScreenCapture);
        ListenerCleaner.cleanMouseListner(this.btnSendSticker);
        ListenerCleaner.cleanMouseListner(this.btnSendEmoticon);
        ListenerCleaner.cleanMouseListner(this.btnCall);
        ListenerCleaner.cleanMouseListner(this.btnHangup);
        ListenerCleaner.cleanMouseListner(this.btnMuteSelf);
        ListenerCleaner.cleanMouseListner(this.btnShowCallPage);
        ListenerCleaner.cleanMouseListner(this.btnCall2);
        ListenerCleaner.cleanMouseListner(this.btnHangup2);
        ListenerCleaner.cleanMouseListner(this.btnMuteSelf2);
        ListenerCleaner.cleanMouseListner(this.btnConfig);
        ListenerCleaner.cleanActionListner(this.sendButton);
        ListenerCleaner.cleanComponentListner(this.panelHeader);
        ListenerCleaner.cleanComponentListner(this.jPanel100);
        this.cleanConfigPopup();
        this.txtMessage.onClose();
        this.jSplitPane1.removeAll();
        this.mMessageArea = null;
        StickerPopupMenu menu = StickerPopupMenu.getInstance();
        menu.setMediaContentInputListener(null);
    }

    private void saveDraft() {
        if (this.txtMessage == null) {
            return;
        }
        if (this.txtMessage.isEnabled()) {
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String roomJid = this.getChatroomID();
            String existedDraftMsg = database.getPendingMessage(roomJid);
            String docText = this.txtMessage.getMessageTextWithIconKey();
            if (!TextUtils.isBlank((CharSequence)docText)) {
                database.savePendingMessage(roomJid, docText);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            } else if (TextUtils.isNotBlank((CharSequence)existedDraftMsg)) {
                database.deletePendingMessage(roomJid);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            }
        }
    }

    @Override
    public void onPhoneStatusChanged() {
        if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.btnCall.setToolTipText(I18NUtil.getString("phone_notice_not_connected"));
            this.jPanelCall1.setVisible(false);
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnCall2.setToolTipText(I18NUtil.getString("phone_notice_not_connected"));
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            return;
        }
        this.btnCall.setToolTipText(null);
        this.btnCall2.setToolTipText(null);
        if (this.chatMode == ChatMode.NORMAL) {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            this.handleNormalPhone();
        } else if (this.chatMode == ChatMode.ONLY_PHONE) {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
            this.handleOnlyPhone();
        } else {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
        }
    }

    private void handleNormalPhone() {
        int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
        if (lineIndex != -1) {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
            boolean isMuted = callLine.isMute();
            if (isMuted) {
                this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
            } else {
                this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
            }
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(true);
            return;
        }
        PhoneAgent.LineAvailableType isAvailableToCall = PhoneAgent.getInstance().isAvailableToCall();
        this.handleCallBtnText(isAvailableToCall != PhoneAgent.LineAvailableType.NONE, isAvailableToCall);
        this.revalidate();
        this.repaint();
    }

    private void handleCallBtnText(boolean btnEnable, PhoneAgent.LineAvailableType ableToCall) {
        if (btnEnable) {
            this.btnCall.setEnabled(true);
            this.btnCall.setVisible(true);
            this.jPanelCall1.setVisible(false);
        } else {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
        }
        if (!btnEnable) {
            this.btnCall.setText(I18NUtil.getString("abook_popup_btn_talk"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line1_full"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line2_full"));
        } else {
            this.btnCall.setText(I18NUtil.getString("abook_popup_btn_talk"));
        }
    }

    private void handleOnlyPhone() {
        int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
        if (lineIndex != -1) {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
            boolean isMuted = callLine.isMute();
            if (isMuted) {
                this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MUTE_SMALL);
                this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_unmute"));
            } else {
                this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MIC_SMALL);
                this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_mute"));
            }
            this.btnMuteSelf2.setPreferredSize(new Dimension(this.btnMuteSelf2.calculatePreferWidth(), 32));
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(true);
            this.btnHangup2.setVisible(true);
            this.btnMuteSelf2.setEnabled(true);
            this.btnMuteSelf2.setVisible(true);
            return;
        }
        PhoneAgent.LineAvailableType isAvailableToCall = PhoneAgent.getInstance().isAvailableToCall();
        this.handleCallBtn2Text(isAvailableToCall != PhoneAgent.LineAvailableType.NONE, isAvailableToCall);
        this.revalidate();
        this.repaint();
    }

    private void handleCallBtn2Text(boolean btnEnable, PhoneAgent.LineAvailableType ableToCall) {
        if (btnEnable) {
            this.btnCall2.setEnabled(true);
            this.btnCall2.setVisible(true);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
        } else {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
        }
        if (!btnEnable) {
            this.btnCall2.setText(I18NUtil.getString("abook_popup_btn_talk"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall2.setText(I18NUtil.getString("call_btn_callout_line1_full"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall2.setText(I18NUtil.getString("call_btn_callout_line2_full"));
        } else {
            this.btnCall2.setText(I18NUtil.getString("abook_popup_btn_talk"));
        }
        this.btnCall2.setPreferredSize(new Dimension(this.btnCall2.calculatePreferWidth(), 32));
    }

    private void group_listChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Chatroom.this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(Chatroom.this.mRoomJid));
            }
        });
    }

    private void web_participantPhotoChanged() {
        Image image;
        LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, this.mRoomJid);
        final Image participantPhotoImage = image = ContactManager.getContactImage(contact, 64, false, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (participantPhotoImage == null) {
                    Chatroom.this.lblPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
                } else {
                    Chatroom.this.lblPhoto.setImage(participantPhotoImage);
                }
            }
        });
        if (this.mMessageArea != null) {
            this.mMessageArea.reloadPage();
        }
    }

    private void web_externalPhotoChanged() {
        Image image;
        LiteMyContact contact = ContactManager.getExternalContact((Context)UCChatClient.context, this.mRoomJid);
        final Image participantPhotoImage = image = ContactManager.getExternalContactImage(contact, 64, false, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (participantPhotoImage == null) {
                    Chatroom.this.lblPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
                } else {
                    Chatroom.this.lblPhoto.setImage(participantPhotoImage);
                }
            }
        });
        if (this.mMessageArea != null) {
            this.mMessageArea.reloadPage();
        }
    }

    private void web_channelPhotoChanged() {
        Image image;
        MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(UCChatClient.context, this.mRoomJid);
        final Image participantPhotoImage = image = MessageChannelManager.getMessageChannelImage(channel, 64, false, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (participantPhotoImage == null) {
                    Chatroom.this.lblPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
                } else {
                    Chatroom.this.lblPhoto.setImage(participantPhotoImage);
                }
            }
        });
        if (this.mMessageArea != null) {
            this.mMessageArea.reloadPage();
        }
    }

    public static enum ChatMode {
        NORMAL,
        DISABLED,
        ONLY_PHONE,
        DELETED;

    }

    class InviteMemberAction
    extends AbstractAction {
        public InviteMemberAction(boolean showText) {
            if (showText) {
                this.putValue("Name", I18NUtil.getString("chatroom_label_invite_participants"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("chatroom_label_invite_participants"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            HashSet<String> exculsiveJIDs = new HashSet<String>();
            exculsiveJIDs.add(PreferencesUtil.getUserJid(UCChatClient.context));
            exculsiveJIDs.add(Chatroom.this.mRoomJid);
            List itemList = UCDBContact.getContactsOrderByName(UCChatClient.context, null, 0, exculsiveJIDs);
            ArrayList<LiteContact> candidateContacts = new ArrayList<LiteContact>();
            for (AddressBookGroup groupResult : itemList) {
                for (LiteContact c : groupResult.getDataList()) {
                    if (!JidUtil.isEmployeeJid(c.getJid())) continue;
                    candidateContacts.add(c);
                }
            }
            MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
            SelectContactResult result = mainPanel.showSelectContactDialog(I18NUtil.getString("chatroom_select_members_to_invite"), candidateContacts);
            if (result != null) {
                List<LiteContact> participants = result.getParticipants();
                ArrayList<String> participantJIDs = new ArrayList<String>();
                participantJIDs.add(0, Chatroom.this.mRoomJid);
                for (LiteContact participant : participants) {
                    participantJIDs.add(participant.getJid());
                }
                WebAgent.getInstance().createChatRoom("-subject-", participantJIDs);
            }
        }
    }
}

