/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.bean.ImageBean;
import com.blisscloud.ezuc.client.bean.SelectContactResult;
import com.blisscloud.ezuc.client.chat.ChatRoomItem;
import com.blisscloud.ezuc.client.chat.ChatRoomMember;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.IMultiUserChatroom;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.MessageDropperField;
import com.blisscloud.ezuc.client.chat.MessageInput;
import com.blisscloud.ezuc.client.chat.popup.EmoticonPopupMenu;
import com.blisscloud.ezuc.client.chat.popup.MediaContentInputListener;
import com.blisscloud.ezuc.client.chat.popup.StickerPopupMenu;
import com.blisscloud.ezuc.client.chat.roomimpl.BaseChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ChangeChatroomNamePanel;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ListenerCleaner;
import com.blisscloud.ezuc.client.chat.roomimpl.ReferenceOut;
import com.blisscloud.ezuc.client.chat.roomimpl.WidgetPanel;
import com.blisscloud.ezuc.client.component.GradientPanel;
import com.blisscloud.ezuc.client.component.ImageLabel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.main.SelectMeetmeItemResult;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.sorter.ChatRoomMemberListSorter;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.screen.CaptureUtil;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;

public class MultiUserChatroom
extends BaseChatroom
implements IMultiUserChatroom,
MessageDropperField {
    private static final long serialVersionUID = 7052338796160515597L;
    public static final String ACTION_NONE = "[none]";
    public static final String ACTION_PLUS = "[plus]";
    public static final String ACTION_ENDMEET = "[endmeet]";
    public static final String ACTION_LOCK = "[lock]";
    public static final String ACTION_ALLMUTE = "[allmute]";
    public static final String ACTION_MUTE = "[mute]";
    public static final String ACTION_MINUS = "[minus]";
    private boolean mMinusSelection = false;
    private MucRoomLayoutMode layoutMode = MucRoomLayoutMode.MEMBER;
    private ChatMode chatMode = null;
    private JLabel disableReasonLabel;
    private JPanel panelHeader;
    private JLabel lblPhoto;
    private JPanel panelTitle;
    private JLabel lblSubject;
    private JLabel lblNo;
    private JLabel headerMember;
    private JLabel lblMemberCount;
    private ImageLabel btnLayout;
    private ImageLabel btnConfig;
    private JPopupMenu popupMenuConfig;
    private JSplitPane jSplitPane1 = null;
    private JSplitPane jSplitPane2 = null;
    private JPanel jPanel5;
    private WidgetPanel panelControl;
    private ImageLabel btnAddMember;
    private ImageLabel btnRemoveMember;
    private JScrollPane spParticipant;
    private WidgetPanel panelParticipant;
    private JScrollPane spMessage;
    private JPanel jToolBar1;
    private JPanel jPanel100;
    private JPanel spMessageOut;
    private ReferenceOut referenceMsgOut;
    private JLabel lblPadding;
    private JSeparator jSeparator0;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private ImageLabel btnSendFile;
    private ImageLabel btnScreenCapture;
    private ImageLabel btnSendSticker;
    private ImageLabel btnSendEmoticon;
    private ImageLabel btnCall;
    private ImageLabel btnHangup;
    private ImageLabel btnMuteSelf;
    private ImageLabel btnShowCallPage;
    private JPanel jPanelCall1;
    private JPanel mMenuPanel;
    private ImageLabel btnCall2;
    private ImageLabel btnHangup2;
    private ImageLabel btnMuteSelf2;
    private ShowMeetmeMsgAction showMeetmeAction = new ShowMeetmeMsgAction(true);
    private ChangeChatroomNameAction changeChatroomNameAction = new ChangeChatroomNameAction(true);
    private MyChatRoomAction myChatRoomAction = new MyChatRoomAction(true);
    private RemoveMemberAction removeMemberAction = new RemoveMemberAction(true);
    private AddMemberAction addMemberAction = new AddMemberAction(true);
    private ExitRoomAction exitRoomAction = new ExitRoomAction(true);
    private LiteConferenceRoom meetmeRoom;
    private List<ChatRoomItem> mParticipantsDataList = Collections.synchronizedList(new ArrayList());
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private JPanel sendBtnPanel = null;
    private boolean showMuteMsg = false;
    private JButton sendButton = null;
    private String mQuotePackageId;
    private boolean manualSelectedLayout = false;

    public MultiUserChatroom(String roomJid, JPanel parent) {
        super(roomJid, parent);
        this.mMessageArea = new MessageArea(roomJid, false, this);
        this.initGUI();
        this.initReceiver();
        this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.mRoomJid);
        if (this.meetmeRoom != null) {
            WebAgent.getInstance().queryMeetMeListUser(this.meetmeRoom.getRoomId());
        }
        this.updateRoom();
        this.refreshParticipants("Constructor", true);
        this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(this.mRoomJid));
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        boolean isEnabled = !database.isDisableNotification(this.mRoomJid);
        this.updateNotificationAction(isEnabled);
        this.updateMyChatRoomAction(ChatRoomManager.isInMyChatRoom(this.mRoomJid));
        this.updateMeetmeShowAction(PreferencesUtil.isMeetmeShowEnabled(UCChatClient.context, this.mRoomJid));
        this.updateRemoveMemberAction();
    }

    @Override
    public ChatroomType getChatroomType() {
        return ChatroomType.MULTI;
    }

    @Override
    public void updateRoom() {
        this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.mRoomJid);
        ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, this.mRoomJid);
        String chatRoomTitle = ChatRoomUtil.getChatRoomTitle(UCChatClient.context, roomInfo);
        Object roomNo = "";
        if (this.meetmeRoom != null) {
            roomNo = " (" + OutboundPrefixManager.getMeetmePrefix(UCChatClient.context) + this.meetmeRoom.getRoomNo() + ")";
        }
        this.mRoomDisplayName = chatRoomTitle + (String)roomNo;
        this.lblSubject.setText(this.mRoomDisplayName);
        boolean roomJoined = UCDBChatRoom.hasParticipants(UCChatClient.context, this.mRoomJid);
        Log.i(MultiUserChatroom.class.getSimpleName(), this.mRoomJid + " hasParticipants:" + roomJoined);
        if (roomJoined) {
            this.setLayoutMode(MucRoomLayoutMode.MEMBER);
            boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
            if (hasChatPermission) {
                this.setChatMode(ChatMode.NORMAL);
            } else {
                this.setChatMode(ChatMode.ONLY_PHONE);
            }
        } else {
            this.setLayoutMode(MucRoomLayoutMode.NO_MEMBER);
            this.setChatMode(ChatMode.DISABLED);
        }
    }

    public ChatMode getChatMode() {
        return this.chatMode;
    }

    public void setChatMode(ChatMode mode) {
        if (this.chatMode == mode) {
            return;
        }
        this.chatMode = mode;
        switch (this.chatMode) {
            case NORMAL: {
                this.disableReasonLabel.setVisible(false);
                this.disableReasonLabel.setText("");
                this.btnConfig.setEnabled(true);
                this.btnSendFile.setEnabled(true);
                this.btnScreenCapture.setEnabled(true);
                this.btnSendSticker.setEnabled(true);
                this.btnSendEmoticon.setEnabled(true);
                if (!this.txtMessage.isEnabled()) {
                    this.txtMessage.setText("");
                }
                this.txtMessage.setEnabled(true);
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                if (!this.jPanel100.isVisible()) {
                    this.btnCall.setEnabled(true);
                    this.btnCall.setVisible(true);
                    this.jPanelCall1.setVisible(true);
                    this.btnLayout.setVisible(true);
                    this.btnConfig.setVisible(true);
                    this.jToolBar1.setVisible(true);
                    this.spMessage.setVisible(true);
                    this.jPanel100.setVisible(true);
                    this.sendBtnPanel.setVisible(true);
                    if (this.panelHeader.getHeight() >= 0) {
                        int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                        int loc = this.mPanrent.getHeight() - this.panelHeader.getHeight() - panelHeight;
                        if (loc > 200 && panelHeight > 200) {
                            this.jSplitPane1.setDividerLocation(loc);
                        } else {
                            this.jSplitPane1.setDividerLocation(0.7);
                        }
                    }
                }
                this.onPhoneStatusChanged();
                break;
            }
            case ONLY_PHONE: {
                this.disableReasonLabel.setVisible(false);
                this.disableReasonLabel.setText("");
                this.btnConfig.setEnabled(true);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(true);
                this.btnCall2.setVisible(true);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnLayout.setVisible(true);
                this.btnConfig.setVisible(true);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
                this.onPhoneStatusChanged();
                break;
            }
            case DISABLED: {
                this.disableReasonLabel.setVisible(false);
                this.disableReasonLabel.setText("");
                this.btnConfig.setEnabled(false);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnLayout.setVisible(false);
                this.btnConfig.setVisible(false);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
            }
        }
    }

    private synchronized void refreshParticipants(String from, boolean syncData) {
        ChatRoomMember m;
        Object meetmeUsers;
        Log.i(MultiUserChatroom.class.getSimpleName(), "refreshParticipants ..........................action: " + from);
        Activity ctx = UCChatClient.context;
        ArrayList<ChatRoomMember> itemList = new ArrayList<ChatRoomMember>();
        ArrayList<String> chatParticipants = UCDBChatRoom.findChatRoomParticipants((Context)ctx, this.mRoomJid);
        this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.mRoomJid);
        HashSet<Long> idSet = new HashSet<Long>();
        boolean isWholeCompany = PreferencesUtil.isAddressBookScopeWholeCompany(UCChatClient.context);
        Set<Long> scopeEmpSet = PreferencesUtil.getAddressBookScopeEmpList(UCChatClient.context);
        Set<Long> extraEmpSet = PreferencesUtil.getAddressBookExtraEmpList(UCChatClient.context);
        if (this.meetmeRoom != null && (meetmeUsers = MeetmeManager.getMeetmeUserList(ctx, this.meetmeRoom.getRoomId())) != null) {
            Iterator iterator = meetmeUsers.iterator();
            while (iterator.hasNext()) {
                LiteConferenceUserStatus meetmeUser = (LiteConferenceUserStatus)iterator.next();
                m = new ChatRoomMember();
                m.setMeetmeOn(true);
                m.setMeetmeUserNo(meetmeUser.getUserNo());
                m.setMeetmeIsMute(meetmeUser.isMuted());
                m.setAdmin(false);
                String callerType = meetmeUser.getCallerType();
                if ("EMPLOYEE".equals(callerType)) {
                    LiteContact contact;
                    String callerDBId;
                    String string = callerDBId = meetmeUser.getCallerDbId() == null ? null : meetmeUser.getCallerDbId().trim();
                    if (TextUtils.isBlank((CharSequence)callerDBId)) continue;
                    Long empId = Long.parseLong(meetmeUser.getCallerDbId());
                    if (!(isWholeCompany || scopeEmpSet.contains(empId) || extraEmpSet.contains(empId))) {
                        idSet.add(empId);
                    }
                    if ((contact = ContactManager.getContact((Context)ctx, empId)) != null) {
                        m.setTitle(ContactManager.getContactShortName((Context)ctx, contact));
                        m.setJid(contact.getJid());
                        m.setContact(contact);
                        chatParticipants.remove(contact.getJid());
                    } else {
                        m.setTitle(meetmeUser.getCallerIdNumber());
                        m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                    }
                } else if ("LOCATION".equals(callerType)) {
                    String locationJid = ContactManager.getJidByLocId(ctx, meetmeUser.getCallerIdNumberSite(), meetmeUser.getCallerIdNumber());
                    LiteContact locContact = null;
                    if (locationJid != null) {
                        locContact = ContactManager.getContact((Context)ctx, locationJid);
                    }
                    if (locContact != null) {
                        m.setTitle(ContactManager.getContactFullName(locContact));
                        m.setJid(locContact.getJid());
                        m.setContact(locContact);
                    } else {
                        m.setTitle(meetmeUser.getCallerIdNumber());
                        m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                    }
                } else {
                    PhoneMatcherResult result = PhoneMatcher.match(ctx, meetmeUser.getCallerIdNumber(), true);
                    if (result != null) {
                        if (result.getMatchType() == 0 || result.getMatchType() == 4) {
                            contact = result.getContact();
                            m.setTitle(ContactManager.getContactShortName((Context)ctx, contact));
                            m.setJid(contact.getJid());
                            m.setContact(contact);
                            chatParticipants.remove(result.getTargetJid());
                        } else if (result.getMatchType() == 1) {
                            contact = result.getContact();
                            m.setTitle(ContactManager.getContactFullName(contact));
                            m.setJid(contact.getJid());
                            m.setContact(contact);
                        } else if (result.getMatchType() == 5) {
                            m.setTitle(result.getTargetName());
                            m.setJid(result.getTargetJid());
                        } else {
                            m.setTitle(meetmeUser.getCallerIdNumber());
                            m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                        }
                    } else {
                        m.setTitle(meetmeUser.getCallerIdNumber());
                        m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                    }
                }
                itemList.add(m);
            }
        }
        if (chatParticipants != null) {
            for (String jid : chatParticipants) {
                LiteContact contact = ContactManager.getContact((Context)ctx, jid);
                if (contact == null) continue;
                m = new ChatRoomMember();
                if (JidUtil.isEmployeeJid(contact.getJid())) {
                    long empId = contact.getId();
                    if (!(isWholeCompany || scopeEmpSet.contains(empId) || extraEmpSet.contains(empId))) {
                        idSet.add(empId);
                    }
                    m.setTitle(ContactManager.getContactShortName((Context)ctx, contact));
                    m.setJid(contact.getJid());
                    m.setContact(contact);
                    m.setMeetmeOn(false);
                    m.setAdmin(false);
                } else {
                    m.setTitle(ContactManager.getContactFullName(contact));
                    m.setJid(contact.getJid());
                    m.setContact(contact);
                    m.setMeetmeOn(false);
                    m.setAdmin(false);
                }
                itemList.add(m);
            }
        }
        if (idSet.size() > 0) {
            long timestamp = UCDBChatRoom.getMemberTimestamp(ctx, this.mRoomJid);
            if (syncData || System.currentTimeMillis() - timestamp > 600000L) {
                WebAgent.getInstance().refreshChatRoomMemberListByIds(this.mRoomJid, timestamp, idSet);
            }
        }
        Collections.sort(itemList, new ChatRoomMemberListSorter());
        this.mParticipantsDataList.clear();
        this.mParticipantsDataList.addAll(itemList);
        this.cleanPanelParticipant();
        this.refreshSelectionList();
        ArrayList<ImageBean> participantImageBeans = new ArrayList<ImageBean>();
        ArrayList<ImageBean> defaultImageBeans = new ArrayList<ImageBean>();
        for (ChatRoomItem item : this.mParticipantsDataList) {
            if (!(item instanceof ChatRoomMember)) continue;
            ChatRoomMember member = (ChatRoomMember)item;
            this.addParticipantItem(member, participantImageBeans, defaultImageBeans);
            Log.i(MultiUserChatroom.class.getSimpleName(), this.mRoomJid + " current member:" + member.getJid());
        }
        boolean inChatroom = this.isInRoom(this.mParticipantsDataList, this.myJid);
        Log.i(MultiUserChatroom.class.getSimpleName(), this.mRoomJid + " inChatroom:" + inChatroom);
        if (this.chatMode == ChatMode.DISABLED && inChatroom) {
            boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
            if (hasChatPermission) {
                this.setChatMode(ChatMode.NORMAL);
            } else {
                this.setChatMode(ChatMode.ONLY_PHONE);
            }
        } else if (this.chatMode == ChatMode.NORMAL && !inChatroom) {
            this.setChatMode(ChatMode.DISABLED);
        } else if (this.chatMode == ChatMode.ONLY_PHONE && !inChatroom) {
            this.setChatMode(ChatMode.DISABLED);
        }
        participantImageBeans.addAll(defaultImageBeans);
        if (participantImageBeans != null && participantImageBeans.size() == 1) {
            ImageBean imageBean = (ImageBean)participantImageBeans.get(0);
            ChatRoomMember chatRoomMember = imageBean.getChatRoomMember();
            ArrayList<ImageBean> participantImageBeanRound2 = new ArrayList<ImageBean>();
            ArrayList<ImageBean> defaultImageBeanRound2 = new ArrayList<ImageBean>();
            if (JidUtil.isEmployeeJid(chatRoomMember.getJid())) {
                this.getEmpParticipantImage(chatRoomMember, participantImageBeanRound2, defaultImageBeanRound2, false, true);
            } else if (JidUtil.isLocationJid(chatRoomMember.getJid())) {
                this.getLocationParticipantImage(chatRoomMember, participantImageBeanRound2, defaultImageBeanRound2, false, true);
            } else if (JidUtil.isMyContactJid(chatRoomMember.getJid())) {
                this.getMyContactParticipantImage(chatRoomMember, participantImageBeanRound2, defaultImageBeanRound2, false, true);
            } else {
                this.getNomanParticipantImage(chatRoomMember, participantImageBeanRound2, defaultImageBeanRound2, false, true);
            }
            participantImageBeanRound2.addAll(defaultImageBeanRound2);
            if (participantImageBeanRound2.size() != 0) {
                ImageBean imageBeanRound2 = (ImageBean)participantImageBeanRound2.get(0);
                this.lblPhoto.setIcon(new ImageIcon(imageBeanRound2.getImage()));
            }
        } else {
            ArrayList<Image> participantImages = new ArrayList<Image>();
            for (ImageBean imageBean : participantImageBeans) {
                if (imageBean == null) continue;
                participantImages.add(imageBean.getImage());
            }
            Image compoundedImage = GraphicUtil.getCompoundRoundedCornerImage(participantImages, 64, 64, true, true);
            this.lblPhoto.setIcon(new ImageIcon(compoundedImage));
        }
    }

    private boolean isInRoom(List<ChatRoomItem> itemList, String myJid) {
        for (ChatRoomItem x : itemList) {
            ChatRoomMember m;
            if (!(x instanceof ChatRoomMember) || !myJid.equalsIgnoreCase((m = (ChatRoomMember)x).getJid())) continue;
            return true;
        }
        return false;
    }

    private void updateRemoveMemberAction() {
        if (this.removeMemberAction == null) {
            return;
        }
        this.removeMemberAction.setEnabled(this.mParticipantsDataList.size() > 0);
    }

    @Override
    public void updateMyChatRoomAction(boolean isMyChatRoom) {
        if (this.myChatRoomAction == null) {
            return;
        }
        if (isMyChatRoom) {
            if (this.myChatRoomAction.showText) {
                this.myChatRoomAction.putValue("Name", I18NUtil.getString("abook_fun_remove_from_my_chatrooms"));
            } else {
                this.myChatRoomAction.putValue("ShortDescription", I18NUtil.getString("abook_fun_remove_from_my_chatrooms"));
            }
        } else if (this.myChatRoomAction.showText) {
            this.myChatRoomAction.putValue("Name", I18NUtil.getString("abook_fun_add_to_my_chatrooms"));
        } else {
            this.myChatRoomAction.putValue("ShortDescription", I18NUtil.getString("abook_fun_add_to_my_chatrooms"));
        }
    }

    public void updateMeetmeShowAction(boolean meetmeShow) {
        if (this.showMeetmeAction == null) {
            return;
        }
        if (meetmeShow) {
            if (this.showMeetmeAction.showText) {
                this.showMeetmeAction.putValue("Name", I18NUtil.getString("conference_btn_hide_voice_action"));
            } else {
                this.showMeetmeAction.putValue("ShortDescription", I18NUtil.getString("conference_btn_hide_voice_action"));
            }
        } else if (this.showMeetmeAction.showText) {
            this.showMeetmeAction.putValue("Name", I18NUtil.getString("conference_btn_display_voice_action"));
        } else {
            this.showMeetmeAction.putValue("ShortDescription", I18NUtil.getString("conference_btn_display_voice_action"));
        }
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(640, 480));
            this.setMinimumSize(new Dimension(520, 300));
            this.panelHeader = new GradientPanel(1, UIConstants.COLOR_HEADER_BACKGROUND_FROM, UIConstants.COLOR_HEADER_BACKGROUND_TO);
            this.add((Component)this.panelHeader, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.panelHeader.setLayout(jPanel1Layout);
            this.panelHeader.setBorder(UIConstants.BORDER_HEADER);
            this.lblPhoto = new JLabel();
            this.panelHeader.add((Component)this.lblPhoto, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPhoto.setIcon(GraphicUtil.scale(UIConstants.ICON_CHATROOM_64, 64, 64));
            this.lblPhoto.setPreferredSize(new Dimension(64, 64));
            this.lblPhoto.setMinimumSize(new Dimension(64, 64));
            this.lblPhoto.setMaximumSize(new Dimension(64, 64));
            this.panelTitle = new JPanel();
            this.panelHeader.add((Component)this.panelTitle, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 12, 0, 0), 0, 0));
            BoxLayout panelTitleLayout = new BoxLayout(this.panelTitle, 0);
            this.panelTitle.setLayout(panelTitleLayout);
            this.panelTitle.setOpaque(false);
            this.lblSubject = new JLabel();
            this.panelTitle.add(this.lblSubject);
            this.lblSubject.setFont(UIConstants.FONT_14_BOLD);
            this.mRoomDisplayName = " ";
            this.lblSubject.setText(this.mRoomDisplayName);
            this.panelTitle.add(Box.createHorizontalStrut(5));
            this.lblNo = new JLabel();
            this.panelTitle.add(this.lblNo);
            this.lblNo.setFont(UIConstants.FONT_14_BOLD);
            this.lblNo.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.headerMember = new JLabel();
            this.panelHeader.add((Component)this.headerMember, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 12, 0, 0), 0, 0));
            this.headerMember.setText(I18NUtil.getString("chatroom_label_participants") + " : ");
            this.headerMember.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblMemberCount = new JLabel();
            this.panelHeader.add((Component)this.lblMemberCount, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 8, 0, 0), 0, 0));
            this.lblMemberCount.setText(String.format(I18NUtil.getString("chat_label_participant_count"), 0));
            this.mMenuPanel = new JPanel();
            this.mMenuPanel.setOpaque(false);
            FlowLayout panelEndcallLayout = new FlowLayout();
            panelEndcallLayout.setAlignment(0);
            panelEndcallLayout.setVgap(0);
            panelEndcallLayout.setHgap(5);
            this.mMenuPanel.setLayout(panelEndcallLayout);
            this.panelHeader.add((Component)this.mMenuPanel, new GridBagConstraints(3, 0, 1, 3, 0.0, 0.0, 12, 3, new Insets(5, 5, 0, 0), 0, 0));
            this.btnCall2 = new ImageLabel((Icon)UIConstants.ICON_VOICE_CALL_SMALL, I18NUtil.getString("abook_popup_btn_talk"));
            this.mMenuPanel.add(this.btnCall2);
            this.btnCall2.setPreferredSize(new Dimension(this.btnCall2.calculatePreferWidth(), 32));
            this.btnCall2.setHorizontalAlignment(0);
            this.btnCall2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnCall2.setCursor(UIConstants.CURSOR_HAND);
            this.btnCall2.setArc(12);
            this.btnCall2.setVisible(false);
            this.btnCall2.setEnabled(false);
            this.btnCall2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnCall2.isEnabled()) {
                        Log.i(Chatroom.class.getSimpleName(), "room start dial:" + MultiUserChatroom.this.mRoomJid);
                        ChatRoomManager.startDialOut(MultiUserChatroom.this.btnCall2, MultiUserChatroom.this.mRoomJid);
                    }
                }
            });
            this.btnHangup2 = new ImageLabel((Icon)UIConstants.ICON_VOICE_END_SMALL, I18NUtil.getString("call_btn_hangup"));
            this.mMenuPanel.add(this.btnHangup2);
            this.btnHangup2.setPreferredSize(new Dimension(this.btnHangup2.calculatePreferWidth(), 32));
            this.btnHangup2.setHorizontalAlignment(0);
            this.btnHangup2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnHangup2.setCursor(UIConstants.CURSOR_HAND);
            this.btnHangup2.setArc(12);
            this.btnHangup2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnHangup2.isEnabled()) {
                        PhoneAgent.getInstance().hangupMeetme(MultiUserChatroom.this.mRoomJid);
                    }
                }
            });
            this.btnMuteSelf2 = new ImageLabel((Icon)UIConstants.ICON_CHAT_MIC_SMALL, I18NUtil.getString("call_btn_click_mute"));
            this.mMenuPanel.add(this.btnMuteSelf2);
            this.btnMuteSelf2.setPreferredSize(new Dimension(this.btnMuteSelf2.calculatePreferWidth(), 32));
            this.btnMuteSelf2.setHorizontalAlignment(0);
            this.btnMuteSelf2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnMuteSelf2.setCursor(UIConstants.CURSOR_HAND);
            this.btnMuteSelf2.setArc(12);
            this.btnMuteSelf2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MultiUserChatroom.this.onClickMuteButton();
                }
            });
            this.btnLayout = new ImageLabel(MucRoomLayoutMode.NO_MEMBER.getIcon());
            this.mMenuPanel.add(this.btnLayout);
            this.btnLayout.setToolTipText(MucRoomLayoutMode.MEMBER.getToolTip());
            this.btnLayout.setPreferredSize(new Dimension(40, 32));
            this.btnLayout.setMinimumSize(new Dimension(40, 32));
            this.btnLayout.setMaximumSize(new Dimension(40, 32));
            this.btnLayout.setHorizontalAlignment(0);
            this.btnLayout.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnLayout.setCursor(UIConstants.CURSOR_HAND);
            this.btnLayout.setArc(12);
            this.btnLayout.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (MultiUserChatroom.this.btnLayout.isEnabled()) {
                        MultiUserChatroom.this.switchLayout();
                    }
                }
            });
            this.btnConfig = new ImageLabel(UIConstants.ICON_MENU);
            this.mMenuPanel.add(this.btnConfig);
            this.btnConfig.setToolTipText(I18NUtil.getString("common_btn_config"));
            this.btnConfig.setPreferredSize(new Dimension(32, 32));
            this.btnConfig.setMinimumSize(new Dimension(32, 32));
            this.btnConfig.setMaximumSize(new Dimension(32, 32));
            this.btnConfig.setHorizontalAlignment(0);
            this.btnConfig.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnConfig.setCursor(UIConstants.CURSOR_HAND);
            this.btnConfig.setArc(12);
            this.popupMenuConfig = new JPopupMenu();
            this.setComponentPopupMenu(this.btnConfig, this.popupMenuConfig);
            this.disableReasonLabel = new JLabel();
            this.disableReasonLabel.setFont(UIConstants.FONT_16_PLAIN);
            this.disableReasonLabel.setText("");
            this.disableReasonLabel.setVisible(false);
            this.panelHeader.add((Component)this.disableReasonLabel, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panelHeader.add((Component)this.getSearchControlPanel(), new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane2 = new JSplitPane(1);
            this.jSplitPane2.setResizeWeight(1.0);
            this.jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
            this.add((Component)this.jSplitPane2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1 = new JSplitPane(0);
            this.jSplitPane1.setResizeWeight(1.0);
            this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
            this.jSplitPane2.add((Component)this.jSplitPane1, "left");
            this.jSplitPane1.add((Component)this.getMessageLayerPanel(), "top");
            this.jPanel100 = new JPanel();
            BorderLayout jPanel100Layout = new BorderLayout();
            this.jPanel100.setLayout(jPanel100Layout);
            this.jSplitPane1.add((Component)this.jPanel100, "bottom");
            this.spMessageOut = new JPanel();
            this.spMessageOut.setLayout(new BorderLayout());
            this.jPanel100.add((Component)this.spMessageOut, "Center");
            this.jToolBar1 = new JPanel();
            this.jPanel100.add((Component)this.jToolBar1, "North");
            GridBagLayout jToolBar1Layout = new GridBagLayout();
            this.jToolBar1.setLayout(jToolBar1Layout);
            this.jToolBar1.setBorder(UIConstants.BORDER_MESSAGE_TOOLBAR);
            int x = 0;
            boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
            boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
            this.btnSendFile = new ImageLabel((Icon)UIConstants.ICON_FILE, I18NUtil.getString("chat_btn_send_file"));
            this.jToolBar1.add((Component)this.btnSendFile, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnSendFile.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendFile.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendFile.setNormalBorderColor(null);
            this.btnSendFile.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendFile.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnSendFile.isEnabled()) {
                        MultiUserChatroom.this.btnSendFileMouseClicked(evt);
                    }
                }
            });
            this.btnSendFile.setVisible(hasFilePermission);
            this.jSeparator0 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator0, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator0.setPreferredSize(new Dimension(2, 20));
            this.jSeparator0.setOrientation(1);
            this.jSeparator0.setVisible(hasFilePermission);
            this.btnScreenCapture = new ImageLabel((Icon)UIConstants.ICON_SCREEN_CAPTURE, I18NUtil.getString("chat_btn_screen_capture"));
            this.jToolBar1.add((Component)this.btnScreenCapture, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnScreenCapture.setFont(UIConstants.FONT_14_PLAIN);
            this.btnScreenCapture.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnScreenCapture.setNormalBorderColor(null);
            this.btnScreenCapture.setCursor(UIConstants.CURSOR_HAND);
            this.btnScreenCapture.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnScreenCapture.isEnabled()) {
                        MultiUserChatroom.this.btnScreenCaptureMouseClicked(evt);
                    }
                }
            });
            this.btnScreenCapture.setVisible(hasPhotoPermission);
            this.jSeparator1 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator1, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator1.setPreferredSize(new Dimension(2, 20));
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setVisible(hasPhotoPermission);
            this.btnSendSticker = new ImageLabel((Icon)UIConstants.ICON_STICKER, I18NUtil.getString("chat_msg_type_sticker"));
            this.jToolBar1.add((Component)this.btnSendSticker, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnSendSticker.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendSticker.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendSticker.setNormalBorderColor(null);
            this.btnSendSticker.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendSticker.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnSendSticker.isEnabled()) {
                        MultiUserChatroom.this.btnSendStickerMouseClicked(evt);
                    }
                }
            });
            this.jSeparator2 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator2, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator2.setPreferredSize(new Dimension(2, 20));
            this.jSeparator2.setOrientation(1);
            this.btnSendEmoticon = new ImageLabel((Icon)UIConstants.ICON_EMOTICON, I18NUtil.getString("chat_msg_type_emoticon"));
            this.jToolBar1.add((Component)this.btnSendEmoticon, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnSendEmoticon.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendEmoticon.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendEmoticon.setNormalBorderColor(null);
            this.btnSendEmoticon.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendEmoticon.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnSendEmoticon.isEnabled()) {
                        MultiUserChatroom.this.btnSendEmoticonMouseClicked(evt);
                    }
                }
            });
            this.lblPadding = new JLabel();
            this.jToolBar1.add((Component)this.lblPadding, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCall = new ImageLabel((Icon)UIConstants.ICON_VOICE_CHAT, I18NUtil.getString("abook_popup_btn_talk"));
            this.jToolBar1.add((Component)this.btnCall, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCall.setFont(UIConstants.FONT_14_PLAIN);
            this.btnCall.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnCall.setNormalBorderColor(null);
            this.btnCall.setCursor(UIConstants.CURSOR_HAND);
            this.btnCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnCall.isEnabled()) {
                        Log.i(MultiUserChatroom.class.getSimpleName(), "multiuser start dial:" + MultiUserChatroom.this.mRoomJid);
                        ChatRoomManager.startDialOut(MultiUserChatroom.this.btnCall, MultiUserChatroom.this.mRoomJid);
                    }
                }
            });
            this.jPanelCall1 = new JPanel();
            FlowLayout panelEndcallLayout2 = new FlowLayout();
            panelEndcallLayout2.setAlignment(0);
            panelEndcallLayout2.setVgap(0);
            this.jPanelCall1.setLayout(panelEndcallLayout2);
            this.jToolBar1.add((Component)this.jPanelCall1, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnHangup = new ImageLabel(UIConstants.ICON_VOICE_END);
            this.jPanelCall1.add(this.btnHangup);
            this.btnHangup.setToolTipText(I18NUtil.getString("call_btn_hangup"));
            this.btnHangup.setFont(UIConstants.FONT_14_PLAIN);
            this.btnHangup.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnHangup.setNormalBorderColor(null);
            this.btnHangup.setCursor(UIConstants.CURSOR_HAND);
            this.btnHangup.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    int result;
                    if (MultiUserChatroom.this.btnHangup.isEnabled() && (result = JOptionPane.showConfirmDialog(MultiUserChatroom.this, I18NUtil.getString("call_title_meetme_hangup_confirm"), I18NUtil.getString("common_title_warning"), 2, 2)) == 0) {
                        PhoneAgent.getInstance().hangupMeetme(MultiUserChatroom.this.mRoomJid);
                    }
                }
            });
            this.jSeparator3 = new JSeparator();
            this.jPanelCall1.add(this.jSeparator3);
            this.jSeparator3.setPreferredSize(new Dimension(2, 20));
            this.jSeparator3.setOrientation(1);
            this.btnMuteSelf = new ImageLabel(UIConstants.ICON_CHAT_MIC);
            this.jPanelCall1.add(this.btnMuteSelf);
            this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
            this.btnMuteSelf.setFont(UIConstants.FONT_14_PLAIN);
            this.btnMuteSelf.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnMuteSelf.setNormalBorderColor(null);
            this.btnMuteSelf.setCursor(UIConstants.CURSOR_HAND);
            this.btnMuteSelf.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnMuteSelf.isEnabled()) {
                        MultiUserChatroom.this.onClickMuteButton();
                    }
                }
            });
            this.jSeparator4 = new JSeparator();
            this.jPanelCall1.add(this.jSeparator4);
            this.jSeparator4.setPreferredSize(new Dimension(2, 20));
            this.jSeparator4.setOrientation(1);
            this.btnShowCallPage = new ImageLabel(UIConstants.ICON_SHOW_CALL_PAGE);
            this.jPanelCall1.add(this.btnShowCallPage);
            this.btnShowCallPage.setToolTipText(I18NUtil.getString("chatroom_btn_switch_to_call_view"));
            this.btnShowCallPage.setFont(UIConstants.FONT_14_PLAIN);
            this.btnShowCallPage.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnShowCallPage.setNormalBorderColor(null);
            this.btnShowCallPage.setCursor(UIConstants.CURSOR_HAND);
            this.btnShowCallPage.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MultiUserChatroom.this.btnShowCallPage.isEnabled()) {
                        UCChatClient.getInstance().getMainPanel().getViewContainer().showPhonePanel(MultiUserChatroom.this.mRoomJid);
                    }
                }
            });
            this.spMessage = new UCScrollPane();
            this.spMessageOut.add((Component)this.spMessage, "Center");
            this.spMessage.setPreferredSize(new Dimension(300, 130));
            this.txtMessage = new MessageInput(new MessageInput.MessageInputCallback(){

                @Override
                public void onSendMessage(String text) {
                    if (TextUtils.isNotBlank((CharSequence)text)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(MultiUserChatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(MultiUserChatroom.this.mQuotePackageId, chatReceiverList, text)) {
                            MultiUserChatroom.this.txtMessage.setText("");
                            MultiUserChatroom.this.onReferenceRemoved(MultiUserChatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(MultiUserChatroom.this.mRoomJid);
                        }
                        MultiUserChatroom.this.txtMessage.requestFocus();
                    }
                }

                @Override
                public List<LiteContact> pickContact() {
                    return MultiUserChatroom.this._pickContacts();
                }

                @Override
                public void focusLost() {
                    MultiUserChatroom.this.saveDraft();
                }
            }, this.fileSelectionCallback, this);
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String pendingMsg = database.getPendingMessage(this.getChatroomID());
            this.txtMessage.setPendingText(pendingMsg);
            this.spMessage.setViewportView(this.txtMessage);
            this.sendBtnPanel = new JPanel();
            this.sendBtnPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 15));
            this.sendBtnPanel.setLayout(new BorderLayout());
            this.sendBtnPanel.setBackground(Color.WHITE);
            this.spMessageOut.add((Component)this.sendBtnPanel, "East");
            this.sendButton = new JButton();
            this.sendBtnPanel.add((Component)this.sendButton, "South");
            this.sendButton.setText(I18NUtil.getString("chat_btn_send") + " (S)");
            this.sendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String docText = MultiUserChatroom.this.txtMessage.getMessageTextWithIconKey();
                    if (TextUtils.isNotBlank((CharSequence)docText)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(MultiUserChatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(MultiUserChatroom.this.mQuotePackageId, chatReceiverList, docText)) {
                            MultiUserChatroom.this.txtMessage.setText("");
                            MultiUserChatroom.this.onReferenceRemoved(MultiUserChatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(MultiUserChatroom.this.mRoomJid);
                        }
                        MultiUserChatroom.this.txtMessage.requestFocus();
                    }
                }
            });
            this.jPanel5 = new JPanel();
            this.jSplitPane2.add((Component)this.jPanel5, "right");
            BorderLayout jPanel4Layout = new BorderLayout();
            this.jPanel5.setLayout(jPanel4Layout);
            this.panelControl = new WidgetPanel(new Color(247, 247, 247));
            this.jPanel5.add((Component)this.panelControl, "North");
            this.panelControl.add(this.getBtnAddMember());
            this.panelControl.add(this.getBtnRemoveMember());
            this.spParticipant = new UCScrollPane(82);
            this.spParticipant.setHorizontalScrollBarPolicy(31);
            this.jPanel5.add((Component)this.spParticipant, "Center");
            this.panelParticipant = new WidgetPanel();
            this.panelParticipant.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.spParticipant.setViewportView(this.panelParticipant);
            this.panelHeader.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (MultiUserChatroom.this.panelHeader.getHeight() >= 0) {
                        int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                        int loc = MultiUserChatroom.this.mPanrent.getHeight() - MultiUserChatroom.this.panelHeader.getHeight() - panelHeight;
                        if (loc > 200 && panelHeight > 200) {
                            MultiUserChatroom.this.jSplitPane1.setDividerLocation(loc);
                        } else {
                            MultiUserChatroom.this.jSplitPane1.setDividerLocation(0.7);
                        }
                    }
                }
            });
            this.jPanel100.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension d = MultiUserChatroom.this.jPanel100.getSize();
                    if (d.getHeight() >= 0.0) {
                        PreferencesUtil.setChatInputAreaHeight(UCChatClient.context, (int)d.getHeight());
                    }
                    if (MultiUserChatroom.this.mMessageArea != null) {
                        MultiUserChatroom.this.mMessageArea.refreshScrollBar();
                    }
                }
            });
            int panelWidth = PreferencesUtil.getMangPanelWidth(UCChatClient.context);
            if (panelWidth > 100) {
                this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - panelWidth);
            } else if (this.spParticipant.getVerticalScrollBar().isVisible()) {
                this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 155);
            } else {
                this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 135);
            }
            this.jPanel5.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension d = MultiUserChatroom.this.jPanel5.getSize();
                    if (d.getWidth() >= 0.0) {
                        PreferencesUtil.setMangPanelWidth(UCChatClient.context, (int)d.getWidth());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClickMuteButton() {
        try {
            Log.i(MultiUserChatroom.class.getSimpleName(), "PhoneActivity onClickMuteButton");
            int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
            if (lineIndex != -1) {
                if (PhoneAgent.getInstance().toggleMute(lineIndex)) {
                    this.showMuteMsg = true;
                } else {
                    CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
                    if (callLine.isMute()) {
                        ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_muted"), 10);
                        this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                        this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
                    } else {
                        ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_unmuted"), 10);
                        this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                        this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.e(MultiUserChatroom.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    @Override
    public void onReferenceSelected(String packetId) {
        if (StringUtils.isBlank((CharSequence)packetId)) {
            return;
        }
        this.onReferenceRemoved(null);
        this.mQuotePackageId = packetId;
        this.referenceMsgOut = new ReferenceOut(new ReferenceOut.ReferenceClose(){

            @Override
            public void onReferenceCancel() {
                MultiUserChatroom.this.onReferenceRemoved(null);
            }

            @Override
            public void onMouseClicked() {
                MultiUserChatroom.this.mMessageArea.scrollToPacketId(MultiUserChatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MultiUserChatroom.this.mMessageArea.scrollToPacketId(MultiUserChatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.setCursor(new Cursor(12));
        Message quoteMsg = UCDBMessage.findMsgByPacketId(UCChatClient.context, this.mQuotePackageId);
        this.referenceMsgOut.setMsg(quoteMsg, false);
        this.spMessageOut.add((Component)this.referenceMsgOut, "North");
        this.jPanel100.validate();
    }

    @Override
    public void onReferenceRemoved(String packetId) {
        if (StringUtils.isNotBlank((CharSequence)packetId) && (StringUtils.isBlank((CharSequence)this.mQuotePackageId) || !this.mQuotePackageId.equalsIgnoreCase(packetId))) {
            return;
        }
        if (this.referenceMsgOut != null) {
            this.spMessageOut.remove(this.referenceMsgOut);
            this.referenceMsgOut = null;
            this.mQuotePackageId = null;
            this.jPanel100.validate();
        }
    }

    private void initConfigPopup() {
        this.popupMenuConfig.add(this.addMemberAction);
        this.popupMenuConfig.add(this.removeMemberAction);
        this.popupMenuConfig.addSeparator();
        boolean isInx = ChatRoomManager.isInMyFavorite(this.mRoomJid);
        this.updateFavoriteAction(isInx);
        this.popupMenuConfig.add(this.favoriteAction);
        long groupId = ContactManager.getGroupIdByName(UCChatClient.context, "My chat rooms");
        if (groupId != -1L) {
            boolean isInO = ChatRoomManager.isInMyChatRoom(this.mRoomJid);
            this.updateMyChatRoomAction(isInO);
            this.popupMenuConfig.add(this.myChatRoomAction);
        }
        this.popupMenuConfig.add(this.changeChatroomNameAction);
        this.popupMenuConfig.add(this.notificationAction);
        this.popupMenuConfig.add(this.showMeetmeAction);
        this.popupMenuConfig.addSeparator();
        this.popupMenuConfig.add(this.exitRoomAction);
    }

    private void cleanConfigPopup() {
        this.popupMenuConfig.removeAll();
        ListenerCleaner.cleanPropertyChangeListener(this.notificationAction);
        ListenerCleaner.cleanPropertyChangeListener(this.showMeetmeAction);
        ListenerCleaner.cleanPropertyChangeListener(this.favoriteAction);
        ListenerCleaner.cleanPropertyChangeListener(this.changeChatroomNameAction);
        ListenerCleaner.cleanPropertyChangeListener(this.myChatRoomAction);
        ListenerCleaner.cleanPropertyChangeListener(this.removeMemberAction);
        ListenerCleaner.cleanPropertyChangeListener(this.addMemberAction);
        ListenerCleaner.cleanPropertyChangeListener(this.exitRoomAction);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    final String action = intent.getAction();
                    Long roomId = intent.getLongExtra("roomId", -1L);
                    if ("ezuc.intent.action.event.PHONE_MUTE_CHANGED".equals(action)) {
                        Bundle bundle = intent.getExtras();
                        if (bundle == null) {
                            return;
                        }
                        int line = bundle.getInt("line");
                        int lineIndex = PhoneAgent.getInstance().isInCall(MultiUserChatroom.this.mRoomJid);
                        if (lineIndex != -1) {
                            if (lineIndex != line) {
                                return;
                            }
                            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
                            if (callLine.isMute()) {
                                if (MultiUserChatroom.this.showMuteMsg) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_muted"), 10);
                                }
                                MultiUserChatroom.this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                                MultiUserChatroom.this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
                                MultiUserChatroom.this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MUTE_SMALL);
                                MultiUserChatroom.this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_unmute"));
                                MultiUserChatroom.this.btnMuteSelf2.setPreferredSize(new Dimension(MultiUserChatroom.this.btnMuteSelf2.calculatePreferWidth(), 32));
                            } else {
                                if (MultiUserChatroom.this.showMuteMsg) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_unmuted"), 10);
                                }
                                MultiUserChatroom.this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                                MultiUserChatroom.this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
                                MultiUserChatroom.this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MIC_SMALL);
                                MultiUserChatroom.this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_mute"));
                                MultiUserChatroom.this.btnMuteSelf2.setPreferredSize(new Dimension(MultiUserChatroom.this.btnMuteSelf2.calculatePreferWidth(), 32));
                            }
                        }
                        MultiUserChatroom.this.showMuteMsg = false;
                    } else if ("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED".equals(action) || "ezuc.intent.action.event.CONTACT_LIST_CHANGED".equals(action)) {
                        if (MultiUserChatroom.this.mMessageArea != null) {
                            MultiUserChatroom.this.mMessageArea.reloadPage();
                            MultiUserChatroom.this.mMessageArea.reloadSystemInfo();
                        }
                        MultiUserChatroom.this.refreshParticipants(action, false);
                    } else if ("ezuc.intent.action.event.MEETME_CHANGED".equals(action)) {
                        MultiUserChatroom.this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, roomId);
                        if (MultiUserChatroom.this.meetmeRoom == null) {
                            Log.w(MultiUserChatroom.class.getSimpleName(), "meetMe has removed!");
                        } else {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    MultiUserChatroom.this.updateRoom();
                                    MultiUserChatroom.this.refreshParticipants(action, false);
                                }
                            });
                        }
                    } else if ("ezuc.intent.action.event.MEETME_USER_LIST_CHANGED".equals(action)) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MultiUserChatroom.this.refreshParticipants(action, false);
                            }
                        });
                    } else if ("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED".equals(action)) {
                        MultiUserChatroom.this.chat_participantChanged(intent);
                    } else if ("ezuc.intent.action.event.GROUP_LIST_CHANGED".equals(action)) {
                        MultiUserChatroom.this.group_listChanged();
                    } else if ("ezuc.intent.action.event.MEETME_PHONE_PREFIX_CHANGED".equals(action)) {
                        MultiUserChatroom.this.updateRoom();
                    } else if ("ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER".equals(action)) {
                        MultiUserChatroom.this.onPhoneStatusChanged();
                    } else if ("ezuc.intent.action.event.PHONE_CALL_BRIDGED".equals(action)) {
                        MultiUserChatroom.this.onPhoneStatusChanged();
                    } else if ("ezuc.intent.action.event.PERSONAL_INFO_CHANGED".equals(action)) {
                        MultiUserChatroom.this.updateRoom();
                        boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
                        boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
                        MultiUserChatroom.this.btnSendFile.setVisible(hasFilePermission);
                        MultiUserChatroom.this.jSeparator0.setVisible(hasFilePermission);
                        MultiUserChatroom.this.btnScreenCapture.setVisible(hasPhotoPermission);
                        MultiUserChatroom.this.jSeparator1.setVisible(hasPhotoPermission);
                    }
                }
                catch (Throwable t) {
                    Log.e(MultiUserChatroom.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CONTACT_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.MEETME_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.MEETME_USER_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.MEETME_PHONE_PREFIX_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.GROUP_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_MUTE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_CALL_BRIDGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER");
        this.filter.addAction("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    @Override
    public void execute(String command) {
    }

    private synchronized List<LiteContact> _pickContacts() {
        String caption;
        ArrayList<LiteContact> candidateContacts = new ArrayList<LiteContact>();
        LiteContact allContact = new LiteContact();
        allContact.setId(-10000L);
        candidateContacts.add(allContact);
        for (ChatRoomItem item : this.mParticipantsDataList) {
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || !JidUtil.isEmployeeJid((m = (ChatRoomMember)item).getJid()) || this.myJid.equals(m.getJid())) continue;
            candidateContacts.add(m.getContact());
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectContactResult result = mainPanel.showSelectContactDialog(caption = I18NUtil.getString("abook_title_select_participant_to_reply"), candidateContacts, true);
        if (result != null) {
            return result.getParticipants();
        }
        return null;
    }

    private void btnSendFileMouseClicked(MouseEvent evt) {
        FileUtil.sendFile(this.fileSelectionCallback);
    }

    private void btnScreenCaptureMouseClicked(MouseEvent evt) {
        CaptureUtil.captureImage(this, this.fileSelectionCallback);
    }

    private void btnSendStickerMouseClicked(MouseEvent evt) {
        final StickerPopupMenu menu = StickerPopupMenu.getInstance();
        menu.setMediaContentInputListener(new MediaContentInputListener(){

            @Override
            public void onStickerClick(String stickerKey) {
                ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                chatReceiverList.add(new ChatReceiver(MultiUserChatroom.this.mRoomJid));
                ChatActionUtil.sendMessage(MultiUserChatroom.this.mQuotePackageId, chatReceiverList, stickerKey);
                MultiUserChatroom.this.onReferenceRemoved(MultiUserChatroom.this.mQuotePackageId);
                menu.setVisible(false);
                MultiUserChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
            }

            @Override
            public void onIdiomClick(String text) {
            }

            @Override
            public void onSymbolClick(String text) {
            }
        });
        menu.show(this.btnSendSticker, 0, -menu.getPreferredSize().height);
    }

    private void btnSendEmoticonMouseClicked(MouseEvent evt) {
        final EmoticonPopupMenu menu = EmoticonPopupMenu.getInstance();
        menu.setMediaContentInputListener(new MediaContentInputListener(){

            @Override
            public void onStickerClick(String stickerKey) {
            }

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
                ImageIcon eIcon = GraphicUtil.getScaledIcon(iconPath, 16, 16);
                eIcon.setDescription(emoticonKey);
                MultiUserChatroom.this.txtMessage.insertIcon(eIcon);
                menu.setVisible(false);
                MultiUserChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onIdiomClick(String text) {
                try {
                    MultiUserChatroom.this.txtMessage.replaceSelection("");
                    MultiUserChatroom.this.txtMessage.getDocument().insertString(MultiUserChatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                MultiUserChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onSymbolClick(String text) {
                try {
                    MultiUserChatroom.this.txtMessage.replaceSelection("");
                    MultiUserChatroom.this.txtMessage.getDocument().insertString(MultiUserChatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                MultiUserChatroom.this.txtMessage.requestFocus();
            }
        });
        menu.show(this.btnSendEmoticon, 0, -menu.getPreferredSize().height);
    }

    private void setComponentPopupMenu(final Component parent, final JPopupMenu menu) {
        parent.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                if (parent.isEnabled()) {
                    menu.show(parent, 0, parent.getHeight());
                }
            }
        });
    }

    public void setLayoutMode(MucRoomLayoutMode mode) {
        if (!this.manualSelectedLayout) {
            this.layoutMode = mode;
            this.updateMucRoomLayoutModeUI();
        } else if (this.layoutMode == MucRoomLayoutMode.MEMBER && mode == MucRoomLayoutMode.NO_MEMBER) {
            this.layoutMode = MucRoomLayoutMode.NO_MEMBER;
            this.updateMucRoomLayoutModeUI();
        }
    }

    private void switchLayout() {
        int newIndex = (this.layoutMode.ordinal() + 1) % MucRoomLayoutMode.values().length;
        this.layoutMode = MucRoomLayoutMode.values()[newIndex];
        this.updateMucRoomLayoutModeUI();
        this.manualSelectedLayout = true;
    }

    private void updateMucRoomLayoutModeUI() {
        this.btnLayout.setIcon(this.layoutMode.getIcon());
        this.btnLayout.setToolTipText(this.layoutMode.getToolTip());
        switch (this.layoutMode) {
            case NO_MEMBER: {
                PreferencesUtil.setMangPrevPanelWidth(UCChatClient.context, (int)this.jPanel5.getSize().getWidth());
                this.jPanel5.setVisible(false);
                this.revalidate();
                this.repaint();
                break;
            }
            case MEMBER: {
                this.jPanel5.setVisible(true);
                int panelWidth = PreferencesUtil.getMangPrevPanelWidth(UCChatClient.context);
                if (panelWidth > 100) {
                    this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - panelWidth);
                } else if (this.spParticipant.getVerticalScrollBar().isVisible()) {
                    this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 155);
                } else {
                    this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 135);
                }
                this.revalidate();
                this.repaint();
            }
        }
    }

    @Override
    public void onShow(Intent intent) {
        Log.i(MultiUserChatroom.class.getSimpleName(), "chatroom onShow: " + this.mRoomJid);
        super.onShow(intent);
        this.cleanConfigPopup();
        this.initConfigPopup();
    }

    @Override
    public void onClose() {
        this.saveDraft();
        if (this.mMessageArea != null) {
            this.mMessageArea.onClose();
        }
        if (this.receiver != null) {
            UCChatClient.context.unregisterReceiver(this.receiver);
        }
        ListenerCleaner.cleanMouseListner(this.lblPhoto);
        ListenerCleaner.cleanMouseListner(this.btnLayout);
        ListenerCleaner.cleanMouseListner(this.btnSendFile);
        ListenerCleaner.cleanMouseListner(this.btnScreenCapture);
        ListenerCleaner.cleanMouseListner(this.btnSendSticker);
        ListenerCleaner.cleanMouseListner(this.btnSendEmoticon);
        ListenerCleaner.cleanMouseListner(this.btnCall);
        ListenerCleaner.cleanMouseListner(this.btnHangup);
        ListenerCleaner.cleanMouseListner(this.btnMuteSelf);
        ListenerCleaner.cleanMouseListner(this.btnShowCallPage);
        ListenerCleaner.cleanMouseListner(this.btnCall2);
        ListenerCleaner.cleanMouseListner(this.btnHangup2);
        ListenerCleaner.cleanMouseListner(this.btnMuteSelf2);
        ListenerCleaner.cleanMouseListner(this.btnConfig);
        ListenerCleaner.cleanMouseListner(this.btnAddMember);
        ListenerCleaner.cleanMouseListner(this.btnRemoveMember);
        ListenerCleaner.cleanActionListner(this.sendButton);
        ListenerCleaner.cleanComponentListner(this.panelHeader);
        ListenerCleaner.cleanComponentListner(this.jPanel100);
        ListenerCleaner.cleanComponentListner(this.jPanel5);
        this.cleanPanelParticipant();
        this.cleanConfigPopup();
        this.txtMessage.onClose();
        this.jSplitPane1.removeAll();
        this.mMessageArea = null;
        StickerPopupMenu menu = StickerPopupMenu.getInstance();
        menu.setMediaContentInputListener(null);
    }

    private void saveDraft() {
        if (this.txtMessage == null) {
            return;
        }
        if (this.txtMessage.isEnabled()) {
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String roomJid = this.getChatroomID();
            String existedDraftMsg = database.getPendingMessage(roomJid);
            String docText = this.txtMessage.getMessageTextWithIconKey();
            if (!TextUtils.isBlank((CharSequence)docText)) {
                database.savePendingMessage(roomJid, docText);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            } else if (TextUtils.isNotBlank((CharSequence)existedDraftMsg)) {
                database.deletePendingMessage(roomJid);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            }
        }
    }

    private void addParticipantItem(final ChatRoomMember m, List<ImageBean> participantImages, List<ImageBean> defaultImages) {
        JLabel lblParticipant = new JLabel();
        lblParticipant.setText(m.getTitle());
        lblParticipant.setToolTipText(m.getTitle());
        Image image = null;
        image = JidUtil.isEmployeeJid(m.getJid()) ? this.getEmpParticipantImage(m, participantImages, defaultImages, true, false) : (JidUtil.isLocationJid(m.getJid()) ? this.getLocationParticipantImage(m, participantImages, defaultImages, true, false) : (JidUtil.isMyContactJid(m.getJid()) ? this.getMyContactParticipantImage(m, participantImages, defaultImages, true, false) : this.getNomanParticipantImage(m, participantImages, defaultImages, true, false)));
        lblParticipant.setIcon(image == null ? UIConstants.ICON_PERSON48 : new ImageIcon(image));
        lblParticipant.setIconTextGap(4);
        lblParticipant.setHorizontalTextPosition(0);
        lblParticipant.setVerticalTextPosition(3);
        lblParticipant.setForeground(new Color(224, 224, 224));
        lblParticipant.setPreferredSize(new Dimension(48, 70));
        lblParticipant.setMaximumSize(new Dimension(48, 70));
        lblParticipant.setMinimumSize(new Dimension(48, 70));
        if (!m.getJid().equals(this.myJid)) {
            lblParticipant.setCursor(new Cursor(12));
            lblParticipant.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    UCChatClient.getInstance().getMainPanel().showChatroom(m.getJid());
                }
            });
        }
        this.panelParticipant.add(lblParticipant);
        this.panelParticipant.revalidate();
        this.panelParticipant.repaint();
        this.lblMemberCount.setText(String.format(I18NUtil.getString("chat_label_participant_count"), this.mParticipantsDataList.size()));
        this.updateRemoveMemberAction();
    }

    private void cleanPanelParticipant() {
        if (this.panelParticipant != null) {
            for (Component comp : this.panelParticipant.getComponents()) {
                ListenerCleaner.cleanMouseListner(comp);
            }
        }
        this.panelParticipant.removeAll();
    }

    private Image getEmpParticipantImage(ChatRoomMember crm, List<ImageBean> participantImages, List<ImageBean> defaultImages, boolean noDefault, boolean roundImage) {
        LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, crm.getJid());
        Image image = ContactManager.getContactImage(contact, 48, noDefault, roundImage);
        if (image == null) {
            image = UIConstants.ICON_PERSON48.getImage();
            defaultImages.add(new ImageBean(image, crm));
        } else {
            participantImages.add(new ImageBean(image, crm));
        }
        return this.mix(crm, image);
    }

    private Image getLocationParticipantImage(ChatRoomMember crm, List<ImageBean> participantImages, List<ImageBean> defaultImages, boolean noDefault, boolean roundImage) {
        Image participantImage = UIConstants.ICON_PHONE_PUBLIC_PHONE48.getImage();
        defaultImages.add(new ImageBean(participantImage, crm));
        return this.mix(crm, participantImage);
    }

    private Image getMyContactParticipantImage(ChatRoomMember crm, List<ImageBean> participantImages, List<ImageBean> defaultImages, boolean noDefault, boolean roundImage) {
        long myContactId = JidUtil.trimExternalContactId(crm.getJid());
        LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, myContactId);
        Image participantImage = ContactManager.getExternalContactImage(myContact, 48, noDefault, roundImage);
        if (participantImage == null) {
            participantImage = UIConstants.ICON_PERSON48.getImage();
            defaultImages.add(new ImageBean(participantImage, crm));
        } else {
            participantImages.add(new ImageBean(participantImage, crm));
        }
        return this.mix(crm, participantImage);
    }

    private Image getNomanParticipantImage(ChatRoomMember crm, List<ImageBean> participantImages, List<ImageBean> defaultImages, boolean noDefault, boolean roundImage) {
        Image participantImage = UIConstants.ICON_PERSON48.getImage();
        defaultImages.add(new ImageBean(participantImage, crm));
        return this.mix(crm, participantImage);
    }

    private Image mix(ChatRoomMember crm, Image participantImage) {
        Image muteImage = null;
        boolean meetme = crm.isMeetmeOn();
        if (meetme) {
            boolean muted = crm.isMeetmeIsMute();
            muteImage = muted ? ICON_VOICE_OFF.getImage() : ICON_VOICE_ON.getImage();
        }
        return GraphicUtil.getPresencedPersonalPhoto(48, 48, participantImage, null, true, null, null, muteImage);
    }

    @Override
    public void onPhoneStatusChanged() {
        if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
            this.btnCall.setToolTipText(I18NUtil.getString("phone_notice_not_connected"));
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnCall2.setToolTipText(I18NUtil.getString("phone_notice_not_connected"));
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            return;
        }
        this.btnCall.setToolTipText(null);
        this.btnCall2.setToolTipText(null);
        if (this.chatMode == ChatMode.NORMAL) {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            this.handleNormalPhone();
        } else if (this.chatMode == ChatMode.ONLY_PHONE) {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
            this.handleOnlyPhone();
        } else {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
        }
    }

    private void handleNormalPhone() {
        int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
        if (lineIndex != -1) {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
            if (callLine.isMute()) {
                this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
            } else {
                this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
            }
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(true);
            return;
        }
        PhoneAgent.LineAvailableType isAvailableToCall = PhoneAgent.getInstance().isAvailableToCall();
        this.handleCallBtnText(isAvailableToCall != PhoneAgent.LineAvailableType.NONE, isAvailableToCall);
        this.revalidate();
        this.repaint();
    }

    private void handleCallBtnText(boolean btnEnable, PhoneAgent.LineAvailableType ableToCall) {
        if (btnEnable) {
            this.btnCall.setEnabled(true);
            this.btnCall.setVisible(true);
            this.jPanelCall1.setVisible(false);
        } else {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
        }
        if (!btnEnable) {
            this.btnCall.setText(I18NUtil.getString("abook_popup_btn_talk"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line1_full"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line2_full"));
        } else {
            this.btnCall.setText(I18NUtil.getString("abook_popup_btn_talk"));
        }
    }

    private void handleOnlyPhone() {
        int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
        if (lineIndex != -1) {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
            boolean isMuted = callLine.isMute();
            if (isMuted) {
                this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MUTE_SMALL);
                this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_unmute"));
            } else {
                this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MIC_SMALL);
                this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_mute"));
            }
            this.btnMuteSelf2.setPreferredSize(new Dimension(this.btnMuteSelf2.calculatePreferWidth(), 32));
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(true);
            this.btnHangup2.setVisible(true);
            this.btnMuteSelf2.setEnabled(true);
            this.btnMuteSelf2.setVisible(true);
            return;
        }
        PhoneAgent.LineAvailableType isAvailableToCall = PhoneAgent.getInstance().isAvailableToCall();
        this.handleCallBtn2Text(isAvailableToCall != PhoneAgent.LineAvailableType.NONE, isAvailableToCall);
        this.revalidate();
        this.repaint();
    }

    private void handleCallBtn2Text(boolean btnEnable, PhoneAgent.LineAvailableType ableToCall) {
        if (btnEnable) {
            this.btnCall2.setEnabled(true);
            this.btnCall2.setVisible(true);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
        } else {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
        }
        if (!btnEnable) {
            this.btnCall2.setText(I18NUtil.getString("abook_popup_btn_talk"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall2.setText(I18NUtil.getString("call_btn_callout_line1_full"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall2.setText(I18NUtil.getString("call_btn_callout_line2_full"));
        } else {
            this.btnCall2.setText(I18NUtil.getString("abook_popup_btn_talk"));
        }
        this.btnCall2.setPreferredSize(new Dimension(this.btnCall2.calculatePreferWidth(), 32));
    }

    private void group_listChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MultiUserChatroom.this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(MultiUserChatroom.this.mRoomJid));
                MultiUserChatroom.this.updateMyChatRoomAction(ChatRoomManager.isInMyChatRoom(MultiUserChatroom.this.mRoomJid));
            }
        });
    }

    private void chat_participantChanged(final Intent intent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean update = false;
                String chatIdTemp = intent.getStringExtra("chatId");
                if (chatIdTemp == null) {
                    update = true;
                } else if (chatIdTemp != null && MultiUserChatroom.this.mRoomJid != null && chatIdTemp.equals(MultiUserChatroom.this.mRoomJid)) {
                    update = true;
                }
                if (update) {
                    MultiUserChatroom.this.refreshParticipants("CHAT_PARTICIPANT_CHANGED_ACTION", false);
                }
            }
        });
    }

    private void _addMember() {
        String string;
        HashSet<String> exculsiveJIDs = new HashSet<String>();
        for (ChatRoomItem item : this.mParticipantsDataList) {
            if (!(item instanceof ChatRoomMember)) continue;
            ChatRoomMember m = (ChatRoomMember)item;
            if (JidUtil.isEmployeeJid(m.getJid())) {
                exculsiveJIDs.add(m.getJid());
                continue;
            }
            if (!JidUtil.isLocationJid(m.getJid())) continue;
            exculsiveJIDs.add(m.getJid());
        }
        List itemList = UCDBContact.getContactsOrderByName(UCChatClient.context, null, 0, exculsiveJIDs);
        ArrayList<LiteContact> candidateContacts = new ArrayList<LiteContact>();
        for (AddressBookGroup addressBookGroup : itemList) {
            for (LiteContact c : addressBookGroup.getDataList()) {
                if (!JidUtil.isEmployeeJid(c.getJid())) continue;
                candidateContacts.add(c);
            }
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectContactResult result = mainPanel.showSelectContactDialog(string = I18NUtil.getString("chatroom_select_members_to_invite"), candidateContacts);
        if (result != null) {
            List<LiteContact> participants = result.getParticipants();
            ArrayList<String> participantJIDs = new ArrayList<String>();
            for (LiteContact participant : participants) {
                participantJIDs.add(participant.getJid());
            }
            ToastUtil.showShort(String.format(I18NUtil.getString("chatroom_notice_invite_processing"), this.getContactDispTitle(participants)));
            WebAgent.getInstance().inviteRoomParticipants(this.mRoomJid, participantJIDs);
        }
    }

    private void refreshSelectionList() {
        ArrayList<ChatRoomItem> candidateContacts = new ArrayList<ChatRoomItem>();
        for (ChatRoomItem item : this.mParticipantsDataList) {
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || (m = (ChatRoomMember)item).isAdmin()) continue;
            candidateContacts.add(m);
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        mainPanel.updateKickSelectMeetmeItemDialog(candidateContacts);
    }

    private void _removeMember() {
        String caption;
        if (this.meetmeRoom != null) {
            this.mMinusSelection = !this.mMinusSelection;
        }
        ArrayList<ChatRoomItem> candidateContacts = new ArrayList<ChatRoomItem>();
        for (ChatRoomItem item : this.mParticipantsDataList) {
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || (m = (ChatRoomMember)item).isAdmin()) continue;
            candidateContacts.add(m);
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectMeetmeItemResult result = mainPanel.showKickSelectMeetmeItemDialog(caption = I18NUtil.getString("conference_select_members_to_kick"), candidateContacts);
        if (result != null) {
            List<ChatRoomItem> participants = result.getParticipants();
            ToastUtil.showShort(String.format(I18NUtil.getString("chatroom_notice_kick_processing"), this.getDispTitle(participants)));
            ArrayList<ChatRoomMember> toRemoveList = new ArrayList<ChatRoomMember>();
            ArrayList<String> removeMemberJidList = new ArrayList<String>();
            for (ChatRoomItem m : participants) {
                if (!(m instanceof ChatRoomMember)) continue;
                ChatRoomMember crm = (ChatRoomMember)m;
                toRemoveList.add(crm);
            }
            for (ChatRoomMember crm : toRemoveList) {
                LiteContact empContact = null;
                if (JidUtil.isEmployeeJid(crm.getJid())) {
                    empContact = ContactManager.getContact((Context)UCChatClient.context, crm.getJid());
                    removeMemberJidList.add(crm.getJid());
                }
                if (this.meetmeRoom == null || this.meetmeRoom.getRoomId() == null) continue;
                if (empContact != null) {
                    WebAgent.getInstance().kickUser(this.meetmeRoom.getRoomId(), crm.getMeetmeUserNo(), empContact.getId());
                    continue;
                }
                WebAgent.getInstance().kickUser(this.meetmeRoom.getRoomId(), crm.getMeetmeUserNo());
            }
            WebAgent.getInstance().removeRoomMembers(this.mRoomJid, removeMemberJidList);
        }
    }

    private ImageLabel getBtnAddMember() {
        if (this.btnAddMember == null) {
            this.btnAddMember = new ImageLabel(ICON_ADD_MEMBER);
            this.btnAddMember.setFlatMode(true);
            this.btnAddMember.setNormalBorderColor(null);
            this.btnAddMember.setCursor(UIConstants.CURSOR_HAND);
            this.btnAddMember.setToolTipText(I18NUtil.getString("chatroom_label_invite_participants"));
            this.btnAddMember.setPreferredSize(new Dimension(48, 48));
            this.btnAddMember.setMaximumSize(new Dimension(48, 48));
            this.btnAddMember.setMinimumSize(new Dimension(48, 48));
            this.btnAddMember.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    MultiUserChatroom.this._addMember();
                }
            });
        }
        return this.btnAddMember;
    }

    private ImageLabel getBtnRemoveMember() {
        if (this.btnRemoveMember == null) {
            this.btnRemoveMember = new ImageLabel(ICON_REMOVE_MEMBER);
            this.btnRemoveMember.setFlatMode(true);
            this.btnRemoveMember.setCursor(UIConstants.CURSOR_HAND);
            this.btnRemoveMember.setNormalBorderColor(null);
            this.btnRemoveMember.setToolTipText(I18NUtil.getString("conference_btn_kick"));
            this.btnRemoveMember.setPreferredSize(new Dimension(48, 48));
            this.btnRemoveMember.setMaximumSize(new Dimension(48, 48));
            this.btnRemoveMember.setMinimumSize(new Dimension(48, 48));
            this.btnRemoveMember.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    MultiUserChatroom.this._removeMember();
                }
            });
        }
        return this.btnRemoveMember;
    }

    public static enum MucRoomLayoutMode {
        NO_MEMBER(IChatroom.ICON_LAYOUT_MEMBER, I18NUtil.getString("chatroom_btn_show_participant_list")),
        MEMBER(IChatroom.ICON_LAYOUT_NOMEMBER, I18NUtil.getString("chatroom_btn_hide_participant_list"));

        Icon icon;
        String toolTip;

        private MucRoomLayoutMode(Icon icon, String toolTip) {
            this.icon = icon;
            this.toolTip = toolTip;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getToolTip() {
            return this.toolTip;
        }
    }

    public static enum ChatMode {
        NORMAL,
        ONLY_PHONE,
        DISABLED;

    }

    class ShowMeetmeMsgAction
    extends AbstractAction {
        boolean showText;

        public ShowMeetmeMsgAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_btn_display_voice_action"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_btn_display_voice_action"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isShow = PreferencesUtil.isMeetmeShowEnabled(UCChatClient.context, MultiUserChatroom.this.mRoomJid);
            if (isShow) {
                PreferencesUtil.removeFromMeetmeShowList(UCChatClient.context, MultiUserChatroom.this.mRoomJid);
                MultiUserChatroom.this.updateMeetmeShowAction(false);
            } else {
                PreferencesUtil.addToMeetmeShowList(UCChatClient.context, MultiUserChatroom.this.mRoomJid);
                MultiUserChatroom.this.updateMeetmeShowAction(true);
            }
            ToastUtil.show(UCChatClient.context, I18NUtil.getString("common_notice_update_success"), 10);
            BroadcastUtil.sendMsgChangedEvent(UCChatClient.context, MultiUserChatroom.this.mRoomJid);
            MultiUserChatroom.this.loadLast();
        }
    }

    class ChangeChatroomNameAction
    extends AbstractAction {
        boolean showText;

        public ChangeChatroomNameAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("chatroom_fun_update_name"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("chatroom_fun_update_name"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, MultiUserChatroom.this.mRoomJid);
                    String roomTitle = ChatRoomUtil.getChatRoomTitle(UCChatClient.context, roomInfo);
                    ChangeChatroomNamePanel ccnp = new ChangeChatroomNamePanel(MultiUserChatroom.this.mRoomJid, roomTitle);
                    UCChatClient.getInstance().showGlassPanel(ccnp, true);
                    ccnp.focusTextField();
                }
            });
        }
    }

    class MyChatRoomAction
    extends AbstractAction {
        boolean showText;

        public MyChatRoomAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("abook_fun_add_to_my_chatrooms"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("abook_fun_add_to_my_chatrooms"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isMyChatRoom = ChatRoomManager.switchMyChatRoom(MultiUserChatroom.this.mRoomJid);
            MultiUserChatroom.this.updateMyChatRoomAction(isMyChatRoom);
        }
    }

    class RemoveMemberAction
    extends AbstractAction {
        public RemoveMemberAction(boolean showText) {
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_btn_kick"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_btn_kick"));
                this.putValue("SmallIcon", IChatroom.ICON_REMOVE_MEMBER);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiUserChatroom.this._removeMember();
        }
    }

    class AddMemberAction
    extends AbstractAction {
        public AddMemberAction(boolean showText) {
            if (showText) {
                this.putValue("Name", I18NUtil.getString("chatroom_label_invite_participants"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("chatroom_label_invite_participants"));
                this.putValue("SmallIcon", IChatroom.ICON_ADD_MEMBER);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MultiUserChatroom.this._addMember();
        }
    }

    class ExitRoomAction
    extends AbstractAction {
        public ExitRoomAction(boolean showText) {
            if (showText) {
                this.putValue("Name", I18NUtil.getString("chatroom_btn_exit"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("chatroom_btn_exit"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            WebAgent.getInstance().exitRoom(MultiUserChatroom.this.mRoomJid);
            PhoneAgent.getInstance().hangupMeetme(MultiUserChatroom.this.mRoomJid);
        }
    }
}

