/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;

public class CustomLineBorder
extends AbstractBorder {
    private static Border blackLine;
    private static Border grayLine;
    protected int thicknessTop;
    protected int thicknessButtom;
    protected int thicknessLeft;
    protected int thicknessRight;
    protected Color lineColor;

    public static Border createBlackLineBorder() {
        if (blackLine == null) {
            blackLine = new LineBorder(Color.black, 1);
        }
        return blackLine;
    }

    public static Border createGrayLineBorder() {
        if (grayLine == null) {
            grayLine = new LineBorder(Color.gray, 1);
        }
        return grayLine;
    }

    public CustomLineBorder(Color color) {
        this(color, 1, 1, 1, 1);
    }

    public CustomLineBorder(Color color, int thickness) {
        this(color, thickness, thickness, thickness, thickness);
    }

    public CustomLineBorder(Color color, int thicknessTop, int thicknessLeft, int thicknessButtom, int thicknessRight) {
        this.lineColor = color;
        this.thicknessTop = thicknessTop;
        this.thicknessLeft = thicknessLeft;
        this.thicknessButtom = thicknessButtom;
        this.thicknessRight = thicknessRight;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color oldColor = g.getColor();
        g.setColor(this.lineColor);
        if (this.thicknessTop > 0) {
            g.fillRect(x, y, width, this.thicknessTop);
        }
        if (this.thicknessLeft > 0) {
            g.fillRect(x, y, this.thicknessLeft, height);
        }
        if (this.thicknessButtom > 0) {
            g.fillRect(x, y + height - this.thicknessButtom, width, this.thicknessButtom);
        }
        if (this.thicknessRight > 0) {
            g.fillRect(x + width - this.thicknessRight, y, this.thicknessRight, height);
        }
        g.setColor(oldColor);
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.set(this.thicknessTop, this.thicknessLeft, this.thicknessButtom, this.thicknessRight);
        return insets;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getThicknessTop() {
        return this.thicknessTop;
    }

    public int getThicknessLeft() {
        return this.thicknessLeft;
    }

    public int getThicknessButtom() {
        return this.thicknessButtom;
    }

    public int getThicknessRight() {
        return this.thicknessRight;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

