/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.mobile.ezuc.bean.ContactReadTime;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class EmployeeReadCellRenderer
extends JPanel
implements ListCellRenderer<ContactReadTime> {
    private PersonalPhoto lblHeadIcon;
    private JLabel lblName;
    private JLabel lblStatus;

    public EmployeeReadCellRenderer() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 10));
        this.lblHeadIcon = new PersonalPhoto();
        this.lblHeadIcon.setPreferredSize(new Dimension(32, 32));
        this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.lblName = new JLabel();
        this.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.lblName.setFont(UIConstants.FONT_14_PLAIN);
        this.lblStatus = new JLabel();
        this.add((Component)this.lblStatus, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.lblStatus.setFont(UIConstants.FONT_12_PLAIN);
        this.lblStatus.setForeground(UIConstants.COLOR_LIGHT_GRAY);
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends ContactReadTime> list, ContactReadTime value, int index, boolean isSelected, boolean cellHasFocus) {
        Color foreground;
        Color background;
        if (isSelected) {
            background = new Color(list.getSelectionBackground().getRGB());
            foreground = new Color(list.getSelectionForeground().getRGB());
            this.setOpaque(true);
        } else {
            background = new Color(list.getBackground().getRGB());
            foreground = new Color(list.getForeground().getRGB());
            this.setOpaque(false);
        }
        this.setBackground(background);
        this.setForeground(foreground);
        this.lblName.setBackground(background);
        this.lblName.setForeground(foreground);
        this.lblStatus.setBackground(background);
        this.lblStatus.setForeground(foreground);
        if (value != null) {
            LiteContact contact = value.getContact();
            Object contactName = null;
            contactName = contact != null ? ContactManager.getContactFullName(contact) : String.valueOf(value.getReaderEmpId()) + " (" + I18NUtil.getString("common_msg_not_exist") + ")";
            this.lblName.setText((String)contactName);
            Image contactImage = ContactManager.getContactImage(contact, 48, false, true);
            this.lblHeadIcon.setImage(contactImage);
            String timeStr = "";
            if (value.getReadTimestamp() != 0L) {
                timeStr = DateTimeUtil.getTimeStr(value.getReadTimestamp(), true);
            }
            this.lblStatus.setText(timeStr);
        }
        return this;
    }
}

