/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.component.GlassPanelCallback;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.OverlayLayout;

public class GlassPanel
extends JPanel {
    private JComponent mComp;
    private boolean mCancellable;
    private boolean mBlockMouse;
    private Color mBackgroundColor;
    private GlassPanelCallback mCallback;
    private MyComponentListener myComponentListener = new MyComponentListener();
    private ShieldMouseListener shieldMouseListener = new ShieldMouseListener(this);

    public GlassPanel() {
        OverlayLayout thisLayout = new OverlayLayout(this);
        this.setLayout(thisLayout);
        this.setBorder(BorderFactory.createEmptyBorder(40, 40, 40, 40));
        this.setOpaque(false);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                GlassPanel.this.hideGlassPanel();
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(27, 0), "myEsc");
        this.getActionMap().put("myEsc", new EscAction());
    }

    public void showComponent(JComponent comp, boolean cancellable) {
        this.showComponent(comp, cancellable, true, null, null);
    }

    public void showComponent(JComponent comp, boolean cancellable, GlassPanelCallback callback) {
        this.showComponent(comp, cancellable, true, null, callback);
    }

    public void showComponent(JComponent comp, boolean cancellable, boolean blockMouse, Color background, GlassPanelCallback callback) {
        this.mComp = comp;
        this.mComp.addComponentListener(this.myComponentListener);
        this.mCancellable = cancellable;
        this.mBlockMouse = blockMouse;
        this.mBackgroundColor = background;
        this.mCallback = callback;
        comp.setAlignmentX(0.5f);
        comp.setAlignmentY(0.5f);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setMinimumSize(comp.getPreferredSize());
        if (background == null) {
            this.setOpaque(false);
        } else {
            this.setOpaque(true);
            this.setBackground(this.mBackgroundColor);
        }
        if (blockMouse) {
            comp.addMouseListener(this.shieldMouseListener);
        }
        this.add(comp);
        this.setVisible(true);
        this.requestFocus();
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (!aFlag) {
            if (this.mBlockMouse) {
                this.mComp.removeMouseListener(this.shieldMouseListener);
            }
            if (this.mCallback != null) {
                this.mCallback.onHide();
            }
            if (this.mComp != null) {
                this.mComp.removeComponentListener(this.myComponentListener);
            }
            this.mComp = null;
            this.mCancellable = false;
            this.mBlockMouse = false;
            this.mBackgroundColor = null;
            this.mCallback = null;
            this.removeAll();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mBackgroundColor == null) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            AlphaComposite c = AlphaComposite.getInstance(3, 0.7f);
            g2d.setComposite(c);
            g2d.setPaint(Color.BLACK);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(oldComposite);
        }
    }

    private void hideGlassPanel() {
        if (this.mCancellable) {
            this.setVisible(false);
        }
    }

    class MyComponentListener
    extends ComponentAdapter {
        MyComponentListener() {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            GlassPanel.this.setVisible(false);
        }
    }

    class ShieldMouseListener
    extends MouseAdapter {
        ShieldMouseListener(GlassPanel this$0) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    class EscAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            GlassPanel.this.hideGlassPanel();
        }
    }
}

