/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final int RADIAL = 2;
    public static final int DIAGONAL_LEFT = 3;
    public static final int DIAGONAL_RIGHT = 4;
    public static final Color DEFAULT_FROM_COLOR = new Color(174, 218, 255);
    public static final Color DEFAULT_TO_COLOR = new Color(114, 185, 241);
    private int direction = 0;
    private boolean cyclic;
    private int maxLength;
    private Color fromColor;
    private Color toColor;

    public GradientPanel() {
        this(0, DEFAULT_FROM_COLOR, DEFAULT_TO_COLOR);
    }

    public GradientPanel(int direction) {
        this(direction, DEFAULT_FROM_COLOR, DEFAULT_TO_COLOR);
    }

    public GradientPanel(Color fromColor, Color toColor) {
        this(0, fromColor, toColor);
    }

    public GradientPanel(int direction, Color fromColor, Color toColor) {
        super(new BorderLayout());
        this.direction = direction;
        this.fromColor = fromColor;
        this.toColor = toColor;
        if (fromColor == null || toColor == null) {
            this.setOpaque(true);
        } else {
            this.setOpaque(false);
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public boolean isCyclic() {
        return this.cyclic;
    }

    public void setCyclic(boolean cyclic) {
        this.cyclic = cyclic;
    }

    public void setMaxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public Color getFromColor() {
        return this.fromColor;
    }

    public void setFromColor(Color fromColor) {
        this.fromColor = fromColor;
    }

    public Color getToColor() {
        return this.toColor;
    }

    public void setToColor(Color toColor) {
        this.toColor = toColor;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Paint paint = null;
        switch (this.direction) {
            case 0: {
                paint = new GradientPaint(0.0f, height / 2, this.fromColor, width, height / 2, this.toColor, this.cyclic);
                break;
            }
            case 1: {
                paint = new GradientPaint(width / 2, 0.0f, this.fromColor, width / 2, this.maxLength > 0 ? (float)this.maxLength : (float)height, this.toColor, this.cyclic);
                break;
            }
            case 2: {
                paint = new RadialGradientPaint(new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0), (float)this.getWidth() / 2.0f, new float[]{0.0f, 1.0f}, new Color[]{this.fromColor, this.toColor});
                break;
            }
            case 3: {
                paint = new GradientPaint(0.0f, 0.0f, this.fromColor, width, height, this.toColor, this.cyclic);
                break;
            }
            case 4: {
                paint = new GradientPaint(width, 0.0f, this.fromColor, 0.0f, height, this.toColor, this.cyclic);
            }
        }
        if (paint == null) {
            throw new RuntimeException("Invalid direction specified in GradientPanel");
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.fromColor == null || this.toColor == null) {
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, width, height);
        } else {
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            g2d.fillRect(0, 0, width, height);
            g2d.setPaint(oldPaint);
        }
    }
}

