/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.util.GraphicUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;

public class ImageDispPanel
extends JComponent {
    private BufferedImage mImage;
    private Dimension mSize;

    public ImageDispPanel(double mainRatio, Dimension parentSize, BufferedImage image) {
        MediaTracker mt = new MediaTracker(this);
        mt.addImage(image, 0);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        double ratio1 = this.getRatio(image, new Dimension((int)parentSize.getWidth(), (int)parentSize.getHeight()));
        double ratio2 = Math.min(1.0, ratio1);
        double finalRatio = ratio2 * mainRatio;
        int imgDispWidth = (int)((double)image.getWidth() * finalRatio);
        int imgDispHeight = (int)((double)image.getHeight() * finalRatio);
        this.mSize = new Dimension(imgDispWidth, imgDispHeight);
        this.mImage = GraphicUtil.createScaledImage(image, finalRatio);
        this.setSize(this.mSize);
    }

    @Override
    public void paint(Graphics g) {
        int imgX = (int)((this.mSize.getWidth() - (double)this.mImage.getWidth()) / 2.0);
        int imgY = (int)((this.mSize.getHeight() - (double)this.mImage.getHeight()) / 2.0);
        g.drawImage(this.mImage, imgX, imgY, this.mImage.getWidth(), this.mImage.getHeight(), this);
    }

    private double getRatio(BufferedImage image, Dimension parentSize) {
        double ratio2;
        double width = parentSize.getWidth();
        double height = parentSize.getHeight();
        double ratio1 = width / (double)image.getWidth();
        double ratio = ratio1 > (ratio2 = height / (double)image.getHeight()) ? ratio2 : ratio1;
        return ratio;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.mSize;
    }
}

