/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageLabel
extends JLabel {
    public static final Color BORDER_COLOR_NORMAL = Color.LIGHT_GRAY;
    public static final Color BORDER_COLOR_OVER = Color.LIGHT_GRAY;
    public static final Color BORDER_COLOR_PRESSED = Color.GRAY;
    public static final Color BG_COLOR_NORMAL_FROM = new Color(240, 240, 240);
    public static final Color BG_COLOR_NORMAL_TO = new Color(240, 240, 240);
    public static final Color BG_COLOR_OVER_FROM = Color.WHITE;
    public static final Color BG_COLOR_OVER_TO = Color.WHITE;
    public static final Color BG_COLOR_PRESSED_FROM = new Color(224, 224, 224);
    public static final Color BG_COLOR_PRESSED_TO = new Color(192, 192, 192);
    private static final BasicStroke STROKE = new BasicStroke(1.0f, 2, 0, 1.0f, null, 0.0f);
    Color borderColorNormal = BORDER_COLOR_NORMAL;
    Color borderColorOver = BORDER_COLOR_OVER;
    Color borderColorPressed = BORDER_COLOR_PRESSED;
    Color bgColorNormalFrom = BG_COLOR_NORMAL_FROM;
    Color bgColorNormalTo = BG_COLOR_NORMAL_TO;
    Color bgColorOverFrom = BG_COLOR_OVER_FROM;
    Color bgColorOverTo = BG_COLOR_OVER_TO;
    Color bgColorPressedFrom = BG_COLOR_PRESSED_FROM;
    Color bgColorPressedTo = BG_COLOR_PRESSED_TO;
    Icon iconNormal = null;
    Icon iconOver = null;
    Icon iconClick = null;
    int arc = 20;
    private Color paintingBorderColor = BORDER_COLOR_NORMAL;
    private Color paintingBgFromColor = BG_COLOR_NORMAL_FROM;
    private Color paintingBgToColor = BG_COLOR_NORMAL_TO;

    public static void main(String[] args) {
        JPanel p = new JPanel();
        p.setBackground(Color.WHITE);
        p.add(new ImageLabel((Icon)UIConstants.ICON_FILE, "\u4e2d\u6587\u6e2c\u8a66 aaaaaaaabbbbbbbbbb"));
        p.add(new ImageLabel((Icon)UIConstants.ICON_FILE, "<html>\u4e2d\u6587\u6e2c\u8a66 aaaaaaaa<br>bbbbbbbbbb<br>bbbbbbbbbb<br>bbbbbbbbbb<html>"));
        JFrame frame = new JFrame("test");
        frame.setDefaultCloseOperation(3);
        frame.setContentPane(p);
        frame.setLocationRelativeTo(null);
        frame.setSize(300, 400);
        frame.setVisible(true);
    }

    public ImageLabel(Icon icon) {
        this.init(icon, null);
    }

    public ImageLabel(Icon icon, String text) {
        this.init(icon, text);
    }

    public ImageLabel(Icon normalIcon, Icon overIcon, Icon clickIcon) {
        this.init(normalIcon, null);
        this.iconNormal = normalIcon;
        this.iconOver = overIcon;
        this.iconClick = clickIcon;
    }

    public ImageLabel(Icon normalIcon, Icon overIcon, Icon clickIcon, String text) {
        this.init(normalIcon, text);
        this.iconNormal = normalIcon;
        this.iconOver = overIcon;
        this.iconClick = clickIcon;
    }

    private void init(Icon icon, String text) {
        this.setIcon(icon);
        this.setText(text);
        this.setFont(UIConstants.FONT_12_PLAIN);
        this.setIconTextGap(7);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (ImageLabel.this.isEnabled()) {
                    ImageLabel.this.changeUI(ImageLabel.this.borderColorNormal, ImageLabel.this.bgColorNormalFrom, ImageLabel.this.bgColorNormalTo, ImageLabel.this.iconNormal);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (ImageLabel.this.isEnabled()) {
                    ImageLabel.this.changeUI(ImageLabel.this.borderColorOver, ImageLabel.this.bgColorOverFrom, ImageLabel.this.bgColorOverTo, ImageLabel.this.iconOver);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (ImageLabel.this.isEnabled()) {
                    ImageLabel.this.changeUI(ImageLabel.this.borderColorPressed, ImageLabel.this.bgColorPressedFrom, ImageLabel.this.bgColorPressedTo, ImageLabel.this.iconClick);
                }
            }
        });
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!enabled) {
            this.changeUI(this.borderColorNormal, this.bgColorNormalFrom, this.bgColorNormalTo, this.iconNormal);
        }
    }

    public void setFlatMode(boolean b) {
        if (b) {
            this.bgColorNormalFrom = null;
            this.bgColorNormalTo = null;
            this.bgColorOverFrom = null;
            this.bgColorOverTo = null;
            this.bgColorPressedFrom = null;
            this.bgColorPressedTo = null;
            this.paintingBgFromColor = null;
            this.paintingBgToColor = null;
        } else {
            this.borderColorNormal = BORDER_COLOR_NORMAL;
            this.bgColorNormalFrom = BG_COLOR_NORMAL_FROM;
            this.bgColorNormalTo = BG_COLOR_NORMAL_TO;
            this.bgColorOverFrom = BG_COLOR_OVER_FROM;
            this.bgColorOverTo = BG_COLOR_OVER_TO;
            this.bgColorPressedFrom = BG_COLOR_PRESSED_FROM;
            this.bgColorPressedTo = BG_COLOR_PRESSED_TO;
        }
    }

    public Color getNormalBorderColor() {
        return this.borderColorNormal;
    }

    public void setNormalBorderColor(Color borderColorNormal) {
        this.borderColorNormal = borderColorNormal;
        this.paintingBorderColor = borderColorNormal;
    }

    public int getArc() {
        return this.arc;
    }

    public void setArc(int arc) {
        this.arc = arc;
    }

    @Override
    public void setIcon(Icon icon) {
        super.setIcon(icon);
        this.iconOver = this.iconClick = icon;
        this.iconNormal = this.iconClick;
    }

    private void changeUI(Color paintingBorderColor, Color paintingBgFromColor, Color paintingBgToColor, Icon paintingIcon) {
        this.paintingBorderColor = paintingBorderColor;
        this.paintingBgFromColor = paintingBgFromColor;
        this.paintingBgToColor = paintingBgToColor;
        this.setIcon(paintingIcon);
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, this.arc, this.arc);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g2d.getStroke();
        Paint oldPaint = g2d.getPaint();
        if (this.paintingBgFromColor != null) {
            GradientPaint paint = new GradientPaint(width / 2, 0.0f, this.paintingBgFromColor, width / 2, height, this.paintingBgToColor, false);
            g2d.setPaint(paint);
            g2d.fill(rect);
        }
        if (this.paintingBorderColor != null) {
            g2d.setStroke(STROKE);
            g2d.setColor(this.paintingBorderColor);
            g2d.draw(rect);
        }
        g2d.setPaint(oldPaint);
        g2d.setStroke(oldStroke);
        super.paintComponent(g2d);
    }

    public int calculatePreferWidth() {
        FontMetrics metrics = this.getFontMetrics(this.getFont());
        int textWidth = metrics.stringWidth(this.getText());
        int iconWidth = this.getIcon() != null ? this.getIcon().getIconWidth() : 0;
        int iconTextGap = this.getIconTextGap();
        Insets insets = this.getInsets();
        int totalInsetsWidth = insets.left + insets.right;
        int totalWidth = textWidth + iconWidth + iconTextGap + totalInsetsWidth + 20;
        return totalWidth;
    }
}

