/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.MarqueeState;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MarqueePanel
extends JPanel
implements ActionListener {
    protected boolean paintChildren;
    protected MarqueeState state = MarqueeState.STOP;
    protected int scrollOffset;
    protected int wrapOffset;
    private int preferredWidth = -1;
    private int scrollAmount;
    private int scrollFrequency;
    private boolean wrap = false;
    private int wrapAmount = 50;
    private JLabel marqueeText = null;
    private Timer timer = new Timer(1000, this);
    private MarqueeContentProvider provider = null;

    public MarqueePanel(MarqueeContentProvider provider) {
        this(50, 1, provider);
    }

    public MarqueePanel(int scrollFrequency, int scrollAmount, MarqueeContentProvider provider) {
        this.provider = provider;
        this.setScrollFrequency(scrollFrequency);
        this.setScrollAmount(scrollAmount);
        this.setLayout(new BoxLayout(this, 0));
        this.setOpaque(false);
        this.marqueeText = new JLabel("");
        this.marqueeText.setFont(UIConstants.FONT_16_BOLD);
        this.add(this.marqueeText);
    }

    public void updateQueueStatus(String queueStatus) {
    }

    @Override
    public void paintChildren(Graphics g) {
        if (!this.paintChildren) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(-this.scrollOffset, 0);
        super.paintChildren(g);
        g2d.translate(this.scrollOffset, 0);
        if (this.isWrap()) {
            this.wrapOffset = this.scrollOffset - super.getPreferredSize().width - this.wrapAmount;
            g2d.translate(-this.wrapOffset, 0);
            super.paintChildren(g);
            g2d.translate(this.wrapOffset, 0);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension d = super.getPreferredSize();
        d.width = this.preferredWidth == -1 ? d.width / 2 : this.preferredWidth;
        return d;
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth = preferredWidth;
        this.revalidate();
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setScrollAmount(int scrollAmount) {
        this.scrollAmount = scrollAmount;
    }

    public int getScrollFrequency() {
        return this.scrollFrequency;
    }

    public void setScrollFrequency(int scrollFrequency) {
        this.scrollFrequency = scrollFrequency;
        int delay = 1000 / scrollFrequency;
        this.timer.setInitialDelay(delay);
        this.timer.setDelay(delay);
    }

    public boolean isWrap() {
        return this.wrap;
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public int getWrapAmount() {
        return this.wrapAmount;
    }

    public void setWrapAmount(int wrapAmount) {
        this.wrapAmount = wrapAmount;
    }

    public void startScrolling() {
        this.paintChildren = true;
        this.scrollOffset = -this.getSize().width;
        this.timer.start();
        this.state = MarqueeState.RUNNING;
    }

    public void stopScrolling() {
        this.timer.stop();
        this.paintChildren = false;
        this.repaint();
        this.state = MarqueeState.STOP;
    }

    public void pauseScrolling() {
        if (this.state == MarqueeState.RUNNING && this.timer.isRunning()) {
            this.timer.stop();
            this.state = MarqueeState.PAUSED;
        }
    }

    public void resumeScrolling() {
        if (this.state == MarqueeState.PAUSED) {
            this.timer.restart();
            this.state = MarqueeState.RUNNING;
        }
    }

    public MarqueeState getState() {
        return this.state;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (this.provider != null) {
            this.marqueeText.setText(this.provider.getMarqueeText());
        }
        this.scrollOffset += this.scrollAmount;
        int width = super.getPreferredSize().width;
        if (this.scrollOffset > width) {
            this.scrollOffset = this.isWrap() ? this.wrapOffset + this.scrollAmount : -this.getSize().width;
        }
        this.repaint();
    }

    public static interface MarqueeContentProvider {
        public String getMarqueeText();
    }
}

