/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JViewport;

public class NavigationBar
extends JPanel {
    private JViewport vpContent;
    private JPanel panelContent;
    private JButton btnBack;
    private JButton btnForward;
    private int mMoveInterval = -1;

    public static void main(String[] args) {
        NavigationBar nb = new NavigationBar();
        nb.addItem(new JButton("aaa"));
        nb.addItem(new JButton("Albert"));
        nb.addItem(new JButton("\u6e2c\u8a66\u4e00\u4e0b"));
        JFrame frame = new JFrame();
        frame.getContentPane().add(nb);
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public NavigationBar() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setOpaque(false);
            this.btnBack = new JButton();
            this.add((Component)this.btnBack, "West");
            this.btnBack.setIcon(UIConstants.ICON_ARROW_BACK);
            this.btnBack.setPreferredSize(new Dimension(16, 16));
            this.btnBack.setMaximumSize(new Dimension(16, 16));
            this.btnBack.setMinimumSize(new Dimension(16, 16));
            this.btnBack.setFocusPainted(false);
            this.btnBack.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NavigationBar.this.btnBackActionPerformed(evt);
                }
            });
            this.vpContent = new JViewport();
            this.add((Component)this.vpContent, "Center");
            this.panelContent = new JPanel();
            this.vpContent.setView(this.panelContent);
            this.vpContent.setOpaque(false);
            this.vpContent.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent evt) {
                    NavigationBar.this.vpContentComponentResized(evt);
                }
            });
            BoxLayout panelChairmanLayout = new BoxLayout(this.panelContent, 0);
            this.panelContent.setLayout(panelChairmanLayout);
            this.panelContent.setOpaque(false);
            this.btnForward = new JButton();
            this.add((Component)this.btnForward, "East");
            this.btnForward.setIcon(UIConstants.ICON_ARROW_FORWARD);
            this.btnForward.setPreferredSize(new Dimension(16, 16));
            this.btnForward.setMaximumSize(new Dimension(16, 16));
            this.btnForward.setMinimumSize(new Dimension(16, 16));
            this.btnForward.setFocusPainted(false);
            this.btnForward.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    NavigationBar.this.btnForwardActionPerformed(evt);
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnBackActionPerformed(ActionEvent evt) {
        int viewX = this.vpContent.getViewPosition().x;
        viewX = Math.max(viewX - 100, 0);
        this.vpContent.setViewPosition(new Point(viewX, 0));
    }

    private void btnForwardActionPerformed(ActionEvent evt) {
        int viewX = this.vpContent.getViewPosition().x;
        this.vpContent.setViewPosition(new Point(viewX += 100, 0));
    }

    private void vpContentComponentResized(ComponentEvent evt) {
        boolean shorter = (double)this.vpContent.getWidth() <= this.panelContent.getPreferredSize().getWidth();
        this.btnBack.setVisible(shorter);
        this.btnForward.setVisible(shorter);
    }

    public int getMoveInterval() {
        int ret = this.mMoveInterval;
        if (ret <= 0) {
            Component firstComp;
            Dimension prefSize;
            ret = this.panelContent.getComponentCount() == 0 ? 0 : ((prefSize = (firstComp = this.panelContent.getComponent(0)).getPreferredSize()) == null ? firstComp.getSize().width : prefSize.width);
        }
        return ret;
    }

    public void setMoveInterval(int moveInterval) {
        this.mMoveInterval = moveInterval;
    }

    public void addItem(Component item) {
        this.panelContent.add(item);
        this.panelContent.revalidate();
        this.panelContent.repaint();
    }

    public void clearItems() {
        this.panelContent.removeAll();
        this.panelContent.revalidate();
        this.panelContent.repaint();
    }
}

