/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class RoundedCornerLabel
extends JLabel {
    private int borderArc = 28;
    private int borderWidth = 6;
    private float borderThick = 2.0f;
    private Color borderColor = Color.WHITE;
    private BasicStroke borderStroke;
    private Icon normalIcon = null;
    private Color normalBackground = null;
    private Color normalBackgroundFrom = null;
    private Color normalBackgroundTo = null;
    private Icon overIcon = null;
    private Color overBackground = null;
    private Color overBackgroundFrom = null;
    private Color overBackgroundTo = null;
    private Icon clickIcon = null;
    private Color clickBackground = null;
    private Color clickBackgroundFrom = null;
    private Color clickBackgroundTo = null;
    private Color paintBackground;
    private Color paintBackgroundFrom;
    private Color paintBackgroundTo;

    public RoundedCornerLabel(int arc) {
        this.borderArc = arc;
        this.init();
    }

    public RoundedCornerLabel(int arc, float borderThick) {
        this.borderArc = arc;
        this.borderThick = borderThick;
        this.init();
    }

    public RoundedCornerLabel(String text, int arc, float borderThick) {
        this.setText(text);
        this.borderArc = arc;
        this.borderThick = borderThick;
        this.init();
    }

    public RoundedCornerLabel(String text, int arc, float borderThick, Color backgroud) {
        this.setText(text);
        this.borderArc = arc;
        this.borderThick = borderThick;
        this.normalBackground = backgroud;
        this.init();
    }

    public RoundedCornerLabel(String text) {
        this.setText(text);
        this.init();
    }

    public RoundedCornerLabel(String text, Icon icon) {
        this.setText(text);
        this.setIcon(icon);
        this.init();
    }

    public RoundedCornerLabel(String text, Icon icon, Color backgroud) {
        this.setText(text);
        this.setIcon(icon);
        this.normalBackground = backgroud;
        this.init();
    }

    public RoundedCornerLabel(String text, Icon icon, Color backgroud, float borderThick) {
        this.setText(text);
        this.setIcon(icon);
        this.normalBackground = backgroud;
        this.borderThick = borderThick;
        this.init();
    }

    public RoundedCornerLabel(String text, Icon icon, Color normalBackgroud, Color overBackgroud, Color clickBackgroud) {
        this.setText(text);
        this.setIcon(icon);
        this.overIcon = this.clickIcon = icon;
        this.normalIcon = this.clickIcon;
        this.normalBackground = normalBackgroud;
        this.overBackground = overBackgroud;
        this.clickBackground = clickBackgroud;
        this.init();
        this.initAnimation();
    }

    public RoundedCornerLabel(String text, Icon icon, Color normalBackgroud, Color overBackgroud, Color clickBackgroud, int borderArc, int borderWidth) {
        this.setText(text);
        this.setIcon(icon);
        this.overIcon = this.clickIcon = icon;
        this.normalIcon = this.clickIcon;
        this.normalBackground = normalBackgroud;
        this.overBackground = overBackgroud;
        this.clickBackground = clickBackgroud;
        this.borderArc = borderArc;
        this.borderWidth = borderWidth;
        this.init();
        this.initAnimation();
    }

    public RoundedCornerLabel(String text, Icon icon, Color normalBackgroudFrom, Color normalBackgroudTo, Color overBackgroudFrom, Color overBackgroudTo, Color clickBackgroudFrom, Color clickBackgroudTo) {
        this.setText(text);
        this.setIcon(icon);
        this.overIcon = this.clickIcon = icon;
        this.normalIcon = this.clickIcon;
        this.normalBackgroundFrom = normalBackgroudFrom;
        this.normalBackgroundTo = normalBackgroudTo;
        this.overBackgroundFrom = overBackgroudFrom;
        this.overBackgroundTo = overBackgroudTo;
        this.clickBackgroundFrom = clickBackgroudFrom;
        this.clickBackgroundTo = clickBackgroudTo;
        this.init();
        this.initAnimation();
    }

    private void init() {
        this.setFont(UIConstants.FONT_12_PLAIN);
        this.setBorder(BorderFactory.createEmptyBorder(this.borderWidth, this.borderArc / 2, this.borderWidth, this.borderArc / 2));
        this.setOpaque(false);
        this.paintBackgroundFrom = this.normalBackgroundFrom;
        this.paintBackgroundTo = this.normalBackgroundTo;
        this.paintBackground = this.normalBackground;
        this.borderStroke = new BasicStroke(this.borderThick);
    }

    private void initAnimation() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (RoundedCornerLabel.this.isEnabled()) {
                    RoundedCornerLabel.this.changeUI(RoundedCornerLabel.this.normalBackgroundFrom, RoundedCornerLabel.this.normalBackgroundTo, RoundedCornerLabel.this.normalBackground, RoundedCornerLabel.this.normalIcon);
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (RoundedCornerLabel.this.isEnabled()) {
                    RoundedCornerLabel.this.changeUI(RoundedCornerLabel.this.overBackgroundFrom, RoundedCornerLabel.this.overBackgroundTo, RoundedCornerLabel.this.overBackground, RoundedCornerLabel.this.overIcon);
                }
            }

            @Override
            public void mousePressed(MouseEvent evt) {
                if (RoundedCornerLabel.this.isEnabled()) {
                    RoundedCornerLabel.this.changeUI(RoundedCornerLabel.this.clickBackgroundFrom, RoundedCornerLabel.this.clickBackgroundTo, RoundedCornerLabel.this.clickBackground, RoundedCornerLabel.this.clickIcon);
                }
            }
        });
    }

    private void changeUI(Color paintBackgroundFrom, Color paintBackgroundTo, Color paintBackground, Icon paintingIcon) {
        this.paintBackgroundFrom = paintBackgroundFrom;
        this.paintBackgroundTo = paintBackgroundTo;
        this.paintBackground = paintBackground;
        this.setIcon(paintingIcon);
        this.repaint();
    }

    public int getArc() {
        return this.borderArc;
    }

    public void setArc(int arc) {
        this.borderArc = arc;
        this.setBorder(BorderFactory.createEmptyBorder(6, arc / 2, 6, arc / 2));
        this.repaint();
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color strokeColor) {
        this.borderColor = strokeColor;
        this.repaint();
    }

    public Icon getNormalIcon() {
        return this.normalIcon;
    }

    public void setNormalIcon(Icon normalIcon) {
        this.normalIcon = normalIcon;
        this.repaint();
    }

    public Color getNormalBackgroundFrom() {
        return this.normalBackgroundFrom;
    }

    public void setNormalBackgroundFrom(Color normalBackgroundFrom) {
        this.normalBackgroundFrom = normalBackgroundFrom;
        this.repaint();
    }

    public Color getNormalBackgroundTo() {
        return this.normalBackgroundTo;
    }

    public void setNormalBackgroundTo(Color normalBackgroundTo) {
        this.normalBackgroundTo = normalBackgroundTo;
        this.repaint();
    }

    public Color getNormalBackground() {
        return this.normalBackground;
    }

    public void setNormalBackground(Color normalBackground) {
        this.normalBackground = normalBackground;
        this.repaint();
    }

    public Icon getOverIcon() {
        return this.overIcon;
    }

    public void setOverIcon(Icon overIcon) {
        this.overIcon = overIcon;
        this.repaint();
    }

    public Color getOverBackgroundFrom() {
        return this.overBackgroundFrom;
    }

    public void setOverBackgroundFrom(Color overBackgroundFrom) {
        this.overBackgroundFrom = overBackgroundFrom;
        this.repaint();
    }

    public Color getOverBackgroundTo() {
        return this.overBackgroundTo;
    }

    public void setOverBackgroundTo(Color overBackgroundTo) {
        this.overBackgroundTo = overBackgroundTo;
        this.repaint();
    }

    public Color getOverBackground() {
        return this.overBackground;
    }

    public void setOverBackground(Color overBackground) {
        this.overBackground = overBackground;
        this.repaint();
    }

    public Icon getClickIcon() {
        return this.clickIcon;
    }

    public void setClickIcon(Icon clickIcon) {
        this.clickIcon = clickIcon;
        this.repaint();
    }

    public Color getClickBackgroundFrom() {
        return this.clickBackgroundFrom;
    }

    public void setClickBackgroundFrom(Color clickBackgroundFrom) {
        this.clickBackgroundFrom = clickBackgroundFrom;
        this.repaint();
    }

    public Color getClickBackgroundTo() {
        return this.clickBackgroundTo;
    }

    public void setClickBackgroundTo(Color clickBackgroundTo) {
        this.clickBackgroundTo = clickBackgroundTo;
        this.repaint();
    }

    public Color getClickBackground() {
        return this.clickBackground;
    }

    public void setClickBackground(Color clickBackground) {
        this.clickBackground = clickBackground;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        Color oldColor = g2d.getColor();
        Stroke oldStroke = g2d.getStroke();
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(0.0, 0.0, width, height, this.borderArc, this.borderArc);
        RoundRectangle2D.Double rect2 = new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, this.borderArc, this.borderArc);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.paintBackgroundFrom == null || this.paintBackgroundTo == null) {
            if (this.paintBackground != null) {
                g2d.setColor(this.paintBackground);
                g2d.fill(rect);
            }
        } else {
            GradientPaint paint = new GradientPaint(width / 2, 0.0f, this.paintBackgroundFrom, width / 2, height, this.paintBackgroundTo, true);
            Paint oldPaint = g2d.getPaint();
            g2d.setPaint(paint);
            g2d.fill(rect);
            g2d.setPaint(oldPaint);
        }
        g2d.setColor(this.borderColor);
        g2d.setStroke(this.borderStroke);
        g2d.draw(rect2);
        g2d.setColor(oldColor);
        g2d.setStroke(oldStroke);
        super.paintComponent(g2d);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new RoundedCornerLabel("RoundedCorner label"));
        frame.getContentPane().add(new RoundedCornerLabel("RoundedCorner label", (Icon)UIConstants.ICON_CHATROOM_48, UIConstants.BACKGROUND_UNJOINED_NORMAL));
        frame.getContentPane().add(new RoundedCornerLabel("Call aaa", 20, 6.0f));
        frame.getContentPane().add(new RoundedCornerLabel("Call", UIConstants.ICON_DIAL, Color.PINK, Color.RED, Color.YELLOW, Color.ORANGE, Color.LIGHT_GRAY, Color.DARK_GRAY));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }
}

