/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class SearchField
extends RoundedCornerPanel {
    private SearchCallback searchCallback;
    private JLabel lblSearch;
    private JTextField txtSearch;
    private JLabel jLabel3;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new SearchField(null));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public SearchField() {
        super(10);
        this.initGUI();
    }

    public SearchField(SearchCallback searchCallback) {
        super(10);
        this.searchCallback = searchCallback;
        this.initGUI();
    }

    public SearchField(int arc, SearchCallback searchCallback) {
        super(arc);
        this.searchCallback = searchCallback;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            thisLayout.setHgap(5);
            this.setLayout(thisLayout);
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
            this.lblSearch = new JLabel();
            this.add((Component)this.lblSearch, "West");
            this.lblSearch.setIcon(UIConstants.ICON_SEARCH);
            this.txtSearch = new HintTextField(I18NUtil.getString("common_placeholder_search"), UIConstants.FONT_14_PLAIN);
            this.add((Component)this.txtSearch, "Center");
            this.txtSearch.setFont(UIConstants.FONT_14_PLAIN);
            this.txtSearch.setForeground(Color.DARK_GRAY);
            this.txtSearch.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.txtSearch.setOpaque(false);
            this.txtSearch.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    String key = SearchField.this.txtSearch.getText();
                    SearchField.this.doSearch(key);
                    SearchField.this.jLabel3.setVisible(StringUtils.isNotBlank((CharSequence)key));
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    String key = SearchField.this.txtSearch.getText();
                    SearchField.this.doSearch(key);
                    SearchField.this.jLabel3.setVisible(StringUtils.isNotBlank((CharSequence)key));
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    String key = SearchField.this.txtSearch.getText();
                    SearchField.this.jLabel3.setVisible(StringUtils.isNotBlank((CharSequence)key));
                }
            });
            this.jLabel3 = new JLabel();
            this.jLabel3.setVisible(false);
            this.add((Component)this.jLabel3, "East");
            this.jLabel3.setIcon(UIConstants.icon_clear);
            this.jLabel3.setCursor(UIConstants.CURSOR_HAND);
            this.jLabel3.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    SearchField.this.jLabel3.setIcon(UIConstants.icon_clearclick);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    SearchField.this.jLabel3.setIcon(UIConstants.icon_clear);
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    SearchField.this.txtSearch.setText("");
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSearchCallback(SearchCallback searchCallback) {
        this.searchCallback = searchCallback;
    }

    private void doSearch(String key) {
        if (this.searchCallback != null) {
            this.searchCallback.doSearch(key);
        }
    }

    public String getSearchKey() {
        return this.txtSearch.getText();
    }

    public void clearSearchKey() {
        this.txtSearch.setText("");
    }

    public static interface SearchCallback {
        public void doSearch(String var1);
    }
}

