/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.stage.FileChooser;
import org.apache.commons.lang3.StringUtils;

public class UCUploadFileChooser {
    public static final List<String> IMAGE_TYPES = Arrays.asList("gif", "jpg", "jpeg", "png", "bmp");
    public static final List<String> TIFF_TYPES = Arrays.asList("tiff");
    public static final List<String> JPG_TYPES = Arrays.asList("jpg", "jpeg");
    public static final List<String> AUDIO_TYPES = Arrays.asList("wav", "mp3", "m4a", "m4a", "flac", "aiff", "aac");
    public static final List<String> VIDEO_TYPES = Arrays.asList("mpg", "mpeg", "avi", "mp4", "m4v", "mov", "3g2", "wmv", "3gp");
    public static final List<String> DOCUMENT_TYPES = Arrays.asList("txt", "pdf", "rtf", "csv", "doc", "docx", "xls", "xlsx", "ppt", "pptx", "vsd", "log", "rar", "zip", "tiff", "ppsx", "svg");
    public static final List<String> FAX_IMAGE_TYPES = Arrays.asList("gif", "jpg", "jpeg", "png");
    public static final List<String> FAX_TYPES = new ArrayList<String>();
    public static final List<String> EXE_TYPES = Arrays.asList("exe");

    public static void setInitialSaveDir(FileChooser fc) {
        String lastDirPath = PreferencesUtil.getChatLastSaveDir(UCChatClient.context);
        File lastDir = null;
        if (StringUtils.isNotBlank((CharSequence)lastDirPath)) {
            lastDir = new File(lastDirPath);
        }
        if (lastDir == null || !lastDir.exists()) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
            PreferencesUtil.setChatLastSaveDir(UCChatClient.context, null);
        } else {
            fc.setInitialDirectory(lastDir);
        }
    }

    public static void setInitialOpenDir(FileChooser fc) {
        String lastDirPath = PreferencesUtil.getChatLastOpenDir(UCChatClient.context);
        File lastDir = null;
        if (StringUtils.isNotBlank((CharSequence)lastDirPath)) {
            lastDir = new File(lastDirPath);
        }
        if (lastDir == null || !lastDir.exists()) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
            PreferencesUtil.setChatLastOpenDir(UCChatClient.context, null);
        } else {
            fc.setInitialDirectory(lastDir);
        }
    }

    public static String getFileExtension(File file) {
        String fileName = file.getName().toLowerCase();
        String fileExt = fileName.lastIndexOf(46) < 0 ? "" : fileName.substring(fileName.lastIndexOf(46) + 1);
        return fileExt;
    }

    public static FileChooser.ExtensionFilter getExtensionFilter(String descr, List<String> extenList1, List<String> extenList2, List<String> extenList3) {
        ArrayList<CallSite> extenList = new ArrayList<CallSite>();
        if (extenList1 != null) {
            for (String x : extenList1) {
                extenList.add((CallSite)((Object)("*." + x)));
            }
        }
        if (extenList2 != null) {
            for (String x : extenList2) {
                extenList.add((CallSite)((Object)("*." + x)));
            }
        }
        if (extenList3 != null) {
            for (String x : extenList3) {
                extenList.add((CallSite)((Object)("*." + x)));
            }
        }
        return new FileChooser.ExtensionFilter(descr, extenList);
    }
}

