/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contact;

import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.bean.web.LiteTeleNumberType;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.contact.EditPhoneDialog;
import com.blisscloud.ezuc.client.contact.EditPhoneResult;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.LiteContactHelper;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.toedter.calendar.JCalendar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AddMyContactDialog
extends GenericDialog
implements PropertyChangeListener {
    private JPanel panelContent;
    private PersonalPhoto lblHeadIcon;
    private JTextField txtContactName;
    private JLabel lblCompanyHeader;
    private JTextField txtCompany;
    private JLabel lblDepartmentHeader;
    private JTextField txtDepartment;
    private JLabel lblTitleHeader;
    private JTextField txtTitle;
    private JLabel lblOfficePhoneHeader;
    private JLabel lblOfficePhone;
    private JLabel lblMobilePhoneHeader;
    private JLabel lblMobilePhone;
    private JLabel lblHomePhoneHeader;
    private JLabel lblHomePhone;
    private JLabel lblBirthdayHeader;
    private JLabel lblBirthday;
    private JLabel lblEmailHeader;
    private JTextField txtEmail;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JSeparator jSeparator7;
    private JLabel lblPadding;
    private JPanel panelConfirm;
    private JButton btnSave;
    private JButton btnCancel;
    boolean mOK;
    EditPhoneDialog epd;
    boolean mFavorite;
    String mContactName;
    String mCompany;
    String mDepartment;
    String mTitle;
    List<LiteTeleNumber> mOfficeNumbers;
    List<LiteTeleNumber> mMobileNumbers;
    List<LiteTeleNumber> mHomeNumbers;
    String mEmail;
    Date mBirthday;
    BufferedImage mPhoto;
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;
    protected JCalendar jcalendar;
    protected JPopupMenu popup;
    protected boolean isInitialized;
    protected boolean dateSelected;
    protected Date lastSelectedDate;
    private ChangeListener changeListener;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                AddMyContactDialog inst = new AddMyContactDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public AddMyContactDialog(JFrame frame) {
        super(frame);
        this.initGUI();
        this.initReceiver();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("abook_btn_addcontact"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.lblHeadIcon = new PersonalPhoto();
            this.lblHeadIcon.setImage(UIConstants.ICON_PERSON64.getImage());
            this.panelContent.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblHeadIcon.setCursor(UIConstants.CURSOR_HAND);
            this.lblHeadIcon.setPreferredSize(new Dimension(64, 64));
            this.lblHeadIcon.setMinimumSize(new Dimension(64, 64));
            this.lblHeadIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    AddMyContactDialog.this.lblHeadIconMouseClicked(evt);
                }
            });
            this.txtContactName = new HintTextField(I18NUtil.getString("abook_mycontact_placeholder_name"));
            this.panelContent.add((Component)this.txtContactName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
            this.txtContactName.setFont(UIConstants.FONT_14_BOLD);
            this.txtContactName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AddMyContactDialog.this.txtContactNameActionPerformed(evt);
                }
            });
            this.jPanel1 = new RoundedCornerPanel();
            LayoutManager jPanel1Layout = new GridBagLayout();
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setBackground(Color.WHITE);
            this.lblCompanyHeader = new JLabel();
            this.jPanel1.add((Component)this.lblCompanyHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblCompanyHeader.setText(I18NUtil.getString("abook_mycontact_label_company_name"));
            this.lblCompanyHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtCompany = new HintTextField(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel1.add((Component)this.txtCompany, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.txtCompany.setFont(UIConstants.FONT_12_PLAIN);
            this.txtCompany.setBorder(null);
            this.txtCompany.setOpaque(false);
            this.jSeparator1 = new JSeparator();
            this.jPanel1.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(Color.LIGHT_GRAY);
            this.jSeparator1.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblDepartmentHeader = new JLabel();
            this.jPanel1.add((Component)this.lblDepartmentHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblDepartmentHeader.setText(I18NUtil.getString("abook_mycontact_label_department"));
            this.lblDepartmentHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtDepartment = new HintTextField(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel1.add((Component)this.txtDepartment, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.txtDepartment.setFont(UIConstants.FONT_12_PLAIN);
            this.txtDepartment.setBorder(null);
            this.txtDepartment.setOpaque(false);
            this.jSeparator2 = new JSeparator();
            this.jPanel1.add((Component)this.jSeparator2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator2.setForeground(Color.LIGHT_GRAY);
            this.jSeparator2.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblTitleHeader = new JLabel();
            this.jPanel1.add((Component)this.lblTitleHeader, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblTitleHeader.setText(I18NUtil.getString("abook_mycontact_label_job_title"));
            this.lblTitleHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtTitle = new HintTextField(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel1.add((Component)this.txtTitle, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.txtTitle.setFont(UIConstants.FONT_12_PLAIN);
            this.txtTitle.setBorder(null);
            this.txtTitle.setOpaque(false);
            this.jPanel2 = new RoundedCornerPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.panelContent.add((Component)this.jPanel2, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.setBackground(Color.WHITE);
            this.lblOfficePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblOfficePhoneHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblOfficePhoneHeader.setText(I18NUtil.getString("abook_office"));
            this.lblOfficePhoneHeader.setIcon(UIConstants.ICON_OFFICEPHONE);
            this.lblOfficePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblOfficePhone = new JLabel(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel2.add((Component)this.lblOfficePhone, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblOfficePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.lblOfficePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblOfficePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    AddMyContactDialog.this.lblOfficePhoneMouseClicked(evt);
                }
            });
            this.jSeparator4 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator4, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator4.setForeground(Color.LIGHT_GRAY);
            this.jSeparator4.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblMobilePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblMobilePhoneHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblMobilePhoneHeader.setText(I18NUtil.getString("abook_mobile"));
            this.lblMobilePhoneHeader.setIcon(UIConstants.ICON_MOBILEPHONE);
            this.lblMobilePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblMobilePhone = new JLabel(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel2.add((Component)this.lblMobilePhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblMobilePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblMobilePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    AddMyContactDialog.this.lblMobilePhoneMouseClicked(evt);
                }
            });
            this.jSeparator5 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator5, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator5.setForeground(Color.LIGHT_GRAY);
            this.jSeparator5.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblHomePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblHomePhoneHeader, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblHomePhoneHeader.setText(I18NUtil.getString("abook_home"));
            this.lblHomePhoneHeader.setIcon(UIConstants.ICON_HOME);
            this.lblHomePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblHomePhone = new JLabel(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel2.add((Component)this.lblHomePhone, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblHomePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.lblHomePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblHomePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    AddMyContactDialog.this.lblHomePhoneMouseClicked(evt);
                }
            });
            this.jSeparator6 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator6, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator6.setForeground(Color.LIGHT_GRAY);
            this.jSeparator6.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblBirthdayHeader = new JLabel();
            this.jPanel2.add((Component)this.lblBirthdayHeader, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblBirthdayHeader.setText(I18NUtil.getString("abook_birthday"));
            this.lblBirthdayHeader.setIcon(UIConstants.ICON_BIRTHDAY);
            this.lblBirthdayHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblBirthday = new JLabel(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel2.add((Component)this.lblBirthday, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.lblBirthday.setFont(UIConstants.FONT_12_PLAIN);
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    AddMyContactDialog.this.lblBirthdayMouseClicked(evt);
                }
            });
            this.jSeparator7 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator7, new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator7.setForeground(Color.LIGHT_GRAY);
            this.jSeparator7.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblEmailHeader = new JLabel();
            this.jPanel2.add((Component)this.lblEmailHeader, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblEmailHeader.setText(I18NUtil.getString("abook_email"));
            this.lblEmailHeader.setIcon(UIConstants.ICON_MAIL);
            this.lblEmailHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtEmail = new HintTextField(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.jPanel2.add((Component)this.txtEmail, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 8, 6, 8), 0, 0));
            this.txtEmail.setFont(UIConstants.FONT_12_PLAIN);
            this.txtEmail.setBorder(null);
            this.txtEmail.setOpaque(false);
            this.lblPadding = new JLabel();
            this.panelContent.add((Component)this.lblPadding, new GridBagConstraints(0, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.panelConfirm = new JPanel();
            jPanel1Layout = new FlowLayout();
            ((FlowLayout)jPanel1Layout).setAlignment(2);
            ((FlowLayout)jPanel1Layout).setHgap(10);
            this.panelConfirm.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.panelConfirm, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.panelConfirm.setOpaque(false);
            this.btnSave = new JButton();
            this.panelConfirm.add(this.btnSave);
            this.btnSave.setText(I18NUtil.getString("common_btn_save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AddMyContactDialog.this.btnSaveActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.panelConfirm.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AddMyContactDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(320, 440);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(this){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    Log.d(AddMyContactDialog.class.getSimpleName(), "AddContactDialog \u6536\u5230\u5ee3\u64ad:" + action);
                }
                catch (Throwable t) {
                    Log.e(AddMyContactDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void lblHeadIconMouseClicked(MouseEvent evt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileChooser fc = new FileChooser();
                UCUploadFileChooser.setInitialOpenDir(fc);
                fc.getExtensionFilters().clear();
                fc.getExtensionFilters().addAll(UCUploadFileChooser.getExtensionFilter(I18NUtil.getString("chat_msg_type_image"), UCUploadFileChooser.IMAGE_TYPES, null, null));
                final File selectedFile = fc.showOpenDialog(null);
                if (selectedFile != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AddMyContactDialog.this.mPhoto = FileUtil.readFileHandleExif(selectedFile);
                            BufferedImage scaledBI = GraphicUtil.createScaledCenterImage(AddMyContactDialog.this.mPhoto, AddMyContactDialog.this.lblHeadIcon.getWidth(), AddMyContactDialog.this.lblHeadIcon.getHeight());
                            AddMyContactDialog.this.lblHeadIcon.setImage(scaledBI);
                            PreferencesUtil.setChatLastOpenDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    private void txtContactNameActionPerformed(ActionEvent evt) {
        this.txtCompany.requestFocus();
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        String contactName = this.txtContactName.getText();
        if (this.isValid(contactName)) {
            this.mContactName = this.txtContactName.getText();
            this.mCompany = this.txtCompany.getText();
            this.mDepartment = this.txtDepartment.getText();
            this.mTitle = this.txtTitle.getText();
            this.mEmail = this.txtEmail.getText();
            this.closeDialog(true);
        }
    }

    @Override
    protected void onESCPressed() {
        this.closeDialog(false);
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeDialog(false);
    }

    private void closeDialog(boolean isOK) {
        this.mOK = isOK;
        this.setVisible(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        if (!b) {
            this.lblHeadIcon.setImage(UIConstants.ICON_PERSON64.getImage());
            this.txtContactName.setText("");
            this.txtCompany.setText("");
            this.txtDepartment.setText("");
            this.txtTitle.setText("");
            this.lblOfficePhone.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.lblOfficePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblMobilePhone.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblHomePhone.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.lblHomePhone.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.txtEmail.setText("");
        }
        super.setVisible(b);
    }

    private boolean isValid(String name) {
        if (TextUtils.isBlank((CharSequence)name)) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("abook_mycontact_placeholder_name"), I18NUtil.getString("common_title_error"), 0);
            this.txtContactName.requestFocus();
            return false;
        }
        String email = this.txtEmail.getText().trim();
        if (!TextUtils.isBlank((CharSequence)email)) {
            Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
            Matcher matcher = pattern.matcher(email);
            if (!matcher.matches()) {
                JOptionPane.showMessageDialog(this, I18NUtil.getString("abook_validation_email_format_incorrect"), I18NUtil.getString("common_title_error"), 0);
                this.txtEmail.requestFocus();
                return false;
            }
            if (email.length() > 50) {
                JOptionPane.showMessageDialog(this, I18NUtil.getString("abook_validation_email_length_incorrect"), I18NUtil.getString("common_title_error"), 0);
                this.txtEmail.requestFocus();
                return false;
            }
        }
        return true;
    }

    public AddMyContactResult showDialog() {
        this.mFavorite = false;
        this.mContactName = null;
        this.mCompany = null;
        this.mDepartment = null;
        this.mTitle = null;
        this.mOfficeNumbers = null;
        this.mMobileNumbers = null;
        this.mHomeNumbers = null;
        this.mBirthday = null;
        this.mPhoto = null;
        this.mEmail = null;
        this.setVisible(true);
        if (this.mOK) {
            ArrayList<LiteTeleNumber> phones = new ArrayList<LiteTeleNumber>();
            if (this.mOfficeNumbers != null) {
                phones.addAll(this.mOfficeNumbers);
            }
            if (this.mMobileNumbers != null) {
                phones.addAll(this.mMobileNumbers);
            }
            if (this.mHomeNumbers != null) {
                phones.addAll(this.mHomeNumbers);
            }
            String phoneStr = LiteContactHelper.getNumbers(phones);
            String birthdayStr = DateTimeUtil.getBirthdayTimeStr(this.mBirthday);
            AddMyContactResult res = new AddMyContactResult(this);
            res.setContactName(this.mContactName);
            res.setCompany(this.mCompany);
            res.setDepartment(this.mDepartment);
            res.setTitle(this.mTitle);
            res.setPhones(phoneStr);
            res.setEmail(this.mEmail);
            res.setBirthday(birthdayStr);
            res.setPhoto(this.mPhoto);
            WebAgent.getInstance().addExternalContact(this.mContactName, phoneStr, this.mCompany, this.mDepartment, this.mTitle, birthdayStr, this.mEmail, this.mPhoto == null ? null : GraphicUtil.convertImageToBase64String(this.mPhoto));
            return res;
        }
        return null;
    }

    private void adjustDialogSize() {
        int count;
        int extraItemCount = 0;
        if (this.mOfficeNumbers != null) {
            count = this.mOfficeNumbers.size();
            extraItemCount += count <= 1 ? 0 : count - 1;
        }
        if (this.mMobileNumbers != null) {
            count = this.mMobileNumbers.size();
            extraItemCount += count <= 1 ? 0 : count - 1;
        }
        if (this.mHomeNumbers != null) {
            count = this.mHomeNumbers.size();
            extraItemCount += count <= 1 ? 0 : count - 1;
        }
        int appendHeight = extraItemCount > 0 ? extraItemCount * 25 : 0;
        this.setSize(320, 440 + appendHeight);
        this.lblOfficePhone.revalidate();
        this.lblMobilePhone.revalidate();
        this.lblHomePhone.revalidate();
        this.jPanel2.revalidate();
        this.jPanel2.repaint();
    }

    private void lblOfficePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.OFFICE, this.mOfficeNumbers);
        if (result != null) {
            this.mOfficeNumbers = result.getNumbers();
            if (this.mOfficeNumbers == null || this.mOfficeNumbers.size() == 0) {
                this.lblOfficePhone.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
                this.lblOfficePhone.setForeground(HintTextField.HINT_COLOR);
            } else {
                this.lblOfficePhone.setText(CommonUtil.getNumberHtmlTable(this.mOfficeNumbers, false));
                this.lblOfficePhone.setForeground(UIManager.getColor("Label.foreground"));
            }
            this.adjustDialogSize();
        }
    }

    private void lblMobilePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.MOBILE, this.mMobileNumbers);
        if (result != null) {
            this.mMobileNumbers = result.getNumbers();
            if (this.mMobileNumbers == null || this.mMobileNumbers.size() == 0) {
                this.lblMobilePhone.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
                this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
            } else {
                this.lblMobilePhone.setText(CommonUtil.getNumberHtmlTable(this.mMobileNumbers, false));
                this.lblMobilePhone.setForeground(UIManager.getColor("Label.foreground"));
            }
            this.adjustDialogSize();
        }
    }

    private void lblHomePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.HOME, this.mHomeNumbers);
        if (result != null) {
            this.mHomeNumbers = result.getNumbers();
            if (this.mHomeNumbers == null || this.mHomeNumbers.size() == 0) {
                this.lblHomePhone.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
                this.lblHomePhone.setForeground(HintTextField.HINT_COLOR);
            } else {
                this.lblHomePhone.setText(CommonUtil.getNumberHtmlTable(this.mHomeNumbers, false));
                this.lblHomePhone.setForeground(UIManager.getColor("Label.foreground"));
            }
            this.adjustDialogSize();
        }
    }

    private EditPhoneResult showEditPhoneDialog(LiteTeleNumberType type, List<LiteTeleNumber> numbers) {
        if (this.epd == null) {
            this.epd = new EditPhoneDialog(this);
        }
        this.epd.setLocationRelativeTo(this);
        return this.epd.showDialog(type, numbers);
    }

    private void lblBirthdayMouseClicked(MouseEvent evt) {
        if (this.jcalendar == null) {
            this.initJCalendar();
        }
        int x = 0;
        int y = this.lblBirthday.getHeight();
        Calendar calendar = Calendar.getInstance();
        Date date = this.mBirthday;
        if (date != null) {
            calendar.setTime(date);
        }
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.lblBirthday, x, y);
        this.dateSelected = false;
    }

    private void initJCalendar() {
        this.jcalendar = new JCalendar();
        this.jcalendar.getDayChooser().addPropertyChangeListener("day", (PropertyChangeListener)this);
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.jcalendar.setMaxSelectableDate(new Date());
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && AddMyContactDialog.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add((Component)this.jcalendar);
        this.changeListener = new ChangeListener(){
            boolean hasListened = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.hasListened) {
                    this.hasListened = false;
                    return;
                }
                if (AddMyContactDialog.this.popup.isVisible() && AddMyContactDialog.this.jcalendar.getMonthChooser().getComboBox().hasFocus()) {
                    MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
                    MenuElement[] newMe = new MenuElement[me.length + 1];
                    newMe[0] = AddMyContactDialog.this.popup;
                    for (int i = 0; i < me.length; ++i) {
                        newMe[i + 1] = me[i];
                    }
                    this.hasListened = true;
                    MenuSelectionManager.defaultManager().setSelectedPath(newMe);
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.changeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day") && this.popup.isVisible()) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            if ((Integer)evt.getNewValue() > 0) {
                this.setBirthday(this.jcalendar.getCalendar().getTime());
            } else {
                this.setBirthday(null);
            }
        }
    }

    private void setBirthday(Date date) {
        this.mBirthday = date;
        if (this.mBirthday == null) {
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.setText(I18NUtil.getString("abook_mycontact_placeholder_general"));
        } else {
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
            this.lblBirthday.setText(DateTimeUtil.getBirthdayTimeStr(this.mBirthday));
        }
    }

    class AddMyContactResult {
        String contactName;
        String company;
        String department;
        String title;
        String phones;
        String email;
        String birthday;
        BufferedImage photo;

        AddMyContactResult(AddMyContactDialog this$0) {
        }

        public String getContactName() {
            return this.contactName;
        }

        public void setContactName(String contactName) {
            this.contactName = contactName;
        }

        public String getCompany() {
            return this.company;
        }

        public void setCompany(String company) {
            this.company = company;
        }

        public String getDepartment() {
            return this.department;
        }

        public void setDepartment(String department) {
            this.department = department;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getPhones() {
            return this.phones;
        }

        public void setPhones(String phones) {
            this.phones = phones;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getBirthday() {
            return this.birthday;
        }

        public void setBirthday(String birthday) {
            this.birthday = birthday;
        }

        public BufferedImage getPhoto() {
            return this.photo;
        }

        public void setPhoto(BufferedImage photo) {
            this.photo = photo;
        }
    }
}

