/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contact;

import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.bean.web.LiteTeleNumberType;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.IView;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.contact.EditPhoneDialog;
import com.blisscloud.ezuc.client.contact.EditPhoneResult;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.LiteContactHelper;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.Utils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.toedter.calendar.JCalendar;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;

public class MyContactEditor
extends JPanel
implements IView,
PropertyChangeListener {
    private static final long serialVersionUID = 6541794467194673000L;
    private PersonalPhoto lblHeadIcon;
    private HintTextField txtName;
    private JLabel lblFavorite;
    private JButton btnEdit;
    private JLabel lblCompanyHeader;
    private HintTextField txtCompany;
    private JLabel lblDepartmentHeader;
    private HintTextField txtDepartment;
    private JLabel lblTitleHeader;
    private HintTextField txtTitle;
    private JLabel lblOfficePhoneHeader;
    private JTextPane tpOfficePhone;
    private JLabel lblMobilePhoneHeader;
    private JTextPane tpMobilePhone;
    private JLabel lblHomePhoneHeader;
    private JTextPane tpHomePhone;
    private JLabel lblBirthdayHeader;
    private JLabel lblBirthday;
    private JLabel lblEmailHeader;
    private HintTextField txtEmail;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JSeparator jSeparator5;
    private JSeparator jSeparator6;
    private JButton btnDelete;
    private JLabel lblPadding;
    protected Date mBirthday;
    protected BufferedImage mPhoto;
    protected List<LiteTeleNumber> mHomeNumbers;
    protected List<LiteTeleNumber> mMobileNumbers;
    protected List<LiteTeleNumber> mOfficeNumbers;
    private long mId;
    private LiteMyContact mContact;
    private boolean mFlagIsFavorite;
    EditPhoneDialog epd;
    boolean mChangePhoto;
    MyContactBroadcastReceiver myContactReceiver;
    IntentFilter intentFilter;
    Mode mode = Mode.VIEW;
    protected JCalendar jcalendar;
    protected JPopupMenu popup;
    protected boolean isInitialized;
    protected boolean dateSelected;
    protected Date lastSelectedDate;
    private ChangeListener changeListener;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new MyContactEditor());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public MyContactEditor() {
        this.myContactReceiver = new MyContactBroadcastReceiver();
        this.intentFilter = new IntentFilter();
        this.intentFilter.addAction("ezuc.intent.action.event.EXTERNAL_CONTACT_LIST_CHANGED");
        this.intentFilter.addAction("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED");
        this.initGUI();
        LiteTeleNumber office1 = new LiteTeleNumber();
        office1.setNumber("123");
        office1.setSiteId(1L);
        office1.setType(LiteTeleNumberType.OFFICE);
        LiteTeleNumber office2 = new LiteTeleNumber();
        office1.setNumber("456");
        office1.setSiteId(2L);
        office1.setType(LiteTeleNumberType.OFFICE);
        this.mOfficeNumbers = new ArrayList<LiteTeleNumber>();
        this.mOfficeNumbers.add(office1);
        this.mOfficeNumbers.add(office2);
        MyContactEditor.updateNumberTable(this.tpOfficePhone, this.mOfficeNumbers, true);
        MyContactEditor.updateNumberTable(this.tpMobilePhone, this.mMobileNumbers, true);
        MyContactEditor.updateNumberTable(this.tpHomePhone, this.mHomeNumbers, true);
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            this.setPreferredSize(new Dimension(550, 500));
            this.lblHeadIcon = new PersonalPhoto();
            this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblHeadIcon.setPreferredSize(new Dimension(64, 64));
            this.lblHeadIcon.setMinimumSize(new Dimension(64, 64));
            this.lblHeadIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MyContactEditor.this.mode == Mode.EDIT) {
                        MyContactEditor.this.lblHeadIconMouseClicked(evt);
                    }
                }
            });
            this.txtName = new HintTextField(I18NUtil.getString("common_not_yet_setting"));
            this.add((Component)this.txtName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 10, 0, 10), 0, 0));
            this.txtName.setFont(UIConstants.FONT_14_BOLD);
            this.txtName.setBorder(null);
            this.txtName.setOpaque(false);
            this.txtName.setEditable(false);
            this.lblFavorite = new JLabel();
            this.add((Component)this.lblFavorite, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 16, 0, new Insets(0, 10, 0, 10), 0, 0));
            this.lblFavorite.setIcon(UIConstants.ICON_FAVORITE_OFF);
            this.lblFavorite.setToolTipText(I18NUtil.getString("abook_btn_add_to_my_favorites"));
            this.lblFavorite.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MyContactEditor.this.mode == Mode.VIEW) {
                        MyContactEditor.this.lblFavoriteMouseClicked(evt);
                    }
                }
            });
            this.btnEdit = new JButton();
            this.add((Component)this.btnEdit, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 12, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnEdit.setIcon(UIConstants.ICON_EDIT);
            this.btnEdit.setText(I18NUtil.getString("common_btn_edit"));
            this.btnEdit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MyContactEditor.this.btnEditActionPerformed(evt);
                }
            });
            this.jPanel1 = new RoundedCornerPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setBackground(Color.WHITE);
            this.lblCompanyHeader = new JLabel();
            this.jPanel1.add((Component)this.lblCompanyHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblCompanyHeader.setText(I18NUtil.getString("abook_mycontact_label_company_name"));
            this.lblCompanyHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtCompany = new HintTextField(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel1.add((Component)this.txtCompany, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.txtCompany.setFont(UIConstants.FONT_12_PLAIN);
            this.txtCompany.setBorder(null);
            this.txtCompany.setOpaque(false);
            this.txtCompany.setEditable(false);
            this.jSeparator1 = new JSeparator();
            this.jPanel1.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(Color.LIGHT_GRAY);
            this.jSeparator1.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblDepartmentHeader = new JLabel();
            this.jPanel1.add((Component)this.lblDepartmentHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblDepartmentHeader.setText(I18NUtil.getString("abook_mycontact_label_department"));
            this.lblDepartmentHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtDepartment = new HintTextField(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel1.add((Component)this.txtDepartment, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.txtDepartment.setFont(UIConstants.FONT_12_PLAIN);
            this.txtDepartment.setBorder(null);
            this.txtDepartment.setOpaque(false);
            this.txtDepartment.setEditable(false);
            this.jSeparator2 = new JSeparator();
            this.jPanel1.add((Component)this.jSeparator2, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator2.setForeground(Color.LIGHT_GRAY);
            this.jSeparator2.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblTitleHeader = new JLabel();
            this.jPanel1.add((Component)this.lblTitleHeader, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblTitleHeader.setText(I18NUtil.getString("abook_mycontact_label_job_title"));
            this.lblTitleHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtTitle = new HintTextField(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel1.add((Component)this.txtTitle, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.txtTitle.setFont(UIConstants.FONT_12_PLAIN);
            this.txtTitle.setBorder(null);
            this.txtTitle.setOpaque(false);
            this.txtTitle.setEditable(false);
            this.jPanel2 = new RoundedCornerPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.add((Component)this.jPanel2, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 18, 2, new Insets(12, 0, 0, 0), 0, 0));
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.setBackground(Color.WHITE);
            this.lblOfficePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblOfficePhoneHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblOfficePhoneHeader.setText(I18NUtil.getString("abook_office"));
            this.lblOfficePhoneHeader.setIcon(UIConstants.ICON_OFFICEPHONE);
            this.lblOfficePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.tpOfficePhone = new JTextPane();
            this.jPanel2.add((Component)this.tpOfficePhone, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.tpOfficePhone.setBorder(BorderFactory.createEmptyBorder());
            this.tpOfficePhone.setEditorKit(new HTMLEditorKit());
            this.tpOfficePhone.setDocument(new HTMLDocument());
            this.tpOfficePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.tpOfficePhone.setEditable(false);
            this.tpOfficePhone.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (MyContactEditor.this.mode == Mode.VIEW && evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        MyContactEditor.this.tpOfficePhoneHyperlinkActivated(evt);
                    }
                }
            });
            this.tpOfficePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MyContactEditor.this.mode == Mode.EDIT) {
                        MyContactEditor.this.tpOfficePhoneMouseClicked(evt);
                    }
                }
            });
            this.jSeparator3 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator3, new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator3.setForeground(Color.LIGHT_GRAY);
            this.jSeparator3.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblMobilePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblMobilePhoneHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblMobilePhoneHeader.setText(I18NUtil.getString("abook_mobile"));
            this.lblMobilePhoneHeader.setIcon(UIConstants.ICON_MOBILEPHONE);
            this.lblMobilePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.tpMobilePhone = new JTextPane();
            this.jPanel2.add((Component)this.tpMobilePhone, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.tpMobilePhone.setBorder(BorderFactory.createEmptyBorder());
            this.tpMobilePhone.setEditorKit(new HTMLEditorKit());
            this.tpMobilePhone.setDocument(new HTMLDocument());
            this.tpMobilePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.tpMobilePhone.setEditable(false);
            this.tpMobilePhone.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (MyContactEditor.this.mode == Mode.VIEW && evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        MyContactEditor.this.tpMobilePhoneHyperlinkActivated(evt);
                    }
                }
            });
            this.tpMobilePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MyContactEditor.this.mode == Mode.EDIT) {
                        MyContactEditor.this.tpMobilePhoneMouseClicked(evt);
                    }
                }
            });
            this.jSeparator4 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator4, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator4.setForeground(Color.LIGHT_GRAY);
            this.jSeparator4.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblHomePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblHomePhoneHeader, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblHomePhoneHeader.setText(I18NUtil.getString("abook_home"));
            this.lblHomePhoneHeader.setIcon(UIConstants.ICON_HOME);
            this.lblHomePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.tpHomePhone = new JTextPane();
            this.jPanel2.add((Component)this.tpHomePhone, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.tpHomePhone.setBorder(BorderFactory.createEmptyBorder());
            this.tpHomePhone.setEditorKit(new HTMLEditorKit());
            this.tpHomePhone.setDocument(new HTMLDocument());
            this.tpHomePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.tpHomePhone.setEditable(false);
            this.tpHomePhone.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (MyContactEditor.this.mode == Mode.VIEW && evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        MyContactEditor.this.tpHomePhoneHyperlinkActivated(evt);
                    }
                }
            });
            this.tpHomePhone.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MyContactEditor.this.mode == Mode.EDIT) {
                        MyContactEditor.this.tpHomePhoneMouseClicked(evt);
                    }
                }
            });
            this.jSeparator5 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator5, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator5.setForeground(Color.LIGHT_GRAY);
            this.jSeparator5.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblBirthdayHeader = new JLabel();
            this.jPanel2.add((Component)this.lblBirthdayHeader, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblBirthdayHeader.setText(I18NUtil.getString("abook_birthday"));
            this.lblBirthdayHeader.setIcon(UIConstants.ICON_BIRTHDAY);
            this.lblBirthdayHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblBirthday = new JLabel();
            this.jPanel2.add((Component)this.lblBirthday, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblBirthday.setFont(UIConstants.FONT_12_PLAIN);
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
            this.lblBirthday.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MyContactEditor.this.mode == Mode.EDIT) {
                        MyContactEditor.this.lblBirthdayMouseClicked(evt);
                    }
                }
            });
            this.jSeparator6 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator6, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator6.setForeground(Color.LIGHT_GRAY);
            this.jSeparator6.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblEmailHeader = new JLabel();
            this.jPanel2.add((Component)this.lblEmailHeader, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 16, 6, 8), 0, 0));
            this.lblEmailHeader.setText(I18NUtil.getString("abook_email"));
            this.lblEmailHeader.setIcon(UIConstants.ICON_MAIL);
            this.lblEmailHeader.setFont(UIConstants.FONT_12_BOLD);
            this.txtEmail = new HintTextField(I18NUtil.getString("common_not_yet_setting"));
            this.jPanel2.add((Component)this.txtEmail, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(6, 16, 6, 8), 0, 0));
            this.txtEmail.setFont(UIConstants.FONT_12_PLAIN);
            this.txtEmail.setBorder(null);
            this.txtEmail.setOpaque(false);
            this.txtEmail.setEditable(false);
            this.txtEmail.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String address;
                    if (MyContactEditor.this.mode == Mode.VIEW && TextUtils.isNotBlank((CharSequence)(address = MyContactEditor.this.txtEmail.getText()))) {
                        Utils.sendMail(address);
                    }
                }
            });
            this.btnDelete = new JButton();
            this.add((Component)this.btnDelete, new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 0, new Insets(15, 0, 0, 0), 0, 0));
            this.btnDelete.setText(I18NUtil.getString("common_btn_delete"));
            this.btnDelete.setFont(UIConstants.FONT_14_BOLD);
            this.btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    MyContactEditor.this.btnDeleteActionPerformed(evt);
                }
            });
            this.lblPadding = new JLabel();
            this.add((Component)this.lblPadding, new GridBagConstraints(0, 5, 3, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getViewId() {
        return "MyContactEditor";
    }

    @Override
    public void onShow(Intent intent) {
        if (this.myContactReceiver != null) {
            UCChatClient.context.registerReceiver(this.myContactReceiver, this.intentFilter);
        }
    }

    @Override
    public void onHide() {
        if (this.myContactReceiver != null) {
            UCChatClient.context.unregisterReceiver(this.myContactReceiver);
        }
    }

    @Override
    public void onClose() {
        if (this.myContactReceiver != null) {
            UCChatClient.context.unregisterReceiver(this.myContactReceiver);
        }
    }

    public void setMyContactId(long contactId) {
        this.mId = contactId;
        this.reloadMyContact();
        this.reloadMyContactPhoto();
    }

    private void reloadMyContact() {
        Activity ctx = UCChatClient.context;
        this.mContact = ContactManager.getExternalContact((Context)ctx, this.mId);
        if (this.mContact == null) {
            return;
        }
        this.mBirthday = null;
        this.mPhoto = null;
        this.mHomeNumbers = this.mContact.getHomePhone();
        this.mMobileNumbers = this.mContact.getMobilePhone();
        this.mOfficeNumbers = this.mContact.getOfficePhone();
        this.refreshFavoriteView();
        this.toViewMode();
        this.revalidate();
        this.repaint();
    }

    private void reloadMyContactPhoto() {
        this.mContact = ContactManager.getExternalContact((Context)UCChatClient.context, this.mId);
        Image image = ContactManager.getExternalContactImage(this.mContact, 48, false, true);
        this.lblHeadIcon.setImage(image);
    }

    private void btnEditActionPerformed(ActionEvent evt) {
        if (this.mode == Mode.VIEW) {
            this.toEditMode();
        } else if (this.mode == Mode.EDIT) {
            String contactName = this.txtName.getText();
            if (TextUtils.isBlank((CharSequence)contactName)) {
                JOptionPane.showMessageDialog(this, I18NUtil.getString("abook_mycontact_placeholder_name"), I18NUtil.getString("common_title_error"), 0);
                this.txtName.requestFocus();
                return;
            }
            String email = this.txtEmail.getText().trim();
            if (!TextUtils.isBlank((CharSequence)email)) {
                Pattern pattern = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$");
                Matcher matcher = pattern.matcher(email);
                if (!matcher.matches()) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("abook_validation_email_format_incorrect"), I18NUtil.getString("common_title_error"), 0);
                    this.txtEmail.requestFocus();
                    return;
                }
                if (email.length() > 50) {
                    JOptionPane.showMessageDialog(this, I18NUtil.getString("abook_validation_email_length_incorrect"), I18NUtil.getString("common_title_error"), 0);
                    this.txtEmail.requestFocus();
                    return;
                }
            }
            this.doSave();
            this.toViewMode();
        }
    }

    private void toEditMode() {
        this.mode = Mode.EDIT;
        this.btnEdit.setIcon(UIConstants.ICON_SAVE);
        this.btnEdit.setText(I18NUtil.getString("common_btn_save"));
        this.lblFavorite.setVisible(false);
        this.lblHeadIcon.setCursor(UIConstants.CURSOR_HAND);
        this.txtName.setHintText(I18NUtil.getString("abook_mycontact_placeholder_name"));
        this.txtName.setBorder(UIManager.getBorder("TextField.border"));
        this.txtName.setOpaque(true);
        this.txtName.setEditable(true);
        this.txtCompany.setHintText(I18NUtil.getString("abook_mycontact_placeholder_general"));
        this.txtCompany.setBorder(UIManager.getBorder("TextField.border"));
        this.txtCompany.setOpaque(true);
        this.txtCompany.setEditable(true);
        this.txtDepartment.setHintText(I18NUtil.getString("abook_mycontact_placeholder_general"));
        this.txtDepartment.setBorder(UIManager.getBorder("TextField.border"));
        this.txtDepartment.setOpaque(true);
        this.txtDepartment.setEditable(true);
        this.txtTitle.setHintText(I18NUtil.getString("abook_mycontact_placeholder_general"));
        this.txtTitle.setBorder(UIManager.getBorder("TextField.border"));
        this.txtTitle.setOpaque(true);
        this.txtTitle.setEditable(true);
        MyContactEditor.updateNumberTable(this.tpOfficePhone, this.mOfficeNumbers, false);
        MyContactEditor.updateNumberTable(this.tpMobilePhone, this.mMobileNumbers, false);
        MyContactEditor.updateNumberTable(this.tpHomePhone, this.mHomeNumbers, false);
        this.lblBirthday.setCursor(UIConstants.CURSOR_HAND);
        if (TextUtils.isBlank((CharSequence)this.mContact.getBirthDayStr())) {
            this.lblBirthday.setText(I18NUtil.getString("common_label_click_to_config"));
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblBirthday.setText(this.mContact.getBirthDayStr());
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.txtEmail.setHintText(I18NUtil.getString("abook_mycontact_placeholder_general"));
        this.txtEmail.setBorder(UIManager.getBorder("TextField.border"));
        this.txtEmail.setOpaque(true);
        this.txtEmail.setEditable(true);
        this.txtEmail.setForeground(UIManager.getColor("TextField.foreground"));
        this.txtEmail.setCursor(UIConstants.CURSOR_TEXT);
    }

    private void toViewMode() {
        this.mode = Mode.VIEW;
        this.btnEdit.setIcon(UIConstants.ICON_EDIT);
        this.btnEdit.setText(I18NUtil.getString("common_btn_edit"));
        this.lblFavorite.setVisible(true);
        this.lblHeadIcon.setCursor(UIConstants.CURSOR_DEFAULT);
        this.txtName.setText(this.mContact.getName());
        this.txtName.setHintText(I18NUtil.getString("common_not_yet_setting"));
        this.txtName.setBorder(null);
        this.txtName.setOpaque(false);
        this.txtName.setEditable(false);
        this.txtCompany.setText(this.mContact.getCompany());
        this.txtCompany.setHintText(I18NUtil.getString("common_not_yet_setting"));
        this.txtCompany.setBorder(null);
        this.txtCompany.setOpaque(false);
        this.txtCompany.setEditable(false);
        this.txtDepartment.setText(this.mContact.getOrganization());
        this.txtDepartment.setHintText(I18NUtil.getString("common_not_yet_setting"));
        this.txtDepartment.setBorder(null);
        this.txtDepartment.setOpaque(false);
        this.txtDepartment.setEditable(false);
        this.txtTitle.setText(this.mContact.getTitle());
        this.txtTitle.setHintText(I18NUtil.getString("common_not_yet_setting"));
        this.txtTitle.setBorder(null);
        this.txtTitle.setOpaque(false);
        this.txtTitle.setEditable(false);
        MyContactEditor.updateNumberTable(this.tpOfficePhone, this.mOfficeNumbers, true);
        MyContactEditor.updateNumberTable(this.tpMobilePhone, this.mMobileNumbers, true);
        MyContactEditor.updateNumberTable(this.tpHomePhone, this.mHomeNumbers, true);
        this.lblBirthday.setCursor(UIConstants.CURSOR_DEFAULT);
        if (TextUtils.isBlank((CharSequence)this.mContact.getBirthDayStr())) {
            this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblBirthday.setText(this.mContact.getBirthDayStr());
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.txtEmail.setText(this.mContact.getEmail());
        this.txtEmail.setHintText(I18NUtil.getString("common_not_yet_setting"));
        this.txtEmail.setBorder(null);
        this.txtEmail.setOpaque(false);
        this.txtEmail.setEditable(false);
        if (TextUtils.isBlank((CharSequence)this.mContact.getEmail())) {
            this.txtEmail.setForeground(UIManager.getColor("TextField.foreground"));
            this.txtEmail.setCursor(UIConstants.CURSOR_DEFAULT);
        } else {
            this.txtEmail.setForeground(Color.BLUE);
            this.txtEmail.setCursor(UIConstants.CURSOR_HAND);
        }
    }

    private void lblHeadIconMouseClicked(MouseEvent evt) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                FileChooser fc = new FileChooser();
                UCUploadFileChooser.setInitialOpenDir(fc);
                fc.getExtensionFilters().clear();
                fc.getExtensionFilters().addAll(UCUploadFileChooser.getExtensionFilter(I18NUtil.getString("chat_msg_type_image"), UCUploadFileChooser.IMAGE_TYPES, null, null));
                final File selectedFile = fc.showOpenDialog(null);
                if (selectedFile != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MyContactEditor.this.mPhoto = FileUtil.readFileHandleExif(selectedFile);
                            MyContactEditor.this.mChangePhoto = true;
                            BufferedImage scaledBI = GraphicUtil.createScaledCenterImage(MyContactEditor.this.mPhoto, MyContactEditor.this.lblHeadIcon.getWidth(), MyContactEditor.this.lblHeadIcon.getHeight());
                            MyContactEditor.this.lblHeadIcon.setImage(scaledBI);
                            PreferencesUtil.setChatLastOpenDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    private void lblFavoriteMouseClicked(MouseEvent evt) {
        this.addOrRemoveFavorite();
    }

    protected Bundle processInput(Bundle extras) {
        boolean handleError = false;
        if (extras == null) {
            handleError = true;
            extras = new Bundle();
        }
        ArrayList<LiteTeleNumber> phoneList = new ArrayList<LiteTeleNumber>();
        phoneList.addAll(this.mHomeNumbers);
        phoneList.addAll(this.mMobileNumbers);
        phoneList.addAll(this.mOfficeNumbers);
        this.mContact.setTelephones(phoneList);
        this.mContact.setName(this.txtName.getText());
        this.mContact.setCompany(this.txtCompany.getText());
        this.mContact.setOrganization(this.txtDepartment.getText());
        this.mContact.setTitle(this.txtTitle.getText());
        this.mContact.setBirthDayStr(DateTimeUtil.getBirthdayTimeStr(this.mBirthday));
        this.mContact.setEmail(this.txtEmail.getText());
        String phoneValues = LiteContactHelper.getNumbers(phoneList);
        extras.putString("name", this.txtName.getText());
        extras.putString("phones", phoneValues);
        extras.putString("company", this.txtCompany.getText());
        extras.putString("title", this.txtTitle.getText());
        extras.putString("organization", this.txtDepartment.getText());
        extras.putString("birthDayStr", DateTimeUtil.getBirthdayTimeStr(this.mBirthday));
        extras.putString("email", this.txtEmail.getText());
        if (this.mPhoto != null) {
            extras.put("image", this.mPhoto);
        }
        return extras;
    }

    protected void doSave() {
        Bundle extras = this.processInput(null);
        if (extras != null) {
            WebAgent.getInstance().modifyExternalContact(this.mId, extras.getString("name"), extras.getString("phones"), extras.getString("company"), extras.getString("organization"), extras.getString("title"), extras.getString("birthDayStr"), extras.getString("email"));
        }
        if (this.mPhoto != null && this.mChangePhoto) {
            String base64ImageValue = GraphicUtil.convertImageToBase64String(this.mPhoto);
            WebAgent.getInstance().changeExternalContactPhoto(this.mId, base64ImageValue);
        }
    }

    private void addOrRemoveFavorite() {
        if (this.mFlagIsFavorite) {
            Utils.doRemoveMyFavorite(UCChatClient.context, String.valueOf(this.mContact.getId()), 2);
        } else {
            Utils.doAddMyFavorite(UCChatClient.context, String.valueOf(this.mContact.getId()), 2);
        }
        this.mFlagIsFavorite = !this.mFlagIsFavorite;
        this.resetFavoriteView();
    }

    private void refreshFavoriteView() {
        if (this.mode == Mode.VIEW) {
            String id = String.valueOf(this.mContact.getId());
            this.mFlagIsFavorite = ContactManager.isInMyFavorite(UCChatClient.context, id, 2);
            this.resetFavoriteView();
        }
    }

    private void resetFavoriteView() {
        if (this.mFlagIsFavorite) {
            this.lblFavorite.setIcon(UIConstants.ICON_FAVORITE_ON);
            this.lblFavorite.setToolTipText(I18NUtil.getString("abook_btn_remove_from_my_favorites"));
        } else {
            this.lblFavorite.setIcon(UIConstants.ICON_FAVORITE_OFF);
            this.lblFavorite.setToolTipText(I18NUtil.getString("abook_btn_add_to_my_favorites"));
        }
    }

    private void tpOfficePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.OFFICE, this.mOfficeNumbers);
        if (result != null) {
            this.mOfficeNumbers = result.getNumbers();
            MyContactEditor.updateNumberTable(this.tpOfficePhone, this.mOfficeNumbers, false);
        }
    }

    private void tpOfficePhoneHyperlinkActivated(HyperlinkEvent evt) {
        String jid = this.mContact.getId() + "@externalcontact";
        DialoutManager.dialMyContactNumber(UCChatClient.context, evt.getDescription(), jid);
    }

    private void tpMobilePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.MOBILE, this.mMobileNumbers);
        if (result != null) {
            this.mMobileNumbers = result.getNumbers();
            MyContactEditor.updateNumberTable(this.tpMobilePhone, this.mMobileNumbers, false);
        }
    }

    private void tpMobilePhoneHyperlinkActivated(HyperlinkEvent evt) {
        String jid = this.mContact.getId() + "@externalcontact";
        DialoutManager.dialMyContactNumber(UCChatClient.context, evt.getDescription(), jid);
    }

    private void tpHomePhoneMouseClicked(MouseEvent evt) {
        EditPhoneResult result = this.showEditPhoneDialog(LiteTeleNumberType.HOME, this.mHomeNumbers);
        if (result != null) {
            this.mHomeNumbers = result.getNumbers();
            MyContactEditor.updateNumberTable(this.tpHomePhone, this.mHomeNumbers, false);
        }
    }

    private void tpHomePhoneHyperlinkActivated(HyperlinkEvent evt) {
        String jid = this.mContact.getId() + "@externalcontact";
        DialoutManager.dialMyContactNumber(UCChatClient.context, evt.getDescription(), jid);
    }

    private void btnDeleteActionPerformed(ActionEvent evt) {
        int result = JOptionPane.showConfirmDialog(this, I18NUtil.getString("abook_confirm_mycontact_delete"), I18NUtil.getString("common_title_warning"), 2, 2);
        if (result == 0) {
            String strId = String.valueOf(this.mId);
            boolean isMyFavorite = ContactManager.isInMyFavorite(UCChatClient.context, strId, 2);
            if (isMyFavorite) {
                WebAgent.getInstance().removeFavorite(strId, 3);
            }
            WebAgent.getInstance().deleteExternalContact(strId);
            UCChatClient.getInstance().getMainPanel().getViewContainer().hideMyContactEditor();
        }
    }

    private static void updateNumberTable(JTextPane textPane, List<LiteTeleNumber> teleNumbers, boolean hyperlinkNumber) {
        String emptyMessage;
        String string = emptyMessage = hyperlinkNumber ? I18NUtil.getString("common_not_yet_setting") : I18NUtil.getString("common_label_click_to_config");
        if (teleNumbers == null || teleNumbers.size() == 0) {
            textPane.setContentType("text/plan");
            textPane.setText(emptyMessage);
            textPane.setForeground(HintTextField.HINT_COLOR);
        } else {
            textPane.setContentType("text/html");
            textPane.setText(CommonUtil.getNumberHtmlTable(teleNumbers, hyperlinkNumber));
            textPane.setForeground(UIManager.getColor("Label.foreground"));
        }
    }

    private EditPhoneResult showEditPhoneDialog(LiteTeleNumberType type, List<LiteTeleNumber> numbers) {
        if (this.epd == null) {
            this.epd = new EditPhoneDialog((JFrame)SwingUtilities.getRoot(this));
        }
        this.epd.setLocationRelativeTo(this);
        return this.epd.showDialog(type, numbers);
    }

    private void lblBirthdayMouseClicked(MouseEvent evt) {
        if (this.jcalendar == null) {
            this.initJCalendar();
        }
        int x = 0;
        int y = this.lblBirthday.getHeight();
        Calendar calendar = Calendar.getInstance();
        Date date = this.mBirthday;
        if (date != null) {
            calendar.setTime(date);
        }
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.lblBirthday, x, y);
        this.dateSelected = false;
    }

    private void initJCalendar() {
        this.jcalendar = new JCalendar();
        this.jcalendar.getDayChooser().addPropertyChangeListener("day", (PropertyChangeListener)this);
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.jcalendar.setMaxSelectableDate(new Date());
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && MyContactEditor.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add((Component)this.jcalendar);
        this.changeListener = new ChangeListener(){
            boolean hasListened = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.hasListened) {
                    this.hasListened = false;
                    return;
                }
                if (MyContactEditor.this.popup.isVisible() && MyContactEditor.this.jcalendar.getMonthChooser().getComboBox().hasFocus()) {
                    MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
                    MenuElement[] newMe = new MenuElement[me.length + 1];
                    newMe[0] = MyContactEditor.this.popup;
                    for (int i = 0; i < me.length; ++i) {
                        newMe[i + 1] = me[i];
                    }
                    this.hasListened = true;
                    MenuSelectionManager.defaultManager().setSelectedPath(newMe);
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.changeListener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day") && this.popup.isVisible()) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            if ((Integer)evt.getNewValue() > 0) {
                this.setBirthday(this.jcalendar.getCalendar().getTime());
            } else {
                this.setBirthday(null);
            }
        }
    }

    private void setBirthday(Date date) {
        this.mBirthday = date;
        if (this.mBirthday == null) {
            this.lblBirthday.setText(I18NUtil.getString("common_label_click_to_config"));
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblBirthday.setText(DateTimeUtil.getBirthdayTimeStr(this.mBirthday));
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
        }
    }

    static enum Mode {
        VIEW,
        EDIT;

    }

    private class MyContactBroadcastReceiver
    extends BroadcastReceiver {
        private MyContactBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            if (intent.getAction().equals("ezuc.intent.action.event.EXTERNAL_CONTACT_LIST_CHANGED")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyContactEditor.this.reloadMyContact();
                    }
                });
            } else if (intent.getAction().equals("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED")) {
                long contactId = intent.getLongExtra("id", -1L);
                final PhotoType type = PhotoType.valueOf(intent.getStringExtra("type"));
                if (contactId == MyContactEditor.this.mId) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (type == PhotoType.SMALL) {
                                MyContactEditor.this.reloadMyContactPhoto();
                            }
                        }
                    });
                }
            }
        }
    }
}

