/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.contacthistory;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteFaxDoc;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.bean.SelectContactResult;
import com.blisscloud.ezuc.client.chat.roomimpl.ConferenceChatroom;
import com.blisscloud.ezuc.client.component.SearchField;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.contacthistory.ContactHistoryEntryPanel;
import com.blisscloud.ezuc.client.contacthistory.ContactHistoryListener;
import com.blisscloud.ezuc.client.contacthistory.DynamicHeightPanel;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.sorter.ChatRoomMsgTimeSorter;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.QueryThread;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBFaxDoc;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactHistoryManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;

public class ContactHistoryPanel
extends JPanel {
    private static final int DEFAULT_DISPLAY_COUNT_FOF_SEARCH = 5;
    private JLabel btnAddChatroom;
    private JPanel panelSearch;
    private SearchField sfHistory;
    private JPanel noContentPanel;
    private JPanel panelContent;
    private JScrollPane spContentEntries;
    private JPanel panelBox;
    private JPanel panelContentEntriesGroup;
    private DynamicHeightPanel panelContentEntries;
    private JLabel panelContentEntriesTitle;
    private JLabel panelContentEntriesBtn;
    private boolean panelContentEntriesAll;
    private JPanel panelSearchEntriesGroup;
    private DynamicHeightPanel panelSearchEntries;
    private JLabel panelSearchEntriesTitle;
    private JLabel panelSearchEntriesBtn;
    private boolean panelSearchEntriesAll;
    private List<ChatRoomInfo> roomInfoList1 = null;
    private List<ChatRoomInfo> roomInfoList2 = null;
    private Map<String, Integer> msgMatchMap = null;
    private int totalMsgCount = 0;
    private EntryPanelMouseListener epml = new EntryPanelMouseListener();
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private QueryThread queryThread = null;
    private CountDownThread countDownThread = null;
    private ContactHistoryEntryPanel selectedEntryPanel;
    private ContactHistoryEntryPanel menuDisplayedEntryPanel;
    private MyPopupMenuListener myPopupMenuListener = new MyPopupMenuListener();

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ContactHistoryPanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public ContactHistoryPanel() {
        this.initGUI();
        this.initReceiver();
        this.queryThread = new QueryThread(UCChatClient.context, "ContactHistoryPanel", new QueryThread.QueryListener(){

            @Override
            public void performAction() {
                try {
                    ContactHistoryPanel.this.refreshContactHistoryListForUpdate();
                }
                catch (Throwable t) {
                    Log.i(ContactHistoryPanel.class.getName(), t.getMessage(), t);
                }
            }
        });
        this.queryThread.start();
    }

    public void scrollTop() {
        if (this.spContentEntries != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ContactHistoryPanel.this.spContentEntries.getVerticalScrollBar().setValue(0);
                }
            });
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setBackground(Color.WHITE);
            this.panelSearch = new JPanel();
            BorderLayout panelSearchLayout = new BorderLayout();
            panelSearchLayout.setHgap(5);
            this.panelSearch.setLayout(panelSearchLayout);
            this.add((Component)this.panelSearch, "North");
            this.panelSearch.setBorder(UIConstants.BORDER_SEARCH_TOOLBAR);
            this.panelSearch.setBackground(UIConstants.BACKGROUND_SELECTED_TAB);
            this.sfHistory = new SearchField();
            this.sfHistory.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    if (!PreferencesUtil.isRemainLoggedIn(UCChatClient.context)) {
                        return;
                    }
                    ContactHistoryPanel.this.queryThread.requestRefreshFast();
                }
            });
            this.panelSearch.add((Component)this.sfHistory, "Center");
            this.btnAddChatroom = new JLabel();
            this.panelSearch.add((Component)this.btnAddChatroom, "East");
            this.btnAddChatroom.setIcon(UIConstants.ICON_ADD_CHATROOM);
            this.btnAddChatroom.setToolTipText(I18NUtil.getString("fun_title_init_chat"));
            this.btnAddChatroom.setPreferredSize(new Dimension(28, 28));
            this.btnAddChatroom.setMinimumSize(new Dimension(28, 28));
            this.btnAddChatroom.setCursor(UIConstants.CURSOR_HAND);
            this.btnAddChatroom.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (ContactHistoryPanel.this.isEnabled()) {
                        ContactHistoryPanel.this.btnAddChatroom.setIcon(UIConstants.ICON_ADD_CHATROOM);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (ContactHistoryPanel.this.isEnabled()) {
                        ContactHistoryPanel.this.btnAddChatroom.setIcon(UIConstants.ICON_ADD_CHATROOM_OVER);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ContactHistoryPanel.this.isEnabled()) {
                        ContactHistoryPanel.this.btnAddChatroom.setIcon(UIConstants.ICON_ADD_CHATROOM_OVER);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (ContactHistoryPanel.this.isEnabled()) {
                        ContactHistoryPanel.this.btnCreateChatRoomActionPerformed();
                    }
                }
            });
            this.panelContent = new JPanel();
            BorderLayout panelContentLayout = new BorderLayout();
            this.panelContent.setLayout(panelContentLayout);
            this.add((Component)this.panelContent, "Center");
            this.spContentEntries = new UCScrollPane(60);
            this.panelContent.add((Component)this.spContentEntries, "Center");
            this.spContentEntries.setHorizontalScrollBarPolicy(31);
            this.panelBox = new JPanel();
            this.panelBox.setLayout(new GridBagLayout());
            this.panelBox.setBackground(UIConstants.CONTACT_HISTORY_BG);
            this.panelContentEntriesGroup = new JPanel();
            this.panelContentEntriesGroup.setLayout(new BorderLayout());
            this.panelContentEntriesGroup.setBackground(UIConstants.CONTACT_HISTORY_BG);
            this.panelContentEntriesTitle = new JLabel();
            this.panelContentEntriesTitle.setFont(UIConstants.FONT_12_PLAIN);
            this.panelContentEntriesTitle.setText(String.format(I18NUtil.getString("contact_history_chatroom_search"), ""));
            this.panelContentEntriesGroup.add((Component)this.panelContentEntriesTitle, "North");
            this.panelContentEntriesTitle.setVisible(false);
            this.panelContentEntriesTitle.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelContentEntriesBtn = new JLabel();
            this.panelContentEntriesBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.panelContentEntriesBtn.setText(I18NUtil.getString("contact_history_more"));
            this.panelContentEntriesBtn.setHorizontalAlignment(0);
            this.panelContentEntriesGroup.add((Component)this.panelContentEntriesBtn, "South");
            this.panelContentEntriesBtn.setVisible(false);
            this.panelContentEntriesBtn.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelContentEntriesBtn.setIcon(UIConstants.ICON_ARROW_DOWN_2);
            this.panelContentEntriesBtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ContactHistoryPanel.this.handleContentEntriesFlagChange();
                }
            });
            this.panelContentEntries = new DynamicHeightPanel();
            this.panelContentEntries.setBackground(Color.WHITE);
            this.panelContentEntriesGroup.add((Component)this.panelContentEntries, "Center");
            this.panelBox.add((Component)this.panelContentEntriesGroup, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.panelSearchEntriesGroup = new JPanel();
            this.panelSearchEntriesGroup.setLayout(new BorderLayout());
            this.panelSearchEntriesGroup.setBackground(UIConstants.CONTACT_HISTORY_BG);
            this.panelSearchEntriesTitle = new JLabel();
            this.panelSearchEntriesTitle.setFont(UIConstants.FONT_12_PLAIN);
            this.panelSearchEntriesTitle.setText(String.format(I18NUtil.getString("contact_history_message_search"), ""));
            this.panelSearchEntriesGroup.add((Component)this.panelSearchEntriesTitle, "North");
            this.panelSearchEntriesTitle.setVisible(false);
            this.panelSearchEntriesTitle.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelSearchEntriesBtn = new JLabel();
            this.panelSearchEntriesBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.panelSearchEntriesBtn.setText(String.format(I18NUtil.getString("contact_history_more"), ""));
            this.panelSearchEntriesBtn.setHorizontalAlignment(0);
            this.panelSearchEntriesGroup.add((Component)this.panelSearchEntriesBtn, "South");
            this.panelSearchEntriesBtn.setVisible(false);
            this.panelSearchEntriesBtn.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.panelSearchEntriesBtn.setIcon(UIConstants.ICON_ARROW_DOWN_2);
            this.panelSearchEntriesBtn.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ContactHistoryPanel.this.handleSearchContentEntriesFlagChange();
                }
            });
            this.panelSearchEntries = new DynamicHeightPanel();
            this.panelSearchEntries.setBackground(Color.WHITE);
            this.panelSearchEntriesGroup.add((Component)this.panelSearchEntries, "Center");
            this.panelBox.add((Component)this.panelSearchEntriesGroup, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.spContentEntries.setViewportView(this.panelBox);
            this.noContentPanel = new JPanel();
            BorderLayout bLayout2 = new BorderLayout();
            this.noContentPanel.setLayout(bLayout2);
            this.noContentPanel.setOpaque(true);
            this.noContentPanel.setBackground(UIConstants.CONTACT_HISTORY_BG);
            this.noContentPanel.setMinimumSize(new Dimension(100, 100));
            this.noContentPanel.setPreferredSize(new Dimension(100, 100));
            JLabel noContentLabel = new JLabel();
            noContentLabel.setOpaque(true);
            noContentLabel.setBackground(UIConstants.CONTACT_HISTORY_BG);
            noContentLabel.setHorizontalAlignment(0);
            noContentLabel.setText(I18NUtil.getString("common_no_history_all"));
            noContentLabel.setForeground(Color.LIGHT_GRAY);
            noContentLabel.setFont(UIConstants.FONT_16_BOLD);
            this.noContentPanel.add((Component)noContentLabel, "Center");
            this.panelContent.add((Component)this.noContentPanel, "North");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnCreateChatRoomActionPerformed() {
        List<LiteContact> participants;
        HashSet<String> exculsiveJIDs = new HashSet<String>();
        exculsiveJIDs.add(PreferencesUtil.getUserJid(UCChatClient.context));
        List itemList = UCDBContact.getContactsOrderByName(UCChatClient.context, null, 0, exculsiveJIDs);
        ArrayList<LiteContact> candidateContacts = new ArrayList<LiteContact>();
        for (AddressBookGroup contactGroup : itemList) {
            for (LiteContact c : contactGroup.getDataList()) {
                if (!JidUtil.isEmployeeJid(c.getJid())) continue;
                candidateContacts.add(c);
            }
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectContactResult result = mainPanel.showSelectContactDialog(I18NUtil.getString("chatroom_select_members_to_invite"), candidateContacts);
        if (result != null && (participants = result.getParticipants()) != null && participants.size() != 0) {
            if (participants.size() == 1) {
                LiteContact p = participants.get(0);
                if (p != null) {
                    mainPanel.showChatroom(p.getJid());
                }
            } else {
                ArrayList<String> participantJIDs = new ArrayList<String>();
                for (LiteContact participant : participants) {
                    participantJIDs.add(participant.getJid());
                }
                WebAgent.getInstance().createChatRoom("-subject-", participantJIDs);
            }
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    Log.d(ContactHistoryPanel.class.getSimpleName(), " \u6536\u5230\u5ee3\u64ad:" + action);
                    if ("ezuc.intent.action.event.CHAT_REMOVE_FROM_CHATROOM".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    } else if ("ezuc.intent.action.event.CUSTOMER_STATUS_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    } else if ("ezuc.intent.action.event.CONTACT_HISTORY_CHANGED".equals(action) || "ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_PROGRESS".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    } else if ("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    } else if ("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED".equals(action)) {
                        long contactId = intent.getLongExtra("id", -1L);
                        ContactHistoryPanel.this.web_externalPhotoChanged(contactId);
                    } else if ("ezuc.intent.action.event.MESSAGE_CHANNEL_PHOTO_CHANGED".equals(action)) {
                        long channelId = intent.getLongExtra("id", -1L);
                        ContactHistoryPanel.this.web_channelPhotoChanged(channelId);
                    } else if ("ezuc.intent.action.event.PHONE_STATE_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.phone_stateChanged(intent);
                    } else if ("ezuc.intent.action.event.PHONE_EMP_STATUS_CHANGED".equals(action)) {
                        ArrayList<String> empIds = intent.getStringArrayListExtra("employeeIdList");
                        ContactHistoryPanel.this.phone_emp_statusChanged(empIds);
                    } else if ("ezuc.intent.action.event.PHONE_LOC_STATUS_CHANGED".equals(action)) {
                        ArrayList<String> locJids = intent.getStringArrayListExtra("locationJidList");
                        ContactHistoryPanel.this.phone_loc_statusChanged(locJids);
                    } else if ("ezuc.intent.action.event.MEETME_CHANGED".equals(action)) {
                        long roomId = intent.getLongExtra("roomId", -1L);
                        String roomJid = null;
                        if (intent.hasExtra("roomJID")) {
                            roomJid = intent.getStringExtra("roomJID");
                        }
                        ContactHistoryPanel.this.web_meetmeChanged(roomId, roomJid);
                    } else if ("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.chat_participantChanged(intent);
                    } else if ("ezuc.intent.action.event.CHAT_ROOM_INFO_UPDATE".equals(action)) {
                        String roomJID = bundle.getString("roomJID");
                        ContactHistoryPanel.this.chat_roomInfoUpdated(roomJID);
                    } else if ("ezuc.intent.action.event.MEETME_PHONE_PREFIX_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    } else if ("ezuc.intent.action.event.CONTACT_LIST_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    } else if ("ezuc.intent.action.event.MESSAGE_CHANNEL_LIST_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    } else if ("ezuc.intent.action.event.CHAT_MSG_READ_STATUS_CHANGED".equals(action)) {
                        String jid = intent.getStringExtra("chatId");
                        ContactHistoryPanel.this.readStatusChangedLocal(jid);
                    } else if ("ezuc.intent.action.event.PERSONAL_INFO_CHANGED".equals(action)) {
                        ContactHistoryPanel.this.web_contactHistoryChanged(intent);
                    }
                }
                catch (Throwable t) {
                    Log.e(ContactHistoryPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.CHAT_MSG_READ_STATUS_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_REMOVE_FROM_CHATROOM");
        this.filter.addAction("ezuc.intent.action.event.CUSTOMER_STATUS_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CONTACT_HISTORY_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_PROGRESS");
        this.filter.addAction("ezuc.intent.action.event.MESSAGE_CHANNEL_PHOTO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CONTACT_PHOTO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.EXTERNAL_PHOTO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_STATE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_EMP_STATUS_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_LOC_STATUS_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.MEETME_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_ROOM_INFO_UPDATE");
        this.filter.addAction("ezuc.intent.action.event.MEETME_PHONE_PREFIX_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CONTACT_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.MESSAGE_CHANNEL_LIST_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    public void prepare() {
        if (this.countDownThread != null) {
            this.countDownThread.terminate();
            this.countDownThread = null;
        }
        this.countDownThread = new CountDownThread();
        this.countDownThread.start();
        this.refreshContactHistoryListForUpdate();
    }

    public void release() {
        if (this.countDownThread != null) {
            this.countDownThread.terminate();
            this.countDownThread = null;
        }
        this.sfHistory.clearSearchKey();
        this.clearContactHistory();
    }

    public void addContactHistoryListener(ContactHistoryListener l) {
        this.listenerList.add(ContactHistoryListener.class, l);
    }

    public void removeContactHistoryListener(ContactHistoryListener l) {
        this.listenerList.remove(ContactHistoryListener.class, l);
    }

    protected void fireContactHistorySelected(String chatId) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContactHistoryListener.class) continue;
            ((ContactHistoryListener)listeners[i + 1]).contactHistorySelected(chatId);
        }
    }

    protected void fireUnreadMessageChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ContactHistoryListener.class) continue;
            ((ContactHistoryListener)listeners[i + 1]).unreadMessageChanged();
        }
    }

    private ContactHistoryEntryPanel getContactHistoryEntryPanel(String chatId) {
        Component[] comps;
        for (Component comp : comps = this.panelContentEntries.getComponents()) {
            ContactHistoryEntryPanel chep;
            if (!(comp instanceof ContactHistoryEntryPanel) || !(chep = (ContactHistoryEntryPanel)comp).getChatId().equals(chatId)) continue;
            return chep;
        }
        return null;
    }

    private ContactHistoryEntryPanel getSearchHistoryEntryPanel(String chatId) {
        Component[] comps;
        for (Component comp : comps = this.panelSearchEntries.getComponents()) {
            ContactHistoryEntryPanel chep;
            if (!(comp instanceof ContactHistoryEntryPanel) || !(chep = (ContactHistoryEntryPanel)comp).getChatId().equals(chatId)) continue;
            return chep;
        }
        return null;
    }

    public void readStatusChangedLocal(String jid) {
        ContactHistoryEntryPanel chep = this.getContactHistoryEntryPanel(jid);
        if (chep != null) {
            String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
            int unreadCount = 0;
            if (JidUtil.isFakeExternalCallJid(jid)) {
                unreadCount = UCDBMessage.lastExternalCallUnread(UCChatClient.context, myJid);
            } else if (JidUtil.isFakeFaxDocJid(jid)) {
                unreadCount = UCDBFaxDoc.lastFaxInUnread(UCChatClient.context);
            } else {
                HashSet<String> jidsSet = new HashSet<String>();
                jidsSet.add(jid);
                Map<String, Integer> unreadCountMap = UCDBMessage.countNotReadMsgForAllRooms(UCChatClient.context, jidsSet, myJid);
                if (unreadCountMap.containsKey(jid)) {
                    unreadCount = unreadCountMap.get(jid);
                }
            }
            chep.upateUnreadCount(unreadCount);
        }
    }

    private ContactHistoryEntryPanel insertContactHistory(ChatRoomInfo roomInfo, Map<String, LiteContact> contactsMap, List<String> participantJidList, Message lastMsg, String pendingDraft, int unreadMsgCount, int hasMeCount, boolean visible) {
        ContactHistoryEntryPanel chep = new ContactHistoryEntryPanel(roomInfo.getChatRoomId(), false);
        chep.setMinimumSize(new Dimension(100, 60));
        chep.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        chep.setAlignmentX(0.0f);
        chep.setSelected(false);
        chep.setVisible(visible);
        chep.addMouseListener(this.epml);
        chep.updateContactHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, null, null);
        return chep;
    }

    private ContactHistoryEntryPanel insertSearchHistory(ChatRoomInfo roomInfo, Map<String, LiteContact> contactsMap, List<String> participantJidList, Message lastMsg, String pendingDraft, int unreadMsgCount, int hasMeCount, boolean visible, int matchCount, String searchKey) {
        ContactHistoryEntryPanel chep = new ContactHistoryEntryPanel(roomInfo.getChatRoomId(), true);
        chep.setMinimumSize(new Dimension(100, 60));
        chep.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
        chep.setAlignmentX(0.0f);
        chep.setSelected(false);
        chep.setVisible(visible);
        chep.addMouseListener(this.epml);
        chep.updateContactHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, matchCount, searchKey);
        return chep;
    }

    private void checkNoContent() {
        this.noContentPanel.setVisible(this.panelContentEntries.getComponentCount() == 0 && this.panelSearchEntries.getComponentCount() == 0);
    }

    private ContactHistoryEntryPanel moveContactHistory(ChatRoomInfo roomInfo, Map<String, LiteContact> contactsMap, List<String> participantJidList, Message lastMsg, String pendingDraft, int unreadMsgCount, int hasMeCount, boolean visible) {
        ContactHistoryEntryPanel chep = this.getContactHistoryEntryPanel(roomInfo.getChatRoomId());
        if (chep != null) {
            boolean selected = chep.isSelected();
            chep.updateContactHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, null, null);
            chep.setSelected(selected);
            chep.setVisible(visible);
        }
        return chep;
    }

    private ContactHistoryEntryPanel moveSearchHistory(ChatRoomInfo roomInfo, Map<String, LiteContact> contactsMap, List<String> participantJidList, Message lastMsg, String pendingDraft, int unreadMsgCount, int hasMeCount, boolean visible, int matchCount, String searchKey) {
        ContactHistoryEntryPanel chep = this.getSearchHistoryEntryPanel(roomInfo.getChatRoomId());
        if (chep != null) {
            boolean selected = chep.isSelected();
            chep.updateContactHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, matchCount, searchKey);
            chep.setSelected(selected);
            chep.setVisible(visible);
        }
        return chep;
    }

    public void deleteAllChatRoomMsgs(final String chatRoomJid) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContactHistoryPanel.this.removeContactHistory(chatRoomJid, null);
                ContactHistoryPanel.this.panelContentEntries.revalidate();
                ContactHistoryPanel.this.panelContentEntries.repaint();
                ContactHistoryPanel.this.fireUnreadMessageChanged();
            }
        });
    }

    private void removeContactHistory(String jid, List<String> allAvailableJidsList) {
        ContactHistoryEntryPanel chep = this.getContactHistoryEntryPanel(jid);
        if (chep != null) {
            if (this.selectedEntryPanel == chep) {
                this.selectedEntryPanel = null;
            }
            if (this.menuDisplayedEntryPanel == chep) {
                this.menuDisplayedEntryPanel = null;
            }
            chep.removeMouseListener(this.epml);
            this.panelContentEntries.remove(chep);
            this.checkNoContent();
            this.closeChatRoomIfNotExist(jid, allAvailableJidsList);
        }
    }

    private void closeChatRoomIfNotExist(String jid, List<String> allAvailableJidsList) {
        if (jid == null || "__EXTERNAL_TRUNK_CALL_GROUP__".equals(jid) || "__FAX_DOC_GROUP__".equals(jid)) {
            return;
        }
        if (allAvailableJidsList != null && allAvailableJidsList.contains(jid)) {
            return;
        }
        if (UCDBChatRoom.existChatRoomById(UCChatClient.context, jid)) {
            return;
        }
        if (UCDBMessage.findHasMsgChatRoomId(UCChatClient.context, jid)) {
            return;
        }
        UCChatClient.getInstance().getMainPanel().closeChatroom(jid);
    }

    private void removeSearchHistory(String jid, List<String> allAvailableJidsList) {
        ContactHistoryEntryPanel chep = this.getSearchHistoryEntryPanel(jid);
        if (chep != null) {
            if (this.selectedEntryPanel == chep) {
                this.selectedEntryPanel = null;
            }
            if (this.menuDisplayedEntryPanel == chep) {
                this.menuDisplayedEntryPanel = null;
            }
            chep.removeMouseListener(this.epml);
            this.panelSearchEntries.remove(chep);
            this.checkNoContent();
            this.closeChatRoomIfNotExist(jid, allAvailableJidsList);
        }
    }

    public void clearContactHistory() {
        this.menuDisplayedEntryPanel = null;
        this.selectedEntryPanel = null;
        this.roomInfoList1 = null;
        this.roomInfoList2 = null;
        this.msgMatchMap = null;
        this.totalMsgCount = 0;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Component[] comps2;
                Component[] comps;
                for (Component comp : comps = ContactHistoryPanel.this.panelContentEntries.getComponents()) {
                    if (!(comp instanceof ContactHistoryEntryPanel)) continue;
                    ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
                    chep.removeMouseListener(ContactHistoryPanel.this.epml);
                    UCChatClient.getInstance().getMainPanel().closeChatroom(chep.getChatId());
                }
                ContactHistoryPanel.this.panelContentEntries.removeAll();
                ContactHistoryPanel.this.panelContentEntries.revalidate();
                ContactHistoryPanel.this.panelContentEntries.repaint();
                ContactHistoryPanel.this.panelContentEntriesTitle.setVisible(false);
                for (Component comp : comps2 = ContactHistoryPanel.this.panelSearchEntries.getComponents()) {
                    if (!(comp instanceof ContactHistoryEntryPanel)) continue;
                    ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
                    chep.removeMouseListener(ContactHistoryPanel.this.epml);
                    UCChatClient.getInstance().getMainPanel().closeChatroom(chep.getChatId());
                }
                ContactHistoryPanel.this.panelSearchEntries.removeAll();
                ContactHistoryPanel.this.panelSearchEntries.revalidate();
                ContactHistoryPanel.this.panelSearchEntries.repaint();
                ContactHistoryPanel.this.panelSearchEntriesTitle.setVisible(false);
                ContactHistoryPanel.this.checkNoContent();
            }
        });
        this.fireUnreadMessageChanged();
    }

    private void setContactHistoryPhoto(String jid, Image contactImage) {
        ContactHistoryEntryPanel chep = this.getContactHistoryEntryPanel(jid);
        if (chep != null) {
            chep.setImage(contactImage);
        }
    }

    private void setContactHistoryDisplayName(String jid, String displayName) {
        ContactHistoryEntryPanel chep = this.getContactHistoryEntryPanel(jid);
        if (chep != null) {
            chep.setDisplayName(displayName);
        }
    }

    private void setContactHistoryPhoneStatus(String jid, String phoneStatus) {
        ContactHistoryEntryPanel chep = this.getContactHistoryEntryPanel(jid);
        if (chep != null) {
            chep.setPhoneStatus(phoneStatus);
        }
    }

    private void phone_stateChanged(Intent intent) {
        this.refreshContactHistoryListForUpdate();
    }

    private void phone_emp_statusChanged(final List<String> empIds) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String empId : empIds) {
                    LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, Long.parseLong(empId));
                    if (contact == null) continue;
                    String empJID = contact.getJid();
                    String status = ContactManager.getPhoneEmpStatus(empId);
                    ContactHistoryPanel.this.setContactHistoryPhoneStatus(empJID, status);
                }
            }
        });
    }

    private void phone_loc_statusChanged(final List<String> locJids) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String jid : locJids) {
                    LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, jid);
                    if (contact == null) continue;
                    String status = ContactManager.getPhoneLocStatus(jid);
                    ContactHistoryPanel.this.setContactHistoryPhoneStatus(jid, status);
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void web_meetmeChanged(long roomId, final String iRoomJid) {
        ChatRoomInfo roomInfo;
        final LiteConferenceRoom confRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, roomId);
        if (iRoomJid != null) {
            if (!JidUtil.isConfJid(iRoomJid)) return;
            roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, iRoomJid);
        } else {
            roomInfo = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ContactHistoryPanel.this.setContactHistoryDisplayName(iRoomJid, ChatRoomUtil.getConfRoomTitle(UCChatClient.context, roomInfo, confRoom, true, true));
                ContactHistoryEntryPanel chep = ContactHistoryPanel.this.getContactHistoryEntryPanel(iRoomJid);
                if (chep != null) {
                    chep.checkConferenceRoomJoined();
                }
            }
        });
    }

    private void web_externalPhotoChanged(final Long contactId) {
        Log.d(ContactHistoryPanel.class.getSimpleName(), "web_externalPhotoChanged " + contactId);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String jid = contactId + "@externalcontact";
                LiteMyContact contact = ContactManager.getExternalContact((Context)UCChatClient.context, contactId);
                Image image = ContactManager.getExternalContactImage(contact, 48, false, true);
                ContactHistoryPanel.this.setContactHistoryPhoto(jid, image);
            }
        });
    }

    private void web_channelPhotoChanged(final Long channelId) {
        Log.d(ContactHistoryPanel.class.getSimpleName(), "web_channelPhotoChanged " + channelId);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MessageChannel channel = UCDBMessageChannel.getMessageChannelById(UCChatClient.context, channelId);
                if (channel != null) {
                    Image image = MessageChannelManager.getMessageChannelImage(channel, 48, false, true);
                    ContactHistoryPanel.this.setContactHistoryPhoto(channel.getJid(), image);
                }
            }
        });
    }

    private void web_contactHistoryChanged(Intent intent) {
        this.queryThread.requestRefresh();
    }

    private void chat_participantChanged(Intent intent) {
        this.queryThread.requestRefresh();
    }

    private void chat_roomInfoUpdated(final String roomJID) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, roomJID);
                if (roomInfo != null && roomInfo.getType() == 1) {
                    LiteConferenceRoom confRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, roomJID);
                    ArrayList<String> participantJidList = UCDBChatRoom.findChatRoomParticipants((Context)UCChatClient.context, roomJID);
                    String chatRoomTitle = ChatRoomUtil.getChatRoomTitleForList(UCChatClient.context, roomInfo, participantJidList, null);
                    Object title = chatRoomTitle;
                    if (confRoom != null) {
                        title = chatRoomTitle + " (" + OutboundPrefixManager.getMeetmePrefix(UCChatClient.context) + confRoom.getRoomNo() + ")";
                    }
                    ContactHistoryPanel.this.setContactHistoryDisplayName(roomJID, (String)title);
                }
            }
        });
    }

    private void refreshContactHistoryListForUpdate() {
        if (!PreferencesUtil.isSyncOldChatEventDone(UCChatClient.context) && !PreferencesUtil.isSyncDataNow(UCChatClient.context)) {
            return;
        }
        if (!PreferencesUtil.isRemainLoggedIn(UCChatClient.context)) {
            return;
        }
        Log.d(ContactHistoryPanel.class.getSimpleName(), "refreshContactHistoryListForUpdate searchKey:" + this.sfHistory.getSearchKey());
        this.doSearch(this.sfHistory.getSearchKey());
    }

    private synchronized void doSearch(String searchKey) {
        ChatRoomInfo roomInfo;
        Log.d(ContactHistoryPanel.class.getSimpleName(), "run doSearch===========>" + searchKey);
        Activity ctx = UCChatClient.context;
        final String trimSearchKey = searchKey.trim();
        long t = System.currentTimeMillis();
        final List<String> allAvailableJidsList = ContactHistoryManager.getAllContactHistory(UCChatClient.context);
        List<String> jidsList = null;
        final boolean doSearch = StringUtils.isNotBlank((CharSequence)trimSearchKey);
        if (doSearch) {
            jidsList = ContactHistoryManager.getContactHistory(UCChatClient.context, trimSearchKey);
            this.msgMatchMap = UCDBMessage.findContent(UCChatClient.context, trimSearchKey);
        } else {
            jidsList = new ArrayList<String>(allAvailableJidsList);
        }
        String myJid = PreferencesUtil.getUserJid(ctx);
        HashSet<String> jidsSet = new HashSet<String>();
        jidsSet.addAll(jidsList);
        if (doSearch && this.msgMatchMap != null) {
            jidsSet.addAll(this.msgMatchMap.keySet());
        }
        List<ChatRoomInfo> roomInfoListTemp = UCDBChatRoom.getChatRoomsByContactJids(ctx, jidsSet);
        HashMap<String, ChatRoomInfo> roomInfoMap = new HashMap<String, ChatRoomInfo>();
        for (ChatRoomInfo roomInfo2 : roomInfoListTemp) {
            roomInfoMap.put(roomInfo2.getChatRoomId(), roomInfo2);
        }
        final Map<String, LiteContact> contactsMap = UCDBContact.findAllRelatedContactsByJids(ctx, jidsSet);
        final Map<String, List<String>> participantJidMap = UCDBChatRoom.findChatRoomParticipants((Context)ctx, jidsSet);
        final Map<String, Integer> notReadMsgCountMap = UCDBMessage.countNotReadMsgForAllRooms(ctx, jidsSet, myJid);
        final Map<String, Integer> hasMeCountMap = UCDBMessage.hasMeCountForAllRooms(ctx, jidsSet, myJid);
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        final Map<String, String> pendingDraftMap = database.getPendingMessage(jidsSet);
        final Map<String, Message> lastMsgMap = UCDBMessage.getLastMsgMap(ctx, jidsSet);
        for (String string : lastMsgMap.keySet()) {
            Message message = lastMsgMap.get(string);
            roomInfo = (ChatRoomInfo)roomInfoMap.get(string);
            if (roomInfo == null) continue;
            roomInfo.setLastMsgTime(message.getServerTime());
        }
        CopyOnWriteArrayList<ChatRoomInfo> temp1 = new CopyOnWriteArrayList<ChatRoomInfo>();
        for (String string : new HashSet<String>(jidsList)) {
            roomInfo = (ChatRoomInfo)roomInfoMap.get(string);
            if (roomInfo == null) continue;
            if (JidUtil.isChatJid(string)) {
                List<String> pList;
                if (!participantJidMap.containsKey(string) || (pList = participantJidMap.get(string)) == null || pList.size() == 0) continue;
                temp1.add(roomInfo);
                continue;
            }
            temp1.add(roomInfo);
        }
        CopyOnWriteArrayList<ChatRoomInfo> copyOnWriteArrayList = new CopyOnWriteArrayList<ChatRoomInfo>();
        this.totalMsgCount = 0;
        if (doSearch && this.msgMatchMap != null) {
            for (String jid : this.msgMatchMap.keySet()) {
                Integer msgFound = this.msgMatchMap.get(jid);
                this.totalMsgCount += msgFound.intValue();
                ChatRoomInfo roomInfo3 = (ChatRoomInfo)roomInfoMap.get(jid);
                if (roomInfo3 == null) continue;
                copyOnWriteArrayList.add(roomInfo3);
            }
        }
        if (!doSearch) {
            boolean faxEnabled;
            boolean bl = PreferencesUtil.isExternalPhoneOnTop(ctx);
            Message lastCallMsg = UCDBMessage.lastExternalCallMsg(ctx);
            if (lastCallMsg != null) {
                int callUnread = UCDBMessage.lastExternalCallUnread(ctx, myJid);
                ChatRoomInfo call = new ChatRoomInfo();
                call.setLastMsgTime(lastCallMsg.getServerTime());
                call.setChatRoomId("__EXTERNAL_TRUNK_CALL_GROUP__");
                call.setOnTop(bl);
                notReadMsgCountMap.put("__EXTERNAL_TRUNK_CALL_GROUP__", callUnread);
                lastMsgMap.put("__EXTERNAL_TRUNK_CALL_GROUP__", lastCallMsg);
                temp1.add(call);
            }
            if (faxEnabled = PreferencesUtil.isFaxEnabled(ctx)) {
                boolean isFaxOnTop = PreferencesUtil.isFaxOnTop(ctx);
                LiteFaxDoc lastFaxDoc = UCDBFaxDoc.getLastFaxDoc(ctx);
                if (lastFaxDoc != null) {
                    int faxInUnread = UCDBFaxDoc.lastFaxInUnread(ctx);
                    ChatRoomInfo fax = new ChatRoomInfo();
                    fax.setLastMsgTime(lastFaxDoc.getCreateTime());
                    fax.setChatRoomId("__FAX_DOC_GROUP__");
                    fax.setOnTop(isFaxOnTop);
                    Message lastMsg = new Message();
                    if (lastFaxDoc.getDirection() == 0) {
                        lastMsg.setMsgType(21);
                    } else {
                        lastMsg.setMsgType(22);
                    }
                    lastMsg.setContent(lastFaxDoc.getPhoneNumber());
                    lastMsg.setServerTime(lastFaxDoc.getCreateTime());
                    lastMsg.setStatus(String.valueOf(lastFaxDoc.getStatus()));
                    notReadMsgCountMap.put("__FAX_DOC_GROUP__", faxInUnread);
                    lastMsgMap.put("__FAX_DOC_GROUP__", lastMsg);
                    temp1.add(fax);
                } else {
                    long currentTimestamp = System.currentTimeMillis();
                    ChatRoomInfo fax = new ChatRoomInfo();
                    fax.setLastMsgTime(currentTimestamp);
                    fax.setChatRoomId("__FAX_DOC_GROUP__");
                    fax.setOnTop(isFaxOnTop);
                    Message lastMsg = new Message();
                    lastMsg.setMsgType(20);
                    lastMsg.setServerTime(currentTimestamp);
                    notReadMsgCountMap.put("__FAX_DOC_GROUP__", 0);
                    lastMsgMap.put("__FAX_DOC_GROUP__", lastMsg);
                    temp1.add(fax);
                }
            }
        }
        if (temp1 != null && temp1.size() > 0) {
            Collections.sort(temp1, new ChatRoomMsgTimeSorter());
        }
        if (copyOnWriteArrayList != null && copyOnWriteArrayList.size() > 0) {
            Collections.sort(copyOnWriteArrayList, new ChatRoomMsgTimeSorter());
        }
        this.roomInfoList1 = temp1;
        this.roomInfoList2 = copyOnWriteArrayList;
        Log.d(ContactHistoryPanel.class.getSimpleName(), "run doSearch done ===========>" + (System.currentTimeMillis() - t));
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ContactHistoryPanel contactHistoryPanel = ContactHistoryPanel.this;
                synchronized (contactHistoryPanel) {
                    long t1 = System.currentTimeMillis();
                    Log.d(ContactHistoryPanel.class.getSimpleName(), "start render ===========>");
                    Set<String> oldHistoryIDs = ContactHistoryPanel.this.getContactHistoryIDs();
                    HashSet<String> unchangedHistoryIDs = new HashSet<String>(oldHistoryIDs);
                    Set<String> newHistoryIDs = ContactHistoryPanel.this.getContactHistoryIDs(ContactHistoryPanel.this.roomInfoList1);
                    unchangedHistoryIDs.retainAll(newHistoryIDs);
                    newHistoryIDs.removeAll(unchangedHistoryIDs);
                    oldHistoryIDs.removeAll(unchangedHistoryIDs);
                    for (String oldHistoryID : oldHistoryIDs) {
                        ContactHistoryPanel.this.removeContactHistory(oldHistoryID, allAvailableJidsList);
                    }
                    Component[] compList1 = new Component[ContactHistoryPanel.this.roomInfoList1.size()];
                    for (int i = 0; ContactHistoryPanel.this.roomInfoList1 != null && i < ContactHistoryPanel.this.roomInfoList1.size(); ++i) {
                        ContactHistoryEntryPanel chep;
                        ChatRoomInfo roomInfo = ContactHistoryPanel.this.roomInfoList1.get(i);
                        String roomJid = roomInfo.getChatRoomId();
                        int unreadMsgCount = notReadMsgCountMap != null && notReadMsgCountMap.containsKey(roomJid) ? (Integer)notReadMsgCountMap.get(roomJid) : 0;
                        int hasMeCount = hasMeCountMap != null && hasMeCountMap.containsKey(roomJid) ? (Integer)hasMeCountMap.get(roomJid) : 0;
                        List participantJidList = (List)participantJidMap.get(roomJid);
                        Message lastMsg = (Message)lastMsgMap.get(roomJid);
                        String pendingDraft = (String)pendingDraftMap.get(roomJid);
                        boolean visible = false;
                        if (!doSearch || ContactHistoryPanel.this.panelContentEntriesAll || i < 5) {
                            visible = true;
                        }
                        if (unchangedHistoryIDs.contains(roomJid)) {
                            chep = ContactHistoryPanel.this.moveContactHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, visible);
                            compList1[i] = chep;
                            continue;
                        }
                        if (!newHistoryIDs.contains(roomJid)) continue;
                        chep = ContactHistoryPanel.this.insertContactHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, visible);
                        compList1[i] = chep;
                    }
                    ContactHistoryPanel.this.panelContentEntries.removeAll();
                    for (Component comp : compList1) {
                        ContactHistoryPanel.this.panelContentEntries.add(comp);
                    }
                    ContactHistoryPanel.this.panelContentEntriesTitle.setVisible(doSearch && ContactHistoryPanel.this.roomInfoList1.size() > 0);
                    ContactHistoryPanel.this.panelContentEntriesTitle.setText(String.format(I18NUtil.getString("contact_history_chatroom_search"), String.valueOf(ContactHistoryPanel.this.roomInfoList1.size())));
                    ContactHistoryPanel.this.checkDisplayAllBtn(doSearch);
                    ContactHistoryPanel.this.panelContentEntries.revalidate();
                    ContactHistoryPanel.this.panelContentEntries.repaint();
                    Set<String> oldSearchHistoryIDs = ContactHistoryPanel.this.getSearchHistoryIDs();
                    HashSet<String> unchangedSearchHistoryIDs = new HashSet<String>(oldSearchHistoryIDs);
                    Set<String> newSearchHistoryIDs = ContactHistoryPanel.this.getSearchHistoryIDs(ContactHistoryPanel.this.roomInfoList2);
                    unchangedSearchHistoryIDs.retainAll(newSearchHistoryIDs);
                    newSearchHistoryIDs.removeAll(unchangedSearchHistoryIDs);
                    oldSearchHistoryIDs.removeAll(unchangedSearchHistoryIDs);
                    for (String oldSearchHistoryID : oldSearchHistoryIDs) {
                        ContactHistoryPanel.this.removeSearchHistory(oldSearchHistoryID, allAvailableJidsList);
                    }
                    Component[] compList2 = new Component[ContactHistoryPanel.this.roomInfoList2.size()];
                    for (int i = 0; ContactHistoryPanel.this.roomInfoList2 != null && i < ContactHistoryPanel.this.roomInfoList2.size(); ++i) {
                        ContactHistoryEntryPanel chep;
                        ChatRoomInfo roomInfo = ContactHistoryPanel.this.roomInfoList2.get(i);
                        String roomJid = roomInfo.getChatRoomId();
                        Integer matchCount = ContactHistoryPanel.this.msgMatchMap.get(roomInfo.getChatRoomId());
                        if (matchCount == null) {
                            matchCount = 0;
                        }
                        int unreadMsgCount = notReadMsgCountMap != null && notReadMsgCountMap.containsKey(roomJid) ? (Integer)notReadMsgCountMap.get(roomJid) : 0;
                        int hasMeCount = hasMeCountMap != null && hasMeCountMap.containsKey(roomJid) ? (Integer)hasMeCountMap.get(roomJid) : 0;
                        List participantJidList = (List)participantJidMap.get(roomJid);
                        Message lastMsg = (Message)lastMsgMap.get(roomJid);
                        String pendingDraft = (String)pendingDraftMap.get(roomJid);
                        boolean visible = false;
                        if (!doSearch || ContactHistoryPanel.this.panelSearchEntriesAll || i < 5) {
                            visible = true;
                        }
                        if (unchangedSearchHistoryIDs.contains(roomJid)) {
                            chep = ContactHistoryPanel.this.moveSearchHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, visible, matchCount, trimSearchKey);
                            compList2[i] = chep;
                            continue;
                        }
                        if (!newSearchHistoryIDs.contains(roomJid)) continue;
                        chep = ContactHistoryPanel.this.insertSearchHistory(roomInfo, contactsMap, participantJidList, lastMsg, pendingDraft, unreadMsgCount, hasMeCount, visible, matchCount, trimSearchKey);
                        compList2[i] = chep;
                    }
                    ContactHistoryPanel.this.panelSearchEntries.removeAll();
                    for (Component comp : compList2) {
                        ContactHistoryPanel.this.panelSearchEntries.add(comp);
                    }
                    oldSearchHistoryIDs = ContactHistoryPanel.this.getSearchHistoryIDs();
                    ContactHistoryPanel.this.panelSearchEntriesTitle.setVisible(doSearch && ContactHistoryPanel.this.roomInfoList2.size() > 0);
                    ContactHistoryPanel.this.panelSearchEntriesTitle.setText(String.format(I18NUtil.getString("contact_history_message_search"), String.valueOf(ContactHistoryPanel.this.totalMsgCount)));
                    ContactHistoryPanel.this.checkSearchDisplayAllBtn(doSearch);
                    ContactHistoryPanel.this.panelSearchEntries.revalidate();
                    ContactHistoryPanel.this.panelSearchEntries.repaint();
                    ContactHistoryPanel.this.fireUnreadMessageChanged();
                    if (ContactHistoryPanel.this.selectedEntryPanel != null && ContactHistoryPanel.this.selectedEntryPanel.getParent() == null) {
                        ContactHistoryPanel.this.selectedEntryPanel = null;
                    }
                    ContactHistoryPanel.this.checkNoContent();
                    Log.d(ContactHistoryPanel.class.getSimpleName(), "end render done ===========>" + (System.currentTimeMillis() - t1));
                }
            }
        });
    }

    private void checkDisplayAllBtn(boolean doSearch) {
        if (!doSearch || this.roomInfoList1.size() <= 5) {
            this.panelContentEntriesBtn.setVisible(false);
        } else {
            this.panelContentEntriesBtn.setVisible(true);
            if (this.panelContentEntriesAll) {
                this.panelContentEntriesBtn.setIcon(UIConstants.ICON_ARROW_UP_2);
                this.panelContentEntriesBtn.setText(I18NUtil.getString("contact_history_less"));
            } else {
                this.panelContentEntriesBtn.setIcon(UIConstants.ICON_ARROW_DOWN_2);
                this.panelContentEntriesBtn.setText(I18NUtil.getString("contact_history_more"));
            }
        }
    }

    private void checkSearchDisplayAllBtn(boolean doSearch) {
        if (!doSearch || this.roomInfoList2.size() <= 5) {
            this.panelSearchEntriesBtn.setVisible(false);
        } else {
            this.panelSearchEntriesBtn.setVisible(true);
            if (this.panelSearchEntriesAll) {
                this.panelSearchEntriesBtn.setIcon(UIConstants.ICON_ARROW_UP_2);
                this.panelSearchEntriesBtn.setText(I18NUtil.getString("contact_history_less"));
            } else {
                this.panelSearchEntriesBtn.setIcon(UIConstants.ICON_ARROW_DOWN_2);
                this.panelSearchEntriesBtn.setText(I18NUtil.getString("contact_history_more"));
            }
        }
    }

    private void handleContentEntriesFlagChange() {
        if (this.panelContentEntriesAll) {
            this.panelContentEntriesAll = false;
            Component[] comps = this.panelContentEntries.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!(comp instanceof ContactHistoryEntryPanel)) continue;
                ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
                if (i < 5) {
                    chep.setVisible(true);
                    continue;
                }
                chep.setVisible(false);
            }
        } else {
            Component[] comps;
            this.panelContentEntriesAll = true;
            for (Component comp : comps = this.panelContentEntries.getComponents()) {
                if (!(comp instanceof ContactHistoryEntryPanel)) continue;
                ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
                chep.setVisible(true);
            }
        }
        this.panelContentEntries.revalidate();
        this.panelContentEntries.repaint();
        this.checkDisplayAllBtn(true);
    }

    private void handleSearchContentEntriesFlagChange() {
        if (this.panelSearchEntriesAll) {
            this.panelSearchEntriesAll = false;
            Component[] comps = this.panelSearchEntries.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                Component comp = comps[i];
                if (!(comp instanceof ContactHistoryEntryPanel)) continue;
                ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
                if (i < 5) {
                    chep.setVisible(true);
                    continue;
                }
                chep.setVisible(false);
            }
        } else {
            Component[] comps;
            this.panelSearchEntriesAll = true;
            for (Component comp : comps = this.panelSearchEntries.getComponents()) {
                if (!(comp instanceof ContactHistoryEntryPanel)) continue;
                ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
                chep.setVisible(true);
            }
        }
        this.panelSearchEntries.revalidate();
        this.panelSearchEntries.repaint();
        this.checkSearchDisplayAllBtn(true);
    }

    private Set<String> getContactHistoryIDs(List<ChatRoomInfo> roomInfoList) {
        HashSet<String> ret = new HashSet<String>();
        for (ChatRoomInfo roomInfo : roomInfoList) {
            ret.add(roomInfo.getChatRoomId());
        }
        return ret;
    }

    private Set<String> getSearchHistoryIDs(List<ChatRoomInfo> roomInfoList) {
        HashSet<String> ret = new HashSet<String>();
        for (ChatRoomInfo roomInfo : roomInfoList) {
            if (roomInfo == null) continue;
            ret.add(roomInfo.getChatRoomId());
        }
        return ret;
    }

    private Set<String> getContactHistoryIDs() {
        Component[] comps;
        HashSet<String> result = new HashSet<String>();
        for (Component comp : comps = this.panelContentEntries.getComponents()) {
            if (!(comp instanceof ContactHistoryEntryPanel)) continue;
            ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
            result.add(chep.getChatId());
        }
        return result;
    }

    private Set<String> getSearchHistoryIDs() {
        Component[] comps;
        HashSet<String> result = new HashSet<String>();
        for (Component comp : comps = this.panelSearchEntries.getComponents()) {
            if (!(comp instanceof ContactHistoryEntryPanel)) continue;
            ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)comp;
            result.add(chep.getChatId());
        }
        return result;
    }

    public void setUnselectedContactHistory() {
        if (this.selectedEntryPanel != null) {
            this.selectedEntryPanel.setSelected(false);
            this.selectedEntryPanel = null;
        }
    }

    public void setSelectedContactHistory(String chatId, Intent viewIntent) {
        boolean forContentSearch = false;
        if (viewIntent != null) {
            forContentSearch = viewIntent.getBooleanExtra("forContentSearch", false);
        }
        ContactHistoryEntryPanel chep = null;
        chep = !forContentSearch ? this.getContactHistoryEntryPanel(chatId) : this.getSearchHistoryEntryPanel(chatId);
        this.setSelectedContactHistory(chep, false);
    }

    public void setSelectedContactHistory(ContactHistoryEntryPanel chep, boolean showViewer) {
        if (this.selectedEntryPanel != null && this.selectedEntryPanel != chep) {
            this.selectedEntryPanel.setSelected(false);
            this.selectedEntryPanel = null;
        }
        if (chep == null) {
            return;
        }
        this.selectedEntryPanel = chep;
        this.selectedEntryPanel.setSelected(true);
        this.fireUnreadMessageChanged();
        this.fireContactHistorySelected(this.selectedEntryPanel.getChatId());
        String chatId = chep.getChatId();
        if (showViewer) {
            MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
            Intent intent = new Intent();
            intent.putExtra("forContentSearch", chep.isForContentSearch());
            if (StringUtils.isNotBlank((CharSequence)chep.getSearchKey())) {
                intent.putExtra("contentSearchKey", chep.getSearchKey());
            }
            if (JidUtil.isConfJid(chatId)) {
                intent.putExtra("unjoined_display_mode", (Serializable)((Object)ConferenceChatroom.UnjoinedDisplayMode.CHAT_HISTORY));
            }
            mainPanel.showChatroom(chatId, intent);
        }
    }

    class EntryPanelMouseListener
    extends MouseAdapter {
        EntryPanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getButton() == 1) {
                ContactHistoryEntryPanel panel = (ContactHistoryEntryPanel)evt.getComponent();
                this.switchSelectedContactHistory(panel);
                MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                mainPanel.switchAddressBookEntry(panel.getChatId());
            }
            this.checkPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.checkPopup(evt);
        }

        private void switchSelectedContactHistory(ContactHistoryEntryPanel chep) {
            ContactHistoryPanel.this.setSelectedContactHistory(chep, true);
        }

        private void checkPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                ContactHistoryEntryPanel chep = (ContactHistoryEntryPanel)evt.getComponent();
                JPopupMenu popupContactHistoryEntry = new JPopupMenu();
                popupContactHistoryEntry.addPopupMenuListener(ContactHistoryPanel.this.myPopupMenuListener);
                if (JidUtil.isFakeFaxDocJid(chep.getChatId())) {
                    boolean isFaxOnTop = PreferencesUtil.isFaxOnTop(UCChatClient.context);
                    if (isFaxOnTop) {
                        popupContactHistoryEntry.add(new JMenuItem(new CancelOnTopAction()));
                    } else {
                        popupContactHistoryEntry.add(new JMenuItem(new OnTopAction()));
                    }
                } else if (JidUtil.isFakeExternalCallJid(chep.getChatId())) {
                    boolean isExternalPhoneOnTop = PreferencesUtil.isExternalPhoneOnTop(UCChatClient.context);
                    if (isExternalPhoneOnTop) {
                        popupContactHistoryEntry.add(new JMenuItem(new CancelOnTopAction()));
                    } else {
                        popupContactHistoryEntry.add(new JMenuItem(new OnTopAction()));
                    }
                } else {
                    LiteConferenceRoom confRoom;
                    ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, chep.getChatId());
                    boolean hasNumber = false;
                    if (chatRoomInfo.getType() == 3) {
                        hasNumber = true;
                    } else if ((chatRoomInfo.getType() == 1 || chatRoomInfo.getType() == 2) && (confRoom = UCDBConf.getConfRoomByChatRoomId(UCChatClient.context, chatRoomInfo.getChatRoomId())) != null) {
                        hasNumber = true;
                    }
                    if (chatRoomInfo.isOnTop()) {
                        popupContactHistoryEntry.add(new JMenuItem(new CancelOnTopAction()));
                    } else {
                        popupContactHistoryEntry.add(new JMenuItem(new OnTopAction()));
                    }
                    if (hasNumber) {
                        popupContactHistoryEntry.add(new JMenuItem(new CopyNumberAction()));
                    }
                    popupContactHistoryEntry.add(new JMenuItem(new DeleteContactHistoryAction()));
                }
                popupContactHistoryEntry.show(chep, evt.getX(), evt.getY());
                ContactHistoryPanel.this.menuDisplayedEntryPanel = chep;
                ContactHistoryPanel.this.menuDisplayedEntryPanel.setMenuDisplayed(true);
            }
        }
    }

    class CountDownThread
    extends Thread {
        boolean goon = true;

        public CountDownThread() {
            this.setName("Wechat-CountDownThread ContactHistoryPanel");
        }

        public void terminate() {
            this.goon = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.goon) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Component[] comps;
                            for (Component comp : comps = ContactHistoryPanel.this.panelContentEntries.getComponents()) {
                                LiteCustomer liteCustomer;
                                ContactHistoryEntryPanel chep;
                                if (!(comp instanceof ContactHistoryEntryPanel) || !JidUtil.isCustomerJid((chep = (ContactHistoryEntryPanel)comp).getChatId()) || (liteCustomer = CustomerManager.getCustomerInfo(UCChatClient.context, JidUtil.convertKey(chep.getChatId()))) == null) continue;
                                chep.setCustomerExpireTime(liteCustomer);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
                try {
                    CountDownThread.sleep(30000L);
                }
                catch (InterruptedException e) {
                    Log.d(ContactHistoryPanel.class.getSimpleName(), this.getName() + ":" + e.getMessage());
                }
            }
        }
    }

    class MyPopupMenuListener
    implements PopupMenuListener {
        MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (ContactHistoryPanel.this.menuDisplayedEntryPanel != null && ContactHistoryPanel.this.menuDisplayedEntryPanel != ContactHistoryPanel.this.selectedEntryPanel) {
                ContactHistoryPanel.this.menuDisplayedEntryPanel.setMenuDisplayed(false);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    class CancelOnTopAction
    extends AbstractAction
    implements ClipboardOwner {
        public CancelOnTopAction() {
            this.putValue("Name", I18NUtil.getString("history_cancel_on_top"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JidUtil.isFakeFaxDocJid(ContactHistoryPanel.this.menuDisplayedEntryPanel.getChatId())) {
                PreferencesUtil.setIsFaxOnTop(UCChatClient.context, false);
            } else if (JidUtil.isFakeExternalCallJid(ContactHistoryPanel.this.menuDisplayedEntryPanel.getChatId())) {
                PreferencesUtil.setIsExternalPhoneOnTop(UCChatClient.context, false);
            } else {
                UCDBChatRoom.updateChatRoomOnTopFlag(UCChatClient.context, ContactHistoryPanel.this.menuDisplayedEntryPanel.getChatId(), false);
            }
            BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class OnTopAction
    extends AbstractAction
    implements ClipboardOwner {
        public OnTopAction() {
            this.putValue("Name", I18NUtil.getString("history_on_top"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JidUtil.isFakeFaxDocJid(ContactHistoryPanel.this.menuDisplayedEntryPanel.getChatId())) {
                PreferencesUtil.setIsFaxOnTop(UCChatClient.context, true);
            } else if (JidUtil.isFakeExternalCallJid(ContactHistoryPanel.this.menuDisplayedEntryPanel.getChatId())) {
                PreferencesUtil.setIsExternalPhoneOnTop(UCChatClient.context, true);
            } else {
                UCDBChatRoom.updateChatRoomOnTopFlag(UCChatClient.context, ContactHistoryPanel.this.menuDisplayedEntryPanel.getChatId(), true);
            }
            BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class CopyNumberAction
    extends AbstractAction
    implements ClipboardOwner {
        public CopyNumberAction() {
            this.putValue("Name", I18NUtil.getString("history_copy_number"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            LiteConferenceRoom confRoom;
            ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, ContactHistoryPanel.this.menuDisplayedEntryPanel.getChatId());
            Object phoneNumber = "";
            if (chatRoomInfo.getType() == 3) {
                if (chatRoomInfo.getChatRoomId().indexOf("_@@_") != -1) {
                    String[] phoneNum = chatRoomInfo.getChatRoomId().split("_@@_");
                    phoneNumber = phoneNum[1];
                } else {
                    phoneNumber = chatRoomInfo.getChatRoomId();
                }
            } else if ((chatRoomInfo.getType() == 1 || chatRoomInfo.getType() == 2) && (confRoom = UCDBConf.getConfRoomByChatRoomId(UCChatClient.context, chatRoomInfo.getChatRoomId())) != null) {
                phoneNumber = OutboundPrefixManager.getMeetmePrefix(UCChatClient.context) + confRoom.getRoomNo();
            }
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection((String)phoneNumber);
            clipboard.setContents(contents, this);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class DeleteContactHistoryAction
    extends AbstractAction {
        public DeleteContactHistoryAction() {
            this.putValue("Name", I18NUtil.getString("common_btn_delete"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result = JOptionPane.showConfirmDialog(ContactHistoryPanel.this, I18NUtil.getString("common_notice_delete_confirm"), I18NUtil.getString("common_title_warning"), 2, 2);
            if (result == 0) {
                final ContactHistoryEntryPanel chep = ContactHistoryPanel.this.menuDisplayedEntryPanel;
                if (JidUtil.isChatConfJid(chep.getChatId())) {
                    UCDBRemoteMark.addRemoteMark((Context)UCChatClient.context, 6, chep.getChatId());
                    ChatRoomManager.clearChatMsg(UCChatClient.context, chep.getChatId());
                    WebAgent.getInstance().deleteChatEventsByRoomJid(chep.getChatId());
                } else {
                    Set<Long> eventIdSet = UCDBMessage.findMsgsEventIdList(UCChatClient.context, chep.getChatId());
                    ChatRoomManager.clearChatMsg(UCChatClient.context, chep.getChatId());
                    UCDBChatRoom.deleteChatRoom(UCChatClient.context, chep.getChatId());
                    WebAgent.getInstance().clearSyncRoomInfo(chep.getChatId());
                    if (eventIdSet != null && eventIdSet.size() > 0) {
                        for (Long id : eventIdSet) {
                            UCDBRemoteMark.addRemoteMark((Context)UCChatClient.context, 8, id);
                        }
                        WebAgent.getInstance().deleteChatEvent(eventIdSet);
                    }
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ContactHistoryPanel.this.removeContactHistory(chep.getChatId(), null);
                        ContactHistoryPanel.this.panelContentEntries.revalidate();
                        ContactHistoryPanel.this.panelContentEntries.repaint();
                        ContactHistoryPanel.this.removeSearchHistory(chep.getChatId(), null);
                        ContactHistoryPanel.this.panelSearchEntries.revalidate();
                        ContactHistoryPanel.this.panelSearchEntries.repaint();
                        ContactHistoryPanel.this.fireUnreadMessageChanged();
                        BroadcastUtil.sendChatRoomMsgDeletedEvent(UCChatClient.context, chep.getChatId());
                        BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
                        BroadcastUtil.sendMsgChangedEvent(UCChatClient.context);
                    }
                });
            }
        }
    }
}

