/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.freeseating;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.freeseating.FreeSeating;
import com.blisscloud.ezuc.client.freeseating.FreeSeatingSelectionRenderer;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FreeSeatingSelectionDialog
extends GenericDialog {
    private JComboBox<FreeSeating> freeSeatingBox;
    private DefaultComboBoxModel<FreeSeating> freeSeatingBoxModel = new DefaultComboBoxModel();
    private JRadioButton optionLaterRadioBtn;
    private JRadioButton optionFreeSeatingRadioBtn;
    ButtonGroup optionBtnGroup = new ButtonGroup();
    private JScrollPane jScrollPane;
    private boolean hasFreeSeating = false;
    private String mPreDeviceId = null;
    private BroadcastReceiver mReceiver = null;
    private Timer timer = new Timer("FreeSeatingSelectionDialog");

    public FreeSeatingSelectionDialog(JFrame frame, JSONObject dataObj) {
        super(frame);
        this.initGUI();
        this.optionLaterRadioBtn.setSelected(true);
        for (ActionListener l : this.freeSeatingBox.getActionListeners()) {
            this.freeSeatingBox.removeActionListener(l);
        }
        this.freeSeatingBoxModel.removeAllElements();
        try {
            int size = dataObj.getInt("freeSeatingSize");
            FreeSeating selectedItem = null;
            if (size > 0) {
                JSONArray array = dataObj.getJSONArray("freeSeatingList");
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject item = array.getJSONObject(i);
                    FreeSeating seating = new FreeSeating();
                    seating.setDeviceId(item.getString("deviceId"));
                    if (item.has("label")) {
                        seating.setLabel(item.getString("label"));
                    }
                    if (item.has("ownerId")) {
                        seating.setOwnerId(item.getLong("ownerId"));
                    }
                    if (item.has("ownerDispName")) {
                        seating.setOwnerName(item.getString("ownerDispName"));
                    }
                    this.freeSeatingBoxModel.addElement(seating);
                    Long myid = PreferencesUtil.getUserId(UCChatClient.context);
                    if (seating.getOwnerId() == null || seating.getOwnerId().longValue() != myid.longValue()) continue;
                    this.hasFreeSeating = true;
                    this.mPreDeviceId = seating.getDeviceId();
                    selectedItem = seating;
                    this.optionFreeSeatingRadioBtn.setSelected(true);
                }
            }
            if (selectedItem != null) {
                this.freeSeatingBox.setSelectedItem(selectedItem);
            } else {
                this.freeSeatingBox.setSelectedIndex(0);
            }
            this.freeSeatingBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (FreeSeatingSelectionDialog.this.freeSeatingBoxModel.getSelectedItem() != null) {
                        FreeSeatingSelectionDialog.this.optionFreeSeatingRadioBtn.setSelected(true);
                    }
                }
            });
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("freeSeating_dialog_title"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            JPanel sPanel = new JPanel();
            sPanel.setLayout(new GridBagLayout());
            sPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            JButton btnConfirm = new JButton();
            btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            btnConfirm.setMinimumSize(new Dimension(75, 30));
            btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FreeSeatingSelectionDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            sPanel.add((Component)btnConfirm, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
            JButton btnCancel = new JButton();
            btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            btnCancel.setMinimumSize(new Dimension(75, 30));
            btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    FreeSeatingSelectionDialog.this.btnCancelActionPerformed(evt);
                }
            });
            sPanel.add((Component)btnCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 5, 10, 5), 0, 0));
            this.add((Component)sPanel, "South");
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setVerticalScrollBarPolicy(20);
            this.jScrollPane.setHorizontalScrollBarPolicy(30);
            this.add((Component)this.jScrollPane, "Center");
            this.jScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
            JPanel mainPanel = new JPanel();
            mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
            GridBagLayout mainLayout = new GridBagLayout();
            mainPanel.setLayout(mainLayout);
            mainPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.jScrollPane.setViewportView(mainPanel);
            this.optionLaterRadioBtn = new JRadioButton();
            mainPanel.add((Component)this.optionLaterRadioBtn, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.optionLaterRadioBtn.setText(I18NUtil.getString("freeSeating_dialog_selection_disabled"));
            this.optionLaterRadioBtn.setOpaque(false);
            this.optionLaterRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.optionBtnGroup.add(this.optionLaterRadioBtn);
            this.optionFreeSeatingRadioBtn = new JRadioButton();
            this.optionFreeSeatingRadioBtn.setText(I18NUtil.getString("freeSeating_dialog_selection_enabled"));
            this.optionFreeSeatingRadioBtn.setOpaque(false);
            this.optionFreeSeatingRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.optionBtnGroup.add(this.optionFreeSeatingRadioBtn);
            mainPanel.add((Component)this.optionFreeSeatingRadioBtn, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 0), 0, 0));
            this.freeSeatingBox = new JComboBox();
            this.freeSeatingBox.setFont(UIConstants.FONT_12_PLAIN);
            this.freeSeatingBox.setModel(this.freeSeatingBoxModel);
            this.freeSeatingBox.setRenderer(new FreeSeatingSelectionRenderer());
            mainPanel.add(this.freeSeatingBox, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 0), 0, 0));
            JPanel x = new JPanel();
            x.setOpaque(false);
            mainPanel.add((Component)x, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setSize(500, 250);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showDialog() {
        this.setVisible(true);
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.mReceiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    if ("ezuc.intent.action.event.CANCEL_FREE_SEATING_RESULT".equals(action)) {
                        int returnCode = bundle.getInt("returnCode");
                        if (returnCode == 0) {
                            ToastUtil.showShort(I18NUtil.getString("freeSeating_dialog_message_clean_success"));
                            FreeSeatingSelectionDialog.this.timer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    FreeSeatingSelectionDialog.this.closeCleanup();
                                }
                            }, 500L);
                        } else {
                            ToastUtil.showErrorLong(I18NUtil.getString("freeSeating_dialog_message_clean_failed"));
                        }
                    } else if ("ezuc.intent.action.event.REQUEST_FREE_SEATING_RESULT".equals(action)) {
                        int returnCode = bundle.getInt("returnCode");
                        if (returnCode == 0) {
                            ToastUtil.showShort(I18NUtil.getString("freeSeating_dialog_message_bind_success"));
                            FreeSeatingSelectionDialog.this.timer.schedule((TimerTask)new UCTimerTask(){

                                @Override
                                public void doRun() {
                                    FreeSeatingSelectionDialog.this.closeCleanup();
                                }
                            }, 500L);
                        } else if (returnCode == -5) {
                            ToastUtil.showErrorLong(I18NUtil.getString("freeSeating_dialog_message_bind_failed_no_license"));
                        } else {
                            ToastUtil.showErrorLong(I18NUtil.getString("freeSeating_dialog_message_bind_failed"));
                        }
                    }
                }
                catch (Throwable t) {
                    Log.e(MainPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        IntentFilter filter = new IntentFilter();
        filter.addAction("ezuc.intent.action.event.CANCEL_FREE_SEATING_RESULT");
        filter.addAction("ezuc.intent.action.event.REQUEST_FREE_SEATING_RESULT");
        UCChatClient.context.registerReceiver(this.mReceiver, filter);
        if (this.optionLaterRadioBtn.isSelected()) {
            if (this.hasFreeSeating) {
                WebAgent.getInstance().cancelFreeSeating();
            } else {
                this.closeCleanup();
            }
        }
        if (this.optionFreeSeatingRadioBtn.isSelected()) {
            FreeSeating selectedItem = (FreeSeating)this.freeSeatingBoxModel.getSelectedItem();
            if (selectedItem == null) {
                ToastUtil.showLong(I18NUtil.getString("freeSeating_dialog_message_selection_requried"));
                this.freeSeatingBox.requestFocus();
            } else {
                if (StringUtils.isNotBlank((CharSequence)this.mPreDeviceId) && this.mPreDeviceId.equals(selectedItem.getDeviceId())) {
                    this.closeCleanup();
                }
                WebAgent.getInstance().requestFreeSeating(selectedItem.getDeviceId());
            }
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.closeCleanup();
    }

    @Override
    protected void onESCPressed() {
        this.closeCleanup();
    }

    private void closeCleanup() {
        if (this.mReceiver != null) {
            UCChatClient.context.unregisterReceiver(this.mReceiver);
        }
        this.dispose();
    }
}

