/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.inboundfilter;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;

public class AddNumToInboundBlackListConfirmDialog
extends GenericDialog {
    private static final long serialVersionUID = 8501428138740803657L;
    private JPanel panelContent;
    private JLabel lblNumberTitle;
    private JTextField phoneNumberField;
    private JLabel lblTitleError;
    private JLabel lblReasonTitle;
    private JTextArea reasonField;
    private JLabel lblReasonError;
    private JButton btnConfirm;
    private JButton btnCancel;
    private boolean mOK = false;
    private String mPhoneNumber = null;

    public AddNumToInboundBlackListConfirmDialog(JFrame frame, String phoneNumber) {
        super(frame);
        this.initGUI();
        this.mPhoneNumber = phoneNumber;
        if (StringUtils.isNotBlank((CharSequence)this.mPhoneNumber)) {
            this.phoneNumberField.setText(this.mPhoneNumber);
        }
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("phone_history_btn_add_to_inbound_black_list"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "North");
            this.panelContent.setLayout(panelContentLayout);
            int y = 0;
            JPanel numberPanel = new JPanel();
            GridBagLayout numberLayout = new GridBagLayout();
            numberPanel.setLayout(numberLayout);
            numberPanel.setOpaque(false);
            this.lblNumberTitle = new JLabel();
            this.lblNumberTitle.setText(I18NUtil.getString("phone_history_add_to_inbound_black_list_phoneNum"));
            this.lblNumberTitle.setFont(UIConstants.FONT_14_PLAIN);
            numberPanel.add((Component)this.lblNumberTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.phoneNumberField = new JTextField(20);
            this.phoneNumberField.setEditable(false);
            this.phoneNumberField.setPreferredSize(new Dimension(200, 20));
            this.phoneNumberField.setMinimumSize(new Dimension(200, 20));
            numberPanel.add((Component)this.phoneNumberField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblTitleError = new JLabel();
            this.lblTitleError.setFont(UIConstants.FONT_12_PLAIN);
            this.lblTitleError.setVisible(false);
            this.lblTitleError.setForeground(Color.RED);
            numberPanel.add((Component)this.lblTitleError, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panelContent.add((Component)numberPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 30), 0, 0));
            JPanel reasonPanel = new JPanel();
            GridBagLayout reasonLayout = new GridBagLayout();
            reasonPanel.setLayout(reasonLayout);
            reasonPanel.setOpaque(false);
            this.lblReasonTitle = new JLabel();
            this.lblReasonTitle.setText(I18NUtil.getString("phone_history_add_to_inbound_black_list_reason"));
            this.lblReasonTitle.setFont(UIConstants.FONT_14_PLAIN);
            reasonPanel.add((Component)this.lblReasonTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.reasonField = new JTextArea(10, 30);
            JScrollPane scrollPane = new JScrollPane(this.reasonField);
            this.reasonField.setLineWrap(true);
            this.reasonField.setWrapStyleWord(true);
            this.reasonField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    AddNumToInboundBlackListConfirmDialog.this.verifyReason();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    AddNumToInboundBlackListConfirmDialog.this.verifyReason();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            reasonPanel.add((Component)scrollPane, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblReasonError = new JLabel();
            this.lblReasonError.setFont(UIConstants.FONT_12_PLAIN);
            this.lblReasonError.setVisible(false);
            this.lblReasonError.setForeground(Color.RED);
            reasonPanel.add((Component)this.lblReasonError, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.panelContent.add((Component)reasonPanel, new GridBagConstraints(0, y++, 2, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 10, 30), 0, 0));
            JPanel buttonPanel = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(1);
            jPanel1Layout.setHgap(10);
            buttonPanel.setLayout(jPanel1Layout);
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 15, 8, 15));
            this.getContentPane().add((Component)buttonPanel, "South");
            buttonPanel.setOpaque(false);
            this.btnConfirm = new JButton();
            buttonPanel.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AddNumToInboundBlackListConfirmDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnConfirm.setEnabled(false);
            this.btnCancel = new JButton();
            buttonPanel.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AddNumToInboundBlackListConfirmDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(250, 250);
            this.setMinimumSize(new Dimension(350, 300));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void verifyReason() {
        String reason = this.reasonField.getText();
        if (TextUtils.isBlank((CharSequence)reason)) {
            this.btnConfirm.setEnabled(false);
            this.lblReasonError.setVisible(false);
            this.lblReasonError.setText("");
        } else if (reason.length() > 1024) {
            this.btnConfirm.setEnabled(false);
            this.lblReasonError.setVisible(true);
            this.lblReasonError.setText(I18NUtil.getString("phone_history_validation_reason_too_long"));
        } else {
            this.btnConfirm.setEnabled(true);
            this.lblReasonError.setVisible(false);
            this.lblReasonError.setText("");
        }
        this.pack();
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.mOK = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    public boolean showDialog() {
        this.mOK = false;
        this.setVisible(true);
        return this.mOK;
    }

    public String getPhoneNumber() {
        return this.phoneNumberField.getText();
    }

    public String getReason() {
        return this.reasonField.getText();
    }
}

