/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.ToastPanel;
import com.blisscloud.ezuc.client.main.ActivePhoneWithControlPanel;
import com.blisscloud.ezuc.client.main.ToastInterface;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;

public class UnfocusPopupWindow
extends JFrame
implements ToastInterface {
    private static final long serialVersionUID = -8560238854557377286L;
    private static final int ALPHA_MAX = 255;
    private static final int ALPHA_MIN = 150;
    private static final int ALPHA_DIFF = 4;
    private static final int ALPHA_DURATION = 80;
    private RoundedCornerPanel contentPane;
    private JLabel lblLogo;
    private JSeparator jSeparator1;
    private JLabel lblClose;
    private Point pressedPoint;
    private Point pressedLocation;
    private ActivePhoneWithControlPanel phoneLine0Panel;
    private JSeparator phoneLine1Separator;
    private ActivePhoneWithControlPanel phoneLine1Panel;
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private int alpha = 150;
    private int increment = 4;
    private Timer timer1;
    private boolean timerOn;
    private Handler callTimeHandler = new Handler("CallTimeHandler2");
    private Runnable callTimeTimer = new Runnable(){

        @Override
        public void run() {
            if (!PhoneAgent.getInstance().isCallIdle()) {
                for (CallLine line : PhoneAgent.getInstance().getCallLineAry()) {
                    if (line.getLineInfo() == null) continue;
                    if (line.getLineId() == 0) {
                        UnfocusPopupWindow.this.phoneLine0Panel.updateTimer();
                        continue;
                    }
                    if (line.getLineId() != 1) continue;
                    UnfocusPopupWindow.this.phoneLine1Panel.updateTimer();
                }
                UnfocusPopupWindow.this.callTimeHandler.postDelayed(this, 500L);
            } else {
                UnfocusPopupWindow.this.phoneLine0Panel.cancelTimer();
                UnfocusPopupWindow.this.phoneLine1Panel.cancelTimer();
            }
        }
    };
    private ToastPanel toastPanel;

    public UnfocusPopupWindow() {
        this.setTitle(I18NUtil.getAppName());
        this.setIconImages(UIConstants.APP_ICONS);
        this.setFocusableWindowState(false);
        this.initGUI();
        this.initReceiver();
        this.timer1 = new Timer(80, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ld2) {
                UnfocusPopupWindow.this.alpha += UnfocusPopupWindow.this.increment;
                if (UnfocusPopupWindow.this.alpha > 255) {
                    UnfocusPopupWindow.this.alpha = 255;
                    UnfocusPopupWindow.this.increment = -4;
                } else if (UnfocusPopupWindow.this.alpha < 150) {
                    UnfocusPopupWindow.this.alpha = 150;
                    UnfocusPopupWindow.this.increment = 4;
                }
                UnfocusPopupWindow.this.contentPane.setFromColor(new Color(128, 128, 128, UnfocusPopupWindow.this.alpha));
                UnfocusPopupWindow.this.contentPane.setToColor(new Color(32, 32, 32, UnfocusPopupWindow.this.alpha));
                UnfocusPopupWindow.this.contentPane.repaint();
            }
        });
    }

    private void initGUI() {
        try {
            this.toastPanel = new ToastPanel();
            this.toastPanel.setVisible(false);
            this.getLayeredPane().add((Component)this.toastPanel, JLayeredPane.POPUP_LAYER);
            this.setDefaultCloseOperation(2);
            this.setUndecorated(true);
            this.contentPane = new RoundedCornerPanel(8, 1.0f, new Color(0x606060), 1, new Color(128, 128, 128, 150), new Color(32, 32, 32, 150));
            GridBagLayout contentPaneLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.contentPane, "Center");
            this.contentPane.setLayout(contentPaneLayout);
            this.contentPane.setPreferredSize(new Dimension(473, 143));
            this.contentPane.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent evt) {
                    UnfocusPopupWindow.this.lblLogoMouseDragged(evt);
                }
            });
            this.contentPane.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    UnfocusPopupWindow.this.lblLogoMousePressed(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    UnfocusPopupWindow.this.dispose();
                    UCChatClient.getInstance().handleMoveToFront();
                }
            });
            this.lblLogo = new JLabel();
            this.contentPane.add((Component)this.lblLogo, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(4, 8, 4, 0), 0, 0));
            this.lblLogo.setIcon(UIConstants.ICON_LOGO20);
            this.lblLogo.setText(I18NUtil.getAppName());
            this.lblLogo.setFont(UIConstants.FONT_12_PLAIN);
            this.lblLogo.setForeground(Color.LIGHT_GRAY);
            this.lblLogo.setPreferredSize(new Dimension(20, 20));
            this.lblClose = new JLabel();
            this.contentPane.add((Component)this.lblClose, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(4, 0, 4, 8), 0, 0));
            this.lblClose.setIcon(UIConstants.ICON_CLOSE);
            this.lblClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    UnfocusPopupWindow.this.dispose();
                    PreferencesUtil.setPopupUnfocus(UCChatClient.context, "-1,-1");
                    UCChatClient.getInstance().handleMoveToFront();
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    UnfocusPopupWindow.this.lblClose.setIcon(UIConstants.ICON_CLOSE_OVER);
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    UnfocusPopupWindow.this.lblClose.setIcon(UIConstants.ICON_CLOSE);
                }
            });
            this.jSeparator1 = new JSeparator();
            this.contentPane.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 4, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(new Color(0x808080));
            this.jSeparator1.setBackground(new Color(0x707070));
            JPanel phoneGroupPanel = new JPanel();
            GridBagLayout panelGroupLayoutMgr = new GridBagLayout();
            phoneGroupPanel.setLayout(panelGroupLayoutMgr);
            phoneGroupPanel.setOpaque(false);
            this.contentPane.add((Component)phoneGroupPanel, new GridBagConstraints(0, 2, 4, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.phoneLine0Panel = new ActivePhoneWithControlPanel(0, this);
            this.phoneLine0Panel.setVisible(false);
            this.phoneLine1Panel = new ActivePhoneWithControlPanel(1, this);
            this.phoneLine1Panel.setVisible(false);
            this.phoneLine1Separator = new JSeparator(0);
            this.phoneLine1Separator.setVisible(false);
            this.phoneLine1Separator.setBackground(new Color(245, 245, 245));
            phoneGroupPanel.add((Component)this.phoneLine0Panel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            phoneGroupPanel.add((Component)this.phoneLine1Separator, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            phoneGroupPanel.add((Component)this.phoneLine1Panel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.setBackground(new Color(0, 0, 0, 0));
            this.setAlwaysOnTop(true);
            this.setResizable(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lblLogoMousePressed(MouseEvent evt) {
        this.pressedPoint = evt.getLocationOnScreen();
        this.pressedLocation = this.getLocation();
    }

    private void lblLogoMouseDragged(MouseEvent evt) {
        Point currentPoint = evt.getLocationOnScreen();
        int diffX = currentPoint.x - this.pressedPoint.x;
        int diffY = currentPoint.y - this.pressedPoint.y;
        int x = this.pressedLocation.x + diffX;
        int y = this.pressedLocation.y + diffY;
        this.setLocation(x, y);
        PreferencesUtil.setPopupUnfocus(UCChatClient.context, x + "," + y);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if ("ezuc.intent.action.event.PHONE_STATE_CHANGED".equals(action) || "ezuc.intent.action.event.PHONE_MUTE_CHANGED".equals(action) || "ezuc.intent.action.event.PHONE_RECORDING_CHANGED".equals(action) || "ezuc.intent.action.event.PHONE_CALL_BRIDGED".equals(action) || "ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER".equals(action) || "ezuc.intent.action.event.PHONE_INVITE_JOIN_MEETME".equals(action) || "ezuc.intent.action.event.PHONE_INFO_CHANGED".equals(action) || "ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED".equals(action)) {
                        UnfocusPopupWindow.this.agentStateChanged();
                    }
                }
                catch (Throwable t) {
                    Log.e(UnfocusPopupWindow.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezuc.intent.action.event.PHONE_STATE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_MUTE_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_RECORDING_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_CALL_BRIDGED");
        this.filter.addAction("ezuc.intent.action.event.PHONE_TWO_STEP_TRANSFER");
        this.filter.addAction("ezuc.intent.action.event.PHONE_INVITE_JOIN_MEETME");
        this.filter.addAction("ezuc.intent.action.event.PHONE_INFO_CHANGED");
        this.filter.addAction("ezuc.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    protected void agentStateChanged() {
        if (PhoneAgent.getInstance().isCallIdle()) {
            this.callTimeHandler.removeCallbacks(this.callTimeTimer);
            this.timerOn = false;
        } else if (!this.timerOn) {
            this.timerOn = true;
            this.callTimeHandler.postDelayed(this.callTimeTimer, 0L);
        }
        this.phoneLine0Panel.updateCurrentPhoneInfo();
        this.phoneLine1Panel.updateCurrentPhoneInfo();
        CallLine callLine0 = this.phoneLine0Panel.getCallLine();
        CallLine callLine1 = this.phoneLine1Panel.getCallLine();
        int i = 0;
        this.phoneLine1Separator.setVisible(false);
        if (callLine0.getState() == CallState.IDLE) {
            this.phoneLine0Panel.setVisible(false);
        } else {
            this.phoneLine0Panel.setVisible(true);
            ++i;
        }
        if (callLine1.getState() == CallState.IDLE) {
            this.phoneLine1Panel.setVisible(false);
        } else {
            if (i != 0) {
                this.phoneLine1Separator.setVisible(true);
            }
            this.phoneLine1Panel.setVisible(true);
            ++i;
        }
        if (i == 1) {
            this.setSize(400, 95);
        } else if (i == 2) {
            this.setSize(400, 160);
        }
    }

    @Override
    public void showToastPanel(String message, int duration) {
        this.toastPanel.showMessage(message, duration);
        JLayeredPane p = this.getLayeredPane();
        p.invalidate();
        p.repaint();
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.timer1.start();
        } else {
            this.timer1.stop();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.phoneLine0Panel.dispose();
        this.phoneLine1Panel.dispose();
        this.timer1.stop();
    }
}

