/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.bean.chat.VoiceMessage;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

class VoiceMessageCellRenderer
extends JPanel
implements ListCellRenderer {
    JLabel lblSendTime = new JLabel();
    JLabel lblSender = new JLabel();
    JLabel lblDuration = new JLabel();

    public VoiceMessageCellRenderer() {
        BorderLayout bl = new BorderLayout();
        bl.setHgap(20);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.setLayout(bl);
        this.add((Component)this.lblSendTime, "West");
        this.add((Component)this.lblSender, "Center");
        this.add((Component)this.lblDuration, "East");
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        VoiceMessage vm = (VoiceMessage)value;
        this.lblSender.setText(vm.getCaller());
        if (vm.getOrigianteTime() != null) {
            this.lblSendTime.setText(DateTimeUtil.getVoicemailTimeStr(vm.getOrigianteTime().getTime()));
        } else {
            this.lblSendTime.setText("");
        }
        Color bg = null;
        Color fg = null;
        if (isSelected) {
            this.setBackground(bg == null ? list.getSelectionBackground() : bg);
            this.setForeground(fg == null ? list.getSelectionForeground() : fg);
            this.lblSender.setForeground(fg == null ? list.getSelectionForeground() : fg);
            this.lblSendTime.setForeground(fg == null ? list.getSelectionForeground() : fg);
            this.lblDuration.setForeground(fg == null ? list.getSelectionForeground() : fg);
        } else {
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.lblSender.setForeground(list.getForeground());
            this.lblSendTime.setForeground(list.getForeground());
            this.lblDuration.setForeground(list.getForeground());
        }
        return this;
    }
}

