/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.outboundfilter;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.chat.roomimpl.PhoneHistoryEntryPanel;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.outboundfilter.CallResultType;
import com.blisscloud.ezuc.client.outboundfilter.RecordingCellRenderer;
import com.blisscloud.ezuc.client.outboundfilter.RecordingItem;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FuzzyNumberUtil;
import com.blisscloud.mobile.ezuc.util.MediaFileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class OutboundFilterDialog
extends GenericDialog {
    private static final long serialVersionUID = -4059214403193628430L;
    private JButton btnConfirm;
    private JButton btnAddToBlackList;
    private JButton btnCancel;
    private int mOK = 0;
    private JSONObject mDataObj = null;
    private String blockingInfo = null;
    private int contactRecordSize = 0;
    private Object[][] contactRecordData = null;
    private String[] contactRecordColumns = null;
    private DownloadFileTask downloadTask = null;

    public OutboundFilterDialog(JFrame frame, JSONObject dataObj) {
        super(frame);
        this.mDataObj = dataObj;
        this.handleData();
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("outbound_check_contact_records_dialog_title"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            JPanel centerPanel = new JPanel();
            GridBagLayout mainLayout = new GridBagLayout();
            centerPanel.setLayout(mainLayout);
            centerPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.getContentPane().add((Component)centerPanel, "Center");
            int y = 0;
            if (StringUtils.isNotBlank((CharSequence)this.blockingInfo)) {
                JLabel outboundBlockingTitle = new JLabel();
                centerPanel.add((Component)outboundBlockingTitle, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 0, 20), 0, 0));
                outboundBlockingTitle.setText(I18NUtil.getString("outbound_check_blocking_title"));
                outboundBlockingTitle.setFont(UIConstants.FONT_14_PLAIN);
                JTextArea textArea = new JTextArea(2, 60);
                textArea.setText(this.blockingInfo);
                textArea.setWrapStyleWord(true);
                textArea.setLineWrap(true);
                textArea.setOpaque(false);
                textArea.setEditable(false);
                textArea.setFocusable(false);
                textArea.setBackground(UIManager.getColor("Label.background"));
                textArea.setFont(UIConstants.FONT_14_PLAIN);
                textArea.setBorder(UIManager.getBorder("Label.border"));
                textArea.setForeground(Color.RED);
                centerPanel.add((Component)textArea, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 55, 0, 20), 0, 0));
            }
            JLabel contactHistoryTitle = new JLabel();
            centerPanel.add((Component)contactHistoryTitle, new GridBagConstraints(0, y++, 1, 1, 0.0, 0.0, 17, 0, new Insets(20, 20, 0, 20), 0, 0));
            if (this.contactRecordSize != this.contactRecordData.length) {
                contactHistoryTitle.setText(String.format(I18NUtil.getString("outbound_check_contact_history_title"), this.contactRecordSize, this.contactRecordData.length));
            } else {
                contactHistoryTitle.setText(String.format(I18NUtil.getString("outbound_check_contact_history_title_short"), this.contactRecordSize));
            }
            contactHistoryTitle.setFont(UIConstants.FONT_14_PLAIN);
            DefaultTableModel tableModel = new DefaultTableModel(this.contactRecordData, this.contactRecordColumns){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            final JTable jt = new JTable(tableModel);
            if (StringUtils.isNotBlank((CharSequence)this.blockingInfo)) {
                jt.setPreferredScrollableViewportSize(new Dimension(300, 150));
            } else {
                jt.setPreferredScrollableViewportSize(new Dimension(300, 230));
            }
            jt.setRowHeight(30);
            boolean isOutboundFilterRecordingIncluded = PreferencesUtil.isOutboundFilterRecordingIncluded(UCChatClient.context);
            if (isOutboundFilterRecordingIncluded) {
                jt.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        Object obj = OutboundFilterDialog.this.contactRecordData[jt.getSelectedRow()][jt.getSelectedColumn()];
                        if (obj instanceof RecordingItem) {
                            try {
                                OutboundFilterDialog.this.playSystemRecording((RecordingItem)obj);
                            }
                            catch (Exception e1) {
                                Log.e(OutboundFilterDialog.class.getSimpleName(), "ERROR:" + e1.getMessage(), e1);
                            }
                        }
                    }
                });
                jt.addMouseMotionListener(new MouseMotionAdapter(){

                    @Override
                    public void mouseMoved(MouseEvent e) {
                        Object obj;
                        Point p = e.getPoint();
                        int column = jt.columnAtPoint(p);
                        int row = jt.rowAtPoint(p);
                        Cursor cursor = Cursor.getPredefinedCursor(0);
                        if (column == 5 && (obj = OutboundFilterDialog.this.contactRecordData[row][column]) != null) {
                            cursor = Cursor.getPredefinedCursor(12);
                        }
                        jt.setCursor(cursor);
                    }
                });
                TableColumn colRecording = jt.getColumnModel().getColumn(5);
                colRecording.setPreferredWidth(100);
                colRecording.setMaxWidth(100);
                colRecording.setMinWidth(100);
                colRecording.setResizable(false);
                colRecording.setCellRenderer(new RecordingCellRenderer());
            }
            centerPanel.add((Component)new JScrollPane(jt), new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 1, new Insets(6, 55, 0, 20), 0, 0));
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(1);
            jPanel1Layout.setHgap(10);
            buttonPanel.setLayout(jPanel1Layout);
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(8, 15, 8, 15));
            this.getContentPane().add((Component)buttonPanel, "South");
            this.btnConfirm = new JButton();
            buttonPanel.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("outbound_check_contact_records_dialog_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OutboundFilterDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            if (StringUtils.isNotBlank((CharSequence)this.blockingInfo)) {
                this.btnConfirm.setEnabled(false);
            }
            if (StringUtils.isBlank((CharSequence)this.blockingInfo)) {
                this.btnAddToBlackList = new JButton();
                buttonPanel.add(this.btnAddToBlackList);
                this.btnAddToBlackList.setText(I18NUtil.getString("phone_history_btn_add_to_outbound_black_list"));
                this.btnAddToBlackList.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        OutboundFilterDialog.this.btnAddToBlackListActionPerformed(evt);
                    }
                });
            }
            this.btnCancel = new JButton();
            buttonPanel.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    OutboundFilterDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(900, 250);
            this.setMinimumSize(new Dimension(900, 400));
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playSystemRecording(RecordingItem item) throws Exception {
        String cacheFileName;
        File sysRecordingDir;
        File cacheFile;
        if (item.getContactRecordId() == null || item.getKey() == null || item.getSiteId() == 0L) {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
        if ((cacheFile = new File(sysRecordingDir = MediaFileUtil.getSysRecordingRoot(UCChatClient.context), cacheFileName = item.getContactRecordId() + "-" + DateTimeUtil.getDateTimeStr(item.getStartTime()) + ".wav")).exists() && cacheFile.length() == item.getFileSize()) {
            Desktop.getDesktop().open(cacheFile);
        } else {
            this.downloadAndOpenSysRecording(cacheFile, item.getKey(), item.getSiteId(), item.getFileSize());
        }
    }

    private void downloadAndOpenSysRecording(File cacheFile, String encodedRecordKey, long recordSiteId, long fileSize) {
        String fileDownloadURL = "/ucrm/file/downloadFile?k=" + encodedRecordKey + "&s=" + recordSiteId + "&type=r";
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL;
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        String msg = I18NUtil.getString("common_notice_downloading");
        ToastUtil.show(UCChatClient.context, msg, 30);
        this.downloadTask = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, fileSize, new DownloadOpenSysRecordingTaskCallBack(this, cacheFile));
        this.downloadTask.start();
    }

    private void handleData() {
        try {
            SimpleDateFormat timeformatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
            if (this.mDataObj.has("blackList")) {
                JSONObject obj = this.mDataObj.getJSONObject("blackList");
                String phoneNum = obj.getString("number");
                String reason = obj.getString("reason");
                String dispName = obj.getString("updateUserDispName");
                String lastUpdateTime = obj.getString("lastUpdateTime");
                Date d = new Date();
                d.setTime(Long.parseLong(lastUpdateTime));
                String formatTime = timeformatter.format(d);
                this.blockingInfo = String.format(I18NUtil.getString("outbound_check_blocking_alert"), phoneNum, formatTime, dispName, reason);
            }
            if (this.mDataObj.has("contactRecordSize")) {
                this.contactRecordSize = this.mDataObj.getInt("contactRecordSize");
            }
            if (this.mDataObj.has("contactRecords")) {
                boolean isOutboundFilterRecordingIncluded = PreferencesUtil.isOutboundFilterRecordingIncluded(UCChatClient.context);
                this.contactRecordColumns = isOutboundFilterRecordingIncluded ? new String[]{I18NUtil.getString("outbound_check_contact_history_agent"), I18NUtil.getString("outbound_check_contact_history_phoneNumber"), I18NUtil.getString("outbound_check_contact_history_time"), I18NUtil.getString("outbound_check_contact_history_duration"), I18NUtil.getString("outbound_check_contact_history_result"), I18NUtil.getString("outbound_check_contact_history_recording")} : new String[]{I18NUtil.getString("outbound_check_contact_history_agent"), I18NUtil.getString("outbound_check_contact_history_phoneNumber"), I18NUtil.getString("outbound_check_contact_history_time"), I18NUtil.getString("outbound_check_contact_history_duration"), I18NUtil.getString("outbound_check_contact_history_result")};
                JSONArray ary = this.mDataObj.getJSONArray("contactRecords");
                this.contactRecordData = isOutboundFilterRecordingIncluded ? new Object[ary.length()][6] : new Object[ary.length()][5];
                for (int i = 0; i < ary.length(); ++i) {
                    JSONObject obj = ary.getJSONObject(i);
                    String srcType = obj.getString("srcType");
                    String srcExt = "";
                    if (obj.has("srcExt")) {
                        srcExt = obj.getString("srcExt");
                    }
                    this.contactRecordData[i][0] = srcExt;
                    if (("EMPLOYEE".equals(srcType) || "LOCATION".equals(srcType)) && obj.has("srcDispName")) {
                        this.contactRecordData[i][0] = obj.getString("srcDispName");
                    }
                    if (obj.has("dstDialExt")) {
                        String dstDialExt = obj.getString("dstDialExt");
                        if (PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context)) {
                            dstDialExt = FuzzyNumberUtil.convert(dstDialExt);
                        }
                        this.contactRecordData[i][1] = dstDialExt;
                    }
                    if (obj.has("startTime")) {
                        long time = obj.getLong("startTime");
                        Date d = new Date();
                        d.setTime(time);
                        String formatTime = timeformatter.format(d);
                        this.contactRecordData[i][2] = formatTime;
                    }
                    if (obj.has("duration")) {
                        this.contactRecordData[i][3] = obj.getString("duration");
                    }
                    if (obj.has("dialResult")) {
                        int dialResult = obj.getInt("dialResult");
                        CallResultType callType = CallResultType.getValue(dialResult);
                        String result = "";
                        result = callType == CallResultType.ANSWERED ? I18NUtil.getString("contactRecord_status_option_answered") : (callType == CallResultType.NO_ANSWERED ? I18NUtil.getString("contactRecord_status_option_noanswer") : (callType == CallResultType.BUSY ? I18NUtil.getString("contactRecord_status_option_busy") : (callType == CallResultType.DND ? I18NUtil.getString("contactRecord_status_option_dnd") : (callType == CallResultType.TRANSFER ? I18NUtil.getString("contactRecord_status_option_transferred") : (callType == CallResultType.CANCELED_CALLER_HANGUP ? I18NUtil.getString("contactRecord_status_option_canceled") : (callType == CallResultType.CANCELED_ANSWERED_ELSEWHERE ? I18NUtil.getString("contactRecord_status_option_answeredelsewhere") : (callType == CallResultType.BLOCKED ? I18NUtil.getString("contactRecord_status_option_block") : (callType == CallResultType.FAILED_UNKNOWN ? I18NUtil.getString("contactRecord_status_option_failed") : (callType == CallResultType.FAILED_ROUTIG_ERROR ? I18NUtil.getString("contactRecord_status_option_failed_routing_error") : (callType == CallResultType.FAILED_CONGESTION ? I18NUtil.getString("contactRecord_status_option_failed_congestion") : (callType == CallResultType.NO_DIAL_RUN_OUT_TIME ? I18NUtil.getString("contactRecord_status_option_totalTimeOver") : (callType == CallResultType.NO_DIAL_TIME_QUOTA_EXHAUSTED ? I18NUtil.getString("contactRecord_status_option_timeQuotaExhausted") : (callType == CallResultType.NO_DIAL_NO_PERMISSION ? I18NUtil.getString("contactRecord_status_option_noPermission") : (callType == CallResultType.NO_DIAL_IN_BLOCK_LIST ? I18NUtil.getString("contactRecord_status_option_inBlockList") : (callType == CallResultType.NO_DIAL_FORBIDDEN_TIME ? I18NUtil.getString("contactRecord_status_option_forbiddenTime") : (callType == CallResultType.NO_DIAL_WRONG_NO ? I18NUtil.getString("contactRecord_status_option_wrong_no") : (callType == CallResultType.NO_DIAL_EMP_OFF_DUTY ? I18NUtil.getString("contactRecord_status_option_emp_off_duty") : (callType == CallResultType.NO_DIAL_TRUNK_LINE_NOT_READY ? I18NUtil.getString("contactRecord_status_option_trunkLineNotReady") : ""))))))))))))))))));
                        this.contactRecordData[i][4] = result;
                    }
                    if (!isOutboundFilterRecordingIncluded || !obj.has("encodedRecordKey") || !obj.has("recordSiteId") || !obj.has("contactRecordId")) continue;
                    RecordingItem item = new RecordingItem();
                    item.setKey(obj.getString("encodedRecordKey"));
                    item.setSiteId(obj.getLong("recordSiteId"));
                    item.setContactRecordId(obj.getLong("contactRecordId"));
                    item.setStartTime(obj.getLong("startTime"));
                    if (obj.has("contactRecordId")) {
                        item.setFileSize(obj.getLong("recordFileSize"));
                    }
                    this.contactRecordData[i][5] = item;
                }
            }
        }
        catch (Exception e) {
            Log.e(OutboundFilterDialog.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
        }
    }

    private void btnAddToBlackListActionPerformed(ActionEvent evt) {
        this.mOK = 2;
        this.dispose();
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.mOK = 1;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = 0;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = 0;
        this.dispose();
    }

    public int showDialog() {
        this.mOK = 0;
        this.setVisible(true);
        if (this.downloadTask != null && this.downloadTask.isAlive()) {
            this.downloadTask.cancel();
        }
        return this.mOK;
    }

    class DownloadOpenSysRecordingTaskCallBack
    implements DownloadFileTaskCallBack {
        File mFile;

        public DownloadOpenSysRecordingTaskCallBack(OutboundFilterDialog this$0, File toFile) {
            this.mFile = toFile;
        }

        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            Timer timer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    try {
                        ToastUtil.hide();
                        String msg = I18NUtil.getString("media_file_download_completed");
                        ToastUtil.show(UCChatClient.context, msg, 10);
                        Desktop.getDesktop().open(DownloadOpenSysRecordingTaskCallBack.this.mFile);
                    }
                    catch (Exception e) {
                        Log.e(PhoneHistoryEntryPanel.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                    }
                }
            });
            timer.setRepeats(false);
            timer.start();
        }

        @Override
        public void onDownloadFileCancelled() {
            String msg = I18NUtil.getString("media_file_download_completed");
            ToastUtil.show(UCChatClient.context, msg, 10);
        }

        @Override
        public void onDownloadFileFailed() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
        }

        @Override
        public void onDownloadFileNotFound() {
            ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
        }
    }
}

